/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.AbstractCollection;
import java.util.EnumSet;
import javax.annotation.concurrent.Immutable;
import jmri.Bundle;
import jmri.LocoAddress;

@Immutable
public enum SpeedStepMode {
    UNKNOWN("unknown", 1, 0.0f, "SpeedStepUnknown"),
    NMRA_DCC_128("128", 126, "SpeedStep128"),
    NMRA_DCC_28("28", 28, "SpeedStep28"),
    NMRA_DCC_27("27", 27, "SpeedStep27"),
    NMRA_DCC_14("14", 14, "SpeedStep14"),
    MOTOROLA_28("motorola_28", 28, "SpeedStep28Motorola"),
    TMCC_32("tmcc_32", 32, "SpeedStep32TMCC"),
    TMCC_200("tmcc_200", 200, "SpeedStep200TMCC"),
    INCREMENTAL("incremental", 1, 1.0f, "SpeedStepIncremental");

    public final String name;
    public final int numSteps;
    public final float increment;
    public final String description;

    private SpeedStepMode(String name, int numSteps, String description) {
        this(name, numSteps, 1.0f / (float)numSteps, description);
    }

    private SpeedStepMode(String name, int numSteps, float increment, String description) {
        this.name = name;
        this.numSteps = numSteps;
        this.increment = increment;
        this.description = Bundle.getMessage(description);
    }

    public String toString() {
        return this.description;
    }

    public static SpeedStepMode getByName(String name) {
        for (SpeedStepMode s : SpeedStepMode.values()) {
            if (!s.name.equals(name)) continue;
            return s;
        }
        throw new IllegalArgumentException("Invalid speed step mode: " + name);
    }

    public static SpeedStepMode getByDescription(String name) {
        for (SpeedStepMode s : SpeedStepMode.values()) {
            if (!s.description.equals(name)) continue;
            return s;
        }
        throw new IllegalArgumentException("Invalid speed step mode: " + name);
    }

    public static EnumSet<SpeedStepMode> getCompatibleModes(EnumSet<SpeedStepMode> command_station_modes, EnumSet<SpeedStepMode> decoder_modes) {
        Object result = command_station_modes.clone();
        ((AbstractCollection)result).retainAll(decoder_modes);
        return result;
    }

    public static SpeedStepMode bestCompatibleMode(EnumSet<SpeedStepMode> command_station_modes, EnumSet<SpeedStepMode> decoder_modes) {
        EnumSet<SpeedStepMode> result = SpeedStepMode.getCompatibleModes(command_station_modes, decoder_modes);
        return SpeedStepMode.bestMode(result);
    }

    public static SpeedStepMode bestMode(EnumSet<SpeedStepMode> modes) {
        if (modes.contains((Object)NMRA_DCC_128)) {
            return NMRA_DCC_128;
        }
        if (modes.contains((Object)TMCC_32)) {
            return TMCC_32;
        }
        if (modes.contains((Object)NMRA_DCC_28)) {
            return NMRA_DCC_28;
        }
        if (modes.contains((Object)MOTOROLA_28)) {
            return MOTOROLA_28;
        }
        if (modes.contains((Object)NMRA_DCC_27)) {
            return NMRA_DCC_27;
        }
        if (modes.contains((Object)NMRA_DCC_14)) {
            return NMRA_DCC_14;
        }
        return UNKNOWN;
    }

    public static EnumSet<SpeedStepMode> getCompatibleModesForProtocol(LocoAddress.Protocol protocol) {
        switch (protocol) {
            case DCC: 
            case DCC_LONG: 
            case DCC_SHORT: {
                return EnumSet.of(NMRA_DCC_128, new SpeedStepMode[]{NMRA_DCC_28, NMRA_DCC_27, NMRA_DCC_14, INCREMENTAL, TMCC_32});
            }
            case MFX: {
                return EnumSet.of(NMRA_DCC_128, new SpeedStepMode[]{NMRA_DCC_28, NMRA_DCC_27, NMRA_DCC_14, INCREMENTAL, MOTOROLA_28});
            }
            case MOTOROLA: {
                return EnumSet.of(MOTOROLA_28);
            }
            case SELECTRIX: 
            case M4: 
            case OPENLCB: 
            case LGB: {
                break;
            }
        }
        return EnumSet.noneOf(SpeedStepMode.class);
    }
}

