/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.ArrayList;
import jmri.InstanceManager;
import jmri.Section;
import jmri.SectionManager;
import jmri.TransitSectionAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransitSection {
    private Section mSection = null;
    private int mSequence = 0;
    private int mDirection = 0;
    private final ArrayList<TransitSectionAction> mTransitSectionActionList = new ArrayList();
    private boolean mAlternate = false;
    private boolean mSafe = false;
    private String mStopAllocatingSensorName = "";
    private String tSectionName = "";
    private boolean needsInitialization = false;
    private boolean temporary = false;
    private static final Logger log = LoggerFactory.getLogger(TransitSection.class);

    public TransitSection(Section s, int seq, int direction) {
        this(s, seq, direction, false);
    }

    public TransitSection(Section s, int seq, int direction, boolean alt) {
        this.mSection = s;
        this.mSequence = seq;
        this.mDirection = direction;
        this.mAlternate = alt;
    }

    public TransitSection(Section s, int seq, int direction, boolean alt, boolean safe, String stopAllocatingSensorName) {
        this.mSection = s;
        this.mSequence = seq;
        this.mDirection = direction;
        this.mAlternate = alt;
        this.mSafe = safe;
        this.mStopAllocatingSensorName = stopAllocatingSensorName;
    }

    public TransitSection(String secName, int seq, int direction, boolean alt) {
        this.tSectionName = secName;
        this.mSequence = seq;
        this.mDirection = direction;
        this.mAlternate = alt;
        this.needsInitialization = true;
    }

    public TransitSection(String secName, int seq, int direction, boolean alt, boolean safe, String stopAllocatingSensorName) {
        this.tSectionName = secName;
        this.mSequence = seq;
        this.mDirection = direction;
        this.mAlternate = alt;
        this.mSafe = safe;
        this.mStopAllocatingSensorName = stopAllocatingSensorName;
        this.needsInitialization = true;
    }

    private void initialize() {
        if (this.tSectionName.equals("null")) {
            log.error("Null Section Name when initializing a TransitSection");
        } else {
            this.mSection = InstanceManager.getDefault(SectionManager.class).getSection(this.tSectionName);
            if (this.mSection == null) {
                log.error("Missing Section - {} - when initializing a TransitSection", (Object)this.tSectionName);
            }
        }
        this.needsInitialization = false;
    }

    public void setTemporary(boolean boo) {
        this.temporary = boo;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public Section getSection() {
        if (this.needsInitialization) {
            this.initialize();
        }
        return this.mSection;
    }

    public String getSectionName() {
        if (this.needsInitialization) {
            this.initialize();
        }
        String s = this.mSection.getSystemName();
        String u = this.mSection.getUserName();
        if (u != null && !u.isEmpty()) {
            return s + "( " + u + " )";
        }
        return s;
    }

    public int getDirection() {
        return this.mDirection;
    }

    public int getSequenceNumber() {
        return this.mSequence;
    }

    public void addAction(TransitSectionAction act) {
        this.mTransitSectionActionList.add(act);
    }

    public boolean isAlternate() {
        return this.mAlternate;
    }

    public void setAlternate(boolean alt) {
        this.mAlternate = alt;
    }

    public boolean isSafe() {
        return this.mSafe;
    }

    public void setSafe(boolean safe) {
        this.mSafe = safe;
    }

    public String getStopAllocatingSensor() {
        return this.mStopAllocatingSensorName;
    }

    public void setStopAllocatingSensor(String stopAllocatingSensor) {
        this.mStopAllocatingSensorName = stopAllocatingSensor;
    }

    public ArrayList<TransitSectionAction> getTransitSectionActionList() {
        return new ArrayList<TransitSectionAction>(this.mTransitSectionActionList);
    }
}

