/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.DigitalIO;
import jmri.InvokeOnLayoutThread;
import jmri.JmriException;
import jmri.NamedBeanHandle;
import jmri.Sensor;
import jmri.TurnoutOperation;
import jmri.VariableControlSpanBean;

public interface Turnout
extends DigitalIO,
VariableControlSpanBean {
    public static final int CLOSED = 2;
    public static final int THROWN = 4;
    public static final int DIRECT = 1;
    public static final int EXACT = 2;
    public static final int INDIRECT = 4;
    public static final int MONITORING = 8;
    public static final int ONESENSOR = 16;
    public static final int TWOSENSOR = 32;
    public static final int SIGNAL = 64;
    public static final int DELAYED = 128;
    public static final int LNALTERNATE = 256;
    public static final int CABLOCKOUT = 1;
    public static final int PUSHBUTTONLOCKOUT = 2;
    public static final int UNLOCKED = 0;
    public static final int LOCKED = 1;
    public static final String PROPERTY_COMMANDED_STATE = "CommandedState";
    public static final String PROPERTY_FEEDBACK_MODE = "feedbackchange";
    public static final String PROPERTY_INVERTED = "inverted";
    public static final String PROPERTY_LOCKED = "locked";
    public static final String PROPERTY_REPORT_LOCKED = "reportlocked";
    public static final String PROPERTY_DECODER_NAME = "decoderNameChange";
    public static final String PROPERTY_TURNOUT_OPERATION_STATE = "TurnoutOperationState";
    public static final String PROPERTY_TURNOUT_FEEDBACK_FIRST_SENSOR = "turnoutFeedbackFirstSensorChange";
    public static final String PROPERTY_TURNOUT_FEEDBACK_SECOND_SENSOR = "turnoutFeedbackSecondSensorChange";
    public static final String PROPERTY_TURNOUT_DIVERGING_SPEED = "TurnoutDivergingSpeedChange";
    public static final String PROPERTY_TURNOUT_STRAIGHT_SPEED = "TurnoutStraightSpeedChange";
    public static final String PROPERTY_LEADING_TURNOUT = "LeadingTurnout";

    public Set<Integer> getValidFeedbackModes();

    public int getValidFeedbackTypes();

    @Nonnull
    public String[] getValidFeedbackNames();

    @InvokeOnLayoutThread
    public void setFeedbackMode(@Nonnull String var1) throws IllegalArgumentException;

    @InvokeOnLayoutThread
    public void setFeedbackMode(int var1) throws IllegalArgumentException;

    @Nonnull
    public String getFeedbackModeName();

    public int getFeedbackMode();

    public boolean getInhibitOperation();

    public void setInhibitOperation(boolean var1);

    @CheckForNull
    public TurnoutOperation getTurnoutOperation();

    @InvokeOnLayoutThread
    public void setTurnoutOperation(@CheckForNull TurnoutOperation var1);

    public static int invertTurnoutState(int inState) {
        int result = 1;
        if (inState == 2) {
            result = 4;
        } else if (inState == 4) {
            result = 2;
        } else if (inState == 8) {
            result = 8;
        }
        return result;
    }

    default public void provideFeedbackSensor(@CheckForNull String name, int number) throws JmriException {
        switch (number) {
            case 0: {
                this.provideFirstFeedbackSensor(name);
                break;
            }
            case 1: {
                this.provideSecondFeedbackSensor(name);
                break;
            }
            default: {
                throw new IllegalArgumentException("Turnouts have no more than two sensors");
            }
        }
    }

    public void provideFirstFeedbackSensor(@CheckForNull String var1) throws JmriException;

    public void provideSecondFeedbackSensor(@CheckForNull String var1) throws JmriException;

    @CheckForNull
    public Sensor getFirstSensor();

    @CheckForNull
    public NamedBeanHandle<Sensor> getFirstNamedSensor();

    @CheckForNull
    public Sensor getSecondSensor();

    @CheckForNull
    public NamedBeanHandle<Sensor> getSecondNamedSensor();

    @InvokeOnLayoutThread
    public void setInitialKnownStateFromFeedback();

    public int getControlType();

    @InvokeOnLayoutThread
    public void setControlType(int var1);

    public boolean getInverted();

    public void setInverted(boolean var1);

    public boolean canInvert();

    public boolean getLocked(int var1);

    @InvokeOnLayoutThread
    public void enableLockOperation(int var1, boolean var2);

    public boolean canLock(int var1);

    public int getPossibleLockModes();

    @InvokeOnLayoutThread
    public void setLocked(int var1, boolean var2);

    public boolean getReportLocked();

    @InvokeOnLayoutThread
    public void setReportLocked(boolean var1);

    @Nonnull
    public String[] getValidDecoderNames();

    @CheckForNull
    public String getDecoderName();

    public void setDecoderName(@CheckForNull String var1);

    @InvokeOnLayoutThread
    public void setBinaryOutput(boolean var1);

    public float getDivergingLimit();

    public String getDivergingSpeed();

    public void setDivergingSpeed(String var1) throws JmriException;

    public float getStraightLimit();

    public String getStraightSpeed();

    public void setStraightSpeed(String var1) throws JmriException;

    public boolean isCanFollow();

    @CheckForNull
    public Turnout getLeadingTurnout();

    public void setLeadingTurnout(@CheckForNull Turnout var1);

    public void setLeadingTurnout(@CheckForNull Turnout var1, boolean var2);

    public boolean isFollowingCommandedState();

    public void setFollowingCommandedState(boolean var1);

    public void setCommandedStateAtInterval(int var1);
}

