/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.Turnout;
import jmri.TurnoutManager;
import jmri.TurnoutOperationManager;
import jmri.TurnoutOperator;
import jmri.beans.PropertyChangeSupport;
import jmri.implementation.AbstractTurnout;

public abstract class TurnoutOperation
extends PropertyChangeSupport
implements Comparable<Object> {
    String name;
    int feedbackModes = 0;
    boolean nonce = false;

    TurnoutOperation(@Nonnull String n) {
        this.name = n;
    }

    public abstract TurnoutOperation makeCopy(@Nonnull String var1);

    protected void setFeedbackModes(int fm) {
        this.feedbackModes = fm;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    @Override
    public int compareTo(Object other) {
        return this.name.compareTo(((TurnoutOperation)other).name);
    }

    public boolean equals(Object ro) {
        if (ro == null) {
            return false;
        }
        if (ro instanceof TurnoutOperation) {
            return this.name.equals(((TurnoutOperation)ro).name);
        }
        return false;
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public abstract boolean equivalentTo(TurnoutOperation var1);

    public boolean rename(@Nonnull String newName) {
        boolean result = false;
        TurnoutOperationManager mgr = InstanceManager.getDefault(TurnoutOperationManager.class);
        if (!this.isDefinitive() && mgr.getOperation(newName) == null) {
            mgr.removeOperation(this);
            this.name = newName;
            this.setNonce(false);
            mgr.addOperation(this);
            result = true;
        }
        return result;
    }

    public TurnoutOperation getDefinitive() {
        String[] myClass = this.getClass().getName().split("\\.");
        String finalClass = myClass[myClass.length - 1];
        String mySubclass = finalClass.substring(0, finalClass.indexOf("TurnoutOperation"));
        return InstanceManager.getDefault(TurnoutOperationManager.class).getOperation(mySubclass);
    }

    public boolean isDefinitive() {
        String[] classNames = this.getClass().getName().split("\\.");
        String className = classNames[classNames.length - 1];
        String opName = this.getName() + "TurnoutOperation";
        return className.equalsIgnoreCase(opName);
    }

    public abstract TurnoutOperator getOperator(@Nonnull AbstractTurnout var1);

    public void dispose() {
        if (!this.isDefinitive()) {
            InstanceManager.getDefault(TurnoutOperationManager.class).removeOperation(this);
            this.name = "*deleted";
            this.firePropertyChange("Deleted", null, null);
        }
    }

    public boolean isDeleted() {
        return this.name.equals("*deleted");
    }

    public boolean isInUse() {
        TurnoutManager tm = InstanceManager.turnoutManagerInstance();
        for (Turnout t : tm.getNamedBeanSet()) {
            if (t == null || t.getTurnoutOperation() != this) continue;
            return true;
        }
        return false;
    }

    public boolean isNonce() {
        return this.nonce;
    }

    public void setNonce(boolean n) {
        this.nonce = n;
        InstanceManager.getDefault(TurnoutOperationManager.class).firePropertyChange("Content", null, null);
    }

    public TurnoutOperation makeNonce(Turnout t) {
        TurnoutOperation op = this.makeCopy("*" + t.getSystemName());
        op.setNonce(true);
        return op;
    }

    public boolean matchFeedbackMode(int mode) {
        return (mode & this.feedbackModes) != 0;
    }

    public String getToolTip() {
        return null;
    }
}

