/*
 * Decompiled with CFR 0.152.
 */
package jmri;

import java.util.ResourceBundle;
import jmri.Bundle;

public class Version {
    private static final ResourceBundle VERSION_BUNDLE = ResourceBundle.getBundle("jmri.Version");
    public static final int major = Integer.parseInt(VERSION_BUNDLE.getString("release.major"));
    public static final int minor = Integer.parseInt(VERSION_BUNDLE.getString("release.minor"));
    public static final int test = Integer.parseInt(VERSION_BUNDLE.getString("release.build"));
    public static final String MODIFIER = VERSION_BUNDLE.getString("release.modifier");
    public static final String NON_OFFICIAL = "plus";
    public static final String buildUser = VERSION_BUNDLE.getString("release.build_user");
    public static final String revisionId = VERSION_BUNDLE.getString("release.revision_id");
    public static final String buildDate = VERSION_BUNDLE.getString("release.build_date");
    public static final boolean official = Boolean.parseBoolean(VERSION_BUNDLE.getString("release.official"));

    public static String getModifier() {
        StringBuilder modifier = new StringBuilder();
        if (!official) {
            modifier.append(NON_OFFICIAL);
        }
        if (!MODIFIER.isEmpty()) {
            modifier.append("-").append(MODIFIER);
        }
        return modifier.toString().replace("--", "-");
    }

    public static String name() {
        String version = major + "." + minor;
        if (test != 0) {
            version = version + "." + test;
        }
        Object addOn = official ? ("unknown".equals(revisionId) ? buildDate : "R" + revisionId) : ("unknown".equals(revisionId) ? buildUser + "+" + buildDate : buildUser + "+" + buildDate + "+R" + revisionId);
        return version + Version.getModifier() + "+" + (String)addOn;
    }

    public static boolean isCanonicalVersion(String version) {
        String[] parts = version.split("\\+");
        if (parts.length > 1) {
            return false;
        }
        parts = version.split("-");
        String[] versions = parts[0].split("\\.");
        if (versions.length != 3) {
            return false;
        }
        try {
            for (String part : versions) {
                if (Integer.parseInt(part) >= 0) continue;
                return false;
            }
        }
        catch (NumberFormatException ex) {
            return false;
        }
        return true;
    }

    public static int compareCanonicalVersions(String version) throws IllegalArgumentException {
        return Version.compareCanonicalVersions(version, Version.getCanonicalVersion());
    }

    public static int compareCanonicalVersions(String version1, String version2) throws IllegalArgumentException {
        int result = 0;
        if (!Version.isCanonicalVersion(version1)) {
            throw new IllegalArgumentException("Parameter version1 (" + version1 + ") is not a canonical version string.");
        }
        if (!Version.isCanonicalVersion(version2)) {
            throw new IllegalArgumentException("Parameter version2 (" + version2 + ") is not a canonical version string.");
        }
        String[] p1 = version1.split("-");
        String[] p2 = version2.split("-");
        String[] v1 = p1[0].split("\\.");
        String[] v2 = p2[0].split("\\.");
        for (int i = 0; i < 3; ++i) {
            result = v1[i].compareTo(v2[i]);
            if (result == 0) continue;
            return result;
        }
        return result;
    }

    public static String getCanonicalVersion() {
        Object version = major + "." + minor + "." + test;
        String modifiers = Version.getModifier().replace(NON_OFFICIAL, "");
        if (!modifiers.isEmpty()) {
            version = (String)version + modifiers;
        }
        if (((String)version).endsWith("-")) {
            version = ((String)version).substring(0, ((String)version).length() - 2);
        }
        return version;
    }

    public static String getCopyright() {
        return Bundle.getMessage("Copyright", VERSION_BUNDLE.getString("jmri.copyright.year"));
    }

    public static void main(String[] args) {
        System.out.println(Version.name());
    }
}

