/*
 * Decompiled with CFR 0.152.
 */
package jmri.beans;

import java.beans.IndexedPropertyDescriptor;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeListenerProxy;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashSet;
import java.util.Set;
import javax.annotation.Nonnull;
import jmri.beans.BeanInterface;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanUtil {
    private static final Logger log = LoggerFactory.getLogger(BeanUtil.class);

    private BeanUtil() {
    }

    public static void setIndexedProperty(Object bean, String key, int index, Object value) {
        if (BeanUtil.implementsBeanInterface(bean)) {
            ((BeanInterface)bean).setIndexedProperty(key, index, value);
        } else {
            BeanUtil.setIntrospectedIndexedProperty(bean, key, index, value);
        }
    }

    public static void setIntrospectedIndexedProperty(Object bean, String key, int index, Object value) {
        if (bean != null && key != null) {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                    if (!(pd instanceof IndexedPropertyDescriptor) || !pd.getName().equalsIgnoreCase(key)) continue;
                    ((IndexedPropertyDescriptor)pd).getIndexedWriteMethod().invoke(bean, index, value);
                    return;
                }
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                log.warn("Exception: ", (Throwable)ex);
            }
        }
    }

    public static Object getIndexedProperty(Object bean, String key, int index) {
        if (BeanUtil.implementsBeanInterface(bean)) {
            return ((BeanInterface)bean).getIndexedProperty(key, index);
        }
        return BeanUtil.getIntrospectedIndexedProperty(bean, key, index);
    }

    public static Object getIntrospectedIndexedProperty(Object bean, String key, int index) {
        if (bean != null && key != null) {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                    if (!(pd instanceof IndexedPropertyDescriptor) || !pd.getName().equalsIgnoreCase(key)) continue;
                    return ((IndexedPropertyDescriptor)pd).getIndexedReadMethod().invoke(bean, index);
                }
            }
            catch (InvocationTargetException ex) {
                Throwable tex = ex.getCause();
                if (tex instanceof RuntimeException) {
                    throw (RuntimeException)tex;
                }
                log.error("RuntimeException: ", (Throwable)ex);
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException ex) {
                log.warn("Exception: ", (Throwable)ex);
            }
        }
        return null;
    }

    public static void setProperty(Object bean, String key, Object value) {
        if (BeanUtil.implementsBeanInterface(bean)) {
            ((BeanInterface)bean).setProperty(key, value);
        } else {
            BeanUtil.setIntrospectedProperty(bean, key, value);
        }
    }

    public static void setIntrospectedProperty(Object bean, String key, Object value) {
        if (bean != null && key != null) {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equalsIgnoreCase(key)) continue;
                    pd.getWriteMethod().invoke(bean, value);
                    return;
                }
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                log.warn("Exception: ", (Throwable)ex);
            }
        }
    }

    public static Object getProperty(Object bean, String key) {
        if (BeanUtil.implementsBeanInterface(bean)) {
            return ((BeanInterface)bean).getProperty(key);
        }
        return BeanUtil.getIntrospectedProperty(bean, key);
    }

    public static Object getIntrospectedProperty(Object bean, String key) {
        if (bean != null && key != null) {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equalsIgnoreCase(key)) continue;
                    return pd.getReadMethod().invoke(bean, (Object[])null);
                }
            }
            catch (IntrospectionException | IllegalAccessException | IllegalArgumentException | InvocationTargetException ex) {
                log.warn("Exception: ", (Throwable)ex);
            }
        }
        return null;
    }

    public static boolean hasProperty(Object bean, String key) {
        if (BeanUtil.implementsBeanInterface(bean)) {
            return ((BeanInterface)bean).hasProperty(key);
        }
        return BeanUtil.hasIntrospectedProperty(bean, key);
    }

    public static boolean hasIndexedProperty(Object bean, String key) {
        if (BeanUtil.implementsBeanInterface(bean)) {
            return ((BeanInterface)bean).hasIndexedProperty(key);
        }
        return BeanUtil.hasIntrospectedIndexedProperty(bean, key);
    }

    public static boolean hasIntrospectedProperty(Object bean, String key) {
        if (bean != null && key != null) {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                    if (!pd.getName().equalsIgnoreCase(key)) continue;
                    return true;
                }
            }
            catch (IntrospectionException ex) {
                log.warn("Exception: ", (Throwable)ex);
            }
        }
        return false;
    }

    public static boolean hasIntrospectedIndexedProperty(Object bean, String key) {
        if (bean != null && key != null) {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                    if (!(pd instanceof IndexedPropertyDescriptor) || !pd.getName().equalsIgnoreCase(key)) continue;
                    return true;
                }
            }
            catch (IntrospectionException ex) {
                log.warn("Introspection Exception: ", (Throwable)ex);
            }
        }
        return false;
    }

    public static Set<String> getPropertyNames(Object bean) {
        if (bean != null) {
            if (BeanUtil.implementsBeanInterface(bean)) {
                return ((BeanInterface)bean).getPropertyNames();
            }
            return BeanUtil.getIntrospectedPropertyNames(bean);
        }
        return new HashSet<String>();
    }

    public static Set<String> getIntrospectedPropertyNames(Object bean) {
        HashSet<String> names = new HashSet<String>();
        if (bean != null) {
            try {
                PropertyDescriptor[] pds;
                for (PropertyDescriptor pd : pds = Introspector.getBeanInfo(bean.getClass()).getPropertyDescriptors()) {
                    names.add(pd.getName());
                }
            }
            catch (IntrospectionException ex) {
                log.warn("Introspection Exception: ", (Throwable)ex);
            }
        }
        return names;
    }

    public static boolean implementsBeanInterface(Object bean) {
        return null != bean && BeanInterface.class.isAssignableFrom(bean.getClass());
    }

    public static boolean contains(PropertyChangeListener[] listeners, @Nonnull PropertyChangeListener needle) {
        for (PropertyChangeListener listener : listeners) {
            if (!listener.equals(needle) && (!(listener instanceof PropertyChangeListenerProxy) || !((PropertyChangeListener)((PropertyChangeListenerProxy)listener).getListener()).equals(needle))) continue;
            return true;
        }
        return false;
    }
}

