/*
 * Decompiled with CFR 0.152.
 */
package jmri.beans;

import java.beans.IndexedPropertyChangeEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.VetoableChangeSupport;
import jmri.beans.Bean;
import jmri.beans.VetoableChangeProvider;

public abstract class ConstrainedBean
extends Bean
implements VetoableChangeProvider {
    protected final VetoableChangeSupport vetoableChangeSupport = new VetoableChangeSupport(this);

    @Override
    public void setProperty(String key, Object value) {
        try {
            this.fireVetoableChange(key, this.getProperty(key), value);
            super.setProperty(key, value);
        }
        catch (PropertyVetoException ex) {
            this.firePropertyChange(key, this.getProperty(key), this.getProperty(key));
        }
    }

    @Override
    public void setIndexedProperty(String key, int index, Object value) {
        try {
            Object old = this.getIndexedPropertyOrNull(key, index);
            this.fireVetoableChange(new IndexedPropertyChangeEvent(this, key, old, value, index));
            super.setIndexedProperty(key, index, value);
        }
        catch (PropertyVetoException ex) {
            this.fireIndexedPropertyChange(key, index, this.getProperty(key), this.getProperty(key));
        }
    }

    @Override
    public void addVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(listener);
    }

    @Override
    public void addVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vetoableChangeSupport.addVetoableChangeListener(propertyName, listener);
    }

    @Override
    public VetoableChangeListener[] getVetoableChangeListeners() {
        return this.vetoableChangeSupport.getVetoableChangeListeners();
    }

    @Override
    public VetoableChangeListener[] getVetoableChangeListeners(String propertyName) {
        return this.vetoableChangeSupport.getVetoableChangeListeners(propertyName);
    }

    @Override
    public void removeVetoableChangeListener(VetoableChangeListener listener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(listener);
    }

    @Override
    public void removeVetoableChangeListener(String propertyName, VetoableChangeListener listener) {
        this.vetoableChangeSupport.removeVetoableChangeListener(propertyName, listener);
    }

    public void fireVetoableChange(PropertyChangeEvent event) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(event);
    }

    public void fireVetoableChange(String propertyName, Object oldValue, Object newValue) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
    }

    public void fireVetoableChange(String propertyName, int oldValue, int newValue) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
    }

    public void fireVetoableChange(String propertyName, boolean oldValue, boolean newValue) throws PropertyVetoException {
        this.vetoableChangeSupport.fireVetoableChange(propertyName, oldValue, newValue);
    }

    protected Object getIndexedPropertyOrNull(String key, int index) {
        try {
            return this.getIndexedProperty(key, index);
        }
        catch (IndexOutOfBoundsException ex) {
            return null;
        }
    }
}

