/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.Version;
import jmri.configurexml.ClassMigrationManager;
import jmri.configurexml.ErrorHandler;
import jmri.configurexml.ErrorMemo;
import jmri.configurexml.JmriConfigureXmlException;
import jmri.configurexml.XmlAdapter;
import jmri.jmrit.XmlFile;
import jmri.jmrit.revhistory.FileHistory;
import jmri.jmrit.revhistory.configurexml.FileHistoryXml;
import jmri.util.FileUtil;
import jmri.util.ThreadingUtil;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.jdom2.ProcessingInstruction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigXmlManager
extends XmlFile
implements ConfigureManager {
    public static final String schemaVersion = "-5-5-5";
    private List<Object> plist = new ArrayList<Object>();
    Map<Object, Integer> clist = Collections.synchronizedMap(new LinkedHashMap());
    private List<Object> tlist = new ArrayList<Object>();
    private List<Object> ulist = new ArrayList<Object>();
    private List<Object> uplist = new ArrayList<Object>();
    private final List<Element> loadDeferredList = new ArrayList<Element>();
    File prefsFile;
    private XmlFile.Validate validate = XmlFile.Validate.CheckDtdThenSchema;
    private static ErrorHandler handler = new ErrorHandler();
    private static final Logger log = LoggerFactory.getLogger(ConfigXmlManager.class);

    @Override
    public void registerConfig(Object o) {
        this.registerConfig(o, 50);
    }

    @Override
    public void registerPref(Object o) {
        if (this.plist.contains(o)) {
            return;
        }
        this.confirmAdapterAvailable(o);
        this.plist.add(o);
    }

    void confirmAdapterAvailable(Object o) {
        if (log.isDebugEnabled()) {
            String adapter = ConfigXmlManager.adapterName(o);
            log.debug("register {} adapter {}", o, (Object)adapter);
            if (adapter != null) {
                try {
                    Class.forName(adapter);
                }
                catch (ClassNotFoundException | NoClassDefFoundError ex) {
                    this.locateClassFailed(ex, adapter, o);
                }
            }
        }
    }

    public static String currentClassName(String name) {
        return InstanceManager.getDefault(ClassMigrationManager.class).getClassName(name);
    }

    @Override
    public void removePrefItems() {
        log.debug("removePrefItems dropped {}", (Object)this.plist.size());
        this.plist.clear();
    }

    @Override
    public Object findInstance(Class<?> c, int index) {
        ArrayList<Object> temp = new ArrayList<Object>(this.plist);
        temp.addAll(this.clist.keySet());
        temp.addAll(this.tlist);
        temp.addAll(this.ulist);
        temp.addAll(this.uplist);
        for (Object e : temp) {
            if (!c.isInstance(e) || index-- != 0) continue;
            return e;
        }
        return null;
    }

    @Override
    public List<Object> getInstanceList(Class<?> c) {
        ArrayList<Object> result = new ArrayList<Object>();
        ArrayList<Object> temp = new ArrayList<Object>(this.plist);
        temp.addAll(this.clist.keySet());
        temp.addAll(this.tlist);
        temp.addAll(this.ulist);
        temp.addAll(this.uplist);
        for (Object e : temp) {
            if (!c.isInstance(e)) continue;
            result.add(e);
        }
        return result;
    }

    @Override
    public void registerConfig(Object o, int x) {
        if (this.clist.containsKey(o)) {
            return;
        }
        this.confirmAdapterAvailable(o);
        this.clist.put(o, x);
    }

    @Override
    public void registerTool(Object o) {
        if (this.tlist.contains(o)) {
            return;
        }
        this.confirmAdapterAvailable(o);
        this.tlist.add(o);
    }

    @Override
    public void registerUser(Object o) {
        if (this.ulist.contains(o)) {
            return;
        }
        this.confirmAdapterAvailable(o);
        this.ulist.add(o);
    }

    @Override
    public void registerUserPrefs(Object o) {
        if (this.uplist.contains(o)) {
            return;
        }
        this.confirmAdapterAvailable(o);
        this.uplist.add(o);
    }

    @Override
    public void deregister(Object o) {
        this.plist.remove(o);
        if (o != null) {
            this.clist.remove(o);
        }
        this.tlist.remove(o);
        this.ulist.remove(o);
        this.uplist.remove(o);
    }

    public static String adapterName(Object o) {
        String className = o.getClass().getName();
        log.trace("handle object of class {}", (Object)className);
        int lastDot = className.lastIndexOf(".");
        if (lastDot > 0) {
            String result = className.substring(0, lastDot) + ".configurexml." + className.substring(lastDot + 1, className.length()) + "Xml";
            log.trace("adapter class name is {}", (Object)result);
            return result;
        }
        log.error("No package name found, which is not yet handled!");
        return null;
    }

    void locateClassFailed(Throwable ex, String adapterName, Object o) {
        log.error("{} could not load adapter class {}", (Object)ex, (Object)adapterName);
        log.debug("Stack trace is", ex);
    }

    protected Element initStore() {
        Element root = new Element("layout-config");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/layout-5-5-5.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        return root;
    }

    protected void addPrefsStore(Element root) {
        for (int i = 0; i < this.plist.size(); ++i) {
            Object o = this.plist.get(i);
            Element e = ConfigXmlManager.elementFromObject(o);
            if (e == null) continue;
            root.addContent((Content)e);
        }
    }

    protected boolean addConfigStore(Element root) {
        boolean result = true;
        ArrayList<Map.Entry<Object, Integer>> l = new ArrayList<Map.Entry<Object, Integer>>(this.clist.entrySet());
        Collections.sort(l, (o1, o2) -> ((Integer)o1.getValue()).compareTo((Integer)o2.getValue()));
        for (int i = 0; i < l.size(); ++i) {
            try {
                Object o = ((Map.Entry)l.get(i)).getKey();
                Element e = ConfigXmlManager.elementFromObject(o);
                if (e == null) continue;
                root.addContent((Content)e);
                continue;
            }
            catch (Exception e) {
                ConfigXmlManager.storingErrorEncountered(null, "storing to file in addConfigStore", "Exception thrown", null, null, e);
                result = false;
            }
        }
        return result;
    }

    protected boolean addToolsStore(Element root) {
        boolean result = true;
        for (Object o : this.tlist) {
            try {
                Element e = ConfigXmlManager.elementFromObject(o);
                if (e == null) continue;
                root.addContent((Content)e);
            }
            catch (Exception e) {
                result = false;
                ConfigXmlManager.storingErrorEncountered(null, "storing to file in addToolsStore", "Exception thrown", null, null, e);
            }
        }
        return result;
    }

    protected boolean addUserStore(Element root) {
        boolean result = true;
        for (Object o : this.ulist) {
            try {
                Element e = ConfigXmlManager.elementFromObject(o);
                if (e == null) continue;
                root.addContent((Content)e);
            }
            catch (Exception e) {
                result = false;
                ConfigXmlManager.storingErrorEncountered(null, "storing to file in addUserStore", "Exception thrown", null, null, e);
            }
        }
        return result;
    }

    protected void addUserPrefsStore(Element root) {
        for (Object o : this.uplist) {
            Element e = ConfigXmlManager.elementFromObject(o);
            if (e == null) continue;
            root.addContent((Content)e);
        }
    }

    protected void includeHistory(Element root, File file) {
        Element historyElement;
        if (InstanceManager.getNullableDefault(FileHistory.class) != null && (historyElement = FileHistoryXml.storeDirectly(InstanceManager.getDefault(FileHistory.class), file.getPath())) != null) {
            root.addContent((Content)historyElement);
        }
    }

    protected boolean finalStore(Element root, File file) {
        try {
            Document doc = ConfigXmlManager.newDocument(root);
            HashMap<String, String> m = new HashMap<String, String>();
            m.put("type", "text/xsl");
            m.put("href", "/xml/XSLT/panelfile-5-5-5.xsl");
            ProcessingInstruction p = new ProcessingInstruction("xml-stylesheet", m);
            doc.addContent(0, (Content)p);
            this.storeVersion(root);
            this.writeXML(file, doc);
        }
        catch (FileNotFoundException ex3) {
            ConfigXmlManager.storingErrorEncountered(null, "storing to file " + file.getName(), "File not found " + file.getName(), null, null, ex3);
            log.error("FileNotFound error writing file: {}", (Object)ex3.getLocalizedMessage());
            return false;
        }
        catch (IOException ex2) {
            ConfigXmlManager.storingErrorEncountered(null, "storing to file " + file.getName(), "IO error writing file " + file.getName(), null, null, ex2);
            log.error("IO error writing file: {}", (Object)ex2.getLocalizedMessage());
            return false;
        }
        return true;
    }

    @Override
    public void storePrefs() {
        this.storePrefs(this.prefsFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storePrefs(File file) {
        ConfigXmlManager configXmlManager = this;
        synchronized (configXmlManager) {
            Element root = this.initStore();
            this.addPrefsStore(root);
            this.finalStore(root, file);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeUserPrefs(File file) {
        ConfigXmlManager configXmlManager = this;
        synchronized (configXmlManager) {
            Element root = this.initStore();
            this.addUserPrefsStore(root);
            this.finalStore(root, file);
        }
    }

    public void setPrefsLocation(File prefsFile) {
        this.prefsFile = prefsFile;
    }

    @Override
    public boolean storeConfig(File file) {
        boolean result = true;
        Element root = this.initStore();
        if (!this.addConfigStore(root)) {
            result = false;
        }
        this.includeHistory(root, file);
        if (!this.finalStore(root, file)) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean storeUser(File file) {
        boolean result = true;
        Element root = this.initStore();
        if (!this.addConfigStore(root)) {
            result = false;
        }
        if (!this.addUserStore(root)) {
            result = false;
        }
        this.includeHistory(root, file);
        if (!this.finalStore(root, file)) {
            result = false;
        }
        return result;
    }

    @Override
    public boolean makeBackup(File file) {
        return this.makeBackupFile(FileUtil.getUserFilesPath() + "backupPanels", file);
    }

    public static Element elementFromObject(Object o) {
        return ConfigXmlManager.elementFromObject(o, true);
    }

    public static Element elementFromObject(Object object, boolean shared) {
        String aName = ConfigXmlManager.adapterName(object);
        log.debug("store using {}", (Object)aName);
        XmlAdapter adapter = null;
        try {
            adapter = (XmlAdapter)Class.forName(ConfigXmlManager.adapterName(object)).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException ex) {
            log.error("Cannot load configuration adapter for {}", (Object)object.getClass().getName(), (Object)ex);
        }
        if (adapter != null) {
            return adapter.store(object, shared);
        }
        log.error("Cannot store configuration for {}", (Object)object.getClass().getName());
        return null;
    }

    private void storeVersion(Element root) {
        root.addContent(0, (Content)new Element("jmriversion").addContent((Content)new Element("major").addContent("" + Version.major)).addContent((Content)new Element("minor").addContent("" + Version.minor)).addContent((Content)new Element("test").addContent("" + Version.test)).addContent((Content)new Element("modifier").addContent(Version.getModifier())));
    }

    @Override
    public boolean load(File fi) throws JmriConfigureXmlException {
        return this.load(fi, false);
    }

    @Override
    public boolean load(URL url) throws JmriConfigureXmlException {
        return this.load(url, false);
    }

    @Override
    public boolean load(File fi, boolean registerDeferred) throws JmriConfigureXmlException {
        return this.load(FileUtil.fileToURL(fi), registerDeferred);
    }

    @Override
    public boolean load(URL url, boolean registerDeferred) throws JmriConfigureXmlException {
        log.trace("starting load({}, {})", (Object)url, (Object)registerDeferred);
        Boolean retval = ThreadingUtil.runOnGUIwithReturn(() -> {
            try {
                Boolean ret = this.loadOnSwingThread(url, registerDeferred);
                return ret;
            }
            catch (Exception e) {
                log.trace("  ending load() via JmriConfigureXmlException");
                throw new RuntimeException(e);
            }
        });
        log.trace("  ending load({}, {} with {})", new Object[]{url, registerDeferred, retval});
        return retval;
    }

    @Override
    public void setValidate(XmlFile.Validate v) {
        this.validate = v;
    }

    @Override
    public XmlFile.Validate getValidate() {
        return this.validate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Boolean loadOnSwingThread(URL url, boolean registerDeferred) throws JmriConfigureXmlException {
        boolean result = true;
        Element root = null;
        Map<Object, Integer> loadlist = Collections.synchronizedMap(new LinkedHashMap());
        try {
            this.setValidate(this.validate);
            root = super.rootFromURL(url);
            List items = root.getChildren();
            for (Object item : items) {
                Attribute attribute = item.getAttribute("class");
                if (attribute == null) {
                    log.debug("skipping {}", item);
                    continue;
                }
                String adapterName = attribute.getValue();
                log.debug("attempt to get adapter {} for {}", (Object)adapterName, item);
                adapterName = ConfigXmlManager.currentClassName(adapterName);
                XmlAdapter adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                int order = adapter.loadOrder();
                log.debug("add {} to load list with order id of {}", item, (Object)order);
                loadlist.put(item, order);
            }
            ArrayList l = new ArrayList(loadlist.entrySet());
            Collections.sort(l, (o1, o2) -> ((Integer)o1.getValue()).compareTo((Integer)o2.getValue()));
            for (Map.Entry entry : l) {
                Element item = (Element)entry.getKey();
                String adapterName = item.getAttribute("class").getValue();
                adapterName = ConfigXmlManager.currentClassName(adapterName);
                log.debug("load {} via {}", (Object)item, (Object)adapterName);
                XmlAdapter adapter = null;
                try {
                    adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    if (adapter.loadDeferred() && registerDeferred) {
                        this.loadDeferredList.add(item);
                        log.debug("deferred load registered for {} {}", (Object)item, (Object)adapterName);
                        continue;
                    }
                    boolean loadStatus = adapter.load(item, item);
                    log.debug("load status for {} {} is {}", new Object[]{item, adapterName, loadStatus});
                    if (loadStatus) continue;
                    result = false;
                }
                catch (Exception e) {
                    ConfigXmlManager.creationErrorEncountered(adapter, "load(" + url.getFile() + ")", "Unexpected error (Exception)", null, null, e);
                    result = false;
                }
                catch (Throwable et) {
                    ConfigXmlManager.creationErrorEncountered(adapter, "in load(" + url.getFile() + ")", "Unexpected error (Throwable)", null, null, et);
                    result = false;
                }
            }
        }
        catch (FileNotFoundException e1) {
            ConfigXmlManager.creationErrorEncountered(null, "opening file " + url.getFile(), "File not found", null, null, e1);
            result = false;
        }
        catch (JDOMException e) {
            ConfigXmlManager.creationErrorEncountered(null, "parsing file " + url.getFile(), "Parse error", null, null, e);
            result = false;
        }
        catch (IOException e) {
            ConfigXmlManager.creationErrorEncountered(null, "loading from file " + url.getFile(), "IOException", null, null, e);
            result = false;
        }
        catch (ClassNotFoundException e) {
            ConfigXmlManager.creationErrorEncountered(null, "loading from file " + url.getFile(), "ClassNotFoundException", null, null, e);
            result = false;
        }
        catch (InstantiationException e) {
            ConfigXmlManager.creationErrorEncountered(null, "loading from file " + url.getFile(), "InstantiationException", null, null, e);
            result = false;
        }
        catch (IllegalAccessException e) {
            ConfigXmlManager.creationErrorEncountered(null, "loading from file " + url.getFile(), "IllegalAccessException", null, null, e);
            result = false;
        }
        catch (NoSuchMethodException e) {
            ConfigXmlManager.creationErrorEncountered(null, "loading from file " + url.getFile(), "NoSuchMethodException", null, null, e);
            result = false;
        }
        catch (InvocationTargetException e) {
            ConfigXmlManager.creationErrorEncountered(null, "loading from file " + url.getFile(), "InvocationTargetException", null, null, e);
            result = false;
        }
        finally {
            handler.done();
        }
        FileHistory r = InstanceManager.getNullableDefault(FileHistory.class);
        if (r != null) {
            Element filehistory;
            FileHistory included = null;
            if (root != null && (filehistory = root.getChild("filehistory")) != null) {
                included = FileHistoryXml.loadFileHistory(filehistory);
            }
            String friendlyName = url.getFile().replaceAll("%20", " ");
            r.addOperation(result ? "Load OK" : "Load with errors", friendlyName, included);
        } else {
            log.info("Not recording file history");
        }
        return result;
    }

    @Override
    public boolean loadDeferred(File fi) {
        return this.loadDeferred(FileUtil.fileToURL(fi));
    }

    @Override
    public boolean loadDeferred(URL url) {
        boolean result = true;
        log.debug("Start processing deferred load list (size): {}", (Object)this.loadDeferredList.size());
        if (!this.loadDeferredList.isEmpty()) {
            for (Element item : this.loadDeferredList) {
                String adapterName = item.getAttribute("class").getValue();
                log.debug("deferred load via {}", (Object)adapterName);
                XmlAdapter adapter = null;
                try {
                    adapter = (XmlAdapter)Class.forName(adapterName).getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                    boolean loadStatus = adapter.load(item, item);
                    log.debug("deferred load status for {} is {}", (Object)adapterName, (Object)loadStatus);
                    if (loadStatus) continue;
                    result = false;
                }
                catch (Exception e) {
                    ConfigXmlManager.creationErrorEncountered(adapter, "deferred load(" + url.getFile() + ")", "Unexpected error (Exception)", null, null, e);
                    result = false;
                }
                catch (Throwable et) {
                    ConfigXmlManager.creationErrorEncountered(adapter, "in deferred load(" + url.getFile() + ")", "Unexpected error (Throwable)", null, null, et);
                    result = false;
                }
            }
        }
        log.debug("Done processing deferred load list with result: {}", (Object)result);
        return result;
    }

    @Override
    public URL find(String f) {
        URL u = FileUtil.findURL(f, "xml/layout", "xml");
        if (u == null) {
            this.locateFileFailed(f);
        }
        return u;
    }

    void locateFileFailed(String f) {
        log.warn("Could not locate file {}", (Object)f);
    }

    public static void creationErrorEncountered(XmlAdapter adapter, String operation, String description, String systemName, String userName, Throwable exception) {
        ErrorMemo e = new ErrorMemo(adapter, operation, description, systemName, userName, exception, "loading");
        if (adapter != null) {
            ErrorHandler aeh = adapter.getExceptionHandler();
            if (aeh != null) {
                aeh.handle(e);
            }
        } else {
            handler.handle(e);
        }
    }

    public static void storingErrorEncountered(XmlAdapter adapter, String operation, String description, String systemName, String userName, Throwable exception) {
        ErrorMemo e = new ErrorMemo(adapter, operation, description, systemName, userName, exception, "storing");
        if (adapter != null) {
            ErrorHandler aeh = adapter.getExceptionHandler();
            if (aeh != null) {
                aeh.handle(e);
            }
        } else {
            handler.handle(e);
        }
    }

    public static void setErrorHandler(ErrorHandler handler) {
        ConfigXmlManager.handler = handler;
    }

    protected List<Element> getLoadDeferredList() {
        return this.loadDeferredList;
    }
}

