/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import jmri.configurexml.AbstractXmlAdapter;
import org.jdom2.Attribute;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultJavaBeanConfigXML
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(DefaultJavaBeanConfigXML.class);

    @Override
    public boolean load(Element shared, Element perNode) {
        return true;
    }

    @Override
    public void load(Element e, Object o) {
    }

    Object unpack(Element e) throws ClassNotFoundException, NoSuchMethodException, InstantiationException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        String classname = e.getAttributeValue("beanClass");
        Class<?> cl = Class.forName(classname);
        Constructor<?> ctor = cl.getConstructor(new Class[0]);
        Object o = ctor.newInstance(new Object[0]);
        BeanInfo b = Introspector.getBeanInfo(o.getClass());
        PropertyDescriptor[] properties = b.getPropertyDescriptors();
        List children = e.getChildren("property");
        block0: for (int i = 0; i < children.size(); ++i) {
            Element property = (Element)children.get(i);
            Element eName = property.getChild("name");
            Element eValue = property.getChild("value");
            String name = eName.getText();
            String value = eValue.getText();
            String type = eName.getAttributeValue("type");
            for (int j = 0; j < properties.length; ++j) {
                if (!properties[j].getName().equals(name)) continue;
                Method m = properties[j].getWriteMethod();
                if (type.equals("class java.lang.String")) {
                    m.invoke(o, value);
                    continue block0;
                }
                if (type.equals("int")) {
                    m.invoke(o, Integer.valueOf(value));
                    continue block0;
                }
                log.error("Can't handle type: {}", (Object)type);
                continue block0;
            }
        }
        return o;
    }

    @Override
    public Element store(Object o) {
        Element e = new Element("javabean");
        e.setAttribute("class", this.getClass().getName());
        e.setAttribute("beanClass", o.getClass().getName());
        try {
            BeanInfo b = Introspector.getBeanInfo(o.getClass());
            PropertyDescriptor[] properties = b.getPropertyDescriptors();
            for (int i = 0; i < properties.length; ++i) {
                Object value;
                if (properties[i].getName().equals("class")) continue;
                if (properties[i].getPropertyType() == null) {
                    log.warn("skipping property with null type: {}", (Object)properties[i].getName());
                    continue;
                }
                Element p = new Element("property");
                Element n = new Element("name");
                n.addContent(properties[i].getName());
                n.setAttribute("type", properties[i].getPropertyType().toString());
                p.addContent((Content)n);
                Element v = new Element("value");
                if (properties[i].getReadMethod() != null && (value = properties[i].getReadMethod().invoke(o, (Object[])null)) != null) {
                    v.addContent(value.toString());
                }
                p.addContent((Content)v);
                e.addContent((Content)p);
            }
        }
        catch (IntrospectionException ex) {
            log.error("Partial store due to IntrospectionException", (Throwable)ex);
        }
        catch (InvocationTargetException ex) {
            log.error("Partial store due to InvocationTargetException", (Throwable)ex);
        }
        catch (IllegalAccessException ex) {
            log.error("Partial store due to IllegalAccessException", (Throwable)ex);
        }
        return e;
    }

    String getAttributeString(Element elem, String name) {
        Attribute a = elem.getAttribute(name);
        if (a != null) {
            return a.getValue();
        }
        return null;
    }

    boolean getAttributeBool(Element elem, String name, boolean def) {
        String v = this.getAttributeString(elem, name);
        if (v == null) {
            return def;
        }
        if (def) {
            return !v.equals("false");
        }
        return v.equals("true");
    }
}

