/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jmri.configurexml.ErrorMemo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorHandler {
    private static final Logger log = LoggerFactory.getLogger(ErrorHandler.class);

    public void handle(ErrorMemo e) {
        StringBuilder m = new StringBuilder(e.description);
        if (e.systemName != null) {
            m.append(" System name \"").append(e.systemName).append("\"");
        }
        if (e.userName != null && !e.userName.isEmpty()) {
            m.append(" User name \"").append(e.userName).append("\"");
        }
        if (e.operation != null) {
            m.append(" while ").append(e.operation);
        }
        if (e.adapter != null) {
            m.append(" in adaptor of type ").append(e.adapter.getClass().getName());
        }
        if (e.exception != null) {
            m.append(" Exception: ").append(e.exception.toString());
        }
        m.append("\nSee http://jmri.org/help/en/package/jmri/configurexml/ErrorHandler.shtml for possibly more information.");
        if (e.exception != null) {
            log.error("Load Error: {}", (Object)m.toString(), (Object)e.exception);
        } else {
            log.error("Load Error: {}", (Object)m.toString());
        }
    }

    @SuppressFBWarnings(value={"NM_CONFUSING"}, justification="Seems to be a false positive due to jmri.jmris.simpleserver.parser.SimpleCharStream.Done()")
    public void done() {
    }
}

