/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import jmri.BooleanPermission;
import jmri.PermissionFactory;
import jmri.PermissionManager;
import jmri.PermissionOwner;
import jmri.Role;
import jmri.configurexml.Bundle;

public class LoadAndStorePermissionOwner
implements PermissionOwner {
    public static final LoadAndStorePermissionOwner LOAD_AND_STORE_PERMISSION_OWNER = new LoadAndStorePermissionOwner();
    public static final LoadXmlFilePermission LOAD_XML_FILE_PERMISSION = new LoadXmlFilePermission(LOAD_AND_STORE_PERMISSION_OWNER);
    public static final StoreXmlFilePermission STORE_XML_FILE_PERMISSION = new StoreXmlFilePermission(LOAD_AND_STORE_PERMISSION_OWNER);

    @Override
    public String getName() {
        return Bundle.getMessage("LoadAndStorePermissionOwner_Name");
    }

    public static class StoreXmlFilePermission
    implements BooleanPermission {
        private final PermissionOwner _owner;

        private StoreXmlFilePermission(PermissionOwner owner) {
            this._owner = owner;
        }

        @Override
        public PermissionOwner getOwner() {
            return this._owner;
        }

        @Override
        public String getName() {
            return Bundle.getMessage("LoadAndStorePermission_Store");
        }

        @Override
        public BooleanPermission.BooleanValue getDefaultPermission(Role role) {
            return BooleanPermission.BooleanValue.get(role.isAdminRole());
        }
    }

    public static class LoadXmlFilePermission
    implements BooleanPermission {
        private final PermissionOwner _owner;

        private LoadXmlFilePermission(PermissionOwner owner) {
            this._owner = owner;
        }

        @Override
        public PermissionOwner getOwner() {
            return this._owner;
        }

        @Override
        public String getName() {
            return Bundle.getMessage("LoadAndStorePermission_Load");
        }

        @Override
        public BooleanPermission.BooleanValue getDefaultPermission(Role role) {
            return BooleanPermission.BooleanValue.get(role.isAdminRole());
        }
    }

    public static class Factory
    implements PermissionFactory {
        @Override
        public void register(PermissionManager manager) {
            manager.registerOwner(LOAD_AND_STORE_PERMISSION_OWNER);
            manager.registerPermission(LOAD_XML_FILE_PERMISSION);
            manager.registerPermission(STORE_XML_FILE_PERMISSION);
        }
    }
}

