/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.util.prefs.Preferences;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.PreferencesBean;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;

public final class LoadAndStorePreferences
extends PreferencesBean
implements InstanceManagerAutoDefault {
    public static final String EXCLUDE_FILE_HISTORY = "excludeFileHistory";
    public static final String EXCLUDE_MEMORY_IMCURRENTTIME = "excludeMemoryIMCURRENTTIME";
    public static final String EXCLUDE_JMRI_VERSION = "excludeJmriVersion";
    private boolean _excludeFileHistory = false;
    private boolean _excludeMemoryIMCURRENTTIME = false;
    private boolean _excludeJmriVersion = false;

    public LoadAndStorePreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this._excludeFileHistory = sharedPreferences.getBoolean(EXCLUDE_FILE_HISTORY, false);
        this._excludeMemoryIMCURRENTTIME = sharedPreferences.getBoolean(EXCLUDE_MEMORY_IMCURRENTTIME, false);
        this._excludeJmriVersion = sharedPreferences.getBoolean(EXCLUDE_JMRI_VERSION, false);
        this.setIsDirty(false);
    }

    public boolean compareValuesDifferent(LoadAndStorePreferences prefs) {
        if (this.isExcludeFileHistory() != prefs.isExcludeFileHistory()) {
            return true;
        }
        if (this.isExcludeMemoryIMCURRENTTIME() != prefs.isExcludeMemoryIMCURRENTTIME()) {
            return true;
        }
        return this.isExcludeJmriVersion() != prefs.isExcludeJmriVersion();
    }

    public void apply(LoadAndStorePreferences prefs) {
        this.setExcludeFileHistory(prefs.isExcludeFileHistory());
        this.setExcludeMemoryIMCURRENTTIME(prefs.isExcludeMemoryIMCURRENTTIME());
        this.setExcludeJmriVersion(prefs.isExcludeJmriVersion());
    }

    public void save() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putBoolean(EXCLUDE_FILE_HISTORY, this.isExcludeFileHistory());
        sharedPreferences.putBoolean(EXCLUDE_MEMORY_IMCURRENTTIME, this.isExcludeMemoryIMCURRENTTIME());
        sharedPreferences.putBoolean(EXCLUDE_JMRI_VERSION, this.isExcludeJmriVersion());
        this.setIsDirty(false);
    }

    public void setExcludeFileHistory(boolean value) {
        this._excludeFileHistory = value;
        this.setIsDirty(true);
    }

    public boolean isExcludeFileHistory() {
        return this._excludeFileHistory;
    }

    public void setExcludeMemoryIMCURRENTTIME(boolean value) {
        this._excludeMemoryIMCURRENTTIME = value;
        this.setIsDirty(true);
    }

    public boolean isExcludeMemoryIMCURRENTTIME() {
        return this._excludeMemoryIMCURRENTTIME;
    }

    public void setExcludeJmriVersion(boolean value) {
        this._excludeJmriVersion = value;
        this.setIsDirty(true);
    }

    public boolean isExcludeJmriVersion() {
        return this._excludeJmriVersion;
    }
}

