/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.JFileChooser;
import jmri.BooleanPermission;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.LogixManager;
import jmri.PermissionManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.Bundle;
import jmri.configurexml.LoadAndStorePermissionOwner;
import jmri.configurexml.LoadStoreBaseAction;
import jmri.jmrit.display.Editor;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.logixng.LogixNGPreferences;
import jmri.jmrit.logixng.LogixNG_Manager;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadXmlConfigAction
extends LoadStoreBaseAction {
    private static final Logger log = LoggerFactory.getLogger(LoadXmlConfigAction.class);

    public LoadXmlConfigAction() {
        this("Open Data File ...");
    }

    public LoadXmlConfigAction(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(LoadAndStorePermissionOwner.LOAD_XML_FILE_PERMISSION, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        this.loadFile(LoadXmlConfigAction.getConfigFileChooser(), JmriJOptionPane.findWindowForObject(e == null ? null : e.getSource()));
    }

    protected boolean loadFile(@Nonnull JFileChooser fileChooser, @CheckForNull Component component) {
        SortedSet<Editor> editors = InstanceManager.getDefault(EditorManager.class).getAll();
        if (!editors.isEmpty()) {
            InstanceManager.getDefault(UserPreferencesManager.class).showWarningMessage(Bundle.getMessage("DuplicateLoadTitle"), Bundle.getMessage("DuplicateLoadMessage"), "jmri.jmrit.display.EditorManager", "skipDupLoadDialog", false, true);
            InstanceManager.getDefault(UserPreferencesManager.class).setPreferenceItemDetails("jmri.jmrit.display.EditorManager", "skipDupLoadDialog", Bundle.getMessage("DuplicateLoadSkip"));
        }
        boolean results = false;
        File file = LoadXmlConfigAction.getFile(fileChooser, component);
        if (file != null) {
            log.info("Loading selected file: {}", (Object)file);
            try {
                ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
                if (cm == null) {
                    log.error("Failed to get default configure manager");
                } else {
                    results = cm.load(file);
                    LogixNG_Manager logixNG_Manager = InstanceManager.getDefault(LogixNG_Manager.class);
                    logixNG_Manager.setupAllLogixNGs();
                    if (results) {
                        InstanceManager.getDefault(LogixManager.class).activateAllLogixs();
                        InstanceManager.getDefault(LayoutBlockManager.class).initializeLayoutBlockPaths();
                        if (InstanceManager.getDefault(LogixNGPreferences.class).getStartLogixNGOnStartup() && logixNG_Manager.isStartLogixNGsOnLoad()) {
                            logixNG_Manager.activateAllLogixNGs();
                        }
                    }
                }
            }
            catch (JmriException e) {
                log.error("Unhandled problem in loadFile", (Throwable)e);
            }
        } else {
            results = true;
        }
        return results;
    }

    @CheckForNull
    @Deprecated(since="5.7.8", forRemoval=true)
    public static File getFile(@Nonnull JFileChooser fileChooser) {
        return LoadXmlConfigAction.getFile(fileChooser, null);
    }

    @CheckForNull
    public static File getFile(@Nonnull JFileChooser fileChooser, @CheckForNull Component component) {
        fileChooser.setDialogType(0);
        return LoadXmlConfigAction.getFileCustom(fileChooser, component);
    }

    @CheckForNull
    @Deprecated(since="5.7.8", forRemoval=true)
    public static File getFileCustom(@Nonnull JFileChooser fileChooser) {
        return LoadXmlConfigAction.getFileCustom(fileChooser, null);
    }

    @CheckForNull
    public static File getFileCustom(@Nonnull JFileChooser fileChooser, @CheckForNull Component component) {
        fileChooser.rescanCurrentDirectory();
        int retVal = fileChooser.showDialog(component, Bundle.getMessage("MenuItemLoad"));
        if (retVal != 0) {
            return null;
        }
        log.debug("Open file: {}", (Object)fileChooser.getSelectedFile().getPath());
        return fileChooser.getSelectedFile();
    }
}

