/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import jmri.BooleanPermission;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.configurexml.Bundle;
import jmri.configurexml.LoadAndStorePermissionOwner;
import jmri.configurexml.LoadXmlConfigAction;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadXmlUserAction
extends LoadXmlConfigAction {
    private static File currentFile = null;
    private static final Logger log = LoggerFactory.getLogger(LoadXmlUserAction.class);

    public LoadXmlUserAction() {
        this(Bundle.getMessage("MenuItemLoad"));
    }

    public LoadXmlUserAction(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(LoadAndStorePermissionOwner.LOAD_XML_FILE_PERMISSION, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        JFileChooser userFileChooser = LoadXmlUserAction.getUserFileChooser();
        userFileChooser.setDialogType(0);
        userFileChooser.setApproveButtonText(Bundle.getMessage("ButtonOpen"));
        userFileChooser.setDialogTitle(Bundle.getMessage("LoadTitle"));
        Window window = JmriJOptionPane.findWindowForObject(e == null ? null : e.getSource());
        boolean results = this.loadFile(userFileChooser, window);
        if (results) {
            log.debug("load was successful");
            LoadXmlUserAction.setCurrentFile(userFileChooser.getSelectedFile());
        } else {
            log.debug("load failed");
            JmriJOptionPane.showMessageDialog(window, Bundle.getMessage("LoadHasErrors") + "\n" + Bundle.getMessage("CheckPreferences") + "\n" + Bundle.getMessage("ConsoleWindowHasInfo"), Bundle.getMessage("LoadError"), 0);
            LoadXmlUserAction.setCurrentFile(null);
        }
    }

    public static File getCurrentFile() {
        return currentFile;
    }

    private static void setCurrentFile(File arg) {
        currentFile = arg;
    }
}

