/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.annotation.CheckForNull;
import jmri.Scale;
import jmri.ScaleManager;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import org.jdom2.Content;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.Namespace;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScaleConfigXML {
    private static final Logger log = LoggerFactory.getLogger(ScaleConfigXML.class);

    private ScaleConfigXML() {
    }

    public static boolean doStore() {
        ScaleXmlFile x = new ScaleXmlFile();
        File file = x.getStoreFile();
        if (file == null) {
            log.warn("Unable to create local scale file");
            return false;
        }
        Element root = new Element("scale-data");
        root.setAttribute("noNamespaceSchemaLocation", "http://jmri.org/xml/schema/scale.xsd", Namespace.getNamespace((String)"xsi", (String)"http://www.w3.org/2001/XMLSchema-instance"));
        Document doc = new Document(root);
        Element values = new Element("scales");
        root.addContent((Content)values);
        for (Scale scale : ScaleManager.getScales()) {
            Element e = new Element("scale");
            e.addContent((Content)new Element("scale_name").addContent(scale.getScaleName()));
            e.addContent((Content)new Element("user_name").addContent(scale.getUserName()));
            e.addContent((Content)new Element("scale_ratio").addContent(Double.toString(scale.getScaleRatio())));
            values.addContent((Content)e);
        }
        try {
            x.writeXML(file, doc);
        }
        catch (FileNotFoundException ex) {
            log.error("File not found when writing", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("IO Exception when writing", (Throwable)ex);
            return false;
        }
        return true;
    }

    public static boolean doLoad() {
        ScaleXmlFile x = new ScaleXmlFile();
        File file = x.getLoadFile();
        if (file == null) {
            log.error("Scale File {} not located", (Object)"ScaleData.xml");
            return false;
        }
        try {
            Element root = x.rootFromFile(file);
            if (root == null) {
                log.debug("File could not be read");
                return false;
            }
            Element scales = root.getChild("scales");
            if (scales == null) {
                log.error("Unable to find a scale entry");
                return false;
            }
            for (Element scale : scales.getChildren("scale")) {
                Element e = scale.getChild("scale_name");
                String scaleName = e == null ? "" : e.getValue();
                e = scale.getChild("user_name");
                String userName = e == null ? "" : e.getValue();
                e = scale.getChild("scale_ratio");
                double scaleRatio = e == null ? 1.0 : Double.parseDouble(e.getValue());
                ScaleManager.addScale(scaleName, userName, scaleRatio);
            }
        }
        catch (JDOMException ex) {
            log.error("File invalid", (Throwable)ex);
            return false;
        }
        catch (IOException ex) {
            log.error("Error reading file", (Throwable)ex);
            return false;
        }
        return true;
    }

    private static class ScaleXmlFile
    extends XmlFile {
        private static final String PROG_PATH = FileUtil.getProgramPath() + "resources/scales/";
        private static final String USER_PATH = FileUtil.getUserFilesPath() + "resources/scales/";
        private static final String FILENAME = "ScaleData.xml";

        private ScaleXmlFile() {
        }

        static String getStoreFileName() {
            return USER_PATH + FILENAME;
        }

        @CheckForNull
        File getStoreFile() {
            File chkdir = new File(USER_PATH);
            if (!chkdir.exists() && !chkdir.mkdirs()) {
                return null;
            }
            File file = this.findFile(ScaleXmlFile.getStoreFileName());
            if (file == null) {
                log.info("Create new scale file");
                file = new File(ScaleXmlFile.getStoreFileName());
            } else {
                try {
                    FileUtil.rotate(file, 4, "bup");
                }
                catch (IOException ex) {
                    log.warn("Rotate failed, reverting to xml backup");
                    this.makeBackupFile(ScaleXmlFile.getStoreFileName());
                }
            }
            return file;
        }

        @CheckForNull
        File getLoadFile() {
            File file = this.findFile(USER_PATH + FILENAME);
            if (file == null) {
                file = this.findFile(PROG_PATH + FILENAME);
            }
            return file;
        }
    }
}

