/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.util.prefs.Preferences;
import jmri.InstanceManagerAutoDefault;
import jmri.beans.PreferencesBean;
import jmri.configurexml.Bundle;
import jmri.profile.ProfileManager;
import jmri.profile.ProfileUtils;

public final class ShutdownPreferences
extends PreferencesBean
implements InstanceManagerAutoDefault {
    public static final String ENABLE_STORE_CHECK = "enableStoreCheck";
    public static final String IGNORE_TIMEBASE = "ignoreTimebase";
    public static final String IGNORE_SENSORCOLORS = "ignoreSensorColors";
    public static final String DISPLAY_DIALOG = "displayDialog";
    private boolean _enableStoreCheck = false;
    private boolean _ignoreTimebase = false;
    private boolean _ignoreSensorColors = false;
    private DialogDisplayOptions _displayDialog = DialogDisplayOptions.ShowDialog;

    public ShutdownPreferences() {
        super(ProfileManager.getDefault().getActiveProfile());
        Preferences sharedPreferences = ProfileUtils.getPreferences(super.getProfile(), this.getClass(), true);
        this.readPreferences(sharedPreferences);
    }

    private void readPreferences(Preferences sharedPreferences) {
        this._enableStoreCheck = sharedPreferences.getBoolean(ENABLE_STORE_CHECK, true);
        this._ignoreTimebase = sharedPreferences.getBoolean(IGNORE_TIMEBASE, false);
        this._ignoreSensorColors = sharedPreferences.getBoolean(IGNORE_SENSORCOLORS, false);
        String display = sharedPreferences.get(DISPLAY_DIALOG, "ShowDialog");
        this._displayDialog = DialogDisplayOptions.valueOf(display);
        this.setIsDirty(false);
    }

    public boolean compareValuesDifferent(ShutdownPreferences prefs) {
        if (this.isStoreCheckEnabled() != prefs.isStoreCheckEnabled()) {
            return true;
        }
        if (this.isIgnoreTimebaseEnabled() != prefs.isIgnoreTimebaseEnabled()) {
            return true;
        }
        if (this.isIgnoreSensorColorsEnabled() != prefs.isIgnoreSensorColorsEnabled()) {
            return true;
        }
        return !this.getDisplayDialog().equals((Object)prefs.getDisplayDialog());
    }

    public void apply(ShutdownPreferences prefs) {
        this.setEnableStoreCheck(prefs.isStoreCheckEnabled());
        this.setIgnoreTimebase(prefs.isIgnoreTimebaseEnabled());
        this.setIgnoreSensorColors(prefs.isIgnoreSensorColorsEnabled());
        this.setDisplayDialog(prefs.getDisplayDialog());
    }

    public void save() {
        Preferences sharedPreferences = ProfileUtils.getPreferences(this.getProfile(), this.getClass(), true);
        sharedPreferences.putBoolean(ENABLE_STORE_CHECK, this.isStoreCheckEnabled());
        sharedPreferences.putBoolean(IGNORE_TIMEBASE, this.isIgnoreTimebaseEnabled());
        sharedPreferences.putBoolean(IGNORE_SENSORCOLORS, this.isIgnoreSensorColorsEnabled());
        sharedPreferences.put(DISPLAY_DIALOG, this.getDisplayDialog().name());
        this.setIsDirty(false);
    }

    public void setEnableStoreCheck(boolean value) {
        this._enableStoreCheck = value;
        this.setIsDirty(true);
    }

    public boolean isStoreCheckEnabled() {
        return this._enableStoreCheck;
    }

    public void setIgnoreTimebase(boolean value) {
        this._ignoreTimebase = value;
        this.setIsDirty(true);
    }

    public boolean isIgnoreTimebaseEnabled() {
        return this._ignoreTimebase;
    }

    public void setIgnoreSensorColors(boolean value) {
        this._ignoreSensorColors = value;
        this.setIsDirty(true);
    }

    public boolean isIgnoreSensorColorsEnabled() {
        return this._ignoreSensorColors;
    }

    public void setDisplayDialog(DialogDisplayOptions value) {
        this._displayDialog = value;
        this.setIsDirty(true);
    }

    public DialogDisplayOptions getDisplayDialog() {
        return this._displayDialog;
    }

    public static enum DialogDisplayOptions {
        ShowDialog(Bundle.getMessage("OptionDisplay")),
        SkipDialog(Bundle.getMessage("OptionSkip"));

        private final String _description;

        private DialogDisplayOptions(String description) {
            this._description = description;
        }

        public String toString() {
            return this._description;
        }
    }
}

