/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.GraphicsEnvironment;
import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.UUID;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import jmri.Application;
import jmri.BooleanPermission;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.MemoryManager;
import jmri.PermissionManager;
import jmri.SensorManager;
import jmri.TurnoutManager;
import jmri.configurexml.LoadAndStorePermissionOwner;
import jmri.configurexml.LoadStoreBaseAction;
import jmri.configurexml.ShutdownPreferences;
import jmri.configurexml.swing.StoreAndCompareDialog;
import jmri.jmrit.display.EditorManager;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreAndCompare
extends AbstractAction {
    private static ShutdownPreferences _preferences = InstanceManager.getDefault(ShutdownPreferences.class);
    private static final Logger log = LoggerFactory.getLogger(StoreAndCompare.class);

    public StoreAndCompare() {
        this("Store and Compare");
    }

    public StoreAndCompare(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        StoreAndCompare.requestStoreIfNeeded();
    }

    public static boolean checkPermissionToStoreIfNeeded() {
        if (InstanceManager.getDefault(PermissionManager.class).hasAtLeastPermission(LoadAndStorePermissionOwner.STORE_XML_FILE_PERMISSION, BooleanPermission.BooleanValue.TRUE)) {
            return false;
        }
        if (Application.getApplicationName().equals("PanelPro") && _preferences.isStoreCheckEnabled() && StoreAndCompare.dataHasChanged() && !GraphicsEnvironment.isHeadless()) {
            return StoreAndCompareDialog.showAbortShutdownDialogPermissionDenied();
        }
        return false;
    }

    public static void requestStoreIfNeeded() {
        if (!InstanceManager.getDefault(PermissionManager.class).hasAtLeastPermission(LoadAndStorePermissionOwner.STORE_XML_FILE_PERMISSION, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        if (Application.getApplicationName().equals("PanelPro") && _preferences.isStoreCheckEnabled()) {
            ThreadingUtil.runOnGUI(() -> {
                if (StoreAndCompare.dataHasChanged() && !GraphicsEnvironment.isHeadless()) {
                    StoreAndCompareDialog.showDialog();
                }
            });
        }
    }

    public static boolean dataHasChanged() {
        boolean result = false;
        JFileChooser chooser = LoadStoreBaseAction.getUserFileChooser();
        File file1 = chooser.getSelectedFile();
        if (file1 == null) {
            return StoreAndCompare.noFileChecks();
        }
        String tempDir = System.getProperty("java.io.tmpdir") + File.separator;
        String fileName = UUID.randomUUID().toString();
        File file2 = new File(tempDir + fileName + ".xml");
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm != null) {
            boolean stored = cm.storeUser(file2);
            log.debug("temp file '{}' stored :: {}", (Object)file2, (Object)stored);
            try {
                result = StoreAndCompare.checkFile(file1, file2);
            }
            catch (Exception ex) {
                log.debug("checkFile exception: ", (Throwable)ex);
            }
            if (!file2.delete()) {
                log.warn("An error occurred while deleting temporary file {}", (Object)file2.getPath());
            }
        }
        return result;
    }

    @SuppressFBWarnings(value={"RCN_REDUNDANT_NULLCHECK_OF_NONNULL_VALUE"}, justification="spotbugs did not like the protection provided by the result boolean, but the second test was declared redundant")
    private static boolean noFileChecks() {
        boolean result = false;
        TurnoutManager tMgr = InstanceManager.getDefault(TurnoutManager.class);
        SensorManager sMgr = InstanceManager.getDefault(SensorManager.class);
        MemoryManager mMgr = InstanceManager.getDefault(MemoryManager.class);
        String systemPrefix = "I";
        if (mMgr != null) {
            systemPrefix = mMgr.getSystemPrefix();
        }
        if (tMgr == null || sMgr == null || mMgr == null) {
            log.debug("triple manager test sets true");
            result = true;
        }
        if (!result && tMgr != null && tMgr.getNamedBeanSet().size() > 0) {
            log.debug("turnout manager test sets true");
            result = true;
        }
        if (!result && sMgr != null) {
            int sensorSize = sMgr.getNamedBeanSet().size();
            if (sensorSize > 1) {
                log.debug("sensor > 1 sets true");
                result = true;
            } else if (sensorSize == 1 && sMgr.getBySystemName(systemPrefix + "SCLOCKRUNNING") == null) {
                log.debug("sensor == 1 sets true");
                result = true;
            }
        }
        if (!result && mMgr != null) {
            int memSize = mMgr.getNamedBeanSet().size();
            if (memSize > 2) {
                log.debug("memory > 2 sets true");
                result = true;
            } else if (memSize != 0) {
                if (mMgr.getBySystemName(systemPrefix + "MCURRENTTIME") == null) {
                    log.debug("memory no MCURRENTTIME sets true");
                    result = true;
                }
                if (mMgr.getBySystemName(systemPrefix + "MRATEFACTOR") == null) {
                    log.debug("memory no MRATEFACTOR sets true");
                    result = true;
                }
            }
        }
        if (!result && InstanceManager.getDefault(EditorManager.class).getList().size() > 0) {
            log.debug("panel check sets true");
            result = true;
        }
        return result;
    }

    @SuppressFBWarnings(value={"OS_OPEN_STREAM_EXCEPTION_PATH", "RV_DONT_JUST_NULL_CHECK_READLINE"}, justification="Open streams are not a problem during JMRI shutdown.The line represents the end of a XML comment and is not relevant")
    public static boolean checkFile(File inFile1, File inFile2) throws Exception {
        String next2;
        String next1;
        boolean result = false;
        BufferedReader fileStream1 = new BufferedReader(new InputStreamReader(new FileInputStream(inFile1)));
        BufferedReader fileStream2 = new BufferedReader(new InputStreamReader(new FileInputStream(inFile2)));
        String line1 = fileStream1.readLine();
        String line2 = fileStream2.readLine();
        int lineNumber1 = 0;
        int lineNumber2 = 0;
        while ((next1 = fileStream1.readLine()) != null && (next2 = fileStream2.readLine()) != null) {
            String[] startsWithStrings;
            String filehistory;
            ++lineNumber1;
            ++lineNumber2;
            if (next1.startsWith("<!--")) {
                while ((next1 = fileStream1.readLine()) != null && !next1.endsWith("-->")) {
                    ++lineNumber1;
                }
                if (fileStream1.readLine() != null) continue;
                break;
            }
            String entryexitpairs = "<entryexitpairs class=\"jmri.jmrit.signalling.configurexml.EntryExitPairsXml\" />";
            if (line1.contains(entryexitpairs)) {
                line1 = next1;
                next1 = fileStream1.readLine();
                if (next1 == null) break;
                ++lineNumber1;
            }
            if (line2.contains(entryexitpairs)) {
                line2 = next2;
                next2 = fileStream2.readLine();
                if (next2 == null) break;
                ++lineNumber2;
            }
            if (line1.contains(filehistory = "filehistory") && line2.contains(filehistory)) break;
            boolean match = false;
            for (String startsWithString : startsWithStrings = new String[]{"  <!--Written by JMRI version", "    <test>", "    <modifier", "    <major", "    <minor", "<layout-config", "<?xml-stylesheet", "    <memory systemName=\"IMCURRENTTIME\"", "    <modifier>This line ignored</modifier>"}) {
                if (!line1.startsWith(startsWithString) || !line2.startsWith(startsWithString)) continue;
                match = true;
                break;
            }
            if (!match) {
                boolean mem2;
                boolean mem1 = line1.startsWith("    <memory value") || line1.startsWith("    <memory>");
                boolean bl = mem2 = line2.startsWith("    <memory value") || line2.startsWith("    <memory>");
                if (mem1 && mem2) {
                    match = true;
                }
            }
            if (!match && line1.contains("  <LayoutEditor")) {
                String windowheight_regexe = "( windowheight=\"[^\"]*\")";
                line1 = StoreAndCompare.filterLineUsingRegEx(line1, windowheight_regexe);
                line2 = StoreAndCompare.filterLineUsingRegEx(line2, windowheight_regexe);
                String windowwidth_regexe = "( windowwidth=\"[^\"]*\")";
                line1 = StoreAndCompare.filterLineUsingRegEx(line1, windowwidth_regexe);
                line2 = StoreAndCompare.filterLineUsingRegEx(line2, windowwidth_regexe);
            }
            if (!match && (line1.contains("  <LayoutEditor") || line1.contains(" <switchboardeditor"))) {
                String yposition_regexe = "( y=\"[^\"]*\")";
                line1 = StoreAndCompare.filterLineUsingRegEx(line1, yposition_regexe);
                line2 = StoreAndCompare.filterLineUsingRegEx(line2, yposition_regexe);
                String xposition_regexe = "( x=\"[^\"]*\")";
                line1 = StoreAndCompare.filterLineUsingRegEx(line1, xposition_regexe);
                line2 = StoreAndCompare.filterLineUsingRegEx(line2, xposition_regexe);
            }
            String date_string = "<date>";
            if (!match && line1.contains(date_string) && line2.contains(date_string)) {
                match = true;
            }
            if (!match) {
                String fontname_regexe = "( fontname=\"[^\"]*\")";
                line1 = StoreAndCompare.filterLineUsingRegEx(line1, fontname_regexe);
                line2 = StoreAndCompare.filterLineUsingRegEx(line2, fontname_regexe);
                String fontFamily_regexe = "( fontFamily=\"[^\"]*\")";
                line1 = StoreAndCompare.filterLineUsingRegEx(line1, fontFamily_regexe);
                line2 = StoreAndCompare.filterLineUsingRegEx(line2, fontFamily_regexe);
            }
            if (!match && line1.startsWith("  <timebase") && line2.startsWith("  <timebase") && _preferences.isIgnoreTimebaseEnabled()) {
                match = true;
            }
            if (!match && line1.startsWith("    <sensoricon") && line2.startsWith("    <sensoricon") && line1.contains("icon=\"no\"") && line2.contains("icon=\"no\"") && _preferences.isIgnoreSensorColorsEnabled()) {
                line1 = StoreAndCompare.removeSensorColors(line1);
                line2 = StoreAndCompare.removeSensorColors(line2);
            }
            if (!match && !line1.equals(line2)) {
                log.warn("Match failed in StoreAndCompare:");
                log.warn("    file1:line {}: \"{}\"", (Object)lineNumber1, (Object)line1);
                log.warn("    file2:line {}: \"{}\"", (Object)lineNumber2, (Object)line2);
                log.warn("  comparing file1:\"{}\"", (Object)inFile1.getPath());
                log.warn("         to file2:\"{}\"", (Object)inFile2.getPath());
                result = true;
                break;
            }
            line1 = next1;
            line2 = next2;
        }
        fileStream1.close();
        fileStream2.close();
        return result;
    }

    private static String filterLineUsingRegEx(String line, String regexe) {
        String[] splits = ((String)line).split(regexe);
        if (splits.length == 2) {
            line = splits[0] + splits[1];
        }
        return line;
    }

    private static String removeSensorColors(String line) {
        String leftSide = line.substring(0, line.indexOf(" red="));
        int index = 0;
        index = line.indexOf("margin=") != -1 ? line.indexOf("margin=") : (line.indexOf("borderSize=") != -1 ? line.indexOf("borderSize=") : (line.indexOf("redBorder=") != -1 ? line.indexOf("redBorder=") : (line.indexOf("greenBorder=") != -1 ? line.indexOf("greenBorder=") : (line.indexOf("blueBorder=") != -1 ? line.indexOf("blueBorder=") : (line.indexOf("fixedWidth=") != -1 ? line.indexOf("fixedWidth=") : (line.indexOf("fixedHeight=") != -1 ? line.indexOf("fixedHeight=") : line.indexOf("justification=")))))));
        String rightSide = line.substring(index - 1, line.length());
        return leftSide + rightSide;
    }
}

