/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.awt.event.ActionEvent;
import java.io.File;
import javax.swing.JFileChooser;
import jmri.BooleanPermission;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.PermissionManager;
import jmri.configurexml.Bundle;
import jmri.configurexml.LoadAndStorePermissionOwner;
import jmri.configurexml.StoreXmlConfigAction;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StoreXmlUserAction
extends StoreXmlConfigAction {
    private static final Logger log = LoggerFactory.getLogger(StoreXmlUserAction.class);

    public StoreXmlUserAction() {
        this(Bundle.getMessage("MenuItemStore"));
    }

    public StoreXmlUserAction(String s) {
        super(s);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!InstanceManager.getDefault(PermissionManager.class).ensureAtLeastPermission(LoadAndStorePermissionOwner.STORE_XML_FILE_PERMISSION, BooleanPermission.BooleanValue.TRUE)) {
            return;
        }
        JFileChooser userFileChooser = StoreXmlUserAction.getUserFileChooser();
        userFileChooser.setDialogType(1);
        userFileChooser.setApproveButtonText(Bundle.getMessage("ButtonSave"));
        userFileChooser.setDialogTitle(Bundle.getMessage("StoreTitle"));
        File file = StoreXmlUserAction.getFileCustom(userFileChooser);
        if (file == null) {
            return;
        }
        ConfigureManager cm = InstanceManager.getNullableDefault(ConfigureManager.class);
        if (cm == null) {
            log.error("Failed to make backup due to unable to get default configure manager");
        } else {
            cm.makeBackup(file);
            boolean results = cm.storeUser(file);
            log.debug("store {}", (Object)(results ? "was successful" : "failed"));
            if (!results) {
                JmriJOptionPane.showMessageDialog(null, Bundle.getMessage("StoreHasErrors") + "\n" + Bundle.getMessage("StoreIncomplete") + "\n" + Bundle.getMessage("ConsoleWindowHasInfo"), Bundle.getMessage("StoreError"), 0);
            }
        }
    }
}

