/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml;

import java.util.List;
import jmri.InstanceManager;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.configurexml.AbstractXmlAdapter;
import jmri.configurexml.turnoutoperations.TurnoutOperationXml;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TurnoutOperationManagerXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(TurnoutOperationManagerXml.class);

    public void setStoreElementClass(Element elem) {
        elem.setAttribute("class", this.getClass().getName());
    }

    @Override
    public boolean load(Element sharedOperations, Element perNodeOperations) {
        boolean result = true;
        TurnoutOperationManager manager = InstanceManager.getDefault(TurnoutOperationManager.class);
        if (sharedOperations.getAttribute("automate") != null) {
            try {
                manager.setDoOperations(sharedOperations.getAttribute("automate").getValue().equals("true"));
            }
            catch (NumberFormatException ex) {
                result = false;
            }
        }
        List operationsList = sharedOperations.getChildren("operation");
        log.debug("Found {} Operations", (Object)operationsList.size());
        for (Element oper : operationsList) {
            TurnoutOperationXml.loadOperation(oper);
        }
        return result;
    }

    @Override
    public Element store(Object o) {
        Element elem = new Element("operations");
        if (o instanceof TurnoutOperationManager) {
            TurnoutOperation[] operations;
            TurnoutOperationManager manager = (TurnoutOperationManager)o;
            elem.setAttribute("automate", String.valueOf(manager.getDoOperations()));
            for (TurnoutOperation op : operations = manager.getTurnoutOperations()) {
                Element opElem;
                TurnoutOperationXml adapter;
                if (op.isNonce() || (adapter = TurnoutOperationXml.getAdapter(op)) == null || (opElem = adapter.store(op)) == null) continue;
                elem.addContent((Content)opElem);
            }
        }
        return elem;
    }
}

