/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml.swing;

import java.awt.HeadlessException;
import jmri.InstanceManager;
import jmri.UserPreferencesManager;
import jmri.configurexml.ErrorHandler;
import jmri.configurexml.ErrorMemo;

public class DialogErrorHandler
extends ErrorHandler {
    @Override
    public void handle(ErrorMemo e) {
        super.handle(e);
        try {
            StringBuilder m = new StringBuilder("<html>").append(e.description);
            if (e.systemName != null) {
                m.append(" System name \"").append(e.systemName).append("\"");
            }
            if (e.userName != null && !e.userName.isEmpty()) {
                m.append("<br> User name \"").append(e.userName).append("\"");
            }
            if (e.operation != null) {
                m.append("<br> while ").append(e.operation);
            }
            if (e.adapter != null) {
                m.append("<br> in adaptor of type ").append(e.adapter.getClass().getName());
            }
            if (e.exception != null) {
                m.append("<br> Exception: ").append(e.exception.toString());
            }
            m.append("<br> See http://jmri.org/help/en/package/jmri/configurexml/ErrorHandler.shtml for more information.</html>");
            InstanceManager.getDefault(UserPreferencesManager.class).showErrorMessage("Error during " + e.title, m.toString(), e.description, "", true, false);
        }
        catch (HeadlessException headlessException) {
            // empty catch block
        }
    }

    @Override
    public void done() {
    }
}

