/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml.swing;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.configurexml.LoadAndStorePreferences;
import jmri.configurexml.swing.Bundle;
import jmri.swing.PreferencesPanel;

public class LoadAndStorePreferencesPanel
extends JPanel
implements PreferencesPanel {
    private final LoadAndStorePreferences _preferences = InstanceManager.getDefault(LoadAndStorePreferences.class);
    private JCheckBox _excludeFileHistoryCheckBox;
    private JCheckBox _excludeMemoryIMCURRENTTIME_CheckBox;
    private JCheckBox _excludeJmriVersionCheckBox;

    public LoadAndStorePreferencesPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.getPanel());
    }

    private boolean setValues() {
        boolean didSet = true;
        this._preferences.setExcludeFileHistory(this._excludeFileHistoryCheckBox.isSelected());
        this._preferences.setExcludeMemoryIMCURRENTTIME(this._excludeMemoryIMCURRENTTIME_CheckBox.isSelected());
        this._preferences.setExcludeJmriVersion(this._excludeJmriVersionCheckBox.isSelected());
        return didSet;
    }

    private JPanel getPanel() {
        JLabel infoLabel = new JLabel(Bundle.getMessage("LabelExcludeInfo"));
        this._excludeFileHistoryCheckBox = new JCheckBox(Bundle.getMessage("LabelExcludeFileHistory"));
        this._excludeFileHistoryCheckBox.setSelected(this._preferences.isExcludeFileHistory());
        this._excludeMemoryIMCURRENTTIME_CheckBox = new JCheckBox(Bundle.getMessage("ExcludeMemoryIMCURRENTTIME"));
        this._excludeMemoryIMCURRENTTIME_CheckBox.setSelected(this._preferences.isExcludeMemoryIMCURRENTTIME());
        this._excludeJmriVersionCheckBox = new JCheckBox(Bundle.getMessage("ExcludeJmriVersion"));
        this._excludeJmriVersionCheckBox.setSelected(this._preferences.isExcludeJmriVersion());
        JPanel gridPanel = new JPanel(new GridLayout(0, 1));
        gridPanel.add(infoLabel);
        gridPanel.add(this._excludeMemoryIMCURRENTTIME_CheckBox);
        gridPanel.add(this._excludeJmriVersionCheckBox);
        gridPanel.add(this._excludeFileHistoryCheckBox);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 40, 0));
        panel.add(gridPanel);
        return panel;
    }

    @Override
    public String getPreferencesItem() {
        return "LOAD_AND_STORE";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("LoadAndStoreMenu");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.getPreferencesItemText();
    }

    @Override
    public String getLabelKey() {
        return Bundle.getMessage("LoadAndStorePrefLabel");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            this._preferences.save();
        }
    }

    @Override
    public boolean isDirty() {
        return this._preferences.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this._preferences.isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    @Override
    public int getSortOrder() {
        return 450;
    }
}

