/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml.swing;

import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import jmri.InstanceManager;
import jmri.configurexml.ShutdownPreferences;
import jmri.configurexml.swing.Bundle;
import jmri.swing.JTitledSeparator;
import jmri.swing.PreferencesPanel;

public class ShutdownPreferencesPanel
extends JPanel
implements PreferencesPanel {
    private final ShutdownPreferences _preferences = InstanceManager.getDefault(ShutdownPreferences.class);
    private JCheckBox _enableCheckBox;
    private JComboBox<ShutdownPreferences.DialogDisplayOptions> _displayActionComboBox;
    private JCheckBox _timebase;
    private JCheckBox _sensorIconColor;

    public ShutdownPreferencesPanel() {
        this.initGUI();
    }

    private void initGUI() {
        this.setLayout(new BoxLayout(this, 3));
        this.add(this.getPanel());
    }

    private boolean setValues() {
        boolean didSet = true;
        this._preferences.setEnableStoreCheck(this._enableCheckBox.isSelected());
        this._preferences.setIgnoreTimebase(this._timebase.isSelected());
        this._preferences.setIgnoreSensorColors(this._sensorIconColor.isSelected());
        this._preferences.setDisplayDialog((ShutdownPreferences.DialogDisplayOptions)((Object)this._displayActionComboBox.getSelectedItem()));
        return didSet;
    }

    private JPanel getPanel() {
        this._enableCheckBox = new JCheckBox(Bundle.getMessage("LabelEnableCheckbox"));
        this._enableCheckBox.setSelected(this._preferences.isStoreCheckEnabled());
        this._timebase = new JCheckBox(Bundle.getMessage("IgnoreTimebase"));
        this._timebase.setSelected(this._preferences.isIgnoreTimebaseEnabled());
        this._sensorIconColor = new JCheckBox(Bundle.getMessage("IgnoreSensorColor"));
        this._sensorIconColor.setSelected(this._preferences.isIgnoreSensorColorsEnabled());
        this._displayActionComboBox = new JComboBox();
        for (ShutdownPreferences.DialogDisplayOptions opt : ShutdownPreferences.DialogDisplayOptions.values()) {
            this._displayActionComboBox.addItem(opt);
            if (opt != this._preferences.getDisplayDialog()) continue;
            this._displayActionComboBox.setSelectedItem((Object)opt);
        }
        JPanel gridPanel = new JPanel(new GridLayout(0, 1));
        gridPanel.add(this._enableCheckBox);
        gridPanel.add(this._displayActionComboBox);
        gridPanel.add(new JLabel());
        gridPanel.add(new JTitledSeparator(Bundle.getMessage("IgnoreSeparator")));
        gridPanel.add(this._timebase);
        gridPanel.add(this._sensorIconColor);
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(1, 40, 0));
        panel.add(gridPanel);
        return panel;
    }

    @Override
    public String getPreferencesItem() {
        return "SHUTDOWN";
    }

    @Override
    public String getPreferencesItemText() {
        return Bundle.getMessage("ShutdownMenu");
    }

    @Override
    public String getTabbedPreferencesTitle() {
        return this.getPreferencesItemText();
    }

    @Override
    public String getLabelKey() {
        return Bundle.getMessage("ShutdownPrefLabel");
    }

    @Override
    public JComponent getPreferencesComponent() {
        return this;
    }

    @Override
    public boolean isPersistant() {
        return false;
    }

    @Override
    public String getPreferencesTooltip() {
        return null;
    }

    @Override
    public void savePreferences() {
        if (this.setValues()) {
            this._preferences.save();
        }
    }

    @Override
    public boolean isDirty() {
        return this._preferences.isDirty();
    }

    @Override
    public boolean isRestartRequired() {
        return this._preferences.isRestartRequired();
    }

    @Override
    public boolean isPreferencesValid() {
        return true;
    }

    @Override
    public int getSortOrder() {
        return 450;
    }
}

