/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml.turnoutoperations;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import jmri.CommonTurnoutOperation;
import jmri.TurnoutOperation;
import jmri.configurexml.turnoutoperations.TurnoutOperationXml;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CommonTurnoutOperationXml
extends TurnoutOperationXml {
    private static final Logger log = LoggerFactory.getLogger(CommonTurnoutOperationXml.class);

    @Override
    public Element store(Object op) {
        CommonTurnoutOperation myOp = (CommonTurnoutOperation)op;
        Element elem = super.store(op);
        elem.setAttribute("interval", String.valueOf(myOp.getInterval()));
        elem.setAttribute("maxtries", String.valueOf(myOp.getMaxTries()));
        return elem;
    }

    public TurnoutOperation loadOne(Element e, Constructor<?> constr, int di, int dmt) {
        int interval = di;
        int maxTries = dmt;
        TurnoutOperation result = null;
        if (e.getAttribute("name") == null) {
            log.warn("unexpected null in name {} {}", (Object)e, (Object)e.getAttributes());
            return null;
        }
        String name = e.getAttribute("name").getValue();
        if (e.getAttribute("interval") != null) {
            try {
                interval = Integer.parseInt(e.getAttribute("interval").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (e.getAttribute("maxtries") != null) {
            try {
                maxTries = Integer.parseInt(e.getAttribute("maxtries").getValue());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        try {
            result = (TurnoutOperation)constr.newInstance(name, interval, maxTries);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e1) {
            log.error("while creating CommonTurnoutOperation", (Throwable)e1);
            return null;
        }
        if (log.isDebugEnabled()) {
            log.debug("create turnout operation: ({})", (Object)name);
        }
        return result;
    }
}

