/*
 * Decompiled with CFR 0.152.
 */
package jmri.configurexml.turnoutoperations;

import java.lang.reflect.InvocationTargetException;
import jmri.TurnoutOperation;
import jmri.configurexml.AbstractXmlAdapter;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class TurnoutOperationXml
extends AbstractXmlAdapter {
    private static final Logger log = LoggerFactory.getLogger(TurnoutOperationXml.class);

    @Override
    public boolean load(Element shared, Element perNode) {
        this.loadOne(shared);
        return true;
    }

    public abstract TurnoutOperation loadOne(Element var1);

    public static TurnoutOperation loadOperation(Element e) {
        TurnoutOperation result = null;
        String className = e.getAttributeValue("class");
        if (className == null) {
            log.error("class name missing in turnout operation \"{}\"", (Object)e);
        } else {
            log.debug("loadOperation for class {}", (Object)className);
            try {
                Class<?> adapterClass = Class.forName(className);
                TurnoutOperationXml adapter = (TurnoutOperationXml)adapterClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                result = adapter.loadOne(e);
                if (result.getName().charAt(0) == '*') {
                    result.setNonce(true);
                }
            }
            catch (ClassNotFoundException | InstantiationException | NoSuchMethodException | InvocationTargetException e1) {
                log.error("while creating TurnoutOperation", (Throwable)e1);
                return null;
            }
            catch (IllegalAccessException e2) {
                log.error("while creating CommonTurnoutOperation", (Throwable)e2);
                return null;
            }
        }
        return result;
    }

    @Override
    public Element store(Object o) {
        TurnoutOperation myOp = (TurnoutOperation)o;
        Element elem = new Element("operation");
        elem.setAttribute("name", myOp.getName());
        elem.setAttribute("class", this.getClass().getName());
        return elem;
    }

    public static TurnoutOperationXml getAdapter(TurnoutOperation op) {
        TurnoutOperationXml adapter = null;
        String[] fullOpNameComponents = op.getClass().getName().split("\\.");
        log.debug("getAdapter found class name {}", (Object)op.getClass().getName());
        CharSequence[] myNameComponents = new String[]{"jmri", "configurexml", "turnoutoperations", "TurnoutOperationXml"};
        myNameComponents[myNameComponents.length - 1] = fullOpNameComponents[fullOpNameComponents.length - 1];
        String fullConfigName = String.join((CharSequence)".", myNameComponents) + "Xml";
        log.debug("getAdapter looks for {}", (Object)fullConfigName);
        try {
            Class<?> configClass = Class.forName(fullConfigName);
            adapter = (TurnoutOperationXml)configClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            log.error("exception in getAdapter", (Throwable)e);
        }
        if (adapter == null) {
            log.warn("could not create adapter class {}", (Object)fullConfigName);
        }
        return adapter;
    }
}

