/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.AnalogIO;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;

public abstract class AbstractAnalogIO
extends AbstractNamedBean
implements AnalogIO {
    private final boolean _commandedValueSetsKnownValue;
    private double _commandedValue = 0.0;
    private double _knownValue = 0.0;

    public AbstractAnalogIO(@Nonnull String systemName, boolean commandedValueSetsKnownValue) {
        super(systemName);
        this._commandedValueSetsKnownValue = commandedValueSetsKnownValue;
    }

    public AbstractAnalogIO(@Nonnull String systemName, @CheckForNull String userName, boolean commandedValueSetsKnownValue) {
        super(systemName, userName);
        this._commandedValueSetsKnownValue = commandedValueSetsKnownValue;
    }

    protected abstract void sendValueToLayout(double var1) throws JmriException;

    public void setValue(double newValue) {
        Double _old = this._knownValue;
        this._knownValue = newValue;
        this.firePropertyChange("state", _old, this._knownValue);
    }

    @Override
    public void setCommandedAnalogValue(double value) throws JmriException {
        if (value == Double.NEGATIVE_INFINITY) {
            throw new IllegalArgumentException("value is negative infinity");
        }
        if (value == Double.POSITIVE_INFINITY) {
            throw new IllegalArgumentException("value is positive infinity");
        }
        if (Double.isNaN(value)) {
            throw new IllegalArgumentException("value is not-a-number");
        }
        double min = this.getMin();
        double max = this.getMax();
        if (value < min) {
            if (this.cutOutOfBoundsValues()) {
                value = min;
            } else {
                throw new JmriException("value out of bounds");
            }
        }
        if (value > max) {
            if (this.cutOutOfBoundsValues()) {
                value = max;
            } else {
                throw new JmriException("value out of bounds");
            }
        }
        this._commandedValue = value;
        if (this._commandedValueSetsKnownValue) {
            this.setValue(this._commandedValue);
        }
        this.sendValueToLayout(this._commandedValue);
    }

    @Override
    public double getCommandedAnalogValue() {
        return this._commandedValue;
    }

    @Override
    public double getKnownAnalogValue() {
        return this._knownValue;
    }

    protected abstract boolean cutOutOfBoundsValues();

    @Override
    public double getState(double v) {
        return this.getCommandedAnalogValue();
    }

    @Override
    public void setState(double value) throws JmriException {
        this.setCommandedAnalogValue(value);
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameAnalogIO");
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return suffix1.compareTo(suffix2);
    }
}

