/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import jmri.NamedBean;
import jmri.beans.BeanUtil;
import jmri.implementation.Bundle;
import jmri.util.AlphanumComparator;

public abstract class AbstractNamedBean
implements NamedBean {
    private String mUserName;
    protected final String mSystemName;
    private String comment;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    protected final HashMap<PropertyChangeListener, String> register = new HashMap();
    protected final HashMap<PropertyChangeListener, String> listenerRefs = new HashMap();
    private HashMap<String, Object> parameters = null;

    protected AbstractNamedBean(@Nonnull String sys) {
        this(sys, null);
    }

    protected AbstractNamedBean(@Nonnull String sys, @CheckForNull String user) throws NamedBean.BadUserNameException, NamedBean.BadSystemNameException {
        if (Objects.isNull(sys)) {
            throw new NamedBean.BadSystemNameException();
        }
        this.mSystemName = sys;
        this.setUserName(user);
    }

    @Override
    public final String getComment() {
        return this.comment;
    }

    @Override
    public final void setComment(String comment) {
        String old = this.comment;
        this.comment = comment == null || comment.trim().isEmpty() ? null : comment;
        this.firePropertyChange("Comment", old, comment);
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public final String getDisplayName() {
        return NamedBean.super.getDisplayName();
    }

    @Override
    @CheckReturnValue
    @Nonnull
    public final String getDisplayName(NamedBean.DisplayOptions displayOptions) {
        return NamedBean.super.getDisplayName(displayOptions);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(@Nonnull PropertyChangeListener l, String beanRef, String listenerRef) {
        this.pcs.addPropertyChangeListener(l);
        if (beanRef != null) {
            this.register.put(l, beanRef);
        }
        if (listenerRef != null) {
            this.listenerRefs.put(l, listenerRef);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(@Nonnull String propertyName, @Nonnull PropertyChangeListener l, String beanRef, String listenerRef) {
        this.pcs.addPropertyChangeListener(propertyName, l);
        if (beanRef != null) {
            this.register.put(l, beanRef);
        }
        if (listenerRef != null) {
            this.listenerRefs.put(l, listenerRef);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(listener);
        if (listener != null && !BeanUtil.contains(this.pcs.getPropertyChangeListeners(), listener)) {
            this.register.remove(listener);
            this.listenerRefs.remove(listener);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void removePropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.removePropertyChangeListener(propertyName, listener);
        if (listener != null && !BeanUtil.contains(this.pcs.getPropertyChangeListeners(), listener)) {
            this.register.remove(listener);
            this.listenerRefs.remove(listener);
        }
    }

    @Override
    @Nonnull
    public synchronized PropertyChangeListener[] getPropertyChangeListenersByReference(@Nonnull String name) {
        ArrayList list = new ArrayList();
        this.register.entrySet().forEach(entry -> {
            PropertyChangeListener l = (PropertyChangeListener)entry.getKey();
            if (((String)entry.getValue()).equals(name)) {
                list.add(l);
            }
        });
        return list.toArray(new PropertyChangeListener[list.size()]);
    }

    @Override
    public synchronized ArrayList<String> getListenerRefs() {
        return new ArrayList<String>(this.listenerRefs.values());
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public synchronized void updateListenerRef(PropertyChangeListener l, String newName) {
        if (this.listenerRefs.containsKey(l)) {
            this.listenerRefs.put(l, newName);
        }
    }

    @Override
    public synchronized String getListenerRef(PropertyChangeListener l) {
        return this.listenerRefs.get(l);
    }

    @Override
    public synchronized int getNumPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners().length;
    }

    @Override
    @Nonnull
    public synchronized PropertyChangeListener[] getPropertyChangeListeners() {
        return this.pcs.getPropertyChangeListeners();
    }

    @Override
    @Nonnull
    public synchronized PropertyChangeListener[] getPropertyChangeListeners(String propertyName) {
        return this.pcs.getPropertyChangeListeners(propertyName);
    }

    @Override
    @Nonnull
    public final String getSystemName() {
        return this.mSystemName;
    }

    @Override
    @Nonnull
    public final String toString() {
        return this.getSystemName() + this.toStringSuffix();
    }

    protected String toStringSuffix() {
        return "";
    }

    @Override
    public final String getUserName() {
        return this.mUserName;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setUserName(String s) throws NamedBean.BadUserNameException {
        String old = this.mUserName;
        this.mUserName = NamedBean.normalizeUserName(s);
        this.firePropertyChange("UserName", old, this.mUserName);
    }

    @OverridingMethodsMustInvokeSuper
    protected void firePropertyChange(String p, Object old, Object n) {
        this.pcs.firePropertyChange(p, old, n);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        PropertyChangeListener[] listeners;
        for (PropertyChangeListener l : listeners = this.pcs.getPropertyChangeListeners()) {
            this.pcs.removePropertyChangeListener(l);
            this.register.remove(l);
            this.listenerRefs.remove(l);
        }
    }

    @Override
    @Nonnull
    public String describeState(int state) {
        switch (state) {
            case 1: {
                return Bundle.getMessage("BeanStateUnknown");
            }
            case 8: {
                return Bundle.getMessage("BeanStateInconsistent");
            }
        }
        return Bundle.getMessage("BeanStateUnexpected", state);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void setProperty(@Nonnull String key, Object value) {
        Set<String> keySet;
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        if ((keySet = this.getPropertyKeys()).contains(key)) {
            Object oldValue = this.getProperty(key);
            if (!Objects.equals(oldValue, value)) {
                this.removeProperty(key);
                this.parameters.put(key, value);
                this.firePropertyChange(key, oldValue, value);
            }
        } else {
            this.parameters.put(key, value);
            this.firePropertyChange(key, null, value);
        }
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public Object getProperty(@Nonnull String key) {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        return this.parameters.get(key);
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    @Nonnull
    public Set<String> getPropertyKeys() {
        if (this.parameters == null) {
            this.parameters = new HashMap();
        }
        return this.parameters.keySet();
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void removeProperty(String key) {
        if (this.parameters == null || Objects.isNull(key)) {
            return;
        }
        this.parameters.remove(key);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj instanceof AbstractNamedBean) {
            AbstractNamedBean b = (AbstractNamedBean)obj;
            return this.getSystemName().equals(b.getSystemName());
        }
        return false;
    }

    public int hashCode() {
        return this.getSystemName().hashCode();
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        AlphanumComparator ac = new AlphanumComparator();
        return ac.compare(suffix1, suffix2);
    }
}

