/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Objects;
import java.util.Vector;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanUsageReport;
import jmri.SignalAppearanceMap;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.SignalSystem;
import jmri.SignalSystemManager;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.DefaultSignalAppearanceMap;
import jmri.implementation.MatrixSignalMast;
import jmri.implementation.SignalHeadSignalMast;
import jmri.implementation.TurnoutSignalMast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSignalMast
extends AbstractNamedBean
implements SignalMast,
VetoableChangeListener {
    protected String aspect = null;
    protected String speed = null;
    private boolean mLit = true;
    private boolean mHeld = false;
    protected DefaultSignalAppearanceMap map;
    SignalSystem systemDefn;
    boolean disablePermissiveSignalMastLogic = false;
    protected ArrayList<String> disabledAspects = new ArrayList(1);
    String mastType;
    private boolean allowUnLit = true;
    private static final Logger log = LoggerFactory.getLogger(AbstractSignalMast.class);

    public AbstractSignalMast(String systemName, String userName) {
        super(systemName, userName);
    }

    public AbstractSignalMast(String systemName) {
        super(systemName);
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        String oldAspect = this.aspect;
        this.aspect = aspect;
        this.speed = (String)this.getSignalSystem().getProperty(aspect, "speed");
        this.firePropertyChange("Aspect", oldAspect, aspect);
    }

    @Override
    public String getAspect() {
        return this.aspect;
    }

    public String getSpeed() {
        return this.speed;
    }

    @Override
    public int getState() {
        return -1;
    }

    @Override
    public void setState(int i) {
    }

    @Override
    public boolean getLit() {
        return this.mLit;
    }

    @Override
    public boolean getHeld() {
        return this.mHeld;
    }

    @Override
    public void setLit(boolean newLit) {
        boolean oldLit = this.mLit;
        this.mLit = newLit;
        if (oldLit != newLit) {
            this.firePropertyChange("Lit", oldLit, newLit);
        }
    }

    @Override
    public void setHeld(boolean newHeld) {
        boolean oldHeld = this.mHeld;
        this.mHeld = newHeld;
        if (oldHeld != newHeld) {
            this.firePropertyChange("Held", oldHeld, newHeld);
        }
    }

    @Override
    public boolean isAtStop() {
        return "0".equals(this.speed);
    }

    @Override
    public boolean isShowingRestricting() {
        String displayedAspect = this.getAspect();
        return displayedAspect != null && displayedAspect.equals(this.getAppearanceMap().getSpecificAppearance(1));
    }

    @Override
    public boolean isCleared() {
        String displayedAspect = this.getAspect();
        if (displayedAspect == null) {
            return false;
        }
        if (displayedAspect.equals(this.getAppearanceMap().getSpecificAppearance(1))) {
            return false;
        }
        if (displayedAspect.equals(this.getAppearanceMap().getSpecificAppearance(0))) {
            return false;
        }
        return !displayedAspect.equals(this.getAppearanceMap().getSpecificAppearance(2));
    }

    @Override
    public void setPermissiveSmlDisabled(boolean disabled) {
        this.disablePermissiveSignalMastLogic = disabled;
        this.firePropertyChange("PermissiveSmlDisabled", null, disabled);
    }

    @Override
    public boolean isPermissiveSmlDisabled() {
        return this.disablePermissiveSignalMastLogic;
    }

    protected void configureSignalSystemDefinition(String name) {
        this.systemDefn = InstanceManager.getDefault(SignalSystemManager.class).getSystem(name);
        if (this.systemDefn == null) {
            log.error("Did not find signal definition: {}", (Object)name);
            throw new IllegalArgumentException("Signal definition not found: " + name);
        }
    }

    protected void configureAspectTable(String signalSystemName, String aspectMapName) {
        this.map = DefaultSignalAppearanceMap.getMap(signalSystemName, aspectMapName);
    }

    @Override
    public SignalSystem getSignalSystem() {
        return this.systemDefn;
    }

    @Override
    public SignalAppearanceMap getAppearanceMap() {
        return this.map;
    }

    @Override
    @Nonnull
    public Vector<String> getValidAspects() {
        Enumeration<String> e = this.map.getAspects();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            String a = e.nextElement();
            if (this.disabledAspects.contains(a)) continue;
            v.add(a);
        }
        return v;
    }

    @Override
    public String getMastType() {
        return this.mastType;
    }

    @Override
    public void setMastType(@Nonnull String type) {
        Objects.requireNonNull(type, "MastType cannot be null");
        this.mastType = type;
    }

    public Vector<String> getAllKnownAspects() {
        Enumeration<String> e = this.map.getAspects();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        return v;
    }

    public void setAspectDisabled(String aspect) {
        if (aspect == null || aspect.isEmpty()) {
            return;
        }
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to disable an aspect: {} that is not on the mast {}", (Object)aspect, (Object)this.getDisplayName());
            return;
        }
        if (!this.disabledAspects.contains(aspect)) {
            this.disabledAspects.add(aspect);
            this.firePropertyChange("aspectDisabled", null, aspect);
        }
    }

    public void setAspectEnabled(String aspect) {
        if (aspect == null || aspect.isEmpty()) {
            return;
        }
        if (!this.map.checkAspect(aspect)) {
            log.warn("attempting to disable an aspect: {} that is not on the mast {}", (Object)aspect, (Object)this.getDisplayName());
            return;
        }
        if (this.disabledAspects.contains(aspect)) {
            this.disabledAspects.remove(aspect);
            this.firePropertyChange("aspectEnabled", null, aspect);
        }
    }

    public List<String> getDisabledAspects() {
        return this.disabledAspects;
    }

    @Override
    public boolean isAspectDisabled(String aspect) {
        return this.disabledAspects.contains(aspect);
    }

    @Override
    public void setAllowUnLit(boolean boo) {
        this.allowUnLit = boo;
    }

    @Override
    public boolean allowUnLit() {
        return this.allowUnLit;
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSignalMast");
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report;
        block3: {
            block4: {
                Turnout t;
                MatrixSignalMast m;
                block5: {
                    report = new ArrayList<NamedBeanUsageReport>();
                    if (bean == null) break block3;
                    if (!(bean instanceof Turnout)) break block4;
                    if (!(this instanceof TurnoutSignalMast)) break block5;
                    TurnoutSignalMast m2 = (TurnoutSignalMast)this;
                    Turnout t2 = (Turnout)bean;
                    if (m2.isTurnoutUsed(t2)) {
                        report.add(new NamedBeanUsageReport("SignalMastTurnout"));
                    }
                    break block3;
                }
                if (!(this instanceof MatrixSignalMast) || !(m = (MatrixSignalMast)this).isTurnoutUsed(t = (Turnout)bean)) break block3;
                report.add(new NamedBeanUsageReport("SignalMastTurnout"));
                break block3;
            }
            if (bean instanceof SignalHead && this instanceof SignalHeadSignalMast) {
                SignalHeadSignalMast m = (SignalHeadSignalMast)this;
                SignalHead h = (SignalHead)bean;
                for (NamedBeanHandle<SignalHead> handle : m.getHeadsUsed()) {
                    if (!h.equals(handle.getBean())) continue;
                    report.add(new NamedBeanUsageReport("SignalMastSignalHead"));
                }
            }
        }
        return report;
    }
}

