/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import javax.annotation.CheckReturnValue;
import javax.annotation.Nonnull;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.StringIO;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;

public abstract class AbstractStringIO
extends AbstractNamedBean
implements StringIO {
    private String _commandedString = "";
    private String _knownString = "";

    public AbstractStringIO(@Nonnull String systemName) {
        super(systemName);
    }

    public AbstractStringIO(@Nonnull String systemName, String userName) {
        super(systemName, userName);
    }

    protected abstract void sendStringToLayout(@Nonnull String var1) throws JmriException;

    protected void setString(@Nonnull String newValue) {
        String _old = this._knownString;
        this._knownString = newValue;
        this.firePropertyChange("KnownValue", _old, this._knownString);
    }

    @Override
    public void setCommandedStringValue(@Nonnull String value) throws JmriException {
        String _old = this._commandedString;
        int maxLength = this.getMaximumLength();
        if (maxLength > 0 && value.length() > maxLength) {
            if (this.cutLongStrings()) {
                value = value.substring(0, maxLength);
            } else {
                throw new JmriException("String too long");
            }
        }
        this._commandedString = value;
        this.sendStringToLayout(this._commandedString);
        this.firePropertyChange("CommandedValue", _old, this._commandedString);
    }

    @Override
    @Nonnull
    public String getCommandedStringValue() {
        return this._commandedString;
    }

    @Override
    public String getKnownStringValue() {
        return this._knownString;
    }

    protected abstract boolean cutLongStrings();

    @Override
    public int getState() {
        return 1;
    }

    @Override
    public void setState(int newState) {
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameStringIO");
    }

    @Override
    @CheckReturnValue
    public int compareSystemNameSuffix(@Nonnull String suffix1, @Nonnull String suffix2, @Nonnull NamedBean n) {
        return suffix1.compareTo(suffix2);
    }
}

