/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.time.LocalDateTime;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.PushbuttonPacket;
import jmri.Sensor;
import jmri.SensorManager;
import jmri.Turnout;
import jmri.TurnoutOperation;
import jmri.TurnoutOperationManager;
import jmri.TurnoutOperator;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.SignalSpeedMap;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractTurnout
extends AbstractNamedBean
implements Turnout,
PropertyChangeListener {
    private Turnout leadingTurnout = null;
    private boolean followingCommandedState = true;
    private final String closedText = InstanceManager.turnoutManagerInstance().getClosedText();
    private final String thrownText = InstanceManager.turnoutManagerInstance().getThrownText();
    public static int DELAYED_FEEDBACK_INTERVAL = 4000;
    protected Thread thr;
    protected Runnable r;
    private LocalDateTime nextWait;
    protected String[] _validFeedbackNames = new String[]{"DIRECT", "ONESENSOR", "TWOSENSOR", "DELAYED"};
    protected int[] _validFeedbackModes = new int[]{1, 16, 32, 128};
    protected int _validFeedbackTypes = 177;
    protected int _activeFeedbackType = 1;
    private int _knownState = 1;
    private int _commandedState = 1;
    private int _numberControlBits = 1;
    private int _controlType = 0;
    protected boolean _inverted = false;
    protected boolean _cabLockout = false;
    protected boolean _pushButtonLockout = false;
    protected boolean _enableCabLockout = false;
    protected boolean _enablePushButtonLockout = false;
    protected boolean _reportLocked = true;
    protected String[] _validDecoderNames = PushbuttonPacket.getValidDecoderNames();
    protected String _decoderName = "None";
    protected TurnoutOperator myOperator;
    protected TurnoutOperation myTurnoutOperation;
    protected boolean inhibitOperation = true;
    private NamedBeanHandle<Sensor> _firstNamedSensor;
    private NamedBeanHandle<Sensor> _secondNamedSensor;
    protected boolean binaryOutput = false;
    private String _divergeSpeed = "";
    private String _straightSpeed = "";
    private static final Logger log = LoggerFactory.getLogger(AbstractTurnout.class);

    protected AbstractTurnout(String systemName) {
        super(systemName);
    }

    protected AbstractTurnout(String systemName, String userName) {
        super(systemName, userName);
    }

    @Override
    @Nonnull
    public String getBeanType() {
        return Bundle.getMessage("BeanNameTurnout");
    }

    protected abstract void forwardCommandChangeToLayout(int var1);

    protected void forwardCommandChangeToLayout() {
        this.forwardCommandChangeToLayout(this._commandedState);
    }

    public boolean stateChangeCheck(int newState) throws IllegalArgumentException {
        if ((newState & 2) != 0) {
            if (this.statesOk(newState)) {
                return !this._inverted;
            }
            throw new IllegalArgumentException("Can't set state for Turnout " + newState);
        }
        return this._inverted;
    }

    protected boolean statesOk(int state) {
        if ((state & 4) != 0) {
            log.error("Cannot command both CLOSED and THROWN");
            return false;
        }
        return true;
    }

    protected void newCommandedState(int s) {
        if (this._commandedState != s) {
            int oldState = this._commandedState;
            this._commandedState = s;
            this.firePropertyChange("CommandedState", oldState, this._commandedState);
        }
    }

    @Override
    public int getKnownState() {
        return this._knownState;
    }

    @Override
    public void setCommandedState(int s) {
        log.debug("set commanded state for turnout {} to {}", (Object)this.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME), (Object)(s == 2 ? this.closedText : this.thrownText));
        this.newCommandedState(s);
        this.myOperator = this.getTurnoutOperator();
        if (this.myOperator == null) {
            log.debug("myOperator NULL");
            this.forwardCommandChangeToLayout(s);
            if (this._activeFeedbackType == 1) {
                this.newKnownState(s);
            } else if (this._activeFeedbackType == 128) {
                this.newKnownState(8);
                ThreadingUtil.runOnLayoutDelayed(() -> this.newKnownState(s), DELAYED_FEEDBACK_INTERVAL);
            }
        } else {
            log.debug("myOperator NOT NULL");
            this.myOperator.start();
        }
    }

    @Override
    public void setCommandedStateAtInterval(int s) {
        this.nextWait = InstanceManager.turnoutManagerInstance().outputIntervalEnds();
        if (this.nextWait.isAfter(LocalDateTime.now())) {
            log.debug("Turnout now() = {}, waitUntil = {}", (Object)LocalDateTime.now(), (Object)this.nextWait);
            this.r = () -> {
                Long duration = Math.max(0L, LocalDateTime.now().until(this.nextWait, ChronoUnit.MILLIS));
                log.debug("go to sleep for {} ms...", (Object)duration);
                try {
                    Thread.sleep(duration);
                    log.debug("back from sleep, forward on {}", (Object)LocalDateTime.now());
                    this.setCommandedState(s);
                }
                catch (InterruptedException ex) {
                    log.debug("setCommandedStateAtInterval(s) interrupted at {}", (Object)LocalDateTime.now());
                    Thread.currentThread().interrupt();
                }
            };
            this.thr = new Thread(this.r);
            this.thr.setName("Turnout " + this.getDisplayName() + " setCommandedStateAtInterval");
            this.thr.start();
        } else {
            log.debug("nextWait has passed");
            this.setCommandedState(s);
        }
    }

    @Override
    public int getCommandedState() {
        return this._commandedState;
    }

    public void newKnownState(int s) {
        if (this._knownState != s) {
            int oldState = this._knownState;
            this._knownState = s;
            this.firePropertyChange("KnownState", oldState, this._knownState);
        }
        this._knownState = s;
        if (this._knownState == 4 && this._commandedState != 4 || this._knownState == 2 && this._commandedState != 2) {
            this.newCommandedState(this._knownState);
        }
    }

    @Override
    public boolean isConsistentState() {
        return this._commandedState == this._knownState && (this._commandedState == 2 || this._commandedState == 4);
    }

    void setKnownStateToCommanded() {
        this.newKnownState(this._commandedState);
    }

    @Override
    public void setState(int s) {
        this.setCommandedState(s);
    }

    @Override
    public int getState() {
        return this.getKnownState();
    }

    @Override
    @Nonnull
    public String describeState(int state) {
        switch (state) {
            case 4: {
                return this.thrownText;
            }
            case 2: {
                return this.closedText;
            }
        }
        return super.describeState(state);
    }

    @Override
    public int getNumberControlBits() {
        return this._numberControlBits;
    }

    @Override
    public void setNumberControlBits(int num) {
        this._numberControlBits = num;
    }

    @Override
    public int getControlType() {
        return this._controlType;
    }

    @Override
    public void setControlType(int num) {
        this._controlType = num;
    }

    @Override
    public Set<Integer> getValidFeedbackModes() {
        HashSet<Integer> modes = new HashSet<Integer>();
        Arrays.stream(this._validFeedbackModes).forEach(modes::add);
        return modes;
    }

    @Override
    public int getValidFeedbackTypes() {
        return this._validFeedbackTypes;
    }

    @Override
    @Nonnull
    public String[] getValidFeedbackNames() {
        return Arrays.copyOf(this._validFeedbackNames, this._validFeedbackNames.length);
    }

    @Override
    public void setFeedbackMode(@Nonnull String mode) throws IllegalArgumentException {
        for (int i = 0; i < this._validFeedbackNames.length; ++i) {
            if (!mode.equals(this._validFeedbackNames[i])) continue;
            this.setFeedbackMode(this._validFeedbackModes[i]);
            this.setInitialKnownStateFromFeedback();
            return;
        }
        throw new IllegalArgumentException("Unexpected mode: " + mode);
    }

    @Override
    public void setFeedbackMode(int mode) throws IllegalArgumentException {
        int test = mode & mode - 1;
        if (test != 0) {
            throw new IllegalArgumentException("More than one bit set: " + mode);
        }
        int oldMode = this._activeFeedbackType;
        this._activeFeedbackType = mode;
        this.setLocked(1, false);
        if (oldMode != this._activeFeedbackType) {
            this.firePropertyChange("feedbackchange", oldMode, this._activeFeedbackType);
        }
    }

    @Override
    public int getFeedbackMode() {
        return this._activeFeedbackType;
    }

    @Override
    @Nonnull
    public String getFeedbackModeName() {
        for (int i = 0; i < this._validFeedbackNames.length; ++i) {
            if (this._activeFeedbackType != this._validFeedbackModes[i]) continue;
            return this._validFeedbackNames[i];
        }
        throw new IllegalArgumentException("Unexpected internal mode: " + this._activeFeedbackType);
    }

    @Override
    public void requestUpdateFromLayout() {
        Sensor s2;
        Sensor s1;
        if ((this._activeFeedbackType == 16 || this._activeFeedbackType == 32) && (s1 = this.getFirstSensor()) != null) {
            s1.requestUpdateFromLayout();
        }
        if (this._activeFeedbackType == 32 && (s2 = this.getSecondSensor()) != null) {
            s2.requestUpdateFromLayout();
        }
    }

    @Override
    public void setInverted(boolean inverted) {
        boolean oldInverted = this._inverted;
        this._inverted = inverted;
        if (oldInverted != this._inverted) {
            int state = this._knownState;
            if (state == 4) {
                this.newKnownState(2);
            } else if (state == 2) {
                this.newKnownState(4);
            }
            this.firePropertyChange("inverted", oldInverted, this._inverted);
        }
    }

    @Override
    public final boolean getInverted() {
        return this._inverted;
    }

    @Override
    public boolean canInvert() {
        return false;
    }

    @Override
    public void setLocked(int turnoutLockout, boolean locked) {
        boolean firechange = false;
        if ((turnoutLockout & 1) != 0 && this._cabLockout != locked) {
            firechange = true;
            this._cabLockout = this.canLock(1) ? locked : false;
        }
        if ((turnoutLockout & 2) != 0 && this._pushButtonLockout != locked) {
            firechange = true;
            if (this.canLock(2)) {
                this._pushButtonLockout = locked;
                this.turnoutPushbuttonLockout();
            } else {
                this._pushButtonLockout = false;
            }
        }
        if (firechange) {
            this.firePropertyChange("locked", !locked, locked);
        }
    }

    @Override
    public boolean getLocked(int turnoutLockout) {
        switch (turnoutLockout) {
            case 1: {
                return this._cabLockout;
            }
            case 2: {
                return this._pushButtonLockout;
            }
            case 3: {
                return this._cabLockout || this._pushButtonLockout;
            }
        }
        return false;
    }

    @Override
    public int getPossibleLockModes() {
        return 0;
    }

    @Override
    public boolean canLock(int turnoutLockout) {
        return false;
    }

    @Override
    public void enableLockOperation(int turnoutLockout, boolean enabled) {
    }

    @Override
    public void setReportLocked(boolean reportLocked) {
        boolean oldReportLocked = this._reportLocked;
        this._reportLocked = reportLocked;
        if (oldReportLocked != this._reportLocked) {
            this.firePropertyChange("reportlocked", oldReportLocked, this._reportLocked);
        }
    }

    @Override
    public boolean getReportLocked() {
        return this._reportLocked;
    }

    @Override
    @Nonnull
    public String[] getValidDecoderNames() {
        return Arrays.copyOf(this._validDecoderNames, this._validDecoderNames.length);
    }

    @Override
    public String getDecoderName() {
        return this._decoderName;
    }

    @Override
    public void setDecoderName(String decoderName) {
        if (!Objects.equals(this._decoderName, decoderName)) {
            String oldName = this._decoderName;
            this._decoderName = decoderName;
            this.firePropertyChange("decoderNameChange", oldName, decoderName);
        }
    }

    protected abstract void turnoutPushbuttonLockout(boolean var1);

    protected void turnoutPushbuttonLockout() {
        this.turnoutPushbuttonLockout(this._pushButtonLockout);
    }

    public TurnoutOperator getCurrentOperator() {
        return this.myOperator;
    }

    @Override
    public TurnoutOperation getTurnoutOperation() {
        return this.myTurnoutOperation;
    }

    @Override
    public void setTurnoutOperation(TurnoutOperation toper) {
        log.debug("setTurnoutOperation Called for turnout {}.  Operation type {}", (Object)this.getSystemName(), (Object)toper);
        TurnoutOperation oldOp = this.myTurnoutOperation;
        if (this.myTurnoutOperation != null) {
            this.myTurnoutOperation.removePropertyChangeListener(this);
        }
        this.myTurnoutOperation = toper;
        if (this.myTurnoutOperation != null) {
            this.myTurnoutOperation.addPropertyChangeListener(this);
        }
        this.firePropertyChange("TurnoutOperationState", oldOp, this.myTurnoutOperation);
    }

    protected void operationPropertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.myTurnoutOperation && ((TurnoutOperation)evt.getSource()).isDeleted()) {
            this.setTurnoutOperation(null);
        }
    }

    @Override
    public boolean getInhibitOperation() {
        return this.inhibitOperation;
    }

    @Override
    public void setInhibitOperation(boolean io) {
        this.inhibitOperation = io;
    }

    protected TurnoutOperator getTurnoutOperator() {
        TurnoutOperator to = null;
        if (!this.inhibitOperation) {
            if (this.myTurnoutOperation != null) {
                to = this.myTurnoutOperation.getOperator(this);
            } else {
                TurnoutOperation toper = InstanceManager.getDefault(TurnoutOperationManager.class).getMatchingOperation(this, this.getFeedbackModeForOperation());
                if (toper != null) {
                    to = toper.getOperator(this);
                }
            }
        }
        return to;
    }

    protected int getFeedbackModeForOperation() {
        return this.getFeedbackMode();
    }

    @Override
    public void provideFirstFeedbackSensor(String pName) throws JmriException, IllegalArgumentException {
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            if (pName == null || pName.isEmpty()) {
                this.provideFirstFeedbackNamedSensor(null);
            } else {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(pName);
                this.provideFirstFeedbackNamedSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, sensor));
            }
        } else {
            log.error("No SensorManager for this protocol");
            throw new JmriException("No Sensor Manager Found");
        }
    }

    public void provideFirstFeedbackNamedSensor(NamedBeanHandle<Sensor> s) {
        Sensor temp = this.getFirstSensor();
        if (temp != null) {
            temp.removePropertyChangeListener(this);
        }
        this._firstNamedSensor = s;
        temp = this.getFirstSensor();
        if (temp != null) {
            temp.addPropertyChangeListener(this, s.getName(), "Feedback Sensor for " + this.getDisplayName());
        }
        this.setInitialKnownStateFromFeedback();
        this.firePropertyChange("turnoutFeedbackFirstSensorChange", temp, s);
    }

    @Override
    public Sensor getFirstSensor() {
        if (this._firstNamedSensor == null) {
            return null;
        }
        return this._firstNamedSensor.getBean();
    }

    @Override
    public NamedBeanHandle<Sensor> getFirstNamedSensor() {
        return this._firstNamedSensor;
    }

    @Override
    public void provideSecondFeedbackSensor(String pName) throws JmriException, IllegalArgumentException {
        if (InstanceManager.getNullableDefault(SensorManager.class) != null) {
            if (pName == null || pName.isEmpty()) {
                this.provideSecondFeedbackNamedSensor(null);
            } else {
                Sensor sensor = InstanceManager.sensorManagerInstance().provideSensor(pName);
                this.provideSecondFeedbackNamedSensor(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, sensor));
            }
        } else {
            log.error("No SensorManager for this protocol");
            throw new JmriException("No Sensor Manager Found");
        }
    }

    public void provideSecondFeedbackNamedSensor(NamedBeanHandle<Sensor> s) {
        Sensor temp = this.getSecondSensor();
        if (temp != null) {
            temp.removePropertyChangeListener(this);
        }
        this._secondNamedSensor = s;
        temp = this.getSecondSensor();
        if (temp != null) {
            temp.addPropertyChangeListener(this, s.getName(), "Feedback Sensor for " + this.getDisplayName());
        }
        this.setInitialKnownStateFromFeedback();
        this.firePropertyChange("turnoutFeedbackSecondSensorChange", temp, s);
    }

    @Override
    @CheckForNull
    public Sensor getSecondSensor() {
        if (this._secondNamedSensor == null) {
            return null;
        }
        return this._secondNamedSensor.getBean();
    }

    @Override
    @CheckForNull
    public NamedBeanHandle<Sensor> getSecondNamedSensor() {
        return this._secondNamedSensor;
    }

    @Override
    public void setInitialKnownStateFromFeedback() {
        Sensor firstSensor = this.getFirstSensor();
        if (this._activeFeedbackType == 16) {
            if (firstSensor != null) {
                int sState = firstSensor.getKnownState();
                if (sState == 2) {
                    this.newKnownState(4);
                } else if (sState == 4) {
                    this.newKnownState(2);
                }
            } else {
                log.warn("expected Sensor 1 not defined - {}", (Object)this.getSystemName());
                this.newKnownState(1);
            }
        } else if (this._activeFeedbackType == 32) {
            int s1State = 1;
            int s2State = 1;
            if (firstSensor != null) {
                s1State = firstSensor.getKnownState();
            } else {
                log.warn("expected Sensor 1 not defined - {}", (Object)this.getSystemName());
            }
            Sensor secondSensor = this.getSecondSensor();
            if (secondSensor != null) {
                s2State = secondSensor.getKnownState();
            } else {
                log.warn("expected Sensor 2 not defined - {}", (Object)this.getSystemName());
            }
            if (s1State == 2 && s2State == 4) {
                this.newKnownState(4);
            } else if (s1State == 4 && s2State == 2) {
                this.newKnownState(2);
            } else if (this._knownState != 1) {
                this.newKnownState(1);
            }
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.myTurnoutOperation) {
            this.operationPropertyChange(evt);
        } else if (evt.getSource() == this.getFirstSensor() || evt.getSource() == this.getSecondSensor()) {
            this.sensorPropertyChange(evt);
        } else if (evt.getSource() == this.leadingTurnout) {
            this.leadingTurnoutPropertyChange(evt);
        }
    }

    protected void sensorPropertyChange(PropertyChangeEvent evt) {
        Sensor src = (Sensor)evt.getSource();
        Sensor s1 = this.getFirstSensor();
        if (src == null || s1 == null) {
            log.warn("Turnout feedback sensors configured incorrectly ");
            return;
        }
        if (this._activeFeedbackType == 16) {
            if (src == s1) {
                if (!"KnownState".equals(evt.getPropertyName())) {
                    return;
                }
                switch ((Integer)evt.getNewValue()) {
                    case 2: {
                        this.newKnownState(4);
                        break;
                    }
                    case 4: {
                        this.newKnownState(2);
                        break;
                    }
                    default: {
                        this.newKnownState(8);
                        break;
                    }
                }
            } else {
                NamedBeanHandle<Sensor> firstNamed = this.getFirstNamedSensor();
                if (firstNamed != null) {
                    log.warn("expected sensor {} was {}", (Object)firstNamed.getName(), (Object)src.getSystemName());
                } else {
                    log.error("unexpected (null) sensors");
                }
            }
        } else if (this._activeFeedbackType == 32) {
            if (!"KnownState".equals(evt.getPropertyName())) {
                return;
            }
            Sensor s2 = this.getSecondSensor();
            if (s2 == null) {
                log.warn("Turnout feedback sensor 2 configured incorrectly ");
                return;
            }
            if (s1.getKnownState() == 4 && s2.getKnownState() == 2) {
                this.newKnownState(2);
            } else if (s1.getKnownState() == 2 && s2.getKnownState() == 4) {
                this.newKnownState(4);
            } else if (s1.getKnownState() == 1 && s2.getKnownState() == 1) {
                this.newKnownState(1);
            } else {
                this.newKnownState(8);
            }
        }
    }

    protected void leadingTurnoutPropertyChange(PropertyChangeEvent evt) {
        int state = (Integer)evt.getNewValue();
        if ("KnownState".equals(evt.getPropertyName()) && this.leadingTurnout != null) {
            if (this.followingCommandedState || state != this.leadingTurnout.getCommandedState()) {
                this.newKnownState(state);
            } else {
                this.newKnownState(this.getCommandedState());
            }
        }
    }

    @Override
    public void setBinaryOutput(boolean state) {
        this.binaryOutput = true;
    }

    @Override
    public void dispose() {
        Sensor temp = this.getFirstSensor();
        if (temp != null) {
            temp.removePropertyChangeListener(this);
        }
        this._firstNamedSensor = null;
        temp = this.getSecondSensor();
        if (temp != null) {
            temp.removePropertyChangeListener(this);
        }
        this._secondNamedSensor = null;
        super.dispose();
    }

    @Override
    public float getDivergingLimit() {
        if (this._divergeSpeed == null || this._divergeSpeed.isEmpty()) {
            return -1.0f;
        }
        String speed = this._divergeSpeed;
        if (this._divergeSpeed.equals("Global")) {
            speed = InstanceManager.turnoutManagerInstance().getDefaultThrownSpeed();
        }
        if (speed.equals("Block")) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(speed);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(speed);
            }
            catch (IllegalArgumentException ex) {
                return -1.0f;
            }
        }
    }

    @Override
    public String getDivergingSpeed() {
        if (this._divergeSpeed.equals("Global")) {
            return Bundle.getMessage("UseGlobal", "Global") + " " + InstanceManager.turnoutManagerInstance().getDefaultThrownSpeed();
        }
        if (this._divergeSpeed.equals("Block")) {
            return Bundle.getMessage("UseGlobal", "Block Speed");
        }
        return this._divergeSpeed;
    }

    @Override
    public void setDivergingSpeed(String s) throws JmriException {
        if (s == null) {
            throw new JmriException("Value of requested turnout thrown speed can not be null");
        }
        if (this._divergeSpeed.equals(s)) {
            return;
        }
        if (s.contains("Global")) {
            s = "Global";
        } else if (s.contains("Block")) {
            s = "Block";
        } else {
            try {
                Float.parseFloat(s);
            }
            catch (NumberFormatException nx) {
                try {
                    InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(s);
                }
                catch (IllegalArgumentException ex) {
                    throw new JmriException("Value of requested block speed is not valid");
                }
            }
        }
        String oldSpeed = this._divergeSpeed;
        this._divergeSpeed = s;
        this.firePropertyChange("TurnoutDivergingSpeedChange", oldSpeed, s);
    }

    @Override
    public float getStraightLimit() {
        if (this._straightSpeed == null || this._straightSpeed.isEmpty()) {
            return -1.0f;
        }
        String speed = this._straightSpeed;
        if (this._straightSpeed.equals("Global")) {
            speed = InstanceManager.turnoutManagerInstance().getDefaultClosedSpeed();
        }
        if (speed.equals("Block")) {
            return -1.0f;
        }
        try {
            return Float.parseFloat(speed);
        }
        catch (NumberFormatException numberFormatException) {
            try {
                return InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(speed);
            }
            catch (IllegalArgumentException ex) {
                return -1.0f;
            }
        }
    }

    @Override
    public String getStraightSpeed() {
        if (this._straightSpeed.equals("Global")) {
            return Bundle.getMessage("UseGlobal", "Global") + " " + InstanceManager.turnoutManagerInstance().getDefaultClosedSpeed();
        }
        if (this._straightSpeed.equals("Block")) {
            return Bundle.getMessage("UseGlobal", "Block Speed");
        }
        return this._straightSpeed;
    }

    @Override
    public void setStraightSpeed(String s) throws JmriException {
        if (s == null) {
            throw new JmriException("Value of requested turnout straight speed can not be null");
        }
        if (this._straightSpeed.equals(s)) {
            return;
        }
        if (s.contains("Global")) {
            s = "Global";
        } else if (s.contains("Block")) {
            s = "Block";
        } else {
            try {
                Float.parseFloat(s);
            }
            catch (NumberFormatException nx) {
                try {
                    InstanceManager.getDefault(SignalSpeedMap.class).getSpeed(s);
                }
                catch (IllegalArgumentException ex) {
                    throw new JmriException("Value of requested turnout straight speed is not valid");
                }
            }
        }
        String oldSpeed = this._straightSpeed;
        this._straightSpeed = s;
        this.firePropertyChange("TurnoutStraightSpeedChange", oldSpeed, s);
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        Object old;
        if ("CanDelete".equals(evt.getPropertyName()) && ((old = evt.getOldValue()).equals(this.getFirstSensor()) || old.equals(this.getSecondSensor()) || old.equals(this.leadingTurnout))) {
            PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
            throw new PropertyVetoException(Bundle.getMessage("InUseSensorTurnoutVeto", this.getDisplayName()), e);
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getFirstSensor())) {
                report.add(new NamedBeanUsageReport("TurnoutFeedback1"));
            }
            if (bean.equals(this.getSecondSensor())) {
                report.add(new NamedBeanUsageReport("TurnoutFeedback2"));
            }
            if (bean.equals(this.getLeadingTurnout())) {
                report.add(new NamedBeanUsageReport("LeadingTurnout"));
            }
        }
        return report;
    }

    @Override
    public boolean isCanFollow() {
        return false;
    }

    @Override
    @CheckForNull
    public Turnout getLeadingTurnout() {
        return this.leadingTurnout;
    }

    @Override
    public void setLeadingTurnout(@CheckForNull Turnout turnout) {
        if (this.isCanFollow()) {
            Turnout old = this.leadingTurnout;
            this.leadingTurnout = turnout;
            this.firePropertyChange("LeadingTurnout", old, this.leadingTurnout);
            if (old != null) {
                old.removePropertyChangeListener("KnownState", this);
            }
            if (this.leadingTurnout != null) {
                this.leadingTurnout.addPropertyChangeListener("KnownState", this);
            }
        }
    }

    @Override
    public void setLeadingTurnout(@CheckForNull Turnout turnout, boolean followingCommandedState) {
        this.setLeadingTurnout(turnout);
        this.setFollowingCommandedState(followingCommandedState);
    }

    @Override
    public boolean isFollowingCommandedState() {
        return this.followingCommandedState;
    }

    @Override
    public void setFollowingCommandedState(boolean following) {
        this.followingCommandedState = following;
    }
}

