/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.AddressedProgrammer;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.ProgrammingMode;
import jmri.jmrix.AbstractProgrammerFacade;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccessoryOpsModeProgrammerFacade
extends AbstractProgrammerFacade
implements ProgListener {
    ProgrammingMode mode;
    Programmer aprog;
    int _val;
    String _cv;
    String _addrType;
    int _delay;
    AddressedProgrammer _baseProg;
    private volatile transient ProgListener _usingProgrammer;
    ProgState state = ProgState.NOTPROGRAMMING;
    private static final Logger log = LoggerFactory.getLogger(AccessoryOpsModeProgrammerFacade.class);

    @SuppressFBWarnings(value={"DM_CONVERT_CASE"}, justification="parameter value is never localised")
    public AccessoryOpsModeProgrammerFacade(Programmer prog, @Nonnull String addrType, int delay, AddressedProgrammer baseProg) {
        super(prog);
        log.debug("Constructing AccessoryOpsModeProgrammerFacade");
        this._usingProgrammer = null;
        this.mode = prog.getMode();
        this.aprog = prog;
        this._addrType = addrType == null ? "" : addrType.toLowerCase();
        this._delay = delay;
        this._baseProg = baseProg;
    }

    @Override
    @Nonnull
    public List<ProgrammingMode> getSupportedModes() {
        ArrayList<ProgrammingMode> ret = new ArrayList<ProgrammingMode>();
        ret.add(ProgrammingMode.OPSACCBYTEMODE);
        ret.add(ProgrammingMode.OPSACCBITMODE);
        ret.add(ProgrammingMode.OPSACCEXTBYTEMODE);
        ret.add(ProgrammingMode.OPSACCEXTBITMODE);
        return ret;
    }

    @Override
    public void setMode(ProgrammingMode p) {
    }

    @Override
    public boolean getCanRead() {
        return this.prog.getCanRead();
    }

    @Override
    public boolean getCanRead(String addr) {
        return this.prog.getCanRead(addr);
    }

    @Override
    public boolean getCanWrite() {
        return this.prog.getCanWrite();
    }

    @Override
    public boolean getCanWrite(String addr) {
        return this.prog.getCanWrite(addr);
    }

    @Override
    public synchronized void writeCV(String cv, int val, ProgListener p) throws ProgrammerException {
        byte[] b;
        log.debug("writeCV entry: ProgListener p is {}", (Object)p);
        this._val = val;
        this.useProgrammer(p);
        this.state = ProgState.PROGRAMMING;
        switch (this._addrType) {
            case "accessory": 
            case "output": {
                log.debug("Send an accDecoderPktOpsMode: address={}, cv={}, value={}", new Object[]{this._baseProg.getAddressNumber(), Integer.parseInt(cv), val});
                b = NmraPacket.accDecoderPktOpsMode(this._baseProg.getAddressNumber(), Integer.parseInt(cv), val);
                break;
            }
            case "signal": {
                log.debug("Send an accSignalDecoderPktOpsMode: address={}, cv={}, value={}", new Object[]{this._baseProg.getAddressNumber(), Integer.parseInt(cv), val});
                b = NmraPacket.accSignalDecoderPktOpsMode(this._baseProg.getAddressNumber(), Integer.parseInt(cv), val);
                break;
            }
            case "altsignal": {
                log.debug("Send an altAccSignalDecoderPktOpsMode: address={}, cv={}, value={}", new Object[]{this._baseProg.getAddressNumber(), Integer.parseInt(cv), val});
                b = NmraPacket.altAccSignalDecoderPktOpsMode(this._baseProg.getAddressNumber(), Integer.parseInt(cv), val);
                break;
            }
            case "decoder": {
                log.debug("Send an accDecPktOpsMode: address={}, cv={}, value={}", new Object[]{this._baseProg.getAddressNumber(), Integer.parseInt(cv), val});
                b = NmraPacket.accDecPktOpsMode(this._baseProg.getAddressNumber(), Integer.parseInt(cv), val);
                break;
            }
            case "legacy": {
                log.debug("Send an accDecPktOpsModeLegacy: address={}, cv={}, value={}", new Object[]{this._baseProg.getAddressNumber(), Integer.parseInt(cv), val});
                b = NmraPacket.accDecPktOpsModeLegacy(this._baseProg.getAddressNumber(), Integer.parseInt(cv), val);
                break;
            }
            default: {
                log.error("Unknown Address Type \"{}\"", (Object)this._addrType);
                this.programmingOpReply(val, 1);
                return;
            }
        }
        boolean ret = InstanceManager.getDefault(CommandStation.class).sendPacket(b, 2);
        if (!ret) {
            log.error("Unable to program cv={}, value={}: Operation not implemented in command station", (Object)Integer.parseInt(cv), (Object)val);
            this.programmingOpReply(val, 8);
            return;
        }
        log.debug("delaying {} milliseconds for cv={}, value={}", new Object[]{this._delay, Integer.parseInt(cv), val});
        ThreadingUtil.runOnLayoutDelayed(() -> {
            log.debug("            delay elapsed for cv={}, value={}", (Object)Integer.parseInt(cv), (Object)val);
            this.programmingOpReply(val, 0);
        }, this._delay);
    }

    @Override
    public synchronized void readCV(String cv, ProgListener p) throws ProgrammerException {
        this.readCV(cv, p, 0);
    }

    @Override
    public synchronized void readCV(String cv, ProgListener p, int startVal) throws ProgrammerException {
        this.useProgrammer(p);
        this.state = ProgState.PROGRAMMING;
        this.prog.readCV(cv, this, startVal);
    }

    @Override
    public synchronized void confirmCV(String cv, int val, ProgListener p) throws ProgrammerException {
        this.useProgrammer(p);
        this.state = ProgState.PROGRAMMING;
        this.prog.confirmCV(cv, val, this);
    }

    protected synchronized void useProgrammer(ProgListener p) throws ProgrammerException {
        log.debug("useProgrammer entry: _usingProgrammer is {}", (Object)this._usingProgrammer);
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            if (log.isInfoEnabled()) {
                log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            }
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
        log.debug("useProgrammer exit: _usingProgrammer is {}", (Object)this._usingProgrammer);
    }

    @Override
    public synchronized void programmingOpReply(int value, int status) {
        log.debug("notifyProgListenerEnd value={}, status={}", (Object)value, (Object)status);
        if (status != 0) {
            log.debug("Reset and pass abort up");
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            temp.programmingOpReply(value, status);
            return;
        }
        if (this._usingProgrammer == null) {
            log.error("No listener to notify, reset and ignore");
            this.state = ProgState.NOTPROGRAMMING;
            return;
        }
        switch (this.state) {
            case PROGRAMMING: {
                log.debug("going NOTPROGRAMMING after value {}, status={}", (Object)value, (Object)status);
                ProgListener temp = this._usingProgrammer;
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                temp.programmingOpReply(value, status);
                break;
            }
            default: {
                log.error("Unexpected state on reply: {}", (Object)this.state);
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
            }
        }
    }

    static enum ProgState {
        PROGRAMMING,
        NOTPROGRAMMING;

    }
}

