/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import jmri.AddressedProgrammer;
import jmri.AddressedProgrammerManager;
import jmri.Consist;
import jmri.ConsistListener;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.ProgListener;
import jmri.ProgrammerException;
import jmri.jmrit.consisttool.ConsistPreferencesManager;
import jmri.jmrit.decoderdefn.DecoderFile;
import jmri.jmrit.decoderdefn.DecoderIndexFile;
import jmri.jmrit.roster.Roster;
import jmri.jmrit.roster.RosterEntry;
import jmri.jmrit.symbolicprog.CvTableModel;
import jmri.jmrit.symbolicprog.CvValue;
import jmri.jmrit.symbolicprog.VariableTableModel;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccConsist
implements Consist,
ProgListener {
    protected ArrayList<DccLocoAddress> consistList = null;
    protected HashMap<DccLocoAddress, Boolean> consistDir = null;
    protected HashMap<DccLocoAddress, Integer> consistPosition = null;
    protected HashMap<DccLocoAddress, String> consistRoster = null;
    protected int consistType = 0;
    protected DccLocoAddress consistAddress = null;
    protected String consistID = null;
    private final ArrayList<ConsistListener> listeners;
    private AddressedProgrammerManager opsProgManager = null;
    private static final Logger log = LoggerFactory.getLogger(DccConsist.class);

    public DccConsist(int address) {
        this(new DccLocoAddress(address, false));
    }

    public DccConsist(DccLocoAddress address) {
        this(address, InstanceManager.getDefault(AddressedProgrammerManager.class));
    }

    public DccConsist(DccLocoAddress address, AddressedProgrammerManager apm) {
        this.opsProgManager = apm;
        this.listeners = new ArrayList();
        this.consistAddress = address;
        this.consistDir = new HashMap();
        this.consistList = new ArrayList();
        this.consistPosition = new HashMap();
        this.consistRoster = new HashMap();
        this.consistID = this.consistAddress.toString();
    }

    @Override
    public void dispose() {
        if (this.consistList == null) {
            return;
        }
        for (int i = this.consistList.size() - 1; i >= 0; --i) {
            DccLocoAddress loco = this.consistList.get(i);
            log.debug("Deleting Locomotive: {}", (Object)loco);
            try {
                this.remove(loco);
                continue;
            }
            catch (Exception ex) {
                log.error("Error removing loco: {} from consist: {}", (Object)loco, (Object)this.consistAddress);
            }
        }
        this.consistList = null;
        this.consistDir = null;
        this.consistPosition = null;
        this.consistRoster = null;
    }

    @Override
    public void setConsistType(int consist_type) {
        if (consist_type == 0) {
            this.consistType = consist_type;
        } else {
            this.notifyUnsupportedConsistType();
        }
    }

    private void notifyUnsupportedConsistType() {
        log.error("Consist Type Not Supported");
        this.notifyConsistListeners(new DccLocoAddress(0, false), 1);
    }

    @Override
    public int getConsistType() {
        return this.consistType;
    }

    @Override
    public DccLocoAddress getConsistAddress() {
        return this.consistAddress;
    }

    @Override
    public boolean isAddressAllowed(DccLocoAddress address) {
        return address.getNumber() != 0;
    }

    @Override
    public int sizeLimit() {
        if (this.consistType == 0) {
            return -1;
        }
        return 0;
    }

    @Override
    public ArrayList<DccLocoAddress> getConsistList() {
        return this.consistList;
    }

    @Override
    public boolean contains(DccLocoAddress address) {
        if (this.consistType == 0) {
            return this.consistList.contains(address);
        }
        this.notifyUnsupportedConsistType();
        return false;
    }

    @Override
    public boolean getLocoDirection(DccLocoAddress address) {
        if (this.consistType == 0) {
            Boolean direction = this.consistDir.get(address);
            return direction;
        }
        this.notifyUnsupportedConsistType();
        return false;
    }

    @Override
    public void add(DccLocoAddress address, boolean directionNormal) {
        if (this.consistType == 0) {
            if (!this.consistList.contains(address)) {
                this.consistList.add(address);
            }
            this.consistDir.put(address, directionNormal);
            this.addToAdvancedConsist(address, directionNormal);
            this.setRosterEntryCVValue(address);
        } else {
            this.notifyUnsupportedConsistType();
        }
    }

    @Override
    public void restore(DccLocoAddress address, boolean directionNormal) {
        if (this.consistType == 0) {
            if (!this.consistList.contains(address)) {
                this.consistList.add(address);
            }
            this.consistDir.put(address, directionNormal);
        } else {
            this.notifyUnsupportedConsistType();
        }
    }

    @Override
    public void remove(DccLocoAddress address) {
        if (this.consistType == 0) {
            this.resetRosterEntryCVValue(address);
            this.consistDir.remove(address);
            this.consistList.remove(address);
            this.consistPosition.remove(address);
            this.consistRoster.remove(address);
            this.removeFromAdvancedConsist(address);
        } else {
            this.notifyUnsupportedConsistType();
        }
    }

    protected void addToAdvancedConsist(DccLocoAddress address, boolean directionNormal) {
        AddressedProgrammer opsProg = this.opsProgManager.getAddressedProgrammer(address.isLongAddress(), address.getNumber());
        if (opsProg == null) {
            log.error("Can't make consisting change because no programmer exists; this is probably a configuration error in the preferences");
            return;
        }
        if (directionNormal) {
            try {
                opsProg.writeCV("19", this.consistAddress.getNumber(), this);
            }
            catch (ProgrammerException e) {
                log.warn("Exception writing CV19 while adding from consist", (Throwable)e);
            }
        } else {
            try {
                opsProg.writeCV("19", this.consistAddress.getNumber() + 128, this);
            }
            catch (ProgrammerException e) {
                log.warn("Exception writing CV19 while adding to consist", (Throwable)e);
            }
        }
        InstanceManager.getDefault(AddressedProgrammerManager.class).releaseAddressedProgrammer(opsProg);
    }

    protected void removeFromAdvancedConsist(DccLocoAddress address) {
        AddressedProgrammer opsProg = InstanceManager.getDefault(AddressedProgrammerManager.class).getAddressedProgrammer(address.isLongAddress(), address.getNumber());
        if (opsProg == null) {
            log.error("Can't make consisting change because no programmer exists; this is probably a configuration error in the preferences");
            return;
        }
        try {
            opsProg.writeCV("19", 0, this);
        }
        catch (ProgrammerException e) {
            log.warn("Exception writing CV19 while removing from consist", (Throwable)e);
        }
        InstanceManager.getDefault(AddressedProgrammerManager.class).releaseAddressedProgrammer(opsProg);
    }

    @Override
    public void setPosition(DccLocoAddress address, int position) {
        this.consistPosition.put(address, position);
    }

    @Override
    public int getPosition(DccLocoAddress address) {
        if (this.consistPosition.containsKey(address)) {
            return this.consistPosition.get(address);
        }
        int index = this.consistList.indexOf(address);
        if (index == 0) {
            return 0;
        }
        if (index == this.consistList.size() - 1) {
            return 255;
        }
        return index;
    }

    @Override
    public void setRosterId(DccLocoAddress address, String rosterId) {
        this.consistRoster.put(address, rosterId);
        if (this.consistType == 0) {
            this.setRosterEntryCVValue(address);
        }
    }

    @Override
    public String getRosterId(DccLocoAddress address) {
        if (this.consistRoster.containsKey(address)) {
            return this.consistRoster.get(address);
        }
        return null;
    }

    protected void setRosterEntryCVValue(DccLocoAddress address) {
        this.updateRosterCV(address, this.getLocoDirection(address), this.consistAddress.getNumber());
    }

    protected void resetRosterEntryCVValue(DccLocoAddress address) {
        this.updateRosterCV(address, this.getLocoDirection(address), 0);
    }

    protected void updateRosterCV(DccLocoAddress address, Boolean direction, int value) {
        if (!InstanceManager.getDefault(ConsistPreferencesManager.class).isUpdateCV19()) {
            log.trace("Consist Manager updates of CV19 are disabled in preferences");
            return;
        }
        if (this.getRosterId(address) == null) {
            log.trace("No RosterID for address {} in consist {}.  Skipping CV19 update.", (Object)address, (Object)this.consistAddress);
            return;
        }
        RosterEntry entry = Roster.getDefault().getEntryForId(this.getRosterId(address));
        if (entry == null || entry.getFileName() == null || entry.getFileName().equals("")) {
            log.trace("No file name available for RosterID {},address {}, in consist {}.  Skipping CV19 update.", new Object[]{this.getRosterId(address), address, this.consistAddress});
            return;
        }
        CvTableModel cvTable = new CvTableModel(null, null);
        VariableTableModel varTable = new VariableTableModel(null, new String[]{"Name", "Value"}, cvTable);
        entry.readFile();
        this.loadDecoderFromLoco(entry, varTable);
        entry.loadCvModel(varTable, cvTable);
        CvValue cv19Value = cvTable.getCvByNumber("19");
        cv19Value.setValue(value & 0xFF | (direction != false ? 0 : 128));
        entry.writeFile(cvTable, varTable);
    }

    protected void loadDecoderFromLoco(RosterEntry r, VariableTableModel varTable) {
        String decoderModel = r.getDecoderModel();
        String decoderFamily = r.getDecoderFamily();
        if (log.isDebugEnabled()) {
            log.debug("selected loco uses decoder {} {}", (Object)decoderFamily, (Object)decoderModel);
        }
        List<DecoderFile> l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, decoderFamily, null, null, null, decoderModel);
        log.debug("found {} matches", (Object)l.size());
        if (l.isEmpty()) {
            log.debug("Loco uses {} {} decoder, but no such decoder defined", (Object)decoderFamily, (Object)decoderModel);
            l = InstanceManager.getDefault(DecoderIndexFile.class).matchingDecoderList(null, null, null, null, null, decoderModel);
            log.debug("found {} matches without family key", (Object)l.size());
        }
        if (!l.isEmpty()) {
            DecoderFile d = l.get(0);
            this.loadDecoderFile(d, r, varTable);
        } else if (decoderModel.equals("")) {
            log.debug("blank decoderModel requested, so nothing loaded");
        } else {
            log.warn("no matching \"{}\" decoder found for loco, no decoder info loaded", (Object)decoderModel);
        }
    }

    protected void loadDecoderFile(DecoderFile df, RosterEntry re, VariableTableModel variableModel) {
        if (df == null) {
            log.warn("loadDecoder file invoked with null object");
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("loadDecoderFile from {} {}", (Object)DecoderFile.fileLocation, (Object)df.getFileName());
        }
        Element decoderRoot = null;
        try {
            decoderRoot = df.rootFromName(DecoderFile.fileLocation + df.getFileName());
        }
        catch (IOException | JDOMException e) {
            log.error("Exception while loading decoder XML file: {}", (Object)df.getFileName(), (Object)e);
        }
        df.getProductID();
        if (decoderRoot != null) {
            df.loadVariableModel(decoderRoot.getChild("decoder"), variableModel);
            re.loadFunctions(decoderRoot.getChild("decoder").getChild("family").getChild("functionlabels"));
        }
    }

    @Override
    public void addConsistListener(ConsistListener listener) {
        if (!this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    @Override
    public void removeConsistListener(ConsistListener listener) {
        if (this.listeners.contains(listener)) {
            this.listeners.remove(listener);
        }
    }

    @Override
    public void setConsistID(String id) {
        this.consistID = id;
    }

    @Override
    public String getConsistID() {
        return this.consistID;
    }

    @Override
    public void reverse() {
        Boolean oldDir = this.consistDir.get(this.consistList.get(0));
        Collections.reverse(this.consistList);
        Boolean newDir = this.consistDir.get(this.consistList.get(0));
        block4: for (DccLocoAddress locoaddress : this.consistList) {
            if (oldDir.equals(newDir)) {
                this.add(locoaddress, this.getLocoDirection(locoaddress));
            } else {
                this.add(locoaddress, !this.getLocoDirection(locoaddress));
            }
            if (!this.consistPosition.containsKey(locoaddress)) continue;
            switch (this.getPosition(locoaddress)) {
                case 0: {
                    this.setPosition(locoaddress, 255);
                    continue block4;
                }
                case 255: {
                    this.setPosition(locoaddress, 0);
                    continue block4;
                }
            }
            this.setPosition(locoaddress, this.consistList.size() - this.getPosition(locoaddress));
        }
        this.notifyConsistListeners(this.consistAddress, 0);
    }

    @Override
    public void restore() {
        for (DccLocoAddress locoaddress : this.consistList) {
            this.add(locoaddress, this.getLocoDirection(locoaddress));
        }
        this.notifyConsistListeners(this.consistAddress, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyConsistListeners(DccLocoAddress locoAddress, int errorCode) {
        ArrayList v;
        DccConsist dccConsist = this;
        synchronized (dccConsist) {
            v = (ArrayList)this.listeners.clone();
        }
        log.debug("Sending Status code: {} to {} listeners for Address {}", new Object[]{errorCode, v.size(), locoAddress});
        v.forEach(client -> client.consistReply(locoAddress, errorCode));
    }

    @Override
    public void programmingOpReply(int value, int status) {
        log.debug("Programming Operation reply received, value is {}, status is {}", (Object)value, (Object)status);
        this.notifyConsistListeners(new DccLocoAddress(0, false), 2);
    }
}

