/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;
import jmri.CommandStation;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.implementation.AbstractSignalMast;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DccSignalMast
extends AbstractSignalMast {
    private String theMastType = "F$dsm";
    private boolean useAddressOffSet = false;
    protected HashMap<String, Integer> appearanceToOutput = new HashMap();
    protected int packetSendCount = 3;
    int unLitId = 31;
    protected CommandStation c;
    protected int dccSignalDecoderAddress;
    private static final Logger log = LoggerFactory.getLogger(DccSignalMast.class);

    public DccSignalMast(String sys, String user) {
        super(sys, user);
        this.configureFromName(sys);
    }

    public DccSignalMast(String sys) {
        super(sys);
        this.configureFromName(sys);
    }

    public DccSignalMast(String sys, String user, String mastSubType) {
        super(sys, user);
        this.theMastType = mastSubType;
        this.configureFromName(sys);
    }

    protected void configureFromName(String systemName) {
        String[] parts = systemName.split(":");
        if (parts.length < 3) {
            log.error("SignalMast system name needs at least three parts: {}", (Object)systemName);
            throw new IllegalArgumentException("System name needs at least three parts: " + systemName);
        }
        if (!parts[0].endsWith(this.theMastType)) {
            log.warn("First part of SignalMast system name is incorrect {} : {}", (Object)systemName, (Object)this.theMastType);
        } else {
            String commandStationPrefix = parts[0].substring(0, parts[0].indexOf("$") - 1);
            List<CommandStation> connList = InstanceManager.getList(CommandStation.class);
            for (CommandStation station : connList) {
                log.trace(" check against {} with letter {}", (Object)station, (Object)station.getSystemPrefix());
                if (!station.getSystemPrefix().equals(commandStationPrefix)) continue;
                this.c = station;
                break;
            }
            if (this.c == null) {
                this.c = InstanceManager.getNullableDefault(CommandStation.class);
                log.error("No match against the command station for \"{}\", so will use the default {}", (Object)commandStationPrefix, (Object)this.c);
            }
        }
        String system = parts[1];
        String mast = parts[2];
        mast = mast.substring(0, mast.indexOf("("));
        log.trace("In configureFromName setMastType to {}", (Object)mast);
        this.setMastType(mast);
        String tmp = parts[2].substring(parts[2].indexOf("(") + 1, parts[2].indexOf(")"));
        try {
            this.dccSignalDecoderAddress = Integer.parseInt(tmp);
        }
        catch (NumberFormatException e) {
            log.warn("DCC accessory address SystemName {} is not in the correct format", (Object)systemName);
        }
        this.configureSignalSystemDefinition(system);
        this.configureAspectTable(system, mast);
    }

    public void setOutputForAppearance(String appearance, int number) {
        if (this.appearanceToOutput.containsKey(appearance)) {
            log.debug("Appearance {} is already defined as {}", (Object)appearance, (Object)this.appearanceToOutput.get(appearance));
            this.appearanceToOutput.remove(appearance);
        }
        this.appearanceToOutput.put(appearance, number);
    }

    public int getOutputForAppearance(String appearance) {
        if (!this.appearanceToOutput.containsKey(appearance)) {
            log.error("Trying to get appearance {} but it has not been configured", (Object)appearance);
            return -1;
        }
        return this.appearanceToOutput.get(appearance);
    }

    @Override
    public void setAspect(@Nonnull String aspect) {
        if (this.appearanceToOutput.containsKey(aspect) && this.appearanceToOutput.get(aspect) != -1) {
            if (this.getLit()) {
                if (this.useAddressOffSet) {
                    this.c.sendPacket(NmraPacket.accSignalDecoderPkt(this.dccSignalDecoderAddress, this.appearanceToOutput.get(aspect)), this.packetSendCount);
                } else {
                    this.c.sendPacket(NmraPacket.altAccSignalDecoderPkt(this.dccSignalDecoderAddress, this.appearanceToOutput.get(aspect)), this.packetSendCount);
                }
            }
        } else {
            log.warn("Trying to set aspect ({}) that has not been configured on mast {}", (Object)aspect, (Object)this.getDisplayName());
        }
        super.setAspect(aspect);
    }

    public void useAddressOffSet(boolean boo) {
        this.useAddressOffSet = boo;
    }

    public boolean useAddressOffSet() {
        return this.useAddressOffSet;
    }

    @Override
    public void setLit(boolean newLit) {
        if (!this.allowUnLit() || newLit == this.getLit()) {
            return;
        }
        super.setLit(newLit);
        if (newLit) {
            String newAspect = this.getAspect();
            if (newAspect != null) {
                this.setAspect(newAspect);
            }
        } else if (this.useAddressOffSet) {
            this.c.sendPacket(NmraPacket.accSignalDecoderPkt(this.dccSignalDecoderAddress, this.unLitId), this.packetSendCount);
        } else {
            this.c.sendPacket(NmraPacket.altAccSignalDecoderPkt(this.dccSignalDecoderAddress, this.unLitId), this.packetSendCount);
        }
    }

    public void setUnlitId(int i) {
        this.unLitId = i;
    }

    public int getUnlitId() {
        return this.unLitId;
    }

    public int getDccSignalMastAddress() {
        return this.dccSignalDecoderAddress;
    }

    public CommandStation getCommandStation() {
        return this.c;
    }

    public static String isDCCAddressUsed(int addr) {
        for (SignalMast mast : InstanceManager.getDefault(SignalMastManager.class).getNamedBeanSet()) {
            if (!(mast instanceof DccSignalMast) || ((DccSignalMast)mast).getDccSignalMastAddress() != addr) continue;
            return ((DccSignalMast)mast).getDisplayName();
        }
        return null;
    }

    public void setDccSignalMastPacketSendCount(int count) {
        this.packetSendCount = count >= 0 ? count : 1;
    }

    public int getDccSignalMastPacketSendCount() {
        return this.packetSendCount;
    }
}

