/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedSet;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.annotation.OverridingMethodsMustInvokeSuper;
import javax.annotation.concurrent.GuardedBy;
import jmri.AddressedIdTag;
import jmri.Block;
import jmri.BlockManager;
import jmri.CabSignal;
import jmri.InstanceManager;
import jmri.LocoAddress;
import jmri.Path;
import jmri.SignalMast;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCabSignal
implements CabSignal,
PropertyChangeListener {
    private LocoAddress _address = null;
    @GuardedBy(value="this")
    private Block _currentBlock = null;
    private Block _nextBlock = null;
    private SignalMast _nextMast = null;
    private boolean _cabSignalActive = true;
    private boolean _masterPausedButtonActive = false;
    private PropertyChangeListener _cconSignalMastListener = null;
    private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);
    private static final Logger log = LoggerFactory.getLogger(DefaultCabSignal.class);

    public DefaultCabSignal(LocoAddress address) {
        this._address = address;
    }

    @Override
    @OverridingMethodsMustInvokeSuper
    public void dispose() {
        if (this._nextMast != null) {
            this._nextMast.removePropertyChangeListener(this._cconSignalMastListener);
        }
        this._address = null;
        this._currentBlock = null;
        this._nextBlock = null;
        this._nextMast = null;
        this._cabSignalActive = true;
        this._masterPausedButtonActive = false;
    }

    @Override
    public LocoAddress getCabSignalAddress() {
        return this._address;
    }

    @Override
    public synchronized void setBlock(Block position) {
        log.debug("CabSignal for {} set block {}", (Object)this.getCabSignalAddress(), (Object)position);
        Block oldCurrentBlock = this._currentBlock;
        if (this._currentBlock != null) {
            this._currentBlock.removePropertyChangeListener(this);
        }
        this._currentBlock = position;
        if (this._currentBlock != null) {
            this._currentBlock.addPropertyChangeListener(this);
            if (!this._currentBlock.equals(oldCurrentBlock)) {
                this.firePropertyChange("CurrentBlock", this._currentBlock, oldCurrentBlock);
            }
        } else if (oldCurrentBlock != null) {
            this.firePropertyChange("CurrentBlock", this._currentBlock, oldCurrentBlock);
        }
        this.getNextBlock();
        this.forwardCabSignalToLayout();
    }

    @Override
    public synchronized void setBlock() {
        BlockManager bmgr = InstanceManager.getDefault(BlockManager.class);
        SortedSet blockSet = bmgr.getNamedBeanSet();
        LocoAddress addr = this.getCabSignalAddress();
        for (Block blockVal : blockSet) {
            Object val = blockVal.getValue();
            if (val == null) continue;
            log.debug("CabSignal for {} searching block {} value {}", new Object[]{addr, blockVal, val});
            if (val instanceof AddressedIdTag) {
                if (!((AddressedIdTag)val).getLocoAddress().toString().equals(addr.toString())) continue;
                this.setBlock(blockVal);
                return;
            }
            if (!val.equals(addr) && !val.toString().equals(addr.toString()) && !val.toString().equals("" + addr.getNumber())) continue;
            this.setBlock(blockVal);
            return;
        }
        this.setBlock(null);
    }

    @Override
    public synchronized Block getBlock() {
        return this._currentBlock;
    }

    @Override
    public Block getNextBlock() {
        Block oldNextBlock = this._nextBlock;
        this._nextBlock = this.getBlock() == null ? null : this.nextBlockOnPath(this.getBlock());
        if (this._nextBlock != null) {
            if (!this._nextBlock.equals(oldNextBlock)) {
                this.firePropertyChange("NextBlock", this._nextBlock, oldNextBlock);
            }
        } else if (oldNextBlock != null) {
            this.firePropertyChange("NextBlock", this._nextBlock, oldNextBlock);
        }
        return this._nextBlock;
    }

    private Block nextBlockOnPath(Block current) {
        int fromdirection = current.getDirection();
        List<Path> thispaths = current.getPaths();
        for (Path testpath : thispaths) {
            if (!testpath.checkPathSet()) continue;
            Block blockTest = testpath.getBlock();
            int dirftTest = testpath.getFromBlockDirection();
            int dirtoTest = testpath.getToBlockDirection();
            if (this.directionMatch(fromdirection, dirtoTest)) {
                blockTest.setDirection(dirtoTest);
                return blockTest;
            }
            if ((fromdirection & dirftTest) == 0) {
                blockTest.setDirection(dirtoTest);
                return blockTest;
            }
            if (fromdirection == dirftTest) continue;
            blockTest.setDirection(dirtoTest);
            return blockTest;
        }
        return null;
    }

    private boolean directionMatch(int fromDirection, int toDirection) {
        return (fromDirection & 0x10) != 0 && (toDirection & 0x10) != 0 || (fromDirection & 0x20) != 0 && (toDirection & 0x20) != 0 || (fromDirection & 0x40) != 0 && (toDirection & 0x40) != 0 || (fromDirection & 0x80) != 0 && (toDirection & 0x80) != 0 || (fromDirection & 0x100) != 0 && (toDirection & 0x100) != 0 || (fromDirection & 0x200) != 0 && (toDirection & 0x200) != 0 || (fromDirection & 0x400) != 0 && (toDirection & 0x400) != 0 || (fromDirection & 0x800) != 0 && (toDirection & 0x800) != 0 || (fromDirection & 0x1000) != 0 && (toDirection & 0x1000) != 0 || (fromDirection & 0x2000) != 0 && (toDirection & 0x2000) != 0;
    }

    @Override
    public SignalMast getNextMast() {
        SignalMast oldNextMast = this._nextMast;
        if (this._nextMast != null) {
            this._nextMast.removePropertyChangeListener(this._cconSignalMastListener);
        }
        this._nextMast = null;
        if (this.getBlock() != null) {
            LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
            Block b = this.getBlock();
            Block nB = this.getNextBlock();
            while (this._nextMast == null && nB != null) {
                this._nextMast = lbm.getFacingSignalMast(b, nB);
                b = nB;
                nB = this.nextBlockOnPath(b);
            }
            if (this._nextMast == null) {
                this._nextMast = lbm.getSignalMastAtEndBumper(b, null);
            }
            if (this._nextMast != null) {
                this._cconSignalMastListener = e -> {
                    this.firePropertyChange("MastChanged", e.getNewValue(), e.getOldValue());
                    this.forwardCabSignalToLayout();
                };
                this._nextMast.addPropertyChangeListener(this._cconSignalMastListener);
            }
        }
        if (this._nextMast != null) {
            if (!this._nextMast.equals(oldNextMast)) {
                this.firePropertyChange("NextMast", this._nextMast, oldNextMast);
            }
        } else if (oldNextMast != null) {
            this.firePropertyChange("NextMast", this._nextMast, oldNextMast);
        }
        return this._nextMast;
    }

    @Override
    @Nonnull
    public List<Block> getBlockList() {
        SignalMast mast;
        ArrayList<Block> blockList = new ArrayList<Block>();
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        Block thisBlock = this.getBlock();
        if (thisBlock == null) {
            return blockList;
        }
        blockList.add(thisBlock);
        Block nextBlock = this.nextBlockOnPath(thisBlock);
        SignalMast signalMast = mast = nextBlock == null ? null : lbm.getFacingSignalMast(thisBlock, nextBlock);
        while (this.okToProceedAfterMast(mast) && nextBlock != null) {
            blockList.add(nextBlock);
            mast = lbm.getFacingSignalMast(thisBlock, nextBlock);
            thisBlock = nextBlock;
            nextBlock = this.nextBlockOnPath(thisBlock);
        }
        return blockList;
    }

    private boolean okToProceedAfterMast(@CheckForNull SignalMast m) {
        if (m == null) {
            return true;
        }
        return !m.isAtStop();
    }

    @Override
    public void forwardCabSignalToLayout() {
        if (!this.isCabSignalActive()) {
            return;
        }
        if (this._masterPausedButtonActive) {
            return;
        }
        LocoAddress locoaddr = this.getCabSignalAddress();
        SignalMast mast = this.getNextMast();
        if (mast != null) {
            log.debug("cab {} aspect {}", (Object)locoaddr, (Object)mast.getAspect());
        }
        this.forwardAspectToLayout();
    }

    protected void forwardAspectToLayout() {
    }

    @Override
    public boolean isCabSignalActive() {
        return this._cabSignalActive;
    }

    @Override
    public void setCabSignalActive(boolean active) {
        this._cabSignalActive = active;
        if (this._cabSignalActive) {
            this.getNextMast();
        } else {
            this.resetLayoutCabSignal();
        }
    }

    @Override
    public void setMasterCabSigPauseActive(boolean active) {
        this._masterPausedButtonActive = active;
        if (!this.isCabSignalActive()) {
            return;
        }
        if (this._masterPausedButtonActive) {
            log.debug("master paused");
            this.resetLayoutCabSignal();
        } else {
            log.debug("master not paused");
            this.getNextMast();
        }
    }

    protected void resetLayoutCabSignal() {
    }

    @Override
    public synchronized void addPropertyChangeListener(PropertyChangeListener l) {
        this.pcs.addPropertyChangeListener(l);
    }

    @Override
    public synchronized void removePropertyChangeListener(PropertyChangeListener l) {
        this.pcs.removePropertyChangeListener(l);
    }

    protected void firePropertyChange(String p, Object old, Object n) {
        log.debug("sending property {} new value {} old value {}", new Object[]{p, old, n});
        this.pcs.firePropertyChange(p, old, n);
    }

    @Override
    public void propertyChange(PropertyChangeEvent event) {
        if (event.getSource() instanceof Block) {
            if (event.getPropertyName().equals("value")) {
                this.setBlock();
            }
            if (event.getPropertyName().equals("state") || event.getPropertyName().equals("direction")) {
                this.getNextBlock();
                this.forwardCabSignalToLayout();
            }
        } else if (event.getSource() instanceof SignalMast) {
            this.forwardCabSignalToLayout();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getCabSignalAddress();
    }
}

