/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalVariable;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Memory;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.Reference;
import jmri.Sensor;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.DefaultConditionalAction;
import jmri.implementation.DefaultConditionalExecute;
import jmri.util.ThreadingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditional
extends AbstractNamedBean
implements Conditional {
    static final ResourceBundle conditionalRbx = ResourceBundle.getBundle("jmri.jmrit.conditional.ConditionalBundle");
    private final DefaultConditionalExecute conditionalExecute;
    private String _antecedent = "";
    private Conditional.AntecedentOperator _logicType = Conditional.AntecedentOperator.ALL_AND;
    private List<ConditionalVariable> _variableList = new ArrayList<ConditionalVariable>();
    protected List<ConditionalAction> _actionList = new ArrayList<ConditionalAction>();
    private int _currentState = 1;
    private boolean _triggerActionsOnChange = true;
    private static volatile boolean skipErrorDialog = false;
    private static final Logger log = LoggerFactory.getLogger(DefaultConditional.class);

    public DefaultConditional(String systemName, String userName) {
        super(systemName, userName);
        this.conditionalExecute = new DefaultConditionalExecute(this);
    }

    public DefaultConditional(String systemName) {
        super(systemName);
        this.conditionalExecute = new DefaultConditionalExecute(this);
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameConditional");
    }

    public static int getIndexInTable(int[] table, int entry) {
        for (int i = 0; i < table.length; ++i) {
            if (entry != table[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public String getAntecedentExpression() {
        return this._antecedent;
    }

    @Override
    public Conditional.AntecedentOperator getLogicType() {
        return this._logicType;
    }

    @Override
    public void setLogicType(Conditional.AntecedentOperator type, String antecedent) {
        this._logicType = type;
        this._antecedent = antecedent;
        this.setState(1);
    }

    @Override
    public boolean getTriggerOnChange() {
        return this._triggerActionsOnChange;
    }

    @Override
    public void setTriggerOnChange(boolean trigger) {
        this._triggerActionsOnChange = trigger;
    }

    @Override
    public void setStateVariables(@Nonnull List<ConditionalVariable> arrayList) {
        log.debug("Conditional \"{}\" ({}) updated ConditionalVariable list.", (Object)this.getUserName(), (Object)this.getSystemName());
        this._variableList = arrayList;
    }

    @Override
    @Nonnull
    public List<ConditionalVariable> getCopyOfStateVariables() {
        ArrayList<ConditionalVariable> variableList = new ArrayList<ConditionalVariable>();
        for (int i = 0; i < this._variableList.size(); ++i) {
            ConditionalVariable variable = this._variableList.get(i);
            ConditionalVariable clone = new ConditionalVariable();
            clone.setNegation(variable.isNegated());
            clone.setOpern(variable.getOpern());
            clone.setType(variable.getType());
            clone.setName(variable.getName());
            clone.setDataString(variable.getDataString());
            clone.setNum1(variable.getNum1());
            clone.setNum2(variable.getNum2());
            clone.setTriggerActions(variable.doTriggerActions());
            clone.setState(variable.getState());
            clone.setGuiName(variable.getGuiName());
            variableList.add(clone);
        }
        return variableList;
    }

    public List<ConditionalVariable> getStateVariableList() {
        return this._variableList;
    }

    @Override
    public void setAction(@Nonnull List<ConditionalAction> arrayList) {
        this._actionList = arrayList;
    }

    @Override
    @Nonnull
    public List<ConditionalAction> getCopyOfActions() {
        ArrayList<ConditionalAction> actionList = new ArrayList<ConditionalAction>();
        for (int i = 0; i < this._actionList.size(); ++i) {
            ConditionalAction action = this._actionList.get(i);
            DefaultConditionalAction clone = new DefaultConditionalAction();
            clone.setType(action.getType());
            clone.setOption(action.getOption());
            clone.setDeviceName(action.getDeviceName());
            clone.setActionData(action.getActionData());
            clone.setActionString(action.getActionString());
            actionList.add(clone);
        }
        return actionList;
    }

    @Nonnull
    public List<ConditionalAction> getActionList() {
        return this._actionList;
    }

    @Override
    public int calculate(boolean enable, PropertyChangeEvent evt) {
        log.trace("calculate starts for {}", (Object)this.getSystemName());
        if (this._variableList.isEmpty()) {
            this.setState(1);
            return this._currentState;
        }
        boolean result = true;
        switch (this._logicType) {
            case ALL_AND: {
                for (int i = 0; i < this._variableList.size() && result; ++i) {
                    result = this._variableList.get(i).evaluate();
                }
                break;
            }
            case ALL_OR: {
                result = false;
                for (int k = 0; k < this._variableList.size() && !result; ++k) {
                    result = this._variableList.get(k).evaluate();
                }
                break;
            }
            case MIXED: {
                char[] ch = this._antecedent.toCharArray();
                int n = 0;
                for (int j = 0; j < ch.length; ++j) {
                    if (ch[j] == ' ') continue;
                    if (ch[j] == '{' || ch[j] == '[') {
                        ch[j] = 40;
                    } else if (ch[j] == '}' || ch[j] == ']') {
                        ch[j] = 41;
                    }
                    ch[n++] = ch[j];
                }
                try {
                    DataPair dp = this.parseCalculate(new String(ch, 0, n), this._variableList);
                    result = dp.result;
                }
                catch (IndexOutOfBoundsException | NumberFormatException | JmriException e) {
                    result = false;
                    log.error("{} parseCalculation error antecedent= {}, ex= {}", new Object[]{this.getDisplayName(), this._antecedent, e.toString(), e});
                }
                break;
            }
            default: {
                log.warn("Conditional {} fell through switch in calculate", (Object)this.getSystemName());
            }
        }
        int newState = 2;
        log.debug("Conditional \"{}\" ({}) has calculated its state to be {}. current state is {}. enabled= {}", new Object[]{this.getUserName(), this.getSystemName(), result, this._currentState, enable});
        if (result) {
            newState = 4;
        }
        boolean enabled = enable;
        log.trace("   enabled starts at {}", (Object)enabled);
        if (enabled && evt != null) {
            enabled = this.wantsToTrigger(evt);
            log.trace("   wantsToTrigger sets enabled to {}", (Object)enabled);
        }
        if (this._triggerActionsOnChange && newState == this._currentState) {
            enabled = false;
            log.trace("   _triggerActionsOnChange sets enabled to false");
        }
        this.setState(newState);
        if (enabled) {
            this.takeActionIfNeeded();
        }
        return this._currentState;
    }

    boolean wantsToTrigger(PropertyChangeEvent evt) {
        try {
            int i;
            String sysName = ((NamedBean)evt.getSource()).getSystemName();
            String userName = ((NamedBean)evt.getSource()).getUserName();
            for (i = 0; i < this._variableList.size(); ++i) {
                if (!sysName.equals(this._variableList.get(i).getName())) continue;
                return this._variableList.get(i).doTriggerActions();
            }
            if (userName != null) {
                for (i = 0; i < this._variableList.size(); ++i) {
                    if (!userName.equals(this._variableList.get(i).getName())) continue;
                    return this._variableList.get(i).doTriggerActions();
                }
            }
        }
        catch (ClassCastException e) {
            log.error("{} PropertyChangeEvent source of unexpected type: {}", (Object)this.getDisplayName(), (Object)evt);
        }
        return true;
    }

    @Override
    @CheckForNull
    public String validateAntecedent(@Nonnull String ant, List<ConditionalVariable> variableList) {
        char[] ch = ant.toCharArray();
        int n = 0;
        for (int j = 0; j < ch.length; ++j) {
            if (ch[j] == ' ') continue;
            if (ch[j] == '{' || ch[j] == '[') {
                ch[j] = 40;
            } else if (ch[j] == '}' || ch[j] == ']') {
                ch[j] = 41;
            }
            ch[n++] = ch[j];
        }
        int count = 0;
        for (int j = 0; j < n; ++j) {
            if (ch[j] == '(') {
                ++count;
            }
            if (ch[j] != ')') continue;
            --count;
        }
        if (count > 0) {
            return MessageFormat.format(conditionalRbx.getString("ParseError7"), Character.valueOf(')'));
        }
        if (count < 0) {
            return MessageFormat.format(conditionalRbx.getString("ParseError7"), Character.valueOf('('));
        }
        try {
            DataPair dp = this.parseCalculate(new String(ch, 0, n), variableList);
            if (n != dp.indexCount) {
                return MessageFormat.format(conditionalRbx.getString("ParseError4"), Character.valueOf(ch[dp.indexCount - 1]));
            }
            int index = dp.argsUsed.nextClearBit(0);
            if (index >= 0 && index < variableList.size()) {
                return MessageFormat.format(conditionalRbx.getString("ParseError5"), variableList.size(), index + 1);
            }
        }
        catch (IndexOutOfBoundsException | NumberFormatException | JmriException nfe) {
            return conditionalRbx.getString("ParseError6") + nfe.getMessage();
        }
        return null;
    }

    DataPair parseCalculate(String expression, List<ConditionalVariable> variableList) throws JmriException {
        int k;
        DataPair dp;
        String s = expression.toUpperCase();
        BitSet argsUsed = new BitSet(this._variableList.size());
        boolean leftArg = false;
        boolean rightArg = false;
        int i = 0;
        if (s.charAt(i) == '(') {
            dp = this.parseCalculate(s.substring(++i), variableList);
            leftArg = dp.result;
            i += dp.indexCount;
            argsUsed.or(dp.argsUsed);
        } else if (s.charAt(i) == 'R') {
            try {
                k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                i += 2;
            }
            catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                k = Integer.parseInt(String.valueOf(s.charAt(++i)));
            }
            leftArg = variableList.get(k - 1).evaluate();
            if (variableList.get(k - 1).isNegated()) {
                leftArg = !leftArg;
            }
            ++i;
            argsUsed.set(k - 1);
        } else if ("NOT".equals(s.substring(i, i + 3))) {
            if (s.charAt(i += 3) == '(') {
                dp = this.parseCalculate(s.substring(++i), variableList);
                leftArg = dp.result;
                i += dp.indexCount;
                argsUsed.or(dp.argsUsed);
            } else if (s.charAt(i) == 'R') {
                try {
                    k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                    i += 2;
                }
                catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                    k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                }
                leftArg = variableList.get(k - 1).evaluate();
                if (variableList.get(k - 1).isNegated()) {
                    leftArg = !leftArg;
                }
                ++i;
                argsUsed.set(k - 1);
            } else {
                throw new JmriException(MessageFormat.format(conditionalRbx.getString("ParseError1"), s.substring(i)));
            }
            leftArg = !leftArg;
        } else {
            throw new JmriException(MessageFormat.format(conditionalRbx.getString("ParseError9"), s));
        }
        while (i < s.length()) {
            if (s.charAt(i) != ')') {
                int oper;
                if ("AND".equals(s.substring(i, i + 3))) {
                    i += 3;
                    oper = 1;
                } else if ("OR".equals(s.substring(i, i + 2))) {
                    i += 2;
                    oper = 5;
                } else {
                    throw new JmriException(MessageFormat.format(conditionalRbx.getString("ParseError2"), s.substring(i)));
                }
                if (s.charAt(i) == '(') {
                    dp = this.parseCalculate(s.substring(++i), variableList);
                    rightArg = dp.result;
                    i += dp.indexCount;
                    argsUsed.or(dp.argsUsed);
                } else if (s.charAt(i) == 'R') {
                    try {
                        k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                        i += 2;
                    }
                    catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                        k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                    }
                    rightArg = variableList.get(k - 1).evaluate();
                    if (variableList.get(k - 1).isNegated()) {
                        rightArg = !rightArg;
                    }
                    ++i;
                    argsUsed.set(k - 1);
                } else if ("NOT".equals(s.substring(i, i + 3))) {
                    if (s.charAt(i += 3) == '(') {
                        dp = this.parseCalculate(s.substring(++i), variableList);
                        rightArg = dp.result;
                        i += dp.indexCount;
                        argsUsed.or(dp.argsUsed);
                    } else if (s.charAt(i) == 'R') {
                        try {
                            k = Integer.parseInt(String.valueOf(s.substring(i + 1, i + 3)));
                            i += 2;
                        }
                        catch (IndexOutOfBoundsException | NumberFormatException nfe) {
                            k = Integer.parseInt(String.valueOf(s.charAt(++i)));
                        }
                        rightArg = variableList.get(k - 1).evaluate();
                        if (variableList.get(k - 1).isNegated()) {
                            rightArg = !rightArg;
                        }
                        ++i;
                        argsUsed.set(k - 1);
                    } else {
                        throw new JmriException(MessageFormat.format(conditionalRbx.getString("ParseError3"), s.substring(i)));
                    }
                    rightArg = !rightArg;
                } else {
                    throw new JmriException(MessageFormat.format(conditionalRbx.getString("ParseError9"), s.substring(i)));
                }
                if (oper == 1) {
                    leftArg = leftArg && rightArg;
                    continue;
                }
                if (oper != 5) continue;
                leftArg = leftArg || rightArg;
                continue;
            }
            ++i;
            break;
        }
        dp = new DataPair();
        dp.result = leftArg;
        dp.indexCount = i;
        dp.argsUsed = argsUsed;
        return dp;
    }

    private void takeActionIfNeeded() {
        int i;
        log.trace("takeActionIfNeeded starts for {}", (Object)this.getSystemName());
        Reference<Integer> actionCount = new Reference<Integer>(0);
        int actionNeeded = 0;
        ArrayList<String> errorList = new ArrayList<String>();
        int currentState = this._currentState;
        for (i = 0; i < this._actionList.size(); ++i) {
            ConditionalAction action = this._actionList.get(i);
            int neededAction = actionNeeded;
            int option = action.getOption();
            log.trace(" takeActionIfNeeded considers action {} with currentState: {} and option: {}", new Object[]{i, currentState, option});
            if (currentState == 4 && option == 1 || currentState == 2 && option == 2 || option == 3) {
                ++actionNeeded;
                Object nb = null;
                NamedBeanHandle<?> anb = action.getNamedBean();
                if (anb != null) {
                    nb = anb.getBean();
                }
                Conditional.Action type = action.getType();
                String devName = this.getDeviceName(action);
                if (devName == null) {
                    errorList.add("invalid memory name in action - " + action);
                    continue;
                }
                log.debug("getDeviceName()={} devName= {}", (Object)action.getDeviceName(), (Object)devName);
                switch (type) {
                    case NONE: {
                        break;
                    }
                    case SET_TURNOUT: {
                        this.conditionalExecute.setTurnout(action, nb, actionCount, errorList);
                        break;
                    }
                    case RESET_DELAYED_TURNOUT: {
                        this.conditionalExecute.delayedTurnout(action, actionCount, new TimeTurnout(i), true, devName);
                        break;
                    }
                    case DELAYED_TURNOUT: {
                        this.conditionalExecute.delayedTurnout(action, actionCount, new TimeTurnout(i), false, devName);
                        break;
                    }
                    case CANCEL_TURNOUT_TIMERS: {
                        this.conditionalExecute.cancelTurnoutTimers(action, actionCount, errorList, devName);
                        break;
                    }
                    case LOCK_TURNOUT: {
                        this.conditionalExecute.lockTurnout(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_SIGNAL_APPEARANCE: {
                        this.conditionalExecute.setSignalAppearance(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_SIGNAL_HELD: {
                        this.conditionalExecute.setSignalHeld(action, nb, actionCount, errorList);
                        break;
                    }
                    case CLEAR_SIGNAL_HELD: {
                        this.conditionalExecute.clearSignalHeld(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_SIGNAL_DARK: {
                        this.conditionalExecute.setSignalDark(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_SIGNAL_LIT: {
                        this.conditionalExecute.setSignalLit(action, nb, actionCount, errorList);
                        break;
                    }
                    case TRIGGER_ROUTE: {
                        this.conditionalExecute.triggerRoute(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_SENSOR: {
                        this.conditionalExecute.setSensor(action, nb, actionCount, errorList, devName);
                        break;
                    }
                    case RESET_DELAYED_SENSOR: {
                        this.conditionalExecute.delayedSensor(action, actionCount, new TimeSensor(i), this.getMillisecondValue(action), true, devName);
                        break;
                    }
                    case DELAYED_SENSOR: {
                        this.conditionalExecute.delayedSensor(action, actionCount, new TimeSensor(i), this.getMillisecondValue(action), false, devName);
                        break;
                    }
                    case CANCEL_SENSOR_TIMERS: {
                        this.conditionalExecute.cancelSensorTimers(action, actionCount, errorList, devName);
                        break;
                    }
                    case SET_LIGHT: {
                        this.conditionalExecute.setLight(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_LIGHT_INTENSITY: {
                        this.conditionalExecute.setLightIntensity(action, nb, this.getIntegerValue(action), actionCount, errorList);
                        break;
                    }
                    case SET_LIGHT_TRANSITION_TIME: {
                        this.conditionalExecute.setLightTransitionTime(action, nb, this.getIntegerValue(action), actionCount, errorList);
                        break;
                    }
                    case SET_MEMORY: {
                        this.conditionalExecute.setMemory(action, nb, actionCount, errorList);
                        break;
                    }
                    case COPY_MEMORY: {
                        this.conditionalExecute.copyMemory(action, nb, DefaultConditional.getMemory(action.getActionString()), this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case ENABLE_LOGIX: {
                        this.conditionalExecute.enableLogix(action, actionCount, errorList, devName);
                        break;
                    }
                    case DISABLE_LOGIX: {
                        this.conditionalExecute.disableLogix(action, actionCount, errorList, devName);
                        break;
                    }
                    case PLAY_SOUND: {
                        this.conditionalExecute.playSound(action, this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case RUN_SCRIPT: {
                        this.conditionalExecute.runScript(action, this.getActionString(action), actionCount);
                        break;
                    }
                    case SET_FAST_CLOCK_TIME: {
                        this.conditionalExecute.setFastClockTime(action, actionCount);
                        break;
                    }
                    case START_FAST_CLOCK: {
                        this.conditionalExecute.startFastClock(actionCount);
                        break;
                    }
                    case STOP_FAST_CLOCK: {
                        this.conditionalExecute.stopFastClock(actionCount);
                        break;
                    }
                    case CONTROL_AUDIO: {
                        this.conditionalExecute.controlAudio(action, devName);
                        break;
                    }
                    case JYTHON_COMMAND: {
                        this.conditionalExecute.jythonCommand(action, this.getActionString(action), actionCount);
                        break;
                    }
                    case ALLOCATE_WARRANT_ROUTE: {
                        this.conditionalExecute.allocateWarrantRoute(action, nb, actionCount, errorList);
                        break;
                    }
                    case DEALLOCATE_WARRANT_ROUTE: {
                        this.conditionalExecute.deallocateWarrantRoute(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_ROUTE_TURNOUTS: {
                        this.conditionalExecute.setRouteTurnouts(action, nb, actionCount, errorList);
                        break;
                    }
                    case GET_TRAIN_LOCATION: {
                        this.conditionalExecute.getTrainLocation(action, nb, DefaultConditional.getMemory(action.getActionString()), this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case SET_TRAIN_ID: {
                        this.conditionalExecute.setTrainId(action, nb, this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case SET_TRAIN_NAME: {
                        this.conditionalExecute.setTrainName(action, nb, this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case AUTO_RUN_WARRANT: {
                        this.conditionalExecute.autoRunWarrant(action, nb, actionCount, errorList);
                        break;
                    }
                    case MANUAL_RUN_WARRANT: {
                        this.conditionalExecute.manualRunWarrant(action, nb, actionCount, errorList);
                        break;
                    }
                    case CONTROL_TRAIN: {
                        this.conditionalExecute.controlTrain(action, nb, actionCount, errorList, devName);
                        break;
                    }
                    case SET_SIGNALMAST_ASPECT: {
                        this.conditionalExecute.setSignalMastAspect(action, nb, this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case SET_SIGNALMAST_HELD: {
                        this.conditionalExecute.setSignalMastHeld(action, nb, actionCount, errorList);
                        break;
                    }
                    case CLEAR_SIGNALMAST_HELD: {
                        this.conditionalExecute.clearSignalMastHeld(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_SIGNALMAST_DARK: {
                        this.conditionalExecute.setSignalMastDark(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_SIGNALMAST_LIT: {
                        this.conditionalExecute.setSignalMastLit(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_BLOCK_VALUE: {
                        this.conditionalExecute.setBlockValue(action, nb, this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case SET_BLOCK_ERROR: {
                        this.conditionalExecute.setBlockError(action, nb, actionCount, errorList);
                        break;
                    }
                    case CLEAR_BLOCK_ERROR: {
                        this.conditionalExecute.clearBlockError(action, nb, errorList);
                        break;
                    }
                    case DEALLOCATE_BLOCK: {
                        this.conditionalExecute.deallocateBlock(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_BLOCK_OUT_OF_SERVICE: {
                        this.conditionalExecute.setBlockOutOfService(action, nb, actionCount, errorList);
                        break;
                    }
                    case SET_BLOCK_IN_SERVICE: {
                        this.conditionalExecute.setBlockInService(action, nb, actionCount, errorList);
                        break;
                    }
                    case GET_BLOCK_TRAIN_NAME: {
                        this.conditionalExecute.getBlockTrainName(action, nb, DefaultConditional.getMemory(action.getActionString()), this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case GET_BLOCK_WARRANT: {
                        this.conditionalExecute.getBlockWarrant(action, nb, DefaultConditional.getMemory(action.getActionString()), this.getActionString(action), actionCount, errorList);
                        break;
                    }
                    case SET_NXPAIR_ENABLED: {
                        this.conditionalExecute.setNXPairEnabled(action, actionCount, errorList, devName);
                        break;
                    }
                    case SET_NXPAIR_DISABLED: {
                        this.conditionalExecute.setNXPairDisabled(action, actionCount, errorList, devName);
                        break;
                    }
                    case SET_NXPAIR_SEGMENT: {
                        this.conditionalExecute.setNXPairSegment(action, actionCount, errorList, devName);
                        break;
                    }
                    default: {
                        log.warn("takeActionIfNeeded drops through switch statement for action {} of {}", (Object)i, (Object)this.getSystemName());
                    }
                }
            }
            if (!log.isDebugEnabled()) continue;
            log.debug("Global state= {} Local state= {} - Action {} taken for action = {} {} for device {}", new Object[]{this._currentState, currentState, actionNeeded > neededAction ? "WAS" : "NOT", action.getTypeString(), action.getActionString(), action.getDeviceName()});
        }
        if (!errorList.isEmpty()) {
            for (i = 0; i < errorList.size(); ++i) {
                log.error(" error: {} - {}", (Object)this.getDisplayName(), errorList.get(i));
            }
            if (!GraphicsEnvironment.isHeadless()) {
                Toolkit.getDefaultToolkit().beep();
                if (!skipErrorDialog) {
                    ThreadingUtil.runOnGUI(() -> new ErrorDialog(errorList, this).setVisible(true));
                }
            }
        }
        if (log.isDebugEnabled()) {
            log.debug("Conditional \"{}\" ({} has {} actions and has executed {} actions of {} actions needed on state change to {}", new Object[]{this.getUserName(), this.getSystemName(), this._actionList.size(), actionCount, actionNeeded, currentState});
        }
    }

    private static synchronized void setSkipErrorDialog(boolean skip) {
        skipErrorDialog = skip;
    }

    private String getDeviceName(@Nonnull ConditionalAction action) {
        String devName = action.getDeviceName();
        if (devName != null && devName.length() > 0 && devName.charAt(0) == '@') {
            String memName = devName.substring(1);
            Memory m = DefaultConditional.getMemory(memName);
            if (m == null) {
                log.error("{} invalid memory name in action - {}", (Object)this.getDisplayName(), (Object)devName);
                return null;
            }
            devName = (String)m.getValue();
        }
        return devName;
    }

    private String getActionString(@Nonnull ConditionalAction action) {
        String devAction = action.getActionString();
        if (!devAction.isEmpty() && devAction.charAt(0) == '@') {
            String memName = devAction.substring(1);
            Memory m = DefaultConditional.getMemory(memName);
            if (m == null) {
                log.error("{} action \"{}\" has invalid memory name in actionString - {}", new Object[]{this.getDisplayName(), action.getDeviceName(), action.getActionString()});
                return "";
            }
            devAction = (String)m.getValue();
        }
        return devAction;
    }

    @CheckForNull
    private static Memory getMemory(String name) {
        return InstanceManager.memoryManagerInstance().getMemory(name);
    }

    int getIntegerValue(@Nonnull ConditionalAction action) {
        int time;
        String sNumber = action.getActionString();
        try {
            time = Integer.parseInt(sNumber);
        }
        catch (NumberFormatException e) {
            Memory mem;
            if (sNumber.charAt(0) == '@') {
                sNumber = sNumber.substring(1);
            }
            if ((mem = DefaultConditional.getMemory(sNumber)) == null) {
                log.error("invalid memory name for action time variable - {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{sNumber, action.getTypeString(), this.getUserName(), this.getSystemName()});
                return -1;
            }
            try {
                time = Integer.parseInt((String)mem.getValue());
            }
            catch (NumberFormatException ex) {
                log.error("invalid action number variable from memory, \"{}\" ({}), value = {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{this.getUserName(), mem.getSystemName(), mem.getValue(), action.getTypeString(), this.getUserName(), this.getSystemName()});
                return -1;
            }
        }
        return time;
    }

    int getMillisecondValue(@Nonnull ConditionalAction action) {
        float time;
        block6: {
            String sNumber = action.getActionString();
            try {
                time = Float.parseFloat(sNumber);
            }
            catch (NumberFormatException e) {
                Memory mem;
                if (sNumber.charAt(0) == '@') {
                    sNumber = sNumber.substring(1);
                }
                if ((mem = DefaultConditional.getMemory(sNumber)) == null) {
                    log.error("invalid memory name for action time variable - {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{sNumber, action.getTypeString(), this.getUserName(), this.getSystemName()});
                    return -1;
                }
                try {
                    time = Float.parseFloat((String)mem.getValue());
                }
                catch (NumberFormatException ex) {
                    time = -1.0f;
                }
                if (!(time <= 0.0f)) break block6;
                log.error("invalid Millisecond value from memory, \"{}\" ({}), value = {}, for Action \"{}\", in Conditional \"{}\" ({})", new Object[]{this.getUserName(), mem.getSystemName(), mem.getValue(), action.getTypeString(), this.getUserName(), this.getSystemName()});
            }
        }
        return (int)(time * 1000.0f);
    }

    @Override
    public void cancelSensorTimer(String sname) {
        for (int i = 0; i < this._actionList.size(); ++i) {
            ConditionalAction action = this._actionList.get(i);
            if (action.getType() != Conditional.Action.DELAYED_SENSOR && action.getType() != Conditional.Action.RESET_DELAYED_SENSOR || !action.isTimerActive()) continue;
            String devName = this.getDeviceName(action);
            if (devName == null) {
                log.error("When cancelling S Timer Could not locate Device Name for Sensor {}", (Object)sname);
                return;
            }
            if (devName.equals(sname)) {
                action.stopTimer();
                continue;
            }
            Sensor sn = InstanceManager.sensorManagerInstance().getSensor(devName);
            if (sn == null) {
                log.error("{} Unknown sensor *{} in cancelSensorTimer.", (Object)this.getDisplayName(), (Object)action.getDeviceName());
                continue;
            }
            if (!sname.equals(sn.getSystemName()) && !sname.equals(sn.getUserName())) continue;
            action.stopTimer();
        }
    }

    @Override
    public void cancelTurnoutTimer(String sname) {
        for (int i = 0; i < this._actionList.size(); ++i) {
            ConditionalAction action = this._actionList.get(i);
            if (action.getType() != Conditional.Action.DELAYED_TURNOUT && action.getType() != Conditional.Action.RESET_DELAYED_TURNOUT || !action.isTimerActive()) continue;
            String devName = this.getDeviceName(action);
            if (devName == null) {
                log.error("When cancelling T Timer Could not locate Device Name for Turnout {}", (Object)sname);
                return;
            }
            if (devName.equals(sname)) {
                action.stopTimer();
                continue;
            }
            Turnout tn = InstanceManager.turnoutManagerInstance().getTurnout(devName);
            if (tn == null) {
                log.error("{} Unknown turnout *{} in cancelTurnoutTimer.", (Object)this.getDisplayName(), (Object)action.getDeviceName());
                continue;
            }
            if (!sname.equals(tn.getSystemName()) && !sname.equals(tn.getUserName())) continue;
            action.stopTimer();
        }
    }

    @Override
    public int getState() {
        return this._currentState;
    }

    @Override
    public void setState(int state) {
        if (this._currentState != state) {
            int oldState = this._currentState;
            this._currentState = state;
            this.firePropertyChange("KnownState", oldState, this._currentState);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        for (int i = 0; i < this._actionList.size(); ++i) {
            this._actionList.get(i).dispose();
        }
    }

    class TimeTurnout
    implements ActionListener {
        private int mIndex = 0;

        TimeTurnout(int index) {
            this.mIndex = index;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConditionalAction action = DefaultConditional.this._actionList.get(this.mIndex);
            NamedBeanHandle<?> beanHandle = action.getNamedBean();
            if (beanHandle == null) {
                log.error("{} Invalid delayed turnout name - {}", (Object)DefaultConditional.this.getDisplayName(), (Object)action.getDeviceName());
            } else {
                Turnout t = (Turnout)beanHandle.getBean();
                int act = action.getActionData();
                if (act == 8) {
                    int state = t.getKnownState();
                    act = state == 2 ? 4 : 2;
                }
                t.setCommandedState(act);
            }
            action.stopTimer();
        }
    }

    class TimeSensor
    implements ActionListener {
        private int mIndex = 0;

        TimeSensor(int index) {
            this.mIndex = index;
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            ConditionalAction action = DefaultConditional.this._actionList.get(this.mIndex);
            if (action.getNamedBean() == null) {
                log.error("{} Invalid delayed sensor name - {}", (Object)DefaultConditional.this.getDisplayName(), (Object)action.getDeviceName());
            } else {
                NamedBeanHandle<?> anb = action.getNamedBean();
                if (anb == null) {
                    log.error("No NamedBean for Acrion {}", (Object)action.getActionString());
                    return;
                }
                Sensor s = (Sensor)anb.getBean();
                try {
                    int act = action.getActionData();
                    if (act == 8) {
                        int state = s.getKnownState();
                        act = state == 2 ? 4 : 2;
                    }
                    s.setKnownState(act);
                }
                catch (JmriException e) {
                    log.warn("Exception setting delayed sensor {} in action", (Object)action.getDeviceName());
                }
            }
            action.stopTimer();
        }
    }

    private class ErrorDialog
    extends JDialog {
        JCheckBox rememberSession;

        ErrorDialog(List<String> list, Conditional cond) {
            this.setTitle("Logix Runtime Errors");
            JPanel contentPanel = new JPanel();
            contentPanel.setLayout(new BoxLayout(contentPanel, 1));
            JPanel panel = new JPanel();
            panel.add(new JLabel("Errors occurred executing Actions in Conditional:"));
            contentPanel.add(panel);
            panel = new JPanel();
            panel.add(new JLabel(DefaultConditional.this.getDisplayName(NamedBean.DisplayOptions.USERNAME_SYSTEMNAME)));
            contentPanel.add(panel);
            panel = new JPanel();
            panel.add(new JList<String>(list.toArray(new String[0])));
            contentPanel.add(panel);
            panel = new JPanel();
            this.rememberSession = new JCheckBox("Skip error dialog for this session only?");
            panel.add(this.rememberSession);
            contentPanel.add(panel);
            panel = new JPanel();
            JButton closeButton = new JButton("Close");
            closeButton.addActionListener(e -> {
                DefaultConditional.setSkipErrorDialog(this.rememberSession.isSelected());
                this.dispose();
            });
            panel.add(closeButton);
            contentPanel.add(panel);
            this.setContentPane(contentPanel);
            this.setLocation(250, 150);
            this.pack();
        }
    }

    private static class DataPair {
        boolean result = false;
        int indexCount = 0;
        BitSet argsUsed = null;

        private DataPair() {
        }
    }
}

