/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.awt.event.ActionListener;
import java.util.ResourceBundle;
import javax.annotation.CheckForNull;
import javax.swing.Timer;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.InstanceManager;
import jmri.LogixManager;
import jmri.Memory;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.RouteManager;
import jmri.SignalHeadManager;
import jmri.SignalMastManager;
import jmri.implementation.Bundle;
import jmri.implementation.DefaultSignalHead;
import jmri.jmrit.Sound;
import jmri.jmrit.beantable.LogixTableAction;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlockManager;
import jmri.jmrit.logix.WarrantManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalAction
implements ConditionalAction {
    private int _option = 1;
    private Conditional.Action _type = Conditional.Action.NONE;
    private String _deviceName = " ";
    private int _actionData = 0;
    private String _actionString = "";
    private NamedBeanHandle<?> _namedBean = null;
    private Timer _timer = null;
    private ActionListener _listener = null;
    private boolean _timerActive = false;
    private boolean _indirectAction = false;
    private Sound _sound = null;
    static final ResourceBundle rbx = ResourceBundle.getBundle("jmri.jmrit.conditional.ConditionalBundle");
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalAction.class);

    public DefaultConditionalAction() {
    }

    public DefaultConditionalAction(int option, Conditional.Action type, String name, int actionData, String actionStr) {
        this._option = option;
        this._type = type;
        this._deviceName = name;
        this._actionData = actionData;
        this._actionString = actionStr;
        NamedBean bean = this.getIndirectBean(this._deviceName);
        if (bean == null) {
            bean = this.getActionBean(this._deviceName);
        }
        this._namedBean = bean != null ? this.nbhm.getNamedBeanHandle(this._deviceName, bean) : null;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DefaultConditionalAction p = (DefaultConditionalAction)obj;
        if (p._option != this._option || p._type != this._type || p._actionData != this._actionData) {
            return false;
        }
        if (p._namedBean == null && this._namedBean != null || p._namedBean != null && this._namedBean == null || p._namedBean != null && this._namedBean != null && !p._namedBean.equals(this._namedBean)) {
            return false;
        }
        if (p._deviceName == null && this._deviceName != null || p._deviceName != null && this._deviceName == null || p._deviceName != null && this._deviceName != null && !p._deviceName.equals(this._deviceName)) {
            return false;
        }
        return !(p._actionString == null && this._actionString != null || p._actionString != null && this._actionString == null) && (p._actionString == null || this._actionString == null || p._actionString.equals(this._actionString));
    }

    public int hashCode() {
        int hash = this._option * 1000 + this._type.getIntValue() * 1000 * 1000 + this._actionData;
        if (this._deviceName != null) {
            hash += this._deviceName.hashCode();
        }
        return hash;
    }

    @CheckForNull
    private Memory getIndirectBean(@CheckForNull String devName) {
        if (devName != null && devName.length() > 0 && devName.charAt(0) == '@') {
            String memName = devName.substring(1);
            Memory m = InstanceManager.memoryManagerInstance().getMemory(memName);
            if (m != null) {
                this._indirectAction = true;
                return m;
            }
            log.error("\"{}\" invalid indirect memory name in action {} of type {}", new Object[]{devName, this._actionString, this._type});
        } else {
            this._indirectAction = false;
        }
        return null;
    }

    @CheckForNull
    private NamedBean getActionBean(@CheckForNull String devName) {
        if (devName == null) {
            return null;
        }
        NamedBean bean = null;
        try {
            switch (this._type.getItemType()) {
                case SENSOR: {
                    try {
                        bean = InstanceManager.sensorManagerInstance().provideSensor(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid sensor name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case TURNOUT: {
                    try {
                        bean = InstanceManager.turnoutManagerInstance().provideTurnout(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid turnout name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case MEMORY: {
                    try {
                        bean = InstanceManager.memoryManagerInstance().provideMemory(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid memory name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case LIGHT: {
                    try {
                        bean = InstanceManager.lightManagerInstance().getLight(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid light name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case SIGNALMAST: {
                    try {
                        bean = InstanceManager.getDefault(SignalMastManager.class).provideSignalMast(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid signal mast name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case SIGNALHEAD: {
                    try {
                        bean = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid signal head name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case WARRANT: {
                    try {
                        bean = InstanceManager.getDefault(WarrantManager.class).getWarrant(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid Warrant name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case OBLOCK: {
                    try {
                        bean = InstanceManager.getDefault(OBlockManager.class).getOBlock(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid OBlock name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case ENTRYEXIT: {
                    try {
                        bean = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid NX name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                case LOGIX: {
                    try {
                        bean = InstanceManager.getDefault(LogixManager.class).getLogix(devName);
                    }
                    catch (IllegalArgumentException e) {
                        bean = null;
                        log.error("invalid Logix name= \"{}\" in conditional action", (Object)devName);
                    }
                    break;
                }
                default: {
                    if (this.getType() == Conditional.Action.TRIGGER_ROUTE) {
                        try {
                            bean = InstanceManager.getDefault(RouteManager.class).getRoute(devName);
                        }
                        catch (IllegalArgumentException e) {
                            bean = null;
                            log.error("invalid Route name= \"{}\" in conditional action", (Object)devName);
                        }
                    }
                    break;
                }
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return bean;
    }

    @Override
    public Conditional.Action getType() {
        return this._type;
    }

    @Override
    public void setType(Conditional.Action type) {
        this._type = type;
    }

    @Override
    public void setType(String type) {
        this._type = DefaultConditionalAction.stringToActionType(type);
    }

    @Override
    public String getDeviceName() {
        if (this._namedBean != null) {
            return this._namedBean.getName();
        }
        this.setDeviceName(this._deviceName);
        return this._deviceName;
    }

    @Override
    public void setDeviceName(String deviceName) {
        this._deviceName = deviceName;
        NamedBean bean = this.getIndirectBean(this._deviceName);
        if (bean == null) {
            bean = this.getActionBean(this._deviceName);
        }
        this._namedBean = bean != null ? this.nbhm.getNamedBeanHandle(this._deviceName, bean) : null;
    }

    @Override
    public NamedBeanHandle<?> getNamedBean() {
        if (this._indirectAction) {
            Memory m = (Memory)this._namedBean.getBean();
            String actionName = (String)m.getValue();
            NamedBean bean = this.getActionBean(actionName);
            if (bean != null) {
                return this.nbhm.getNamedBeanHandle(actionName, bean);
            }
            return null;
        }
        return this._namedBean;
    }

    @Override
    public NamedBean getBean() {
        if (this._namedBean != null) {
            NamedBeanHandle<?> handle = this.getNamedBean();
            if (handle == null) {
                return null;
            }
            return handle.getBean();
        }
        this.setDeviceName(this._deviceName);
        if (this._namedBean != null) {
            return this.getNamedBean().getBean();
        }
        return null;
    }

    @Override
    public int getOption() {
        return this._option;
    }

    @Override
    public void setOption(int option) {
        this._option = option;
    }

    @Override
    public int getActionData() {
        return this._actionData;
    }

    @Override
    public void setActionData(int actionData) {
        this._actionData = actionData;
    }

    @Override
    public void setActionData(String actionData) {
        this._actionData = DefaultConditionalAction.stringToActionData(actionData);
    }

    @Override
    public String getActionString() {
        if (this._actionString == null) {
            this._actionString = this.getTypeString();
        }
        return this._actionString;
    }

    @Override
    public void setActionString(String actionString) {
        this._actionString = actionString;
    }

    @Override
    public Timer getTimer() {
        return this._timer;
    }

    @Override
    public void setTimer(Timer timer) {
        this._timer = timer;
    }

    @Override
    public boolean isTimerActive() {
        return this._timerActive;
    }

    @Override
    public void startTimer() {
        if (this._timer != null) {
            this._timer.start();
            this._timerActive = true;
        } else {
            log.error("timer is null for {} of type {}", (Object)this._deviceName, (Object)this.getTypeString());
        }
    }

    @Override
    public void stopTimer() {
        if (this._timer != null) {
            this._timer.stop();
            this._timerActive = false;
        }
    }

    @Override
    public ActionListener getListener() {
        return this._listener;
    }

    @Override
    public void setListener(ActionListener listener) {
        this._listener = listener;
    }

    @Override
    public Sound getSound() {
        return this._sound;
    }

    protected void setSound(Sound sound) {
        this._sound = sound;
    }

    @Override
    public String getTypeString() {
        return this._type.toString();
    }

    @Override
    public String getOptionString(boolean type) {
        return DefaultConditionalAction.getOptionString(this._option, type);
    }

    @Override
    public String getActionDataString() {
        return DefaultConditionalAction.getActionDataString(this._type, this._actionData);
    }

    public static String getOptionString(int opt, boolean type) {
        switch (opt) {
            case 1: {
                if (type) {
                    return rbx.getString("OnChangeToTrue");
                }
                return rbx.getString("OnTriggerToTrue");
            }
            case 2: {
                if (type) {
                    return rbx.getString("OnChangeToFalse");
                }
                return rbx.getString("OnTriggerToFalse");
            }
            case 3: {
                if (type) {
                    return rbx.getString("OnChange");
                }
                return rbx.getString("OnTrigger");
            }
        }
        log.warn("Unexpected parameter to getOptionString({})", (Object)opt);
        return "";
    }

    public static Conditional.Action stringToActionType(String str) {
        if (str != null) {
            for (Conditional.Action action : Conditional.Action.values()) {
                if (!str.equals(action.toString())) continue;
                return action;
            }
        }
        log.warn("Unexpected parameter to stringToActionType({})", (Object)str);
        return Conditional.Action.NONE;
    }

    public static int stringToActionData(String str) {
        if (str.equals(Bundle.getMessage("TurnoutStateClosed"))) {
            return 2;
        }
        if (str.equals(Bundle.getMessage("TurnoutStateThrown"))) {
            return 4;
        }
        if (str.equals(Bundle.getMessage("SensorStateActive"))) {
            return 2;
        }
        if (str.equals(Bundle.getMessage("SensorStateInactive"))) {
            return 4;
        }
        if (str.equals(rbx.getString("LightOn"))) {
            return 2;
        }
        if (str.equals(rbx.getString("LightOff"))) {
            return 4;
        }
        if (str.equals(rbx.getString("TurnoutUnlock"))) {
            return 0;
        }
        if (str.equals(rbx.getString("TurnoutLock"))) {
            return 1;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateRed"))) {
            return 1;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateYellow"))) {
            return 4;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateGreen"))) {
            return 16;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateDark"))) {
            return 0;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingRed"))) {
            return 2;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingYellow"))) {
            return 8;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingGreen"))) {
            return 32;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateLunar"))) {
            return 64;
        }
        if (str.equals(Bundle.getMessage("SignalHeadStateFlashingLunar"))) {
            return 128;
        }
        if (str.equals(rbx.getString("AudioSourcePlay"))) {
            return 64;
        }
        if (str.equals(rbx.getString("AudioSourceStop"))) {
            return 65;
        }
        if (str.equals(rbx.getString("AudioSourcePlayToggle"))) {
            return 66;
        }
        if (str.equals(rbx.getString("AudioSourcePause"))) {
            return 67;
        }
        if (str.equals(rbx.getString("AudioSourceResume"))) {
            return 68;
        }
        if (str.equals(rbx.getString("AudioSourcePauseToggle"))) {
            return 69;
        }
        if (str.equals(rbx.getString("AudioSourceRewind"))) {
            return 70;
        }
        if (str.equals(rbx.getString("AudioSourceFadeIn"))) {
            return 71;
        }
        if (str.equals(rbx.getString("AudioSourceFadeOut"))) {
            return 72;
        }
        if (str.equals(rbx.getString("AudioResetPosition"))) {
            return 73;
        }
        if (str.length() > 0) {
            log.warn("Unexpected parameter to stringToActionData({})", (Object)str);
        }
        return -1;
    }

    public static String getActionDataString(Conditional.Action t, int data) {
        switch (t) {
            case SET_TURNOUT: 
            case DELAYED_TURNOUT: 
            case RESET_DELAYED_TURNOUT: {
                if (data == 2) {
                    return Bundle.getMessage("TurnoutStateClosed");
                }
                if (data == 4) {
                    return Bundle.getMessage("TurnoutStateThrown");
                }
                if (data != 8) break;
                return Bundle.getMessage("Toggle");
            }
            case SET_SIGNAL_APPEARANCE: {
                return DefaultSignalHead.getDefaultStateName(data);
            }
            case SET_SENSOR: 
            case DELAYED_SENSOR: 
            case RESET_DELAYED_SENSOR: {
                if (data == 2) {
                    return Bundle.getMessage("SensorStateActive");
                }
                if (data == 4) {
                    return Bundle.getMessage("SensorStateInactive");
                }
                if (data != 8) break;
                return Bundle.getMessage("Toggle");
            }
            case SET_LIGHT: {
                if (data == 2) {
                    return rbx.getString("LightOn");
                }
                if (data == 4) {
                    return rbx.getString("LightOff");
                }
                if (data != 8) break;
                return Bundle.getMessage("Toggle");
            }
            case LOCK_TURNOUT: {
                if (data == 0) {
                    return rbx.getString("TurnoutUnlock");
                }
                if (data == 1) {
                    return rbx.getString("TurnoutLock");
                }
                if (data != 8) break;
                return Bundle.getMessage("Toggle");
            }
            case CONTROL_AUDIO: {
                switch (data) {
                    case 64: {
                        return rbx.getString("AudioSourcePlay");
                    }
                    case 65: {
                        return rbx.getString("AudioSourceStop");
                    }
                    case 66: {
                        return rbx.getString("AudioSourcePlayToggle");
                    }
                    case 67: {
                        return rbx.getString("AudioSourcePause");
                    }
                    case 68: {
                        return rbx.getString("AudioSourceResume");
                    }
                    case 69: {
                        return rbx.getString("AudioSourcePauseToggle");
                    }
                    case 70: {
                        return rbx.getString("AudioSourceRewind");
                    }
                    case 71: {
                        return rbx.getString("AudioSourceFadeIn");
                    }
                    case 72: {
                        return rbx.getString("AudioSourceFadeOut");
                    }
                    case 73: {
                        return rbx.getString("AudioResetPosition");
                    }
                }
                log.error("Unhandled Audio operation command: {}", (Object)data);
                break;
            }
            case CONTROL_TRAIN: {
                switch (data) {
                    case 1: {
                        return rbx.getString("WarrantHalt");
                    }
                    case 2: {
                        return rbx.getString("WarrantResume");
                    }
                    case 4: {
                        return rbx.getString("WarrantMoveToNext");
                    }
                    case 7: {
                        return rbx.getString("WarrantSpeedUp");
                    }
                    case 0: {
                        return rbx.getString("WarrantStop");
                    }
                    case 5: {
                        return rbx.getString("WarrantEStop");
                    }
                    case 3: {
                        return rbx.getString("WarrantAbort");
                    }
                }
                log.error("Unhandled Warrant control: {}", (Object)data);
                break;
            }
        }
        return "";
    }

    @Override
    public String description(boolean triggerType) {
        String str = this.getOptionString(triggerType) + ", " + this.getTypeString();
        if (this._deviceName.length() > 0) {
            switch (this._type) {
                case CANCEL_TURNOUT_TIMERS: 
                case SET_SIGNAL_HELD: 
                case CLEAR_SIGNAL_HELD: 
                case SET_SIGNAL_DARK: 
                case SET_SIGNAL_LIT: 
                case TRIGGER_ROUTE: 
                case CANCEL_SENSOR_TIMERS: 
                case SET_MEMORY: 
                case ENABLE_LOGIX: 
                case DISABLE_LOGIX: 
                case COPY_MEMORY: 
                case SET_LIGHT_INTENSITY: 
                case SET_LIGHT_TRANSITION_TIME: 
                case ALLOCATE_WARRANT_ROUTE: 
                case DEALLOCATE_WARRANT_ROUTE: 
                case SET_SIGNALMAST_HELD: 
                case CLEAR_SIGNALMAST_HELD: 
                case SET_SIGNALMAST_DARK: 
                case SET_SIGNALMAST_LIT: 
                case SET_BLOCK_ERROR: 
                case CLEAR_BLOCK_ERROR: 
                case DEALLOCATE_BLOCK: 
                case SET_BLOCK_OUT_OF_SERVICE: 
                case SET_BLOCK_IN_SERVICE: {
                    str = str + ", \"" + this._deviceName + "\".";
                    break;
                }
                case SET_NXPAIR_ENABLED: 
                case SET_NXPAIR_DISABLED: 
                case SET_NXPAIR_SEGMENT: {
                    str = str + ", \"" + this.getBean().getUserName() + "\".";
                    break;
                }
                case SET_ROUTE_TURNOUTS: 
                case AUTO_RUN_WARRANT: 
                case MANUAL_RUN_WARRANT: {
                    str = str + " " + rbx.getString("onWarrant") + ", \"" + this._deviceName + "\".";
                    break;
                }
                case SET_TURNOUT: 
                case DELAYED_TURNOUT: 
                case RESET_DELAYED_TURNOUT: 
                case SET_SIGNAL_APPEARANCE: 
                case SET_SENSOR: 
                case DELAYED_SENSOR: 
                case RESET_DELAYED_SENSOR: 
                case SET_LIGHT: 
                case LOCK_TURNOUT: 
                case CONTROL_AUDIO: {
                    str = str + ", \"" + this._deviceName + "\" " + rbx.getString("to") + " " + this.getActionDataString();
                    break;
                }
                case GET_TRAIN_LOCATION: 
                case GET_BLOCK_WARRANT: 
                case GET_BLOCK_TRAIN_NAME: {
                    str = str + " \"" + this._deviceName + "\" " + rbx.getString("intoMemory") + " " + this._actionString;
                    break;
                }
                case SET_SIGNALMAST_ASPECT: {
                    str = str + ", \"" + this._deviceName + "\" " + rbx.getString("to") + " " + this._actionString;
                    break;
                }
                case CONTROL_TRAIN: {
                    str = str + " " + rbx.getString("onWarrant") + " \"" + this._deviceName + "\" " + rbx.getString("to") + " " + this.getActionDataString();
                    break;
                }
            }
        }
        if (this._actionString.length() > 0) {
            switch (this._type) {
                case SET_MEMORY: 
                case COPY_MEMORY: {
                    str = str + " " + rbx.getString("to") + " " + this._actionString + ".";
                    break;
                }
                case PLAY_SOUND: 
                case RUN_SCRIPT: {
                    str = str + " " + rbx.getString("FromFile") + " " + this._actionString + ".";
                    break;
                }
                case DELAYED_TURNOUT: 
                case RESET_DELAYED_TURNOUT: 
                case DELAYED_SENSOR: 
                case RESET_DELAYED_SENSOR: {
                    str = str + rbx.getString("After") + " ";
                    try {
                        Float.parseFloat(this._actionString);
                        str = str + this._actionString + " " + rbx.getString("Seconds") + ".";
                    }
                    catch (NumberFormatException nfe) {
                        str = str + this._actionString + " " + rbx.getString("ValueInMemory") + " " + rbx.getString("Seconds") + ".";
                    }
                    break;
                }
                case SET_LIGHT_INTENSITY: 
                case SET_LIGHT_TRANSITION_TIME: {
                    try {
                        str = str + " " + rbx.getString("to") + " " + this._actionString + ".";
                    }
                    catch (NumberFormatException nfe) {
                        str = str + " " + rbx.getString("to") + " " + this._actionString + " " + rbx.getString("ValueInMemory") + ".";
                    }
                    break;
                }
                case JYTHON_COMMAND: {
                    str = str + " " + rbx.getString("ExecJythonCmd") + " " + this._actionString + ".";
                    break;
                }
                case SET_TRAIN_ID: 
                case SET_TRAIN_NAME: {
                    str = str + ", \"" + this._actionString + "\" " + rbx.getString("onWarrant") + " \"" + this._deviceName + "\".";
                    break;
                }
                case SET_BLOCK_VALUE: {
                    str = str + ", \"" + this._actionString + "\" " + rbx.getString("onBlock") + " \"" + this._deviceName + "\".";
                    break;
                }
            }
        }
        switch (this._type) {
            case SET_LIGHT_INTENSITY: 
            case SET_LIGHT_TRANSITION_TIME: {
                str = str + " " + rbx.getString("to") + " " + this._actionData + ".";
                break;
            }
            case SET_FAST_CLOCK_TIME: {
                str = str + " " + rbx.getString("to") + " " + LogixTableAction.formatTime(this._actionData / 60, this._actionData - this._actionData / 60 * 60);
                break;
            }
        }
        return str;
    }

    @Override
    public void dispose() {
        if (this._sound != null) {
            this._sound.dispose();
        }
    }
}

