/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.io.File;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nonnull;
import javax.script.ScriptEngine;
import javax.script.ScriptException;
import javax.swing.Timer;
import jmri.Audio;
import jmri.AudioManager;
import jmri.Conditional;
import jmri.ConditionalAction;
import jmri.ConditionalManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Light;
import jmri.Logix;
import jmri.LogixManager;
import jmri.Memory;
import jmri.Reference;
import jmri.Route;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalMast;
import jmri.Timebase;
import jmri.Turnout;
import jmri.VariableLight;
import jmri.implementation.DefaultConditional;
import jmri.jmrit.Sound;
import jmri.jmrit.audio.AudioListener;
import jmri.jmrit.audio.AudioSource;
import jmri.jmrit.entryexit.DestinationPoints;
import jmri.jmrit.entryexit.EntryExitPairs;
import jmri.jmrit.logix.OBlock;
import jmri.jmrit.logix.Warrant;
import jmri.jmrit.logix.WarrantTableFrame;
import jmri.script.JmriScriptEngineManager;
import jmri.script.swing.ScriptOutput;
import jmri.util.FileUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultConditionalExecute {
    private final DefaultConditional conditional;
    private static final Logger log = LoggerFactory.getLogger(DefaultConditionalExecute.class);

    DefaultConditionalExecute(@Nonnull DefaultConditional conditional) {
        this.conditional = conditional;
    }

    void setTurnout(@Nonnull ConditionalAction action, Turnout t, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (t == null) {
            errorList.add("invalid turnout name in action - " + action.getDeviceName());
        } else {
            int act = action.getActionData();
            if (act == 8) {
                int state = t.getKnownState();
                act = state == 2 ? 4 : 2;
            }
            t.setCommandedState(act);
            this.increaseCounter(actionCount);
        }
    }

    void delayedTurnout(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull DefaultConditional.TimeTurnout timeTurnout, boolean reset, String devName) {
        if (reset) {
            action.stopTimer();
        }
        if (!action.isTimerActive()) {
            int value;
            Timer timer = action.getTimer();
            if (timer == null) {
                action.setListener(timeTurnout);
                timer = new Timer(2000, action.getListener());
                timer.setRepeats(true);
            }
            if ((value = this.conditional.getMillisecondValue(action)) < 0) {
                return;
            }
            timer.setInitialDelay(value);
            action.setTimer(timer);
            action.startTimer();
            this.increaseCounter(actionCount);
        } else {
            log.warn("timer already active on request to start delayed turnout action - {}", (Object)devName);
        }
    }

    void cancelTurnoutTimers(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        ConditionalManager cmg = InstanceManager.getDefault(ConditionalManager.class);
        Iterator iter = cmg.getNamedBeanSet().iterator();
        while (iter.hasNext()) {
            String sname = ((Conditional)iter.next()).getSystemName();
            Conditional c = cmg.getBySystemName(sname);
            if (c == null) {
                errorList.add("Conditional null during cancel turnout timers for " + action.getDeviceName());
                continue;
            }
            c.cancelTurnoutTimer(devName);
            this.increaseCounter(actionCount);
        }
    }

    void lockTurnout(@Nonnull ConditionalAction action, Turnout tl, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (tl == null) {
            errorList.add("invalid turnout name in action - " + action.getDeviceName());
        } else {
            int act = action.getActionData();
            if (act == 8) {
                act = tl.getLocked(1) ? 0 : 1;
            }
            if (act == 1) {
                tl.setLocked(3, true);
            } else if (act == 0) {
                tl.setLocked(3, false);
            }
            this.increaseCounter(actionCount);
        }
    }

    void setSignalAppearance(@Nonnull ConditionalAction action, SignalHead h, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (h == null) {
            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
        } else {
            h.setAppearance(action.getActionData());
            this.increaseCounter(actionCount);
        }
    }

    void setSignalHeld(@Nonnull ConditionalAction action, SignalHead h, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (h == null) {
            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
        } else {
            h.setHeld(true);
            this.increaseCounter(actionCount);
        }
    }

    void clearSignalHeld(@Nonnull ConditionalAction action, SignalHead h, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (h == null) {
            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
        } else {
            h.setHeld(false);
            this.increaseCounter(actionCount);
        }
    }

    void setSignalDark(@Nonnull ConditionalAction action, SignalHead h, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (h == null) {
            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
        } else {
            h.setLit(false);
            this.increaseCounter(actionCount);
        }
    }

    void setSignalLit(@Nonnull ConditionalAction action, SignalHead h, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (h == null) {
            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
        } else {
            h.setLit(true);
            this.increaseCounter(actionCount);
        }
    }

    void triggerRoute(@Nonnull ConditionalAction action, Route r, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (r == null) {
            errorList.add("invalid Route name in action - " + action.getDeviceName());
        } else {
            r.setRoute();
            this.increaseCounter(actionCount);
        }
    }

    void setSensor(@Nonnull ConditionalAction action, Sensor sn, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        if (sn == null) {
            errorList.add("invalid Sensor name in action - " + action.getDeviceName());
        } else {
            int act = action.getActionData();
            if (act == 8) {
                int state = sn.getState();
                act = state == 2 ? 4 : 2;
            }
            try {
                sn.setKnownState(act);
                this.increaseCounter(actionCount);
            }
            catch (JmriException e) {
                log.warn("Exception setting Sensor {} in action", (Object)devName);
            }
        }
    }

    void delayedSensor(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull DefaultConditional.TimeSensor timeSensor, int delay, boolean reset, String devName) {
        if (reset) {
            action.stopTimer();
        }
        if (!action.isTimerActive()) {
            Timer timer = action.getTimer();
            if (timer == null) {
                action.setListener(timeSensor);
                timer = new Timer(2000, action.getListener());
                timer.setRepeats(true);
            }
            if (delay < 0) {
                return;
            }
            timer.setInitialDelay(delay);
            action.setTimer(timer);
            action.startTimer();
            this.increaseCounter(actionCount);
        } else {
            log.warn("timer already active on request to start delayed sensor action - {}", (Object)devName);
        }
    }

    void cancelSensorTimers(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        ConditionalManager cm = InstanceManager.getDefault(ConditionalManager.class);
        Iterator itr = cm.getNamedBeanSet().iterator();
        while (itr.hasNext()) {
            String sname = ((Conditional)itr.next()).getSystemName();
            Conditional c = cm.getBySystemName(sname);
            if (c == null) {
                errorList.add("Conditional null during cancel sensor timers for " + action.getDeviceName());
                continue;
            }
            c.cancelSensorTimer(devName);
            this.increaseCounter(actionCount);
        }
    }

    void setLight(@Nonnull ConditionalAction action, Light lgt, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (lgt == null) {
            errorList.add("invalid light name in action - " + action.getDeviceName());
        } else {
            int act = action.getActionData();
            if (act == 8) {
                int state = lgt.getState();
                act = state == 2 ? 4 : 2;
            }
            lgt.setState(act);
            this.increaseCounter(actionCount);
        }
    }

    void setLightIntensity(@Nonnull ConditionalAction action, Light lgt, int intensity, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (lgt == null) {
            errorList.add("invalid light name in action - " + action.getDeviceName());
        } else {
            try {
                if (intensity < 0) {
                    return;
                }
                if (lgt instanceof VariableLight) {
                    ((VariableLight)lgt).setTargetIntensity((double)intensity / 100.0);
                } else {
                    lgt.setState((double)intensity > 0.5 ? 2 : 4);
                }
                this.increaseCounter(actionCount);
            }
            catch (IllegalArgumentException e) {
                errorList.add("Exception in set light intensity action - " + action.getDeviceName());
            }
        }
    }

    void setLightTransitionTime(@Nonnull ConditionalAction action, Light lgt, int time, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (lgt == null) {
            errorList.add("invalid light name in action - " + action.getDeviceName());
        } else {
            try {
                if (time < 0) {
                    return;
                }
                if (lgt instanceof VariableLight) {
                    ((VariableLight)lgt).setTransitionTime(time);
                }
                this.increaseCounter(actionCount);
            }
            catch (IllegalArgumentException e) {
                errorList.add("Exception in set light transition time action - " + action.getDeviceName());
            }
        }
    }

    void setMemory(@Nonnull ConditionalAction action, Memory m, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (m == null) {
            errorList.add("invalid memory name in action - " + action.getDeviceName());
        } else {
            m.setValue(action.getActionString());
            this.increaseCounter(actionCount);
        }
    }

    void copyMemory(@Nonnull ConditionalAction action, Memory mFrom, Memory mTo, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (mFrom == null) {
            errorList.add("invalid memory name in action - " + action.getDeviceName());
        } else if (mTo == null) {
            errorList.add("invalid memory name in action - " + action.getActionString());
        } else {
            mTo.setValue(mFrom.getValue());
            this.increaseCounter(actionCount);
        }
    }

    void enableLogix(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        Logix x = InstanceManager.getDefault(LogixManager.class).getLogix(devName);
        if (x == null) {
            errorList.add("invalid logix name in action - " + action.getDeviceName());
        } else {
            x.setEnabled(true);
            this.increaseCounter(actionCount);
        }
    }

    void disableLogix(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        Logix x = InstanceManager.getDefault(LogixManager.class).getLogix(devName);
        if (x == null) {
            errorList.add("invalid logix name in action - " + action.getDeviceName());
        } else {
            x.setEnabled(false);
            this.increaseCounter(actionCount);
        }
    }

    void playSound(@Nonnull ConditionalAction action, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        String path = actionStr;
        if (!path.isEmpty()) {
            Sound sound = action.getSound();
            if (sound == null) {
                try {
                    sound = new Sound(path);
                }
                catch (NullPointerException ex) {
                    errorList.add("invalid path to sound: " + path);
                }
            }
            if (sound != null) {
                sound.play();
            }
            this.increaseCounter(actionCount);
        }
    }

    void runScript(@Nonnull ConditionalAction action, @Nonnull String actionStr, @Nonnull Reference<Integer> actionCount) {
        if (!actionStr.isEmpty()) {
            JmriScriptEngineManager.getDefault().runScript(new File(FileUtil.getExternalFilename(actionStr)));
            this.increaseCounter(actionCount);
        }
    }

    void setFastClockTime(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount) {
        Date date = InstanceManager.getDefault(Timebase.class).getTime();
        date.setHours(action.getActionData() / 60);
        date.setMinutes(action.getActionData() - action.getActionData() / 60 * 60);
        date.setSeconds(0);
        InstanceManager.getDefault(Timebase.class).userSetTime(date);
        this.increaseCounter(actionCount);
    }

    void startFastClock(@Nonnull Reference<Integer> actionCount) {
        InstanceManager.getDefault(Timebase.class).setRun(true);
        this.increaseCounter(actionCount);
    }

    void stopFastClock(@Nonnull Reference<Integer> actionCount) {
        InstanceManager.getDefault(Timebase.class).setRun(false);
        this.increaseCounter(actionCount);
    }

    void controlAudio(@Nonnull ConditionalAction action, String devName) {
        Audio audio = InstanceManager.getDefault(AudioManager.class).getAudio(devName);
        if (audio == null) {
            return;
        }
        if (audio.getSubType() == 'S') {
            AudioSource audioSource = (AudioSource)audio;
            switch (action.getActionData()) {
                case 64: {
                    audioSource.play();
                    break;
                }
                case 65: {
                    audioSource.stop();
                    break;
                }
                case 66: {
                    audioSource.togglePlay();
                    break;
                }
                case 67: {
                    audioSource.pause();
                    break;
                }
                case 68: {
                    audioSource.resume();
                    break;
                }
                case 69: {
                    audioSource.togglePause();
                    break;
                }
                case 70: {
                    audioSource.rewind();
                    break;
                }
                case 71: {
                    audioSource.fadeIn();
                    break;
                }
                case 72: {
                    audioSource.fadeOut();
                    break;
                }
                case 73: {
                    audioSource.resetCurrentPosition();
                    break;
                }
            }
        } else if (audio.getSubType() == 'L') {
            AudioListener audioListener = (AudioListener)audio;
            switch (action.getActionData()) {
                case 73: {
                    audioListener.resetCurrentPosition();
                    break;
                }
            }
        }
    }

    void jythonCommand(@Nonnull ConditionalAction action, String actionStr, @Nonnull Reference<Integer> actionCount) {
        if (!actionStr.isEmpty()) {
            ScriptOutput.writeScript(actionStr);
            ScriptEngine se = JmriScriptEngineManager.getDefault().getEngine("jython");
            if (se != null) {
                try {
                    JmriScriptEngineManager.getDefault().eval(actionStr, se);
                }
                catch (ScriptException ex) {
                    log.error("Error executing script:", (Throwable)ex);
                }
            } else {
                log.error("Error getting default ScriptEngine");
            }
            this.increaseCounter(actionCount);
        }
    }

    void allocateWarrantRoute(@Nonnull ConditionalAction action, Warrant w, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            String msg = w.allocateRoute(false, null);
            if (msg != null) {
                log.info("Warrant {} - {}", (Object)action.getDeviceName(), (Object)msg);
            }
            this.increaseCounter(actionCount);
        }
    }

    void deallocateWarrantRoute(@Nonnull ConditionalAction action, Warrant w, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            w.deAllocate();
            this.increaseCounter(actionCount);
        }
    }

    void setRouteTurnouts(@Nonnull ConditionalAction action, Warrant w, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            String msg = w.setRoute(false, null);
            if (msg != null) {
                log.info("Warrant {} unable to Set Route - {}", (Object)action.getDeviceName(), (Object)msg);
            }
            this.increaseCounter(actionCount);
        }
    }

    void setTrainId(@Nonnull ConditionalAction action, Warrant w, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            if (w.getRunMode() != 0) {
                errorList.add("Cannot set when Warrant is running - " + action.getActionString());
            } else if (!w.getSpeedUtil().setAddress(actionStr)) {
                errorList.add("invalid train ID in action - " + action.getDeviceName());
            }
            this.increaseCounter(actionCount);
        }
    }

    void setTrainName(@Nonnull ConditionalAction action, Warrant w, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            w.setTrainName(actionStr);
            this.increaseCounter(actionCount);
        }
    }

    void getTrainLocation(@Nonnull ConditionalAction action, Warrant w, Memory mTo, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else if (mTo == null) {
            errorList.add("invalid memory name in action - " + action.getActionString());
        } else {
            mTo.setValue(w.getCurrentBlockName());
            this.increaseCounter(actionCount);
        }
    }

    void autoRunWarrant(@Nonnull ConditionalAction action, Warrant w, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            WarrantTableFrame frame = WarrantTableFrame.getDefault();
            String err = frame.runTrain(w, 2);
            if (err != null) {
                errorList.add("runAutoTrain error - " + err);
                w.stopWarrant(true, true);
            }
            this.increaseCounter(actionCount);
        }
    }

    void manualRunWarrant(@Nonnull ConditionalAction action, Warrant w, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            if (w.getRunMode() != 0) {
                errorList.add("Cannot set when Warrant is running - " + action.getActionString());
            } else {
                String err = w.setRoute(false, null);
                if (err == null) {
                    err = w.setRunMode(3, null, null, null, false);
                }
                if (err != null) {
                    errorList.add("runManualTrain error - " + err);
                }
            }
            this.increaseCounter(actionCount);
        }
    }

    void controlTrain(@Nonnull ConditionalAction action, Warrant w, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        if (w == null) {
            errorList.add("invalid Warrant name in action - " + action.getDeviceName());
        } else {
            if (!w.controlRunTrain(action.getActionData())) {
                log.info("Train {} not running  - {}", (Object)w.getSpeedUtil().getRosterId(), (Object)devName);
            }
            this.increaseCounter(actionCount);
        }
    }

    void setSignalMastAspect(@Nonnull ConditionalAction action, SignalMast f, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (f == null) {
            errorList.add("invalid Signal Mast name in action - " + action.getDeviceName());
        } else {
            f.setAspect(actionStr);
            this.increaseCounter(actionCount);
        }
    }

    void setSignalMastHeld(@Nonnull ConditionalAction action, SignalMast f, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (f == null) {
            errorList.add("invalid Signal Mast name in action - " + action.getDeviceName());
        } else {
            f.setHeld(true);
            this.increaseCounter(actionCount);
        }
    }

    void clearSignalMastHeld(@Nonnull ConditionalAction action, SignalMast f, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (f == null) {
            errorList.add("invalid Signal Mast name in action - " + action.getDeviceName());
        } else {
            f.setHeld(false);
            this.increaseCounter(actionCount);
        }
    }

    void setSignalMastDark(@Nonnull ConditionalAction action, SignalMast f, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (f == null) {
            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
        } else {
            f.setLit(false);
            this.increaseCounter(actionCount);
        }
    }

    void setSignalMastLit(@Nonnull ConditionalAction action, SignalMast f, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (f == null) {
            errorList.add("invalid Signal Head name in action - " + action.getDeviceName());
        } else {
            f.setLit(true);
            this.increaseCounter(actionCount);
        }
    }

    void setBlockValue(@Nonnull ConditionalAction action, OBlock b, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else {
            b.setValue(actionStr);
            this.increaseCounter(actionCount);
        }
    }

    void setBlockError(@Nonnull ConditionalAction action, OBlock b, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else {
            b.setError(true);
            this.increaseCounter(actionCount);
        }
    }

    void clearBlockError(@Nonnull ConditionalAction action, OBlock b, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else {
            b.setError(false);
        }
    }

    void deallocateBlock(@Nonnull ConditionalAction action, OBlock b, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else {
            b.deAllocate(null);
            this.increaseCounter(actionCount);
        }
    }

    void setBlockOutOfService(@Nonnull ConditionalAction action, OBlock b, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else {
            b.setOutOfService(true);
            this.increaseCounter(actionCount);
        }
    }

    void setBlockInService(@Nonnull ConditionalAction action, OBlock b, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else {
            b.setOutOfService(false);
            this.increaseCounter(actionCount);
        }
    }

    void getBlockTrainName(@Nonnull ConditionalAction action, OBlock b, Memory mTo, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else if (mTo == null) {
            errorList.add("invalid memory name in action - " + action.getActionString());
        } else {
            String name = (String)b.getValue();
            if (name == null) {
                name = " ";
            }
            mTo.setValue(name);
            this.increaseCounter(actionCount);
        }
    }

    void getBlockWarrant(@Nonnull ConditionalAction action, OBlock b, Memory mTo, String actionStr, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList) {
        if (b == null) {
            errorList.add("invalid Block name in action - " + action.getDeviceName());
        } else if (mTo == null) {
            errorList.add("invalid memory name in action - " + action.getActionString());
        } else {
            Warrant w = b.getWarrant();
            String name = w != null ? w.getDisplayName() : " ";
            mTo.setValue(name);
            this.increaseCounter(actionCount);
        }
    }

    void setNXPairEnabled(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        DestinationPoints dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(devName);
        if (dp == null) {
            errorList.add("Invalid NX Pair name in action - " + action.getDeviceName());
        } else {
            dp.setEnabled(true);
            this.increaseCounter(actionCount);
        }
    }

    void setNXPairDisabled(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        DestinationPoints dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(devName);
        if (dp == null) {
            errorList.add("Invalid NX Pair name in action - " + action.getDeviceName());
        } else {
            dp.setEnabled(false);
            this.increaseCounter(actionCount);
        }
    }

    void setNXPairSegment(@Nonnull ConditionalAction action, @Nonnull Reference<Integer> actionCount, @Nonnull List<String> errorList, String devName) {
        DestinationPoints dp = InstanceManager.getDefault(EntryExitPairs.class).getNamedBean(devName);
        if (dp == null) {
            errorList.add("Invalid NX Pair name in action - " + action.getDeviceName());
        } else {
            InstanceManager.getDefault(EntryExitPairs.class).setSingleSegmentRoute(devName);
            this.increaseCounter(actionCount);
        }
    }

    private void increaseCounter(@Nonnull Reference<Integer> actionCount) {
        Integer value = actionCount.get();
        actionCount.set(value != null ? value + 1 : 0);
    }
}

