/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import com.fasterxml.jackson.databind.util.StdDateFormat;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Objects;
import javax.annotation.CheckForNull;
import jmri.ClockControl;
import jmri.IdTagManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.Manager;
import jmri.NamedBean;
import jmri.Reporter;
import jmri.ReporterManager;
import jmri.implementation.AbstractIdTag;
import org.jdom2.Content;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultIdTag
extends AbstractIdTag {
    private int currentState = 1;
    public static final String PROPERTY_WHEN_LAST_SEEN = "whenLastSeen";
    public static final String PROPERTY_WHERE_LAST_SEEN = "whereLastSeen";
    private static final Logger log = LoggerFactory.getLogger(DefaultIdTag.class);

    public DefaultIdTag(String systemName) {
        super(systemName);
        this.setWhereLastSeen(null);
    }

    public DefaultIdTag(String systemName, String userName) {
        super(systemName, userName);
        this.setWhereLastSeen(null);
    }

    @Override
    public int compareTo(NamedBean n2) {
        Objects.requireNonNull(n2);
        String o1 = this.getSystemName();
        String o2 = n2.getSystemName();
        int p1len = Manager.getSystemPrefixLength(o1);
        int p2len = Manager.getSystemPrefixLength(o2);
        int comp = o1.substring(0, p1len).compareTo(o2.substring(0, p2len));
        if (comp != 0) {
            return comp;
        }
        comp = o1.compareTo(o2);
        return comp;
    }

    @Override
    public final void setWhereLastSeen(@CheckForNull Reporter r) {
        Reporter oldWhere = this.whereLastSeen;
        Date oldWhen = this.whenLastSeen;
        this.whereLastSeen = r;
        this.whenLastSeen = r != null ? this.getDateNow() : null;
        this.setCurrentState(r != null ? 3 : 2);
        this.firePropertyChange(PROPERTY_WHERE_LAST_SEEN, oldWhere, this.whereLastSeen);
        this.firePropertyChange(PROPERTY_WHEN_LAST_SEEN, oldWhen, this.whenLastSeen);
    }

    private Date getDateNow() {
        return InstanceManager.getDefault(IdTagManager.class).isFastClockUsed() ? InstanceManager.getDefault(ClockControl.class).getTime() : Calendar.getInstance().getTime();
    }

    private void setCurrentState(int state) {
        try {
            this.setState(state);
        }
        catch (JmriException ex) {
            log.warn("Problem setting state of IdTag {} {}", (Object)this.getSystemName(), (Object)ex.getMessage());
        }
    }

    @Override
    public void setState(int s) throws JmriException {
        this.currentState = s;
    }

    @Override
    public int getState() {
        return this.currentState;
    }

    @Override
    public Element store(boolean storeState) {
        Reporter whereLast;
        String comment;
        Element e = new Element("idtag");
        e.addContent((Content)new Element("systemName").addContent(this.mSystemName));
        String uName = this.getUserName();
        if (uName != null && !uName.isEmpty()) {
            e.addContent((Content)new Element("userName").addContent(uName));
        }
        if ((comment = this.getComment()) != null && !comment.isEmpty()) {
            e.addContent((Content)new Element("comment").addContent(comment));
        }
        if ((whereLast = this.getWhereLastSeen()) != null && storeState) {
            e.addContent((Content)new Element(PROPERTY_WHERE_LAST_SEEN).addContent(whereLast.getSystemName()));
        }
        if (this.getWhenLastSeen() != null && storeState) {
            e.addContent((Content)new Element(PROPERTY_WHEN_LAST_SEEN).addContent(new StdDateFormat().format(this.getWhenLastSeen())));
        }
        return e;
    }

    @Override
    public void load(Element e) {
        if (e.getName().equals("idtag")) {
            log.debug("Load IdTag element for {}", (Object)this.getSystemName());
            if (e.getChild("userName") != null) {
                this.setUserName(e.getChild("userName").getText());
            }
            if (e.getChild("comment") != null) {
                this.setComment(e.getChild("comment").getText());
            }
            if (e.getChild(PROPERTY_WHERE_LAST_SEEN) != null) {
                try {
                    Reporter r = InstanceManager.getDefault(ReporterManager.class).provideReporter(e.getChild(PROPERTY_WHERE_LAST_SEEN).getText());
                    this.setWhereLastSeen(r);
                    this.whenLastSeen = null;
                }
                catch (IllegalArgumentException ex) {
                    log.warn("Failed to provide Reporter \"{}\" in load of \"{}\"", (Object)e.getChild(PROPERTY_WHERE_LAST_SEEN).getText(), (Object)this.getDisplayName());
                }
            }
            if (e.getChild(PROPERTY_WHEN_LAST_SEEN) != null) {
                String lastSeenText = e.getChildText(PROPERTY_WHEN_LAST_SEEN);
                log.debug("Loading {} When Last Seen: {}", (Object)this.getDisplayName(), (Object)lastSeenText);
                try {
                    this.whenLastSeen = new StdDateFormat().parse(lastSeenText);
                }
                catch (ParseException ex) {
                    log.debug("ParseException in whenLastSeen ISO attempt: \"{}\"", (Object)lastSeenText, (Object)ex);
                    try {
                        this.whenLastSeen = DateFormat.getDateTimeInstance(2, 2).parse(lastSeenText);
                    }
                    catch (ParseException ex2) {
                        log.warn("During load of IdTag \"{}\" {}", (Object)this.getDisplayName(), (Object)ex.getMessage());
                    }
                }
            }
        } else {
            log.error("Not an IdTag element: \"{}\" for Tag \"{}\"", (Object)e.getName(), (Object)this.getDisplayName());
        }
    }
}

