/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.swing.Timer;
import jmri.InstanceManager;
import jmri.Light;
import jmri.LightControl;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.Sensor;
import jmri.Timebase;
import jmri.Turnout;
import jmri.jmrit.beantable.LightTableAction;
import jmri.util.LoggingUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLightControl
implements LightControl {
    private int _controlType = 0;
    private String _controlSensorName = "";
    protected int _controlSensorSense = 2;
    private int _fastClockOnHour = 0;
    private int _fastClockOnMin = 0;
    private int _fastClockOffHour = 0;
    private int _fastClockOffMin = 0;
    private String _controlTurnoutName = "";
    private int _turnoutState = 2;
    private String _timedSensorName = "";
    protected int _timeOnDuration = 0;
    private String _controlSensor2Name = "";
    private Light _parentLight = null;
    private boolean _active = false;
    private NamedBeanHandle<Sensor> _namedControlSensor = null;
    private PropertyChangeListener _sensorListener = null;
    private NamedBeanHandle<Sensor> _namedControlSensor2 = null;
    private PropertyChangeListener _sensor2Listener = null;
    private PropertyChangeListener _timebaseListener = null;
    private Timebase _clock = null;
    private Turnout _controlTurnout = null;
    private PropertyChangeListener _turnoutListener = null;
    private NamedBeanHandle<Sensor> _namedTimedControlSensor = null;
    private PropertyChangeListener _timedSensorListener = null;
    private Timer _timedControlTimer = null;
    private ActionListener _timedControlListener = null;
    private int _timeNow;
    private PropertyChangeListener _parentLightListener = null;
    private final NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private static final Logger log = LoggerFactory.getLogger(DefaultLightControl.class);

    public DefaultLightControl() {
    }

    public DefaultLightControl(Light l) {
        this._parentLight = l;
    }

    public DefaultLightControl(@Nonnull LightControl lc) {
        this._controlType = lc.getControlType();
        this._controlSensorName = lc.getControlSensorName();
        this._controlSensorSense = lc.getControlSensorSense();
        this._fastClockOnHour = lc.getFastClockOnHour();
        this._fastClockOnMin = lc.getFastClockOnMin();
        this._fastClockOffHour = lc.getFastClockOffHour();
        this._fastClockOffMin = lc.getFastClockOffMin();
        this._controlTurnoutName = lc.getControlTurnoutName();
        this._turnoutState = lc.getControlTurnoutState();
        this._timedSensorName = lc.getTimedSensorName();
        this._timeOnDuration = lc.getTimedOnDuration();
        this._controlSensor2Name = lc.getControlSensor2Name();
    }

    public boolean equals(Object o) {
        if (!(o instanceof LightControl)) {
            return false;
        }
        LightControl that = (LightControl)o;
        if (that.getControlType() != this._controlType) {
            return false;
        }
        boolean _shouldReturn = true;
        switch (this._controlType) {
            case 0: {
                break;
            }
            case 1: {
                if (that.getControlSensorName().equals(this._controlSensorName) && that.getControlSensorSense() == this._controlSensorSense) break;
                _shouldReturn = false;
                break;
            }
            case 2: {
                if (that.getFastClockOffCombined() == this.getFastClockOffCombined() && that.getFastClockOnCombined() == this.getFastClockOnCombined()) break;
                _shouldReturn = false;
                break;
            }
            case 3: {
                if (that.getControlTurnoutName().equals(this._controlTurnoutName) && that.getControlTurnoutState() == this._turnoutState) break;
                _shouldReturn = false;
                break;
            }
            case 4: {
                if (that.getTimedSensorName().equals(this._timedSensorName) && that.getTimedOnDuration() == this._timeOnDuration) break;
                _shouldReturn = false;
                break;
            }
            case 5: {
                if (that.getControlSensorName().equals(this._controlSensorName) && that.getControlSensorSense() == this._controlSensorSense && that.getControlSensor2Name().equals(this._controlSensor2Name)) break;
                _shouldReturn = false;
                break;
            }
            default: {
                LoggingUtil.warnOnce(log, "Unexpected _controlType = {}", this._controlType);
            }
        }
        return _shouldReturn;
    }

    public int hashCode() {
        return this._controlType;
    }

    @Override
    public int getControlType() {
        return this._controlType;
    }

    @Override
    public void setControlType(int type) {
        this._controlType = type;
    }

    @Override
    public void setControlSensorName(String sensorName) {
        this._controlSensorName = sensorName;
    }

    @Override
    public int getControlSensorSense() {
        return this._controlSensorSense;
    }

    @Override
    public String getControlSensorName() {
        if (this._namedControlSensor != null) {
            return this._namedControlSensor.getName();
        }
        return this._controlSensorName;
    }

    @Override
    public void setControlSensorSense(int sense) {
        if (sense != 2 && sense != 4) {
            log.error("Incorrect Sensor State Set");
        } else {
            this._controlSensorSense = sense;
        }
    }

    @Override
    public int getFastClockOnHour() {
        return this._fastClockOnHour;
    }

    @Override
    public int getFastClockOnMin() {
        return this._fastClockOnMin;
    }

    @Override
    public int getFastClockOnCombined() {
        return this._fastClockOnHour * 60 + this._fastClockOnMin;
    }

    @Override
    public int getFastClockOffHour() {
        return this._fastClockOffHour;
    }

    @Override
    public int getFastClockOffMin() {
        return this._fastClockOffMin;
    }

    @Override
    public int getFastClockOffCombined() {
        return this._fastClockOffHour * 60 + this._fastClockOffMin;
    }

    @Override
    public void setFastClockControlSchedule(int onHour, int onMin, int offHour, int offMin) {
        this._fastClockOnHour = onHour;
        this._fastClockOnMin = onMin;
        this._fastClockOffHour = offHour;
        this._fastClockOffMin = offMin;
    }

    @Override
    public String getControlTurnoutName() {
        return this._controlTurnoutName;
    }

    @Override
    public void setControlTurnout(String turnoutName) {
        this._controlTurnoutName = turnoutName;
    }

    @Override
    public int getControlTurnoutState() {
        return this._turnoutState;
    }

    @Override
    public void setControlTurnoutState(int state) {
        if (state != 2 && state != 4) {
            log.error("Incorrect Turnout State Set");
        } else {
            this._turnoutState = state;
        }
    }

    @Override
    public String getTimedSensorName() {
        return this._timedSensorName;
    }

    @Override
    public String getControlTimedOnSensorName() {
        if (this._namedTimedControlSensor != null) {
            return this._namedTimedControlSensor.getName();
        }
        return this._timedSensorName;
    }

    @Override
    public void setControlTimedOnSensorName(String sensorName) {
        this._timedSensorName = sensorName;
    }

    @Override
    public int getTimedOnDuration() {
        return this._timeOnDuration;
    }

    @Override
    public void setTimedOnDuration(int duration) {
        this._timeOnDuration = duration;
    }

    @Override
    public String getControlSensor2Name() {
        if (this._namedControlSensor2 != null) {
            return this._namedControlSensor2.getName();
        }
        return this._controlSensor2Name;
    }

    @Override
    public void setControlSensor2Name(String sensorName) {
        this._controlSensor2Name = sensorName;
    }

    @Override
    public void setParentLight(Light l) {
        this._parentLight = l;
    }

    @Override
    public String getDescriptionText(String lightName) {
        StringBuilder name = new StringBuilder(LightTableAction.lightControlTitle);
        name.append(" ");
        name.append(lightName);
        name.append(" ");
        name.append(LightTableAction.getDescriptionText(this, this.getControlType()));
        return name.toString();
    }

    @Override
    public void activateLightControl() {
        if (this._active) {
            return;
        }
        if (this._parentLight == null) {
            log.error("No Parent Light when activating LightControl");
            return;
        }
        this._parentLightListener = e -> {};
        this._parentLight.addPropertyChangeListener(this._parentLightListener, this._parentLight.toString(), this.getDescriptionText(""));
        switch (this._controlType) {
            case 1: {
                this._namedControlSensor = null;
                if (!this._controlSensorName.isEmpty()) {
                    Sensor sen = InstanceManager.sensorManagerInstance().provideSensor(this._controlSensorName);
                    this._namedControlSensor = this.nbhm.getNamedBeanHandle(this._controlSensorName, sen);
                }
                if (this._namedControlSensor != null) {
                    this.oneSensorChanged(this._namedControlSensor.getBean().getKnownState());
                    this._sensorListener = e -> {
                        if (e.getPropertyName().equals("KnownState")) {
                            this.oneSensorChanged((Integer)e.getNewValue());
                        }
                    };
                    this._namedControlSensor.getBean().addPropertyChangeListener(this._sensorListener, this._controlSensorName, this.getDescriptionText(this._parentLight.getDisplayName()));
                    this._active = true;
                    break;
                }
                log.error("Light {} is linked to a Sensor that does not exist: {}", (Object)this._parentLight.getSystemName(), (Object)this._controlSensorName);
                break;
            }
            case 2: {
                if (this.areFollowerTimesFaulty(this._parentLight.getLightControlList())) {
                    log.error("Light has multiple actions for the same time in {}", (Object)this.getDescriptionText(this._parentLight.getDisplayName()));
                }
                if (this._clock == null) {
                    this._clock = InstanceManager.getDefault(Timebase.class);
                }
                this.updateClockControlLightFollower();
                this._timebaseListener = e -> this.updateClockControlLightFollower();
                this._clock.addMinuteChangeListener(this._timebaseListener);
                this._active = true;
                break;
            }
            case 3: {
                try {
                    this._controlTurnout = InstanceManager.turnoutManagerInstance().provideTurnout(this._controlTurnoutName);
                }
                catch (IllegalArgumentException e2) {
                    log.error("Light {} is linked to a Turnout that does not exist: {}", (Object)this._parentLight.getSystemName(), (Object)this._controlSensorName);
                    return;
                }
                this.oneTurnoutChanged(this._controlTurnout.getKnownState());
                this._turnoutListener = e -> {
                    if (e.getPropertyName().equals("KnownState")) {
                        this.oneTurnoutChanged((Integer)e.getNewValue());
                    }
                };
                this._controlTurnout.addPropertyChangeListener(this._turnoutListener, this._controlTurnoutName, this.getDescriptionText(this._parentLight.getDisplayName()));
                this._active = true;
                break;
            }
            case 4: {
                if (!this._timedSensorName.isEmpty()) {
                    Sensor sen = InstanceManager.sensorManagerInstance().provideSensor(this._timedSensorName);
                    this._namedTimedControlSensor = this.nbhm.getNamedBeanHandle(this._timedSensorName, sen);
                }
                if (this._namedTimedControlSensor != null) {
                    if (this._parentLight.getEnabled()) {
                        this._parentLight.setState(4);
                    }
                    this.addNamedTimedControlListener();
                    this._active = true;
                    break;
                }
                log.error("Light {} is linked to a Sensor that does not exist: {}", (Object)this._parentLight.getSystemName(), (Object)this._timedSensorName);
                break;
            }
            case 5: {
                Sensor sen;
                this._namedControlSensor = null;
                this._namedControlSensor2 = null;
                if (!this._controlSensorName.isEmpty()) {
                    sen = InstanceManager.sensorManagerInstance().provideSensor(this._controlSensorName);
                    this._namedControlSensor = this.nbhm.getNamedBeanHandle(this._controlSensorName, sen);
                }
                if (!this._controlSensor2Name.isEmpty()) {
                    sen = InstanceManager.sensorManagerInstance().provideSensor(this._controlSensor2Name);
                    this._namedControlSensor2 = this.nbhm.getNamedBeanHandle(this._controlSensor2Name, sen);
                }
                if (this._namedControlSensor != null && this._namedControlSensor2 != null) {
                    this.twoSensorChanged();
                    this._sensorListener = this.addTwoSensorListener(this._namedControlSensor.getBean());
                    this._sensor2Listener = this.addTwoSensorListener(this._namedControlSensor2.getBean());
                    this._active = true;
                    break;
                }
                log.error("Light {} with 2 Sensor Control is linked to a Sensor that does not exist.", (Object)this._parentLight.getSystemName());
                break;
            }
            default: {
                log.error("Unexpected control type when activating Light: {}", (Object)this._parentLight);
            }
        }
    }

    private PropertyChangeListener addTwoSensorListener(Sensor sensor) {
        PropertyChangeListener pcl = e -> {
            if (e.getPropertyName().equals("KnownState")) {
                this.twoSensorChanged();
            }
        };
        sensor.addPropertyChangeListener(pcl, sensor.getDisplayName(), this.getDescriptionText(this._parentLight.getDisplayName()));
        return pcl;
    }

    private void addNamedTimedControlListener() {
        this._timedSensorListener = e -> {
            if (e.getPropertyName().equals("KnownState") && (Integer)e.getNewValue() == 2 && this._timedControlTimer == null && this._parentLight.getEnabled()) {
                this._parentLight.setState(2);
                this._timedControlListener = new TimeLight();
                this._timedControlTimer = new Timer(this._timeOnDuration, this._timedControlListener);
                this._timedControlTimer.start();
            }
        };
        this._namedTimedControlSensor.getBean().addPropertyChangeListener(this._timedSensorListener, this._timedSensorName, this.getDescriptionText(this._parentLight.getDisplayName()));
    }

    private void oneSensorChanged(int newSensorState) {
        if (!this._parentLight.getEnabled()) {
            return;
        }
        if (newSensorState == 2) {
            if (this._controlSensorSense == 2) {
                this._parentLight.setState(2);
            } else {
                this._parentLight.setState(4);
            }
        } else if (newSensorState == 4) {
            if (this._controlSensorSense == 4) {
                this._parentLight.setState(2);
            } else {
                this._parentLight.setState(4);
            }
        }
    }

    private void oneTurnoutChanged(int newTurnoutState) {
        if (!this._parentLight.getEnabled()) {
            return;
        }
        if (newTurnoutState == 2) {
            if (this._turnoutState == 2) {
                this._parentLight.setState(2);
            } else {
                this._parentLight.setState(4);
            }
        } else if (newTurnoutState == 4) {
            if (this._turnoutState == 4) {
                this._parentLight.setState(2);
            } else {
                this._parentLight.setState(4);
            }
        }
    }

    protected void twoSensorChanged() {
        if (!this._parentLight.getEnabled()) {
            return;
        }
        int kState = this._namedControlSensor.getBean().getKnownState();
        int kState2 = this._namedControlSensor2.getBean().getKnownState();
        if (this._controlSensorSense == 2) {
            if (kState == 2 || kState2 == 2) {
                this._parentLight.setState(2);
            } else {
                this._parentLight.setState(4);
            }
        } else if (this._controlSensorSense == 4) {
            if (kState == 4 || kState2 == 4) {
                this._parentLight.setState(2);
            } else {
                this._parentLight.setState(4);
            }
        }
    }

    private boolean isMasterFastClockFollower() {
        ArrayList<Integer> otherControlTimes = new ArrayList<Integer>();
        ArrayList<Integer> thisControlTimes = new ArrayList<Integer>();
        this._parentLight.getLightControlList().forEach(otherLc -> {
            if (otherLc != this && otherLc.getControlType() == 2) {
                otherControlTimes.add(otherLc.getFastClockOnCombined());
                otherControlTimes.add(otherLc.getFastClockOffCombined());
                otherControlTimes.add(otherLc.getFastClockOnCombined() + 1440);
                otherControlTimes.add(otherLc.getFastClockOffCombined() + 1440);
            }
        });
        thisControlTimes.add(this.getFastClockOnCombined());
        thisControlTimes.add(this.getFastClockOffCombined());
        thisControlTimes.add(this.getFastClockOnCombined() + 1440);
        thisControlTimes.add(this.getFastClockOffCombined() + 1440);
        otherControlTimes.removeIf(e -> e > this._timeNow + 1440);
        thisControlTimes.removeIf(e -> e > this._timeNow + 1440);
        if (otherControlTimes.isEmpty()) {
            return true;
        }
        return (Integer)Collections.max(thisControlTimes) >= (Integer)Collections.max(otherControlTimes);
    }

    @Override
    public boolean onOffTimesFaulty() {
        return this.getFastClockOnCombined() == this.getFastClockOffCombined();
    }

    private Predicate<LightControl> isFastClockEqual(int time) {
        return p -> p != this && (p.getFastClockOnCombined() == time || p.getFastClockOffCombined() == time);
    }

    @Override
    public boolean areFollowerTimesFaulty(List<LightControl> compareList) {
        if (this.onOffTimesFaulty()) {
            return true;
        }
        return compareList.stream().anyMatch(this.isFastClockEqual(this.getFastClockOnCombined())) || compareList.stream().anyMatch(this.isFastClockEqual(this.getFastClockOffCombined()));
    }

    private void setTheTime() {
        Date now = this._clock.getTime();
        this._timeNow = now.getHours() * 60 + now.getMinutes();
    }

    private void updateClockControlLightFollower() {
        if (!this._parentLight.getEnabled()) {
            return;
        }
        if (this._clock != null) {
            this.setTheTime();
            if (!this.isMasterFastClockFollower()) {
                return;
            }
            int state = this._parentLight.getState();
            if (this.getFastClockOnCombined() <= this.getFastClockOffCombined()) {
                if (this._timeNow < this.getFastClockOnCombined() || this._timeNow >= this.getFastClockOffCombined()) {
                    if (state == 2) {
                        this.logTimeChanges("OFF");
                        this._parentLight.setState(4);
                    }
                } else if (state == 4) {
                    this.logTimeChanges("ON");
                    this._parentLight.setState(2);
                }
            } else if (this._timeNow >= this.getFastClockOnCombined() || this._timeNow < this.getFastClockOffCombined()) {
                if (state == 4) {
                    this.logTimeChanges("ON");
                    this._parentLight.setState(2);
                }
            } else if (state == 2) {
                this.logTimeChanges("OFF");
                this._parentLight.setState(4);
            }
        }
    }

    private void logTimeChanges(String onOrOff) {
        log.debug("{}:{} Setting Light {} {}", new Object[]{this._timeNow / 60, String.format("%02d", this._timeNow % 60), this._parentLight.getDisplayName(), onOrOff});
    }

    @Override
    public void deactivateLightControl() {
        if (this._active) {
            this._parentLight.removePropertyChangeListener(this._parentLightListener);
            if (this._sensorListener != null) {
                this._namedControlSensor.getBean().removePropertyChangeListener(this._sensorListener);
                this._sensorListener = null;
            }
            if (this._clock != null && this._timebaseListener != null) {
                this._clock.removeMinuteChangeListener(this._timebaseListener);
                this._timebaseListener = null;
            }
            if (this._turnoutListener != null) {
                this._controlTurnout.removePropertyChangeListener(this._turnoutListener);
                this._turnoutListener = null;
            }
            if (this._timedSensorListener != null) {
                this._namedTimedControlSensor.getBean().removePropertyChangeListener(this._timedSensorListener);
                this._timedSensorListener = null;
            }
            if (this._timedControlListener != null && this._timedControlTimer != null) {
                this._timedControlTimer.removeActionListener(this._timedControlListener);
                this._timedControlListener = null;
            }
            if (this._timedControlTimer != null) {
                this._timedControlTimer.stop();
                this._timedControlTimer = null;
            }
            if (this._sensor2Listener != null) {
                this._namedControlSensor2.getBean().removePropertyChangeListener(this._sensor2Listener);
                this._sensor2Listener = null;
            }
            this._active = false;
        }
    }

    private class TimeLight
    implements ActionListener {
        private TimeLight() {
        }

        @Override
        public void actionPerformed(ActionEvent event) {
            DefaultLightControl.this._parentLight.setState(4);
            if (DefaultLightControl.this._timedControlTimer != null) {
                DefaultLightControl.this._timedControlTimer.stop();
            }
            DefaultLightControl.this._timedControlTimer = null;
        }
    }
}

