/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import javax.annotation.Nonnull;
import jmri.Block;
import jmri.BlockManager;
import jmri.EntryPoint;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Path;
import jmri.Scale;
import jmri.Section;
import jmri.Sensor;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.jmrit.display.EditorManager;
import jmri.jmrit.display.layoutEditor.ConnectivityUtil;
import jmri.jmrit.display.layoutEditor.HitPointType;
import jmri.jmrit.display.layoutEditor.LayoutBlock;
import jmri.jmrit.display.layoutEditor.LayoutBlockManager;
import jmri.jmrit.display.layoutEditor.LayoutEditor;
import jmri.jmrit.display.layoutEditor.LayoutTurnout;
import jmri.jmrit.display.layoutEditor.LevelXing;
import jmri.jmrit.display.layoutEditor.PositionablePoint;
import jmri.jmrit.display.layoutEditor.TrackNode;
import jmri.jmrit.display.layoutEditor.TrackSegment;
import jmri.util.NonNullArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSection
extends AbstractNamedBean
implements Section {
    private static final NamedBean.DisplayOptions USERSYS = NamedBean.DisplayOptions.USERNAME_SYSTEMNAME;
    private String mForwardBlockingSensorName = "";
    private String mReverseBlockingSensorName = "";
    private String mForwardStoppingSensorName = "";
    private String mReverseStoppingSensorName = "";
    private final List<Block> mBlockEntries = new NonNullArrayList<Block>();
    private final List<EntryPoint> mForwardEntryPoints = new NonNullArrayList<EntryPoint>();
    private final List<EntryPoint> mReverseEntryPoints = new NonNullArrayList<EntryPoint>();
    private int mState = 2;
    private int mOccupancy = 4;
    private boolean mOccupancyInitialized = false;
    private Block mFirstBlock = null;
    private Block mLastBlock = null;
    private NamedBeanHandle<Sensor> mForwardBlockingNamedSensor = null;
    private NamedBeanHandle<Sensor> mReverseBlockingNamedSensor = null;
    private NamedBeanHandle<Sensor> mForwardStoppingNamedSensor = null;
    private NamedBeanHandle<Sensor> mReverseStoppingNamedSensor = null;
    private final List<PropertyChangeListener> mBlockListeners = new ArrayList<PropertyChangeListener>();
    protected NamedBeanHandleManager nbhm = InstanceManager.getDefault(NamedBeanHandleManager.class);
    private String tempSensorName = "";
    private boolean initializationNeeded = false;
    private final List<String> blockNameList = new ArrayList<String>();
    private int blockIndex = 0;
    private Section.SectionType sectionType = USERDEFINED;
    private static final Logger log = LoggerFactory.getLogger(DefaultSection.class);

    public DefaultSection(String systemName, String userName) {
        super(systemName, userName);
    }

    public DefaultSection(String systemName) {
        super(systemName);
    }

    @Override
    public int getState() {
        return this.mState;
    }

    @Override
    public void setState(int state) {
        if (state == 2 || state == 4 || state == 8) {
            int old = this.mState;
            this.mState = state;
            this.firePropertyChange("state", old, this.mState);
            Sensor fbSensor = this.getForwardBlockingSensor();
            Sensor rbSensor = this.getReverseBlockingSensor();
            switch (state) {
                case 4: {
                    try {
                        if (fbSensor != null && fbSensor.getState() != 4) {
                            fbSensor.setState(4);
                        }
                        if (rbSensor != null && rbSensor.getState() != 2) {
                            rbSensor.setKnownState(2);
                        }
                    }
                    catch (JmriException reason) {
                        log.error("Exception when setting Sensors for Section {}", (Object)this.getDisplayName(USERSYS));
                    }
                    break;
                }
                case 8: {
                    try {
                        if (rbSensor != null && rbSensor.getState() != 4) {
                            rbSensor.setKnownState(4);
                        }
                        if (fbSensor != null && fbSensor.getState() != 2) {
                            fbSensor.setKnownState(2);
                        }
                    }
                    catch (JmriException reason) {
                        log.error("Exception when setting Sensors for Section {}", (Object)this.getDisplayName(USERSYS));
                    }
                    break;
                }
                case 2: {
                    try {
                        if (fbSensor != null && fbSensor.getState() != 2) {
                            fbSensor.setKnownState(2);
                        }
                        if (rbSensor != null && rbSensor.getState() != 2) {
                            rbSensor.setKnownState(2);
                        }
                    }
                    catch (JmriException reason) {
                        log.error("Exception when setting Sensors for Section {}", (Object)this.getDisplayName(USERSYS));
                    }
                    break;
                }
            }
        } else {
            log.error("Attempt to set state of Section {} to illegal value - {}", (Object)this.getDisplayName(USERSYS), (Object)state);
        }
    }

    @Override
    public int getOccupancy() {
        if (this.mOccupancyInitialized) {
            return this.mOccupancy;
        }
        this.mOccupancy = 4;
        for (Block block : this.mBlockEntries) {
            if (block.getState() == 2) {
                this.mOccupancy = 2;
                continue;
            }
            if (block.getState() == 4) continue;
            log.warn("Occupancy of block {} is not OCCUPIED or UNOCCUPIED in Section - {}", (Object)block.getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
            return block.getState();
        }
        this.mOccupancyInitialized = true;
        return this.mOccupancy;
    }

    private void setOccupancy(int occupancy) {
        int old = this.mOccupancy;
        this.mOccupancy = occupancy;
        this.firePropertyChange("occupancy", old, this.mOccupancy);
    }

    @Override
    public String getForwardBlockingSensorName() {
        if (this.mForwardBlockingNamedSensor != null) {
            return this.mForwardBlockingNamedSensor.getName();
        }
        return this.mForwardBlockingSensorName;
    }

    @Override
    public Sensor getForwardBlockingSensor() {
        if (this.mForwardBlockingNamedSensor != null) {
            return this.mForwardBlockingNamedSensor.getBean();
        }
        if (this.mForwardBlockingSensorName != null && !this.mForwardBlockingSensorName.isEmpty()) {
            Sensor s = InstanceManager.sensorManagerInstance().getSensor(this.mForwardBlockingSensorName);
            if (s == null) {
                log.error("Missing FB Sensor - {} - when initializing Section - {}", (Object)this.mForwardBlockingSensorName, (Object)this.getDisplayName(USERSYS));
                return null;
            }
            this.mForwardBlockingNamedSensor = this.nbhm.getNamedBeanHandle(this.mForwardBlockingSensorName, s);
            return s;
        }
        return null;
    }

    @Override
    public Sensor setForwardBlockingSensorName(String forwardSensor) {
        if (forwardSensor == null || forwardSensor.length() <= 0) {
            this.mForwardBlockingSensorName = "";
            this.mForwardBlockingNamedSensor = null;
            return null;
        }
        this.tempSensorName = forwardSensor;
        Sensor s = this.validateSensor();
        if (s == null) {
            log.error("Sensor name - {} invalid when setting forward sensor in Section {}", (Object)forwardSensor, (Object)this.getDisplayName(USERSYS));
            return null;
        }
        this.mForwardBlockingNamedSensor = this.nbhm.getNamedBeanHandle(this.tempSensorName, s);
        this.mForwardBlockingSensorName = this.tempSensorName;
        return s;
    }

    @Override
    public void delayedSetForwardBlockingSensorName(String forwardSensor) {
        this.mForwardBlockingSensorName = forwardSensor;
    }

    @Override
    public String getReverseBlockingSensorName() {
        if (this.mReverseBlockingNamedSensor != null) {
            return this.mReverseBlockingNamedSensor.getName();
        }
        return this.mReverseBlockingSensorName;
    }

    @Override
    public Sensor setReverseBlockingSensorName(String reverseSensor) {
        if (reverseSensor == null || reverseSensor.length() <= 0) {
            this.mReverseBlockingNamedSensor = null;
            this.mReverseBlockingSensorName = "";
            return null;
        }
        this.tempSensorName = reverseSensor;
        Sensor s = this.validateSensor();
        if (s == null) {
            log.error("Sensor name - {} invalid when setting reverse sensor in Section {}", (Object)reverseSensor, (Object)this.getDisplayName(USERSYS));
            return null;
        }
        this.mReverseBlockingNamedSensor = this.nbhm.getNamedBeanHandle(this.tempSensorName, s);
        this.mReverseBlockingSensorName = this.tempSensorName;
        return s;
    }

    @Override
    public void delayedSetReverseBlockingSensorName(String reverseSensor) {
        this.mReverseBlockingSensorName = reverseSensor;
    }

    @Override
    public Sensor getReverseBlockingSensor() {
        if (this.mReverseBlockingNamedSensor != null) {
            return this.mReverseBlockingNamedSensor.getBean();
        }
        if (this.mReverseBlockingSensorName != null && !this.mReverseBlockingSensorName.isEmpty()) {
            Sensor s = InstanceManager.sensorManagerInstance().getSensor(this.mReverseBlockingSensorName);
            if (s == null) {
                log.error("Missing Sensor - {} - when initializing Section - {}", (Object)this.mReverseBlockingSensorName, (Object)this.getDisplayName(USERSYS));
                return null;
            }
            this.mReverseBlockingNamedSensor = this.nbhm.getNamedBeanHandle(this.mReverseBlockingSensorName, s);
            return s;
        }
        return null;
    }

    @Override
    public Block getLastBlock() {
        return this.mLastBlock;
    }

    @CheckForNull
    private Sensor validateSensor() {
        if (this.tempSensorName.length() < 1) {
            return null;
        }
        Sensor s = InstanceManager.sensorManagerInstance().getSensor(this.tempSensorName);
        if (s == null) {
            return null;
        }
        if (!this.tempSensorName.equals(s.getUserName()) && s.getUserName() != null) {
            this.tempSensorName = s.getUserName();
        }
        return s;
    }

    @Override
    public String getForwardStoppingSensorName() {
        if (this.mForwardStoppingNamedSensor != null) {
            return this.mForwardStoppingNamedSensor.getName();
        }
        return this.mForwardStoppingSensorName;
    }

    @Override
    @CheckForNull
    public Sensor getForwardStoppingSensor() {
        if (this.mForwardStoppingNamedSensor != null) {
            return this.mForwardStoppingNamedSensor.getBean();
        }
        if (this.mForwardStoppingSensorName != null && !this.mForwardStoppingSensorName.isEmpty()) {
            Sensor s = InstanceManager.sensorManagerInstance().getSensor(this.mForwardStoppingSensorName);
            if (s == null) {
                log.error("Missing Sensor - {} - when initializing Section - {}", (Object)this.mForwardStoppingSensorName, (Object)this.getDisplayName(USERSYS));
                return null;
            }
            this.mForwardStoppingNamedSensor = this.nbhm.getNamedBeanHandle(this.mForwardStoppingSensorName, s);
            return s;
        }
        return null;
    }

    @Override
    public Sensor setForwardStoppingSensorName(String forwardSensor) {
        if (forwardSensor == null || forwardSensor.length() <= 0) {
            this.mForwardStoppingNamedSensor = null;
            this.mForwardStoppingSensorName = "";
            return null;
        }
        this.tempSensorName = forwardSensor;
        Sensor s = this.validateSensor();
        if (s == null) {
            log.error("Sensor name - {} invalid when setting forward sensor in Section {}", (Object)forwardSensor, (Object)this.getDisplayName(USERSYS));
            return null;
        }
        this.mForwardStoppingNamedSensor = this.nbhm.getNamedBeanHandle(this.tempSensorName, s);
        this.mForwardStoppingSensorName = this.tempSensorName;
        return s;
    }

    @Override
    public void delayedSetForwardStoppingSensorName(String forwardSensor) {
        this.mForwardStoppingSensorName = forwardSensor;
    }

    @Override
    public String getReverseStoppingSensorName() {
        if (this.mReverseStoppingNamedSensor != null) {
            return this.mReverseStoppingNamedSensor.getName();
        }
        return this.mReverseStoppingSensorName;
    }

    @Override
    @CheckForNull
    public Sensor setReverseStoppingSensorName(String reverseSensor) {
        if (reverseSensor == null || reverseSensor.length() <= 0) {
            this.mReverseStoppingNamedSensor = null;
            this.mReverseStoppingSensorName = "";
            return null;
        }
        this.tempSensorName = reverseSensor;
        Sensor s = this.validateSensor();
        if (s == null) {
            log.error("Sensor name - {} invalid when setting reverse sensor in Section {}", (Object)reverseSensor, (Object)this.getDisplayName(USERSYS));
            return null;
        }
        this.mReverseStoppingNamedSensor = this.nbhm.getNamedBeanHandle(this.tempSensorName, s);
        this.mReverseStoppingSensorName = this.tempSensorName;
        return s;
    }

    @Override
    public void delayedSetReverseStoppingSensorName(String reverseSensor) {
        this.mReverseStoppingSensorName = reverseSensor;
    }

    @Override
    @CheckForNull
    public Sensor getReverseStoppingSensor() {
        if (this.mReverseStoppingNamedSensor != null) {
            return this.mReverseStoppingNamedSensor.getBean();
        }
        if (this.mReverseStoppingSensorName != null && !this.mReverseStoppingSensorName.isEmpty()) {
            Sensor s = InstanceManager.sensorManagerInstance().getSensor(this.mReverseStoppingSensorName);
            if (s == null) {
                log.error("Missing Sensor - {}  - when initializing Section - {}", (Object)this.mReverseStoppingSensorName, (Object)this.getDisplayName(USERSYS));
                return null;
            }
            this.mReverseStoppingNamedSensor = this.nbhm.getNamedBeanHandle(this.mReverseStoppingSensorName, s);
            return s;
        }
        return null;
    }

    @Override
    public boolean addBlock(Block b) {
        if (this.mBlockEntries.isEmpty()) {
            this.mFirstBlock = b;
        } else {
            for (Block block : this.mBlockEntries) {
                if (block != b) continue;
                return false;
            }
        }
        if (b.getUserName() == null) {
            log.warn("Block {} does not have a user name, may not work correctly in Section {}", (Object)b.getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
        }
        this.mBlockEntries.add(b);
        this.mLastBlock = b;
        if (b.getState() == 2 && this.mOccupancy != 2) {
            this.setOccupancy(2);
        }
        PropertyChangeListener listener = e -> this.handleBlockChange();
        b.addPropertyChangeListener(listener);
        this.mBlockListeners.add(listener);
        return true;
    }

    @Override
    public void delayedAddBlock(String blockName) {
        this.initializationNeeded = true;
        this.blockNameList.add(blockName);
    }

    private void initializeBlocks() {
        for (int i = 0; i < this.blockNameList.size(); ++i) {
            Block b = InstanceManager.getDefault(BlockManager.class).getBlock(this.blockNameList.get(i));
            if (b == null) {
                log.error("Missing Block - {} - when initializing Section - {}", (Object)this.blockNameList.get(i), (Object)this.getDisplayName(USERSYS));
                continue;
            }
            if (this.mBlockEntries.isEmpty()) {
                this.mFirstBlock = b;
            }
            this.mBlockEntries.add(b);
            this.mLastBlock = b;
            PropertyChangeListener listener = e -> this.handleBlockChange();
            b.addPropertyChangeListener(listener);
            this.mBlockListeners.add(listener);
        }
        this.initializationNeeded = false;
    }

    private void handleBlockChange() {
        int o = 4;
        for (Block block : this.mBlockEntries) {
            if (block.getState() != 2) continue;
            o = 2;
            break;
        }
        if (this.mOccupancy != o) {
            this.setOccupancy(o);
        }
    }

    @Override
    @Nonnull
    public List<Block> getBlockList() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        return new ArrayList<Block>(this.mBlockEntries);
    }

    @Override
    public int getNumBlocks() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        return this.mBlockEntries.size();
    }

    @Override
    public float getLengthF(boolean meters, Scale scale) {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        float length = 0.0f;
        for (Block block : this.mBlockEntries) {
            length += block.getLengthMm();
        }
        length /= (float)scale.getScaleFactor();
        if (meters) {
            return length * 0.001f;
        }
        return length * 0.00328084f;
    }

    @Override
    public int getLengthI(boolean meters, Scale scale) {
        return (int)(this.getLengthF(meters, scale) + 0.5f);
    }

    @Override
    public int getActualLength() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        int len = 0;
        for (Block b : this.mBlockEntries) {
            len += (int)b.getLengthMm();
        }
        return len;
    }

    @Override
    @CheckForNull
    public Block getBlockBySequenceNumber(int seqNumber) {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        if (seqNumber < this.mBlockEntries.size() && seqNumber >= 0) {
            return this.mBlockEntries.get(seqNumber);
        }
        return null;
    }

    @Override
    public int getBlockSequenceNumber(Block b) {
        for (int i = 0; i < this.mBlockEntries.size(); ++i) {
            if (b != this.mBlockEntries.get(i)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public void removeAllBlocksFromSection() {
        int i;
        for (i = this.mBlockEntries.size(); i > 0; --i) {
            Block b = this.mBlockEntries.get(i - 1);
            b.removePropertyChangeListener(this.mBlockListeners.get(i - 1));
            this.mBlockListeners.remove(i - 1);
            this.mBlockEntries.remove(i - 1);
        }
        for (i = this.mForwardEntryPoints.size(); i > 0; --i) {
            this.mForwardEntryPoints.remove(i - 1);
        }
        for (i = this.mReverseEntryPoints.size(); i > 0; --i) {
            this.mReverseEntryPoints.remove(i - 1);
        }
        this.initializationNeeded = false;
    }

    @Override
    @CheckForNull
    public Block getEntryBlock() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        if (this.mBlockEntries.size() <= 0) {
            return null;
        }
        this.blockIndex = this.mState == 8 ? this.mBlockEntries.size() : 1;
        return this.mBlockEntries.get(this.blockIndex - 1);
    }

    @Override
    @CheckForNull
    public Block getNextBlock() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        this.blockIndex = this.mState == 8 ? --this.blockIndex : ++this.blockIndex;
        if (this.blockIndex > this.mBlockEntries.size() || this.blockIndex <= 0) {
            return null;
        }
        return this.mBlockEntries.get(this.blockIndex - 1);
    }

    @Override
    @CheckForNull
    public Block getExitBlock() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        if (this.mBlockEntries.size() <= 0) {
            return null;
        }
        this.blockIndex = this.mState == 8 ? 1 : this.mBlockEntries.size();
        return this.mBlockEntries.get(this.blockIndex - 1);
    }

    @Override
    public boolean containsBlock(Block b) {
        for (Block block : this.mBlockEntries) {
            if (b != block) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean connectsToBlock(Block b) {
        if (this.mForwardEntryPoints.stream().anyMatch(ep -> ep.getFromBlock() == b)) {
            return true;
        }
        return this.mReverseEntryPoints.stream().anyMatch(ep -> ep.getFromBlock() == b);
    }

    @Override
    public String getBeginBlockName() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        if (this.mFirstBlock == null) {
            return "unknown";
        }
        return this.mFirstBlock.getDisplayName();
    }

    @Override
    public String getEndBlockName() {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        if (this.mLastBlock == null) {
            return "unknown";
        }
        return this.mLastBlock.getDisplayName();
    }

    @Override
    public void addToForwardList(EntryPoint ep) {
        if (ep != null) {
            this.mForwardEntryPoints.add(ep);
        }
    }

    @Override
    public void addToReverseList(EntryPoint ep) {
        if (ep != null) {
            this.mReverseEntryPoints.add(ep);
        }
    }

    @Override
    public void removeEntryPoint(EntryPoint ep) {
        int i;
        for (i = this.mForwardEntryPoints.size(); i > 0; --i) {
            if (this.mForwardEntryPoints.get(i - 1) != ep) continue;
            this.mForwardEntryPoints.remove(i - 1);
        }
        for (i = this.mReverseEntryPoints.size(); i > 0; --i) {
            if (this.mReverseEntryPoints.get(i - 1) != ep) continue;
            this.mReverseEntryPoints.remove(i - 1);
        }
    }

    @Override
    @Nonnull
    public List<EntryPoint> getForwardEntryPointList() {
        return new ArrayList<EntryPoint>(this.mForwardEntryPoints);
    }

    @Override
    @Nonnull
    public List<EntryPoint> getReverseEntryPointList() {
        return new ArrayList<EntryPoint>(this.mReverseEntryPoints);
    }

    @Override
    @Nonnull
    public List<EntryPoint> getEntryPointList() {
        ArrayList<EntryPoint> list = new ArrayList<EntryPoint>(this.mForwardEntryPoints);
        list.addAll(this.mReverseEntryPoints);
        return list;
    }

    @Override
    public boolean isForwardEntryPoint(EntryPoint ep) {
        for (int i = 0; i < this.mForwardEntryPoints.size(); ++i) {
            if (ep != this.mForwardEntryPoints.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isReverseEntryPoint(EntryPoint ep) {
        for (int i = 0; i < this.mReverseEntryPoints.size(); ++i) {
            if (ep != this.mReverseEntryPoints.get(i)) continue;
            return true;
        }
        return false;
    }

    @Override
    @CheckForNull
    public EntryPoint getEntryPointFromSection(Section s, int dir) {
        block3: {
            block2: {
                if (dir != 4) break block2;
                for (EntryPoint ep : this.mForwardEntryPoints) {
                    if (!s.containsBlock(ep.getFromBlock())) continue;
                    return ep;
                }
                break block3;
            }
            if (dir != 8) break block3;
            for (EntryPoint ep : this.mReverseEntryPoints) {
                if (!s.containsBlock(ep.getFromBlock())) continue;
                return ep;
            }
        }
        return null;
    }

    @Override
    @CheckForNull
    public EntryPoint getExitPointToSection(Section s, int dir) {
        block4: {
            block3: {
                if (s == null) {
                    return null;
                }
                if (dir != 8) break block3;
                for (EntryPoint ep : this.mForwardEntryPoints) {
                    if (!s.containsBlock(ep.getFromBlock())) continue;
                    return ep;
                }
                break block4;
            }
            if (dir != 4) break block4;
            for (EntryPoint ep : this.mReverseEntryPoints) {
                if (!s.containsBlock(ep.getFromBlock())) continue;
                return ep;
            }
        }
        return null;
    }

    @Override
    @CheckForNull
    public EntryPoint getEntryPointFromBlock(Block b, int dir) {
        block3: {
            block2: {
                if (dir != 4) break block2;
                for (EntryPoint ep : this.mForwardEntryPoints) {
                    if (b != ep.getFromBlock()) continue;
                    return ep;
                }
                break block3;
            }
            if (dir != 8) break block3;
            for (EntryPoint ep : this.mReverseEntryPoints) {
                if (b != ep.getFromBlock()) continue;
                return ep;
            }
        }
        return null;
    }

    @Override
    @CheckForNull
    public EntryPoint getExitPointToBlock(Block b, int dir) {
        block3: {
            block2: {
                if (dir != 8) break block2;
                for (EntryPoint ep : this.mForwardEntryPoints) {
                    if (b != ep.getFromBlock()) continue;
                    return ep;
                }
                break block3;
            }
            if (dir != 4) break block3;
            for (EntryPoint ep : this.mReverseEntryPoints) {
                if (b != ep.getFromBlock()) continue;
                return ep;
            }
        }
        return null;
    }

    private int getDirectionStandardTurnout(LayoutTurnout t, ConnectivityUtil cUtil) {
        int dir;
        LayoutBlock aBlock = ((TrackSegment)t.getConnectA()).getLayoutBlock();
        LayoutBlock bBlock = ((TrackSegment)t.getConnectB()).getLayoutBlock();
        LayoutBlock cBlock = ((TrackSegment)t.getConnectC()).getLayoutBlock();
        if (aBlock == null || bBlock == null || cBlock == null) {
            log.error("All blocks not assigned for track segments connecting to turnout - {}.", (Object)t.getTurnout().getDisplayName(USERSYS));
            return 2;
        }
        Block exBlock = this.checkDualDirection(aBlock, bBlock, cBlock);
        if (exBlock != null || aBlock == bBlock && aBlock == cBlock) {
            LayoutBlock lb;
            String userName;
            int dir2 = 2;
            AbstractNamedBean tBlock = null;
            TrackNode tn = new TrackNode(t, HitPointType.TURNOUT_A, (TrackSegment)t.getConnectA(), false, 2);
            while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                tn = cUtil.getNextNode(tn, 0);
                tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock);
            }
            if (tBlock == null) {
                tn = new TrackNode(t, HitPointType.TURNOUT_A, (TrackSegment)t.getConnectA(), false, 4);
                while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                    tn = cUtil.getNextNode(tn, 0);
                    tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock);
                }
            }
            if (tBlock != null && (userName = tBlock.getUserName()) != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                dir2 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, lb);
            }
            if (dir2 == 2) {
                tBlock = null;
                tn = new TrackNode(t, HitPointType.TURNOUT_B, (TrackSegment)t.getConnectB(), false, 2);
                while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                    tn = cUtil.getNextNode(tn, 0);
                    tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock);
                }
                if (tBlock != null && (userName = tBlock.getUserName()) != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                    dir2 = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, lb);
                }
            }
            if (dir2 == 2) {
                log.error("Block definition ambiguity - cannot determine direction of Turnout {} in Section {}", (Object)t.getTurnout().getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
            }
            return dir2;
        }
        if (aBlock != bBlock && this.containsBlock(aBlock.getBlock()) && this.containsBlock(bBlock.getBlock())) {
            if (this.getBlockSequenceNumber(aBlock.getBlock()) < this.getBlockSequenceNumber(bBlock.getBlock())) {
                return 4;
            }
            return 8;
        }
        if (aBlock != cBlock && this.containsBlock(aBlock.getBlock()) && this.containsBlock(cBlock.getBlock())) {
            if (this.getBlockSequenceNumber(aBlock.getBlock()) < this.getBlockSequenceNumber(cBlock.getBlock())) {
                return 4;
            }
            return 8;
        }
        LayoutBlock tBlock = t.getLayoutBlock();
        if (tBlock == null) {
            log.error("Block not assigned for turnout {}", (Object)t.getTurnout().getDisplayName(USERSYS));
            return 2;
        }
        if (this.containsBlock(aBlock.getBlock()) && !this.containsBlock(bBlock.getBlock())) {
            dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, bBlock);
            if (dir != 2) {
                return dir;
            }
            if (tBlock != bBlock && !this.containsBlock(tBlock.getBlock()) && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, tBlock)) != 2) {
                return dir;
            }
        }
        if (this.containsBlock(aBlock.getBlock()) && !this.containsBlock(cBlock.getBlock())) {
            dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, cBlock);
            if (dir != 2) {
                return dir;
            }
            if (tBlock != cBlock && !this.containsBlock(tBlock.getBlock()) && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, tBlock)) != 2) {
                return dir;
            }
        }
        if ((this.containsBlock(bBlock.getBlock()) || this.containsBlock(cBlock.getBlock())) && !this.containsBlock(aBlock.getBlock())) {
            dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, aBlock);
            if (dir != 2) {
                return dir;
            }
            if (tBlock != aBlock && !this.containsBlock(tBlock.getBlock()) && (dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, tBlock)) != 2) {
                return dir;
            }
        }
        if (!this.containsBlock(aBlock.getBlock()) && !this.containsBlock(bBlock.getBlock()) && !this.containsBlock(cBlock.getBlock()) && this.containsBlock(tBlock.getBlock())) {
            dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, aBlock);
            return dir;
        }
        log.error("Unexpected error in getDirectionStandardTurnout when working with turnout {}", (Object)t.getTurnout().getDisplayName(USERSYS));
        return 2;
    }

    private int getDirectionXoverTurnout(LayoutTurnout t, ConnectivityUtil cUtil) {
        int dir;
        LayoutBlock exBlock;
        LayoutBlock aBlock = ((TrackSegment)t.getConnectA()).getLayoutBlock();
        LayoutBlock bBlock = ((TrackSegment)t.getConnectB()).getLayoutBlock();
        LayoutBlock cBlock = ((TrackSegment)t.getConnectC()).getLayoutBlock();
        LayoutBlock dBlock = ((TrackSegment)t.getConnectD()).getLayoutBlock();
        if (aBlock == null || bBlock == null || cBlock == null || dBlock == null) {
            log.error("All blocks not assigned for track segments connecting to crossover turnout - {}.", (Object)t.getTurnout().getDisplayName(USERSYS));
            return 2;
        }
        if (aBlock == bBlock && aBlock == cBlock && aBlock == dBlock) {
            log.error("Block setup problem - All track segments connecting to crossover turnout - {} are assigned to the same Block.", (Object)t.getTurnout().getDisplayName(USERSYS));
            return 2;
        }
        if (this.containsBlock(aBlock.getBlock()) || this.containsBlock(bBlock.getBlock())) {
            exBlock = null;
            if (aBlock == bBlock && t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER && cBlock == dBlock) {
                exBlock = cBlock;
            }
            if (exBlock != null) {
                int dir2 = 2;
                AbstractNamedBean tBlock = null;
                TrackNode tn = new TrackNode(t, HitPointType.TURNOUT_A, (TrackSegment)t.getConnectA(), false, 2);
                while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                    tn = cUtil.getNextNode(tn, 0);
                    tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                }
                if (tBlock != null) {
                    LayoutBlock lb;
                    String userName = tBlock.getUserName();
                    if (userName != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir2 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, lb);
                    }
                } else {
                    LayoutBlock lb;
                    String userName;
                    tn = new TrackNode(t, HitPointType.TURNOUT_B, (TrackSegment)t.getConnectB(), false, 2);
                    while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                        tn = cUtil.getNextNode(tn, 0);
                        tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                    }
                    if (tBlock != null && (userName = tBlock.getUserName()) != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir2 = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, lb);
                    }
                }
                if (dir2 == 2) {
                    log.error("Block definition ambiguity - cannot determine direction of crossover Turnout {} in Section {}", (Object)t.getTurnout().getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
                }
                return dir2;
            }
            if (aBlock != bBlock && this.containsBlock(aBlock.getBlock()) && this.containsBlock(bBlock.getBlock())) {
                if (this.getBlockSequenceNumber(aBlock.getBlock()) < this.getBlockSequenceNumber(bBlock.getBlock())) {
                    return 4;
                }
                return 8;
            }
            if (this.containsBlock(aBlock.getBlock()) && !this.containsBlock(bBlock.getBlock()) && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, bBlock)) != 2) {
                return dir;
            }
            if (this.containsBlock(bBlock.getBlock()) && !this.containsBlock(aBlock.getBlock()) && (dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, aBlock)) != 2) {
                return dir;
            }
            if (t.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && this.containsBlock(aBlock.getBlock()) && !this.containsBlock(cBlock.getBlock()) && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, cBlock)) != 2) {
                return dir;
            }
            if (t.getTurnoutType() != LayoutTurnout.TurnoutType.RH_XOVER && this.containsBlock(bBlock.getBlock()) && !this.containsBlock(dBlock.getBlock()) && (dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, dBlock)) != 2) {
                return dir;
            }
        }
        if (this.containsBlock(dBlock.getBlock()) || this.containsBlock(cBlock.getBlock())) {
            exBlock = null;
            if (dBlock == cBlock && t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER && bBlock == aBlock) {
                exBlock = aBlock;
            }
            if (exBlock != null) {
                dir = 2;
                AbstractNamedBean tBlock = null;
                TrackNode tn = new TrackNode(t, HitPointType.TURNOUT_D, (TrackSegment)t.getConnectD(), false, 2);
                while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                    tn = cUtil.getNextNode(tn, 0);
                    tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                }
                if (tBlock != null) {
                    LayoutBlock lb;
                    String userName = tBlock.getUserName();
                    if (userName != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, lb);
                    }
                } else {
                    LayoutBlock lb;
                    String userName;
                    tn = new TrackNode(t, HitPointType.TURNOUT_C, (TrackSegment)t.getConnectC(), false, 2);
                    while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                        tn = cUtil.getNextNode(tn, 0);
                        tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                    }
                    if (tBlock != null && (userName = tBlock.getUserName()) != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, lb);
                    }
                }
                if (dir == 2) {
                    log.error("Block definition ambiguity - cannot determine direction of crossover Turnout {} in Section {}.", (Object)t.getTurnout().getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
                }
                return dir;
            }
            if (dBlock != cBlock && this.containsBlock(dBlock.getBlock()) && this.containsBlock(cBlock.getBlock())) {
                if (this.getBlockSequenceNumber(dBlock.getBlock()) < this.getBlockSequenceNumber(cBlock.getBlock())) {
                    return 4;
                }
                return 8;
            }
            if (this.containsBlock(dBlock.getBlock()) && !this.containsBlock(cBlock.getBlock()) && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, cBlock)) != 2) {
                return dir;
            }
            if (this.containsBlock(cBlock.getBlock()) && !this.containsBlock(dBlock.getBlock()) && (dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, dBlock)) != 2) {
                return dir;
            }
            if (t.getTurnoutType() != LayoutTurnout.TurnoutType.RH_XOVER && this.containsBlock(dBlock.getBlock()) && !this.containsBlock(bBlock.getBlock()) && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, bBlock)) != 2) {
                return dir;
            }
            if (t.getTurnoutType() != LayoutTurnout.TurnoutType.LH_XOVER && this.containsBlock(cBlock.getBlock()) && !this.containsBlock(aBlock.getBlock()) && (dir = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, aBlock)) != 2) {
                return dir;
            }
        }
        log.error("Entry point checks failed - cannot determine direction of crossover Turnout {} in Section {}.", (Object)t.getTurnout().getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
        return 2;
    }

    private int getDirectionSlip(LayoutTurnout t, ConnectivityUtil cUtil) {
        int dir;
        int dir2;
        LayoutBlock exBlock;
        LayoutBlock aBlock = ((TrackSegment)t.getConnectA()).getLayoutBlock();
        LayoutBlock bBlock = ((TrackSegment)t.getConnectB()).getLayoutBlock();
        LayoutBlock cBlock = ((TrackSegment)t.getConnectC()).getLayoutBlock();
        LayoutBlock dBlock = ((TrackSegment)t.getConnectD()).getLayoutBlock();
        if (aBlock == null || bBlock == null || cBlock == null || dBlock == null) {
            log.error("All blocks not assigned for track segments connecting to crossover turnout - {}.", (Object)t.getTurnout().getDisplayName(USERSYS));
            return 2;
        }
        if (aBlock == bBlock && aBlock == cBlock && aBlock == dBlock) {
            log.error("Block setup problem - All track segments connecting to crossover turnout - {} are assigned to the same Block.", (Object)t.getTurnout().getDisplayName(USERSYS));
            return 2;
        }
        if (this.containsBlock(aBlock.getBlock()) || this.containsBlock(cBlock.getBlock())) {
            exBlock = null;
            if (aBlock == cBlock && t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP && bBlock == dBlock) {
                exBlock = bBlock;
            }
            if (exBlock != null) {
                int dir3 = 2;
                AbstractNamedBean tBlock = null;
                TrackNode tn = new TrackNode(t, HitPointType.SLIP_A, (TrackSegment)t.getConnectA(), false, 2);
                while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                    tn = cUtil.getNextNode(tn, 0);
                    tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                }
                if (tBlock != null) {
                    LayoutBlock lb;
                    String userName = tBlock.getUserName();
                    if (userName != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir3 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, lb);
                    }
                } else {
                    LayoutBlock lb;
                    String userName;
                    tn = new TrackNode(t, HitPointType.SLIP_C, (TrackSegment)t.getConnectC(), false, 2);
                    while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                        tn = cUtil.getNextNode(tn, 0);
                        tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                    }
                    if (tBlock != null && (userName = tBlock.getUserName()) != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir3 = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, lb);
                    }
                }
                if (dir3 == 2) {
                    log.error("Block definition ambiguity - cannot determine direction of crossover slip {} in Section {}.", (Object)t.getTurnout().getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
                }
                return dir3;
            }
            if (aBlock != cBlock && this.containsBlock(aBlock.getBlock()) && this.containsBlock(cBlock.getBlock())) {
                if (this.getBlockSequenceNumber(aBlock.getBlock()) < this.getBlockSequenceNumber(cBlock.getBlock())) {
                    return 4;
                }
                return 8;
            }
            if (this.containsBlock(aBlock.getBlock()) && !this.containsBlock(cBlock.getBlock()) && (dir2 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, cBlock)) != 2) {
                return dir2;
            }
            if (this.containsBlock(cBlock.getBlock()) && !this.containsBlock(aBlock.getBlock()) && (dir2 = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, aBlock)) != 2) {
                return dir2;
            }
            dir2 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, dBlock);
            if (dir2 != 2) {
                return dir2;
            }
        }
        if (this.containsBlock(dBlock.getBlock()) || this.containsBlock(bBlock.getBlock())) {
            exBlock = null;
            if (dBlock == bBlock && t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP && cBlock == aBlock) {
                exBlock = aBlock;
            }
            if (exBlock != null) {
                dir2 = 2;
                AbstractNamedBean tBlock = null;
                TrackNode tn = new TrackNode(t, HitPointType.SLIP_D, (TrackSegment)t.getConnectD(), false, 4);
                while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                    tn = cUtil.getNextNode(tn, 0);
                    tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                }
                if (tBlock != null) {
                    LayoutBlock lb;
                    String userName = tBlock.getUserName();
                    if (userName != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir2 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, lb);
                    }
                } else {
                    LayoutBlock lb;
                    String userName;
                    tn = new TrackNode(t, HitPointType.TURNOUT_B, (TrackSegment)t.getConnectB(), false, 4);
                    while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                        tn = cUtil.getNextNode(tn, 0);
                        tBlock = cUtil.getExitBlockForTrackNode(tn, exBlock.getBlock());
                    }
                    if (tBlock != null && (userName = tBlock.getUserName()) != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                        dir2 = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, lb);
                    }
                }
                if (dir2 == 2) {
                    log.error("Block definition ambiguity - cannot determine direction of slip {} in Section {}.", (Object)t.getTurnout().getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
                }
                return dir2;
            }
            if (dBlock != bBlock && this.containsBlock(dBlock.getBlock()) && this.containsBlock(bBlock.getBlock())) {
                if (this.getBlockSequenceNumber(dBlock.getBlock()) < this.getBlockSequenceNumber(bBlock.getBlock())) {
                    return 4;
                }
                return 8;
            }
            if (this.containsBlock(dBlock.getBlock()) && !this.containsBlock(bBlock.getBlock()) && (dir2 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, bBlock)) != 2) {
                return dir2;
            }
            if (this.containsBlock(bBlock.getBlock()) && !this.containsBlock(dBlock.getBlock()) && (dir2 = this.checkLists(this.mForwardEntryPoints, this.mReverseEntryPoints, dBlock)) != 2) {
                return dir2;
            }
            if (t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_SLIP && (dir2 = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, aBlock)) != 2) {
                return dir2;
            }
        }
        if (t.getLayoutBlock() != aBlock && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, aBlock)) != 2) {
            return dir;
        }
        if (t.getLayoutBlock() != bBlock && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, bBlock)) != 2) {
            return dir;
        }
        if (t.getLayoutBlock() != cBlock && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, cBlock)) != 2) {
            return dir;
        }
        if (t.getLayoutBlock() != dBlock && (dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, dBlock)) != 2) {
            return dir;
        }
        return 2;
    }

    private boolean placeSensorInCrossover(String b1Name, String b2Name, String c1Name, String c2Name, int direction, ConnectivityUtil cUtil) {
        SignalHead b1Head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(b1Name);
        SignalHead b2Head = null;
        SignalHead c1Head = null;
        SignalHead c2Head = null;
        boolean success = true;
        if (b2Name != null && !b2Name.isEmpty()) {
            b2Head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(b2Name);
        }
        if (c1Name != null && !c1Name.isEmpty()) {
            c1Head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(c1Name);
        }
        if (c2Name != null && !c2Name.isEmpty()) {
            c2Head = InstanceManager.getDefault(SignalHeadManager.class).getSignalHead(c2Name);
        }
        if (b2Head != null) {
            if (!this.checkDirectionSensor(b1Head, direction, 0, cUtil)) {
                success = false;
            }
        } else if (!this.checkDirectionSensor(b1Head, direction, 1, cUtil)) {
            success = false;
        }
        if (c2Head != null) {
            if (!this.checkDirectionSensor(c2Head, direction, 0, cUtil)) {
                success = false;
            }
        } else if (c1Head != null && !this.checkDirectionSensor(c1Head, direction, 2, cUtil)) {
            success = false;
        }
        return success;
    }

    private int checkLists(List<EntryPoint> forwardList, List<EntryPoint> reverseList, LayoutBlock lBlock) {
        int i;
        for (i = 0; i < forwardList.size(); ++i) {
            if (forwardList.get(i).getFromBlock() != lBlock.getBlock()) continue;
            return 4;
        }
        for (i = 0; i < reverseList.size(); ++i) {
            if (reverseList.get(i).getFromBlock() != lBlock.getBlock()) continue;
            return 8;
        }
        return 2;
    }

    @CheckForNull
    private Block checkDualDirection(LayoutBlock aBlock, LayoutBlock bBlock, LayoutBlock cBlock) {
        for (int i = 0; i < this.mForwardEntryPoints.size(); ++i) {
            Block b = this.mForwardEntryPoints.get(i).getFromBlock();
            for (int j = 0; j < this.mReverseEntryPoints.size(); ++j) {
                if (this.mReverseEntryPoints.get(j).getFromBlock() != b) continue;
                if (aBlock.getBlock() == b) {
                    return b;
                }
                if (bBlock.getBlock() == b) {
                    return b;
                }
                if (cBlock.getBlock() != b || aBlock != bBlock) continue;
                return b;
            }
        }
        return null;
    }

    private int getDirectionForBlocks(LayoutBlock a, LayoutBlock b) {
        if (this.containsBlock(b.getBlock())) {
            if (this.getBlockSequenceNumber(a.getBlock()) > this.getBlockSequenceNumber(b.getBlock())) {
                return 4;
            }
            return 8;
        }
        for (int i = 0; i < this.mForwardEntryPoints.size(); ++i) {
            if (this.mForwardEntryPoints.get(i).getFromBlock() != b.getBlock()) continue;
            return 4;
        }
        for (int j = 0; j < this.mReverseEntryPoints.size(); ++j) {
            if (this.mReverseEntryPoints.get(j).getFromBlock() != b.getBlock()) continue;
            return 8;
        }
        log.error("Unexpected error in getDirectionForBlocks when working with LevelCrossing in Section {}", (Object)this.getDisplayName(USERSYS));
        return 2;
    }

    private boolean setDirectionSensorByConnectivity(TrackNode tNode, TrackNode altNode, SignalHead sh, Block cBlock, ConnectivityUtil cUtil) {
        boolean successful = false;
        TrackNode tn = tNode;
        if (tn != null && sh != null) {
            AbstractNamedBean tBlock = null;
            int dir = 2;
            while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                tBlock = (tn = cUtil.getNextNode(tn, 0)) == null ? null : cUtil.getExitBlockForTrackNode(tn, null);
            }
            if (tBlock != null) {
                LayoutBlock lb;
                String userName = tBlock.getUserName();
                if (userName != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                    dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, lb);
                }
            } else {
                LayoutBlock lb;
                String userName;
                tn = altNode;
                while (tBlock == null && tn != null && !tn.reachedEndOfTrack()) {
                    tBlock = (tn = cUtil.getNextNode(tn, 0)) == null ? null : cUtil.getExitBlockForTrackNode(tn, null);
                }
                if (tBlock != null && (userName = tBlock.getUserName()) != null && (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) != null) {
                    dir = this.checkLists(this.mReverseEntryPoints, this.mForwardEntryPoints, lb);
                    if (dir == 8) {
                        dir = 4;
                    } else if (dir == 4) {
                        dir = 8;
                    }
                }
            }
            if (dir != 2) {
                if (this.checkDirectionSensor(sh, dir, 0, cUtil)) {
                    successful = true;
                }
            } else {
                log.error("Trouble following track in Block {} in Section {}.", (Object)cBlock.getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
            }
        }
        return successful;
    }

    @Override
    public int placeDirectionSensors() {
        int missingSignalsBB = 0;
        int missingSignalsTurnouts = 0;
        int missingSignalsLevelXings = 0;
        int errorCount = 0;
        EditorManager editorManager = InstanceManager.getDefault(EditorManager.class);
        if (editorManager.getAll(LayoutEditor.class).isEmpty()) {
            log.error("No Layout Editor panels on call to 'placeDirectionSensors'");
            return 1;
        }
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        if (this.mForwardBlockingSensorName == null || this.mForwardBlockingSensorName.isEmpty() || this.mReverseBlockingSensorName == null || this.mReverseBlockingSensorName.isEmpty()) {
            log.error("Missing direction sensor in Section {}", (Object)this.getDisplayName(USERSYS));
            return 1;
        }
        LayoutBlockManager layoutBlockManager = InstanceManager.getDefault(LayoutBlockManager.class);
        SignalHeadManager signalHeadManager = InstanceManager.getDefault(SignalHeadManager.class);
        for (Block cBlock : this.mBlockEntries) {
            String userName = cBlock.getUserName();
            if (userName == null) {
                log.error("No user name for block '{}' in 'placeDirectionSensors'", (Object)cBlock);
                continue;
            }
            LayoutBlock lBlock = (LayoutBlock)layoutBlockManager.getByUserName(userName);
            if (lBlock == null) {
                log.error("No layout block for block '{}' in 'placeDirectionSensors'", (Object)cBlock.getDisplayName());
                continue;
            }
            LayoutEditor panel = lBlock.getMaxConnectedPanel();
            if (panel == null) {
                log.error("Unable to get a panel for '{}' in 'placeDirectionSensors'", (Object)cBlock.getDisplayName());
                continue;
            }
            ConnectivityUtil cUtil = new ConnectivityUtil(panel);
            List<PositionablePoint> anchorList = cUtil.getAnchorBoundariesThisBlock(cBlock);
            for (int j = 0; j < anchorList.size(); ++j) {
                PositionablePoint p = anchorList.get(j);
                if (!p.getEastBoundSignal().isEmpty() && !p.getWestBoundSignal().isEmpty()) {
                    SignalHead sh = cUtil.getSignalHeadAtAnchor(p, cBlock, false);
                    if (sh == null) {
                        log.warn("Unexpected missing signal head at boundary of Block {}", (Object)cBlock.getDisplayName(USERSYS));
                        ++errorCount;
                        continue;
                    }
                    int direction = cUtil.getDirectionFromAnchor(this.mForwardEntryPoints, this.mReverseEntryPoints, p);
                    if (direction == 2) {
                        sh = cUtil.getSignalHeadAtAnchor(p, cBlock, true);
                        Block otherBlock = p.getConnect1().getLayoutBlock().getBlock();
                        if (otherBlock == cBlock) {
                            otherBlock = p.getConnect2().getLayoutBlock().getBlock();
                        }
                        direction = this.getBlockSequenceNumber(cBlock) < this.getBlockSequenceNumber(otherBlock) ? 4 : 8;
                    }
                    if (this.checkDirectionSensor(sh, direction, 0, cUtil)) continue;
                    ++errorCount;
                    continue;
                }
                ++errorCount;
                ++missingSignalsBB;
            }
            List<LevelXing> xingList = cUtil.getLevelCrossingsThisBlock(cBlock);
            for (int k = 0; k < xingList.size(); ++k) {
                SignalHead sh;
                SignalHead sh2;
                TrackNode altNode;
                LevelXing x = xingList.get(k);
                LayoutBlock alBlock = ((TrackSegment)x.getConnectA()).getLayoutBlock();
                LayoutBlock blBlock = ((TrackSegment)x.getConnectB()).getLayoutBlock();
                LayoutBlock clBlock = ((TrackSegment)x.getConnectC()).getLayoutBlock();
                LayoutBlock dlBlock = ((TrackSegment)x.getConnectD()).getLayoutBlock();
                if (cUtil.isInternalLevelXingAC(x, cBlock)) {
                    if (!x.getSignalAName().isEmpty() || !x.getSignalCName().isEmpty()) {
                        TrackNode tn;
                        if (!x.getSignalAName().isEmpty() && !this.setDirectionSensorByConnectivity(tn = new TrackNode(x, HitPointType.LEVEL_XING_A, (TrackSegment)x.getConnectA(), false, 0), altNode = new TrackNode(x, HitPointType.LEVEL_XING_C, (TrackSegment)x.getConnectC(), false, 0), sh2 = signalHeadManager.getSignalHead(x.getSignalAName()), cBlock, cUtil)) {
                            ++errorCount;
                        }
                        if (!x.getSignalCName().isEmpty() && !this.setDirectionSensorByConnectivity(tn = new TrackNode(x, HitPointType.LEVEL_XING_C, (TrackSegment)x.getConnectC(), false, 0), altNode = new TrackNode(x, HitPointType.LEVEL_XING_A, (TrackSegment)x.getConnectA(), false, 0), sh2 = signalHeadManager.getSignalHead(x.getSignalCName()), cBlock, cUtil)) {
                            ++errorCount;
                        }
                    }
                } else if (alBlock == lBlock) {
                    int direction = this.getDirectionForBlocks(alBlock, clBlock);
                    if (direction != 2) {
                        if (!x.getSignalCName().isEmpty() && !this.checkDirectionSensor(sh = signalHeadManager.getSignalHead(x.getSignalCName()), direction, 0, cUtil)) {
                            ++errorCount;
                        }
                    } else {
                        ++errorCount;
                    }
                } else if (clBlock == lBlock) {
                    int direction = this.getDirectionForBlocks(clBlock, alBlock);
                    if (direction != 2) {
                        if (!x.getSignalAName().isEmpty() && !this.checkDirectionSensor(sh = signalHeadManager.getSignalHead(x.getSignalAName()), direction, 0, cUtil)) {
                            ++errorCount;
                        }
                    } else {
                        ++errorCount;
                    }
                }
                if (cUtil.isInternalLevelXingBD(x, cBlock)) {
                    TrackNode tn;
                    if (x.getSignalBName().isEmpty() && x.getSignalDName().isEmpty()) continue;
                    if (!x.getSignalBName().isEmpty() && !this.setDirectionSensorByConnectivity(tn = new TrackNode(x, HitPointType.LEVEL_XING_B, (TrackSegment)x.getConnectB(), false, 0), altNode = new TrackNode(x, HitPointType.LEVEL_XING_D, (TrackSegment)x.getConnectD(), false, 0), sh2 = signalHeadManager.getSignalHead(x.getSignalBName()), cBlock, cUtil)) {
                        ++errorCount;
                    }
                    if (x.getSignalDName().isEmpty() || this.setDirectionSensorByConnectivity(tn = new TrackNode(x, HitPointType.LEVEL_XING_D, (TrackSegment)x.getConnectD(), false, 0), altNode = new TrackNode(x, HitPointType.LEVEL_XING_B, (TrackSegment)x.getConnectB(), false, 0), sh2 = signalHeadManager.getSignalHead(x.getSignalDName()), cBlock, cUtil)) continue;
                    ++errorCount;
                    continue;
                }
                if (blBlock == lBlock) {
                    int direction = this.getDirectionForBlocks(blBlock, dlBlock);
                    if (direction != 2) {
                        if (x.getSignalDName().isEmpty() || this.checkDirectionSensor(sh = signalHeadManager.getSignalHead(x.getSignalDName()), direction, 0, cUtil)) continue;
                        ++errorCount;
                        continue;
                    }
                    ++errorCount;
                    continue;
                }
                if (dlBlock != lBlock) continue;
                int direction = this.getDirectionForBlocks(dlBlock, blBlock);
                if (direction != 2) {
                    if (x.getSignalBName().isEmpty() || this.checkDirectionSensor(sh = signalHeadManager.getSignalHead(x.getSignalBName()), direction, 0, cUtil)) continue;
                    ++errorCount;
                    continue;
                }
                ++errorCount;
            }
            List<LayoutTurnout> turnoutList = cUtil.getLayoutTurnoutsThisBlock(cBlock);
            for (int m = 0; m < turnoutList.size(); ++m) {
                LayoutTurnout t = turnoutList.get(m);
                if (cUtil.layoutTurnoutHasRequiredSignals(t)) {
                    if (t.getLinkType() == LayoutTurnout.LinkType.NO_LINK && (t.getTurnoutType() == LayoutTurnout.TurnoutType.RH_TURNOUT || t.getTurnoutType() == LayoutTurnout.TurnoutType.LH_TURNOUT || t.getTurnoutType() == LayoutTurnout.TurnoutType.WYE_TURNOUT)) {
                        int direction = this.getDirectionStandardTurnout(t, cUtil);
                        int altDirection = 4;
                        if (direction == 4) {
                            altDirection = 8;
                        }
                        if (direction == 2) {
                            ++errorCount;
                            continue;
                        }
                        SignalHead aHead = signalHeadManager.getSignalHead(t.getSignalA1Name());
                        SignalHead a2Head = null;
                        String a2Name = t.getSignalA2Name();
                        if (!a2Name.isEmpty()) {
                            a2Head = signalHeadManager.getSignalHead(a2Name);
                        }
                        SignalHead bHead = signalHeadManager.getSignalHead(t.getSignalB1Name());
                        SignalHead cHead = signalHeadManager.getSignalHead(t.getSignalC1Name());
                        if (t.getLayoutBlock().getBlock() == cBlock) {
                            if (!this.checkDirectionSensor(aHead, direction, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (a2Head != null && !this.checkDirectionSensor(a2Head, direction, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (!this.checkDirectionSensor(bHead, altDirection, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (this.checkDirectionSensor(cHead, altDirection, 0, cUtil)) continue;
                            ++errorCount;
                            continue;
                        }
                        if (((TrackSegment)t.getConnectA()).getLayoutBlock().getBlock() == cBlock) {
                            if (!this.checkDirectionSensor(bHead, altDirection, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (this.checkDirectionSensor(cHead, altDirection, 0, cUtil)) continue;
                            ++errorCount;
                            continue;
                        }
                        if (t.getContinuingSense() == 2 && ((TrackSegment)t.getConnectB()).getLayoutBlock().getBlock() == cBlock || t.getContinuingSense() == 4 && ((TrackSegment)t.getConnectC()).getLayoutBlock().getBlock() == cBlock) {
                            if (a2Head == null) {
                                if (!this.checkDirectionSensor(aHead, direction, 1, cUtil)) {
                                    ++errorCount;
                                }
                            } else if (!this.checkDirectionSensor(aHead, direction, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (this.checkDirectionSensor(bHead, altDirection, 0, cUtil)) continue;
                            ++errorCount;
                            continue;
                        }
                        if ((t.getContinuingSense() != 2 || ((TrackSegment)t.getConnectC()).getLayoutBlock().getBlock() != cBlock) && (t.getContinuingSense() != 4 || ((TrackSegment)t.getConnectB()).getLayoutBlock().getBlock() != cBlock)) continue;
                        if (a2Head == null) {
                            if (!this.checkDirectionSensor(aHead, direction, 2, cUtil)) {
                                ++errorCount;
                            }
                        } else if (!this.checkDirectionSensor(a2Head, direction, 0, cUtil)) {
                            ++errorCount;
                        }
                        if (this.checkDirectionSensor(cHead, altDirection, 0, cUtil)) continue;
                        ++errorCount;
                        continue;
                    }
                    if (t.getLinkType() != LayoutTurnout.LinkType.NO_LINK) {
                        SignalHead a3Head;
                        int altDirection;
                        String hName;
                        LayoutTurnout tLinked = this.getLayoutTurnoutFromTurnoutName(t.getLinkedTurnoutName(), panel);
                        if (tLinked == null) {
                            log.error("null Layout Turnout linked to turnout {}", (Object)t.getTurnout().getDisplayName(USERSYS));
                            continue;
                        }
                        if (t.getLinkType() == LayoutTurnout.LinkType.THROAT_TO_THROAT) {
                            SignalHead b1Head = signalHeadManager.getSignalHead(t.getSignalB1Name());
                            SignalHead b2Head = null;
                            hName = t.getSignalB2Name();
                            if (!hName.isEmpty()) {
                                b2Head = signalHeadManager.getSignalHead(hName);
                            }
                            SignalHead c1Head = signalHeadManager.getSignalHead(t.getSignalC1Name());
                            SignalHead c2Head = null;
                            hName = t.getSignalC2Name();
                            if (!hName.isEmpty()) {
                                c2Head = signalHeadManager.getSignalHead(hName);
                            }
                            int direction = this.getDirectionStandardTurnout(t, cUtil);
                            altDirection = 4;
                            if (direction == 4) {
                                altDirection = 8;
                            }
                            if (direction == 2) continue;
                            if (t.getLayoutBlock().getBlock() == cBlock) {
                                if (!this.checkDirectionSensor(b1Head, altDirection, 0, cUtil)) {
                                    ++errorCount;
                                }
                                if (b2Head != null && !this.checkDirectionSensor(b2Head, altDirection, 0, cUtil)) {
                                    ++errorCount;
                                }
                                if (!this.checkDirectionSensor(c1Head, altDirection, 0, cUtil)) {
                                    ++errorCount;
                                }
                                if (c2Head == null || this.checkDirectionSensor(c2Head, altDirection, 0, cUtil)) continue;
                                ++errorCount;
                                continue;
                            }
                            b1Head = signalHeadManager.getSignalHead(tLinked.getSignalB1Name());
                            hName = tLinked.getSignalB2Name();
                            b2Head = null;
                            if (!hName.isEmpty()) {
                                b2Head = signalHeadManager.getSignalHead(hName);
                            }
                            c1Head = signalHeadManager.getSignalHead(tLinked.getSignalC1Name());
                            c2Head = null;
                            hName = tLinked.getSignalC2Name();
                            if (!hName.isEmpty()) {
                                c2Head = signalHeadManager.getSignalHead(hName);
                            }
                            if (t.getContinuingSense() == 2 && ((TrackSegment)t.getConnectB()).getLayoutBlock().getBlock() == cBlock || t.getContinuingSense() == 4 && ((TrackSegment)t.getConnectC()).getLayoutBlock().getBlock() == cBlock) {
                                if (b2Head != null) {
                                    if (!this.checkDirectionSensor(b1Head, direction, 0, cUtil)) {
                                        ++errorCount;
                                    }
                                } else if (!this.checkDirectionSensor(b1Head, direction, 1, cUtil)) {
                                    ++errorCount;
                                }
                                if (c2Head != null) {
                                    if (this.checkDirectionSensor(c1Head, direction, 0, cUtil)) continue;
                                    ++errorCount;
                                    continue;
                                }
                                if (this.checkDirectionSensor(c1Head, direction, 1, cUtil)) continue;
                                ++errorCount;
                                continue;
                            }
                            if ((t.getContinuingSense() != 2 || ((TrackSegment)t.getConnectC()).getLayoutBlock().getBlock() != cBlock) && (t.getContinuingSense() != 4 || ((TrackSegment)t.getConnectB()).getLayoutBlock().getBlock() != cBlock)) continue;
                            if (b2Head != null) {
                                if (!this.checkDirectionSensor(b2Head, direction, 0, cUtil)) {
                                    ++errorCount;
                                }
                            } else if (!this.checkDirectionSensor(b1Head, direction, 2, cUtil)) {
                                ++errorCount;
                            }
                            if (c2Head != null) {
                                if (this.checkDirectionSensor(c2Head, direction, 0, cUtil)) continue;
                                ++errorCount;
                                continue;
                            }
                            if (this.checkDirectionSensor(c1Head, direction, 2, cUtil)) continue;
                            ++errorCount;
                            continue;
                        }
                        if (t.getLinkType() == LayoutTurnout.LinkType.FIRST_3_WAY) {
                            SignalHead a1Head = signalHeadManager.getSignalHead(t.getSignalA1Name());
                            SignalHead a2Head = null;
                            hName = t.getSignalA2Name();
                            if (!hName.isEmpty()) {
                                a2Head = signalHeadManager.getSignalHead(hName);
                            }
                            a3Head = null;
                            hName = t.getSignalA3Name();
                            if (!hName.isEmpty()) {
                                a3Head = signalHeadManager.getSignalHead(hName);
                            }
                            SignalHead cHead = signalHeadManager.getSignalHead(t.getSignalC1Name());
                            int direction = this.getDirectionStandardTurnout(t, cUtil);
                            altDirection = 4;
                            if (direction == 4) {
                                altDirection = 8;
                            }
                            if (direction == 2) continue;
                            if (t.getLayoutBlock().getBlock() == cBlock) {
                                if (!this.checkDirectionSensor(a1Head, direction, 0, cUtil)) {
                                    ++errorCount;
                                }
                                if (a2Head != null && a3Head != null) {
                                    if (!this.checkDirectionSensor(a2Head, direction, 0, cUtil)) {
                                        ++errorCount;
                                    }
                                    if (!this.checkDirectionSensor(a3Head, direction, 0, cUtil)) {
                                        ++errorCount;
                                    }
                                }
                                if (this.checkDirectionSensor(cHead, altDirection, 0, cUtil)) continue;
                                ++errorCount;
                                continue;
                            }
                            if (((TrackSegment)t.getConnectA()).getLayoutBlock().getBlock() == cBlock) {
                                if (this.checkDirectionSensor(cHead, altDirection, 0, cUtil)) continue;
                                ++errorCount;
                                continue;
                            }
                            if (((TrackSegment)t.getConnectC()).getLayoutBlock().getBlock() != cBlock) continue;
                            if (a2Head != null) {
                                if (this.checkDirectionSensor(a2Head, direction, 0, cUtil)) continue;
                                ++errorCount;
                                continue;
                            }
                            if (this.checkDirectionSensor(a1Head, direction, 2, cUtil)) continue;
                            ++errorCount;
                            continue;
                        }
                        if (t.getLinkType() != LayoutTurnout.LinkType.SECOND_3_WAY) continue;
                        SignalHead bHead = signalHeadManager.getSignalHead(t.getSignalB1Name());
                        SignalHead cHead = signalHeadManager.getSignalHead(t.getSignalC1Name());
                        SignalHead a1Head = signalHeadManager.getSignalHead(tLinked.getSignalA1Name());
                        a3Head = null;
                        String hName2 = tLinked.getSignalA3Name();
                        if (!hName2.isEmpty()) {
                            a3Head = signalHeadManager.getSignalHead(hName2);
                        }
                        int direction = this.getDirectionStandardTurnout(t, cUtil);
                        altDirection = 4;
                        if (direction == 4) {
                            altDirection = 8;
                        }
                        if (direction == 2) continue;
                        if (t.getLayoutBlock().getBlock() == cBlock) {
                            if (!this.checkDirectionSensor(bHead, altDirection, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (!this.checkDirectionSensor(cHead, altDirection, 0, cUtil)) {
                                ++errorCount;
                            }
                        }
                        if (((TrackSegment)t.getConnectC()).getLayoutBlock().getBlock() == cBlock) {
                            if (a3Head != null) {
                                if (this.checkDirectionSensor(a3Head, direction, 0, cUtil)) continue;
                                ++errorCount;
                                continue;
                            }
                            log.warn("Turnout {} - SSL for head {} cannot handle direction sensor for second diverging track.", (Object)tLinked.getTurnout().getDisplayName(USERSYS), (Object)(a1Head == null ? "Unknown" : a1Head.getDisplayName(USERSYS)));
                            ++errorCount;
                            continue;
                        }
                        if (((TrackSegment)t.getConnectB()).getLayoutBlock().getBlock() != cBlock) continue;
                        if (a3Head != null) {
                            if (this.checkDirectionSensor(a1Head, direction, 0, cUtil)) continue;
                            ++errorCount;
                            continue;
                        }
                        if (this.checkDirectionSensor(a1Head, direction, 1, cUtil)) continue;
                        ++errorCount;
                        continue;
                    }
                    if (t.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER || t.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER || t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER) {
                        int direction = this.getDirectionXoverTurnout(t, cUtil);
                        int altDirection = 4;
                        if (direction == 4) {
                            altDirection = 8;
                        }
                        if (direction == 2) {
                            ++errorCount;
                            continue;
                        }
                        if (((TrackSegment)t.getConnectA()).getLayoutBlock().getBlock() == cBlock) {
                            if (t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || t.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                                if (!this.placeSensorInCrossover(t.getSignalB1Name(), t.getSignalB2Name(), t.getSignalC1Name(), t.getSignalC2Name(), altDirection, cUtil)) {
                                    ++errorCount;
                                }
                            } else if (!this.placeSensorInCrossover(t.getSignalB1Name(), t.getSignalB2Name(), null, null, altDirection, cUtil)) {
                                ++errorCount;
                            }
                        }
                        if (((TrackSegment)t.getConnectB()).getLayoutBlock().getBlock() == cBlock) {
                            if (t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || t.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                                if (!this.placeSensorInCrossover(t.getSignalA1Name(), t.getSignalA2Name(), t.getSignalD1Name(), t.getSignalD2Name(), direction, cUtil)) {
                                    ++errorCount;
                                }
                            } else if (!this.placeSensorInCrossover(t.getSignalA1Name(), t.getSignalA2Name(), null, null, direction, cUtil)) {
                                ++errorCount;
                            }
                        }
                        if (((TrackSegment)t.getConnectC()).getLayoutBlock().getBlock() == cBlock) {
                            if (t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || t.getTurnoutType() == LayoutTurnout.TurnoutType.RH_XOVER) {
                                if (!this.placeSensorInCrossover(t.getSignalD1Name(), t.getSignalD2Name(), t.getSignalA1Name(), t.getSignalA2Name(), direction, cUtil)) {
                                    ++errorCount;
                                }
                            } else if (!this.placeSensorInCrossover(t.getSignalD1Name(), t.getSignalD2Name(), null, null, direction, cUtil)) {
                                ++errorCount;
                            }
                        }
                        if (((TrackSegment)t.getConnectD()).getLayoutBlock().getBlock() != cBlock) continue;
                        if (t.getTurnoutType() == LayoutTurnout.TurnoutType.DOUBLE_XOVER || t.getTurnoutType() == LayoutTurnout.TurnoutType.LH_XOVER) {
                            if (this.placeSensorInCrossover(t.getSignalC1Name(), t.getSignalC2Name(), t.getSignalB1Name(), t.getSignalB2Name(), altDirection, cUtil)) continue;
                            ++errorCount;
                            continue;
                        }
                        if (this.placeSensorInCrossover(t.getSignalC1Name(), t.getSignalC2Name(), null, null, altDirection, cUtil)) continue;
                        ++errorCount;
                        continue;
                    }
                    if (t.isTurnoutTypeSlip()) {
                        int direction = this.getDirectionSlip(t, cUtil);
                        int altDirection = 4;
                        if (direction == 4) {
                            altDirection = 8;
                        }
                        if (direction == 2) {
                            ++errorCount;
                            continue;
                        }
                        if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalA1Name()), altDirection, 0, cUtil)) {
                            ++errorCount;
                        }
                        if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalA2Name()), altDirection, 0, cUtil)) {
                            ++errorCount;
                        }
                        if (t.getTurnoutType() == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                            if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalB1Name()), altDirection, 0, cUtil)) {
                                ++errorCount;
                            }
                        } else {
                            if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalB1Name()), altDirection, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalB2Name()), altDirection, 0, cUtil)) {
                                ++errorCount;
                            }
                        }
                        if (t.getTurnoutType() == LayoutTurnout.TurnoutType.SINGLE_SLIP) {
                            if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalC1Name()), direction, 0, cUtil)) {
                                ++errorCount;
                            }
                        } else {
                            if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalC1Name()), direction, 0, cUtil)) {
                                ++errorCount;
                            }
                            if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalC2Name()), direction, 0, cUtil)) {
                                ++errorCount;
                            }
                        }
                        if (!this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalD1Name()), direction, 0, cUtil)) {
                            ++errorCount;
                        }
                        if (this.checkDirectionSensor(signalHeadManager.getSignalHead(t.getSignalD2Name()), direction, 0, cUtil)) continue;
                        ++errorCount;
                        continue;
                    }
                    log.error("Unknown turnout type for turnout {} in Section {}.", (Object)t.getTurnout().getDisplayName(USERSYS), (Object)this.getDisplayName(USERSYS));
                    ++errorCount;
                    continue;
                }
                ++missingSignalsTurnouts;
            }
        }
        if (missingSignalsBB + missingSignalsTurnouts + missingSignalsLevelXings > 0) {
            Object s = "";
            if (missingSignalsBB > 0) {
                s = ", " + missingSignalsBB + " anchor point signal heads missing";
            }
            if (missingSignalsTurnouts > 0) {
                s = ", " + missingSignalsTurnouts + " turnouts missing signals";
            }
            if (missingSignalsLevelXings > 0) {
                s = ", " + missingSignalsLevelXings + " level crossings missing signals";
            }
            log.warn("Section - {} {}", (Object)this.getDisplayName(USERSYS), s);
        }
        return errorCount;
    }

    private boolean checkDirectionSensor(SignalHead sh, int direction, int where, ConnectivityUtil cUtil) {
        String sensorName = "";
        if (direction == 4) {
            sensorName = this.getForwardBlockingSensorName();
        } else if (direction == 8) {
            sensorName = this.getReverseBlockingSensorName();
        }
        return cUtil.addSensorToSignalHeadLogic(sensorName, sh, where);
    }

    private LayoutTurnout getLayoutTurnoutFromTurnoutName(String turnoutName, LayoutEditor panel) {
        Turnout t = InstanceManager.turnoutManagerInstance().getTurnout(turnoutName);
        if (t == null) {
            return null;
        }
        for (LayoutTurnout lt : panel.getLayoutTurnouts()) {
            if (lt.getTurnout() != t) continue;
            return lt;
        }
        return null;
    }

    @SuppressFBWarnings(value={"UPM_UNCALLED_PRIVATE_METHOD"}, justification="was previously marked with @SuppressWarnings, reason unknown")
    private List<EntryPoint> getListOfForwardBlockEntryPoints(Block b) {
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        ArrayList<EntryPoint> a = new ArrayList<EntryPoint>();
        for (int i = 0; i < this.mForwardEntryPoints.size(); ++i) {
            if (b != this.mForwardEntryPoints.get(i).getBlock()) continue;
            a.add(this.mForwardEntryPoints.get(i));
        }
        return a;
    }

    @Override
    public String validate() {
        String s;
        EntryPoint ep;
        int i;
        if (this.initializationNeeded) {
            this.initializeBlocks();
        }
        for (i = 0; i < this.mBlockEntries.size() - 1; ++i) {
            Block test = this.getBlockBySequenceNumber(i);
            if (test == null) {
                log.error("Block {} not found in Block Entries. Paths not checked.", (Object)i);
                break;
            }
            String userName = test.getUserName();
            if (userName == null) continue;
            LayoutBlock lBlock = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName);
            if (lBlock == null) {
                log.error("Layout Block {} not found. Paths not checked.", (Object)userName);
                continue;
            }
            lBlock.updatePaths();
        }
        if (this.mBlockEntries.size() > 1) {
            for (i = 0; i < this.mBlockEntries.size() - 1; ++i) {
                String s2;
                Block thisBlock = this.getBlockBySequenceNumber(i);
                Block nextBlock = this.getBlockBySequenceNumber(i + 1);
                if (thisBlock == null || nextBlock == null) {
                    return "Sequential blocks " + i + " " + thisBlock + " or " + i + "1 " + nextBlock + " are empty in Block List.";
                }
                if (!this.connected(thisBlock, nextBlock)) {
                    s2 = "Sequential Blocks - " + thisBlock.getDisplayName(USERSYS) + ", " + nextBlock.getDisplayName(USERSYS) + " - are not connected in Section " + this.getDisplayName(USERSYS) + ".";
                    return s2;
                }
                if (this.connected(nextBlock, thisBlock)) continue;
                s2 = "Sequential Blocks - " + thisBlock.getDisplayName(USERSYS) + ", " + nextBlock.getDisplayName(USERSYS) + " - Paths are not consistent - Section " + this.getDisplayName(USERSYS) + ".";
                return s2;
            }
        }
        if (this.mForwardEntryPoints.isEmpty() && this.mReverseEntryPoints.isEmpty()) {
            return "Section " + this.getDisplayName(USERSYS) + "has no Entry Points.";
        }
        if (!this.mForwardEntryPoints.isEmpty()) {
            for (i = 0; i < this.mForwardEntryPoints.size(); ++i) {
                ep = this.mForwardEntryPoints.get(i);
                if (!this.containsBlock(ep.getBlock())) {
                    s = "Entry Point Block, " + ep.getBlock().getDisplayName(USERSYS) + ", is not a Block in Section " + this.getDisplayName(USERSYS) + ".";
                    return s;
                }
                if (!this.connectsToBlock(ep.getFromBlock())) {
                    s = "Entry Point From Block, " + ep.getBlock().getDisplayName(USERSYS) + ", is not connected to a Block in Section " + this.getDisplayName(USERSYS) + ".";
                    return s;
                }
                if (!ep.isForwardType()) {
                    s = "Direction of FORWARD Entry Point From Block " + ep.getFromBlock().getDisplayName(USERSYS) + " to Section " + this.getDisplayName(USERSYS) + " is incorrectly set.";
                    return s;
                }
                if (this.connected(ep.getBlock(), ep.getFromBlock())) continue;
                s = "Entry Point Blocks, " + ep.getBlock().getDisplayName(USERSYS) + " and " + ep.getFromBlock().getDisplayName(USERSYS) + ", are not connected in Section " + this.getDisplayName(USERSYS) + ".";
                return s;
            }
        }
        if (!this.mReverseEntryPoints.isEmpty()) {
            for (i = 0; i < this.mReverseEntryPoints.size(); ++i) {
                ep = this.mReverseEntryPoints.get(i);
                if (!this.containsBlock(ep.getBlock())) {
                    s = "Entry Point Block, " + ep.getBlock().getDisplayName(USERSYS) + ", is not a Block in Section " + this.getDisplayName(USERSYS) + ".";
                    return s;
                }
                if (!this.connectsToBlock(ep.getFromBlock())) {
                    s = "Entry Point From Block, " + ep.getBlock().getDisplayName(USERSYS) + ", is not connected to a Block in Section " + this.getDisplayName(USERSYS) + ".";
                    return s;
                }
                if (!ep.isReverseType()) {
                    s = "Direction of REVERSE Entry Point From Block " + ep.getFromBlock().getDisplayName(USERSYS) + " to Section " + this.getDisplayName(USERSYS) + " is incorrectly set.";
                    return s;
                }
                if (this.connected(ep.getBlock(), ep.getFromBlock())) continue;
                s = "Entry Point Blocks, " + ep.getBlock().getDisplayName(USERSYS) + " and " + ep.getFromBlock().getDisplayName(USERSYS) + ", are not connected in Section " + this.getDisplayName(USERSYS) + ".";
                return s;
            }
        }
        return "";
    }

    private boolean connected(Block b1, Block b2) {
        if (b1 != null && b2 != null) {
            List<Path> paths = b1.getPaths();
            for (int i = 0; i < paths.size(); ++i) {
                if (paths.get(i).getBlock() != b2) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setAlternateColor(boolean set) {
        for (Block b : this.mBlockEntries) {
            LayoutBlock lb;
            String userName = b.getUserName();
            if (userName == null || (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) == null) continue;
            lb.setUseExtraColor(set);
        }
    }

    @Override
    public void setAlternateColorFromActiveBlock(boolean set) {
        LayoutBlockManager lbm = InstanceManager.getDefault(LayoutBlockManager.class);
        boolean beenSet = false;
        if (!set || this.getState() == 2 || this.getState() == 1) {
            this.setAlternateColor(set);
        } else if (this.getState() == 4) {
            for (Block b : this.mBlockEntries) {
                LayoutBlock lb;
                String userName;
                if (b.getState() == 2) {
                    beenSet = true;
                }
                if (!beenSet || (userName = b.getUserName()) == null || (lb = (LayoutBlock)lbm.getByUserName(userName)) == null) continue;
                lb.setUseExtraColor(set);
            }
        } else if (this.getState() == 8) {
            for (Block b : this.mBlockEntries) {
                LayoutBlock lb;
                String userName;
                if (b.getState() == 2) {
                    beenSet = true;
                }
                if (!beenSet || (userName = b.getUserName()) == null || (lb = (LayoutBlock)lbm.getByUserName(userName)) == null) continue;
                lb.setUseExtraColor(set);
            }
        }
        if (!beenSet) {
            this.setAlternateColor(set);
        }
    }

    @Override
    public void setNameInBlocks(String name) {
        for (Block b : this.mBlockEntries) {
            b.setValue(name);
        }
    }

    @Override
    public void setNameInBlocks(Object value) {
        for (Block b : this.mBlockEntries) {
            b.setValue(value);
        }
    }

    @Override
    public void setNameFromActiveBlock(Object value) {
        boolean beenSet = false;
        if (value == null || this.getState() == 2 || this.getState() == 1) {
            this.setNameInBlocks(value);
        } else if (this.getState() == 4) {
            for (Block b : this.mBlockEntries) {
                if (b.getState() == 2) {
                    beenSet = true;
                }
                if (!beenSet) continue;
                b.setValue(value);
            }
        } else if (this.getState() == 8) {
            for (Block b : this.mBlockEntries) {
                if (b.getState() == 2) {
                    beenSet = true;
                }
                if (!beenSet) continue;
                b.setValue(value);
            }
        }
        if (!beenSet) {
            this.setNameInBlocks(value);
        }
    }

    @Override
    public void clearNameInUnoccupiedBlocks() {
        for (Block b : this.mBlockEntries) {
            if (b.getState() != 4) continue;
            b.setValue(null);
        }
    }

    @Override
    public void suppressNameUpdate(boolean set) {
        for (Block b : this.mBlockEntries) {
            LayoutBlock lb;
            String userName = b.getUserName();
            if (userName == null || (lb = (LayoutBlock)InstanceManager.getDefault(LayoutBlockManager.class).getByUserName(userName)) == null) continue;
            lb.setSuppressNameUpdate(set);
        }
    }

    @Override
    public void setSectionType(Section.SectionType type) {
        this.sectionType = type;
    }

    @Override
    public Section.SectionType getSectionType() {
        return this.sectionType;
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSection");
    }

    @Override
    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if ("CanDelete".equals(evt.getPropertyName())) {
            NamedBean nb = (NamedBean)evt.getOldValue();
            if (nb instanceof Sensor) {
                if (nb.equals(this.getForwardBlockingSensor())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("VetoBlockingSensor", nb.getBeanType(), Bundle.getMessage("Forward"), Bundle.getMessage("Blocking"), this.getDisplayName()), e);
                }
                if (nb.equals(this.getForwardStoppingSensor())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("VetoBlockingSensor", nb.getBeanType(), Bundle.getMessage("Forward"), Bundle.getMessage("Stopping"), this.getDisplayName()), e);
                }
                if (nb.equals(this.getReverseBlockingSensor())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("VetoBlockingSensor", nb.getBeanType(), Bundle.getMessage("Reverse"), Bundle.getMessage("Blocking"), this.getDisplayName()), e);
                }
                if (nb.equals(this.getReverseStoppingSensor())) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("VetoBlockingSensor", nb.getBeanType(), Bundle.getMessage("Reverse"), Bundle.getMessage("Stopping"), this.getDisplayName()), e);
                }
            }
            if (nb instanceof Block) {
                Block check = (Block)nb;
                if (this.getBlockList().contains(check)) {
                    PropertyChangeEvent e = new PropertyChangeEvent(this, "DoNotDelete", null, null);
                    throw new PropertyVetoException(Bundle.getMessage("VetoBlockInSection", this.getDisplayName()), e);
                }
            }
        }
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            this.getBlockList().forEach(block -> {
                if (bean.equals(block)) {
                    report.add(new NamedBeanUsageReport("SectionBlock"));
                }
            });
            if (bean.equals(this.getForwardBlockingSensor())) {
                report.add(new NamedBeanUsageReport("SectionSensorForwardBlocking"));
            }
            if (bean.equals(this.getForwardStoppingSensor())) {
                report.add(new NamedBeanUsageReport("SectionSensorForwardStopping"));
            }
            if (bean.equals(this.getReverseBlockingSensor())) {
                report.add(new NamedBeanUsageReport("SectionSensorReverseBlocking"));
            }
            if (bean.equals(this.getReverseStoppingSensor())) {
                report.add(new NamedBeanUsageReport("SectionSensorReverseStopping"));
            }
        }
        return report;
    }
}

