/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Vector;
import jmri.SignalAppearanceMap;
import jmri.SignalSystem;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.jmrit.XmlFile;
import jmri.util.FileUtil;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalAppearanceMap
extends AbstractNamedBean
implements SignalAppearanceMap {
    protected Hashtable<String, Hashtable<String, String>> aspectAttributeMap = new Hashtable();
    protected Hashtable<String, Hashtable<String, String>> aspectImageMap = new Hashtable();
    static HashMap<String, DefaultSignalAppearanceMap> maps = new LinkedHashMap<String, DefaultSignalAppearanceMap>();
    protected Hashtable<Integer, String> specificMaps = new Hashtable();
    protected Hashtable<String, String[]> aspectRelationshipMap = new Hashtable();
    protected SignalSystem systemDefn;
    protected HashMap<String, int[]> table = new LinkedHashMap<String, int[]>();
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalAppearanceMap.class);

    public DefaultSignalAppearanceMap(String systemName, String userName) {
        super(systemName, userName);
    }

    public DefaultSignalAppearanceMap(String systemName) {
        super(systemName);
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSignalAppMap");
    }

    public static DefaultSignalAppearanceMap getMap(String signalSystemName, String aspectMapName) {
        log.debug("getMap signalSystem= \"{}\", aspectMap= \"{}\"", (Object)signalSystemName, (Object)aspectMapName);
        DefaultSignalAppearanceMap map = maps.get("map:" + signalSystemName + ":" + aspectMapName);
        if (map == null) {
            log.debug("not located, request loadMap signalSystem= \"{}\", aspectMap= \"{}\"", (Object)signalSystemName, (Object)aspectMapName);
            map = DefaultSignalAppearanceMap.loadMap(signalSystemName, aspectMapName);
        }
        return map;
    }

    protected void registerMap() {
        maps.put(this.getSystemName(), this);
    }

    public static DefaultSignalAppearanceMap findMap(String systemName) {
        return maps.get(systemName);
    }

    static DefaultSignalAppearanceMap loadMap(String signalSystemName, String aspectMapName) {
        DefaultSignalAppearanceMap map = new DefaultSignalAppearanceMap("map:" + signalSystemName + ":" + aspectMapName);
        maps.put("map:" + signalSystemName + ":" + aspectMapName, map);
        String path = "signals/" + signalSystemName + "/appearance-" + aspectMapName + ".xml";
        URL file = FileUtil.findURL(path, "resources", "xml");
        if (file == null) {
            log.error("appearance file (xml/{}) doesn't exist", (Object)path);
            throw new IllegalArgumentException("appearance file (xml/" + path + ") doesn't exist");
        }
        XmlFile xf = new XmlFile(){};
        try {
            Element root = xf.rootFromURL(file);
            List l = root.getChild("appearances").getChildren("appearance");
            log.debug("   reading {} aspectname elements", (Object)l.size());
            for (int i = 0; i < l.size(); ++i) {
                String name = ((Element)l.get(i)).getChild("aspectname").getText();
                log.debug("aspect name {}", (Object)name);
                List c = ((Element)l.get(i)).getChildren("show");
                int[] appearances = new int[c.size()];
                for (int j = 0; j < c.size(); ++j) {
                    int ival;
                    String sval = ((Element)c.get(j)).getText().toUpperCase();
                    if (sval.equals("LUNAR")) {
                        ival = 64;
                    } else if (sval.equals("GREEN")) {
                        ival = 16;
                    } else if (sval.equals("YELLOW")) {
                        ival = 4;
                    } else if (sval.equals("RED")) {
                        ival = 1;
                    } else if (sval.equals("FLASHLUNAR")) {
                        ival = 128;
                    } else if (sval.equals("FLASHGREEN")) {
                        ival = 32;
                    } else if (sval.equals("FLASHYELLOW")) {
                        ival = 8;
                    } else if (sval.equals("FLASHRED")) {
                        ival = 2;
                    } else if (sval.equals("DARK")) {
                        ival = 0;
                    } else {
                        log.error("found invalid content: {}", (Object)sval);
                        throw new JDOMException("invalid content: " + sval);
                    }
                    appearances[j] = ival;
                }
                map.addAspect(name, appearances);
                List img = ((Element)l.get(i)).getChildren("imagelink");
                DefaultSignalAppearanceMap.loadImageMaps(img, name, map);
                Hashtable<String, String> hm = new Hashtable<String, String>();
                List a = ((Element)l.get(i)).getChildren();
                for (int j = 0; j < a.size(); ++j) {
                    String key = ((Element)a.get(j)).getName();
                    String value = ((Element)a.get(j)).getText();
                    hm.put(key, value);
                }
                map.aspectAttributeMap.put(name, hm);
            }
            DefaultSignalAppearanceMap.loadSpecificMap(signalSystemName, aspectMapName, map, root);
            DefaultSignalAppearanceMap.loadAspectRelationMap(signalSystemName, aspectMapName, map, root);
            log.debug("loading complete");
        }
        catch (IOException | JDOMException e) {
            log.error("error reading file {}", (Object)file.getPath(), (Object)e);
            return null;
        }
        return map;
    }

    static void loadImageMaps(List<Element> img, String name, DefaultSignalAppearanceMap map) {
        Hashtable<String, String> images = new Hashtable<String, String>();
        for (int j = 0; j < img.size(); ++j) {
            String key = "default";
            if (img.get(j).getAttribute("type") != null) {
                key = img.get(j).getAttribute("type").getValue();
            }
            String value = img.get(j).getText();
            images.put(key, value);
        }
        map.aspectImageMap.put(name, images);
    }

    static void loadSpecificMap(String signalSystemName, String aspectMapName, DefaultSignalAppearanceMap SMmap, Element root) {
        log.debug("load specific signalSystem= \"{}\", aspectMap= \"{}\"", (Object)signalSystemName, (Object)aspectMapName);
        DefaultSignalAppearanceMap.loadSpecificAspect(signalSystemName, aspectMapName, 0, SMmap, root);
        DefaultSignalAppearanceMap.loadSpecificAspect(signalSystemName, aspectMapName, 2, SMmap, root);
        DefaultSignalAppearanceMap.loadSpecificAspect(signalSystemName, aspectMapName, 1, SMmap, root);
        DefaultSignalAppearanceMap.loadSpecificAspect(signalSystemName, aspectMapName, 3, SMmap, root);
    }

    static void loadSpecificAspect(String signalSystemName, String aspectMapName, int aspectType, DefaultSignalAppearanceMap SMmap, Element root) {
        String child;
        switch (aspectType) {
            case 0: {
                child = "held";
                break;
            }
            case 2: {
                child = "danger";
                break;
            }
            case 1: {
                child = "permissive";
                break;
            }
            case 3: {
                child = "dark";
                break;
            }
            default: {
                child = "danger";
            }
        }
        String appearance = null;
        if (root.getChild("specificappearances") == null || root.getChild("specificappearances").getChild(child) == null) {
            log.debug("appearance not configured {}", (Object)child);
            return;
        }
        try {
            appearance = root.getChild("specificappearances").getChild(child).getChild("aspect").getText();
            SMmap.specificMaps.put(aspectType, appearance);
        }
        catch (NullPointerException e) {
            log.debug("aspect for specific appearance not configured {}", (Object)child);
        }
        try {
            List img = root.getChild("specificappearances").getChild(child).getChildren("imagelink");
            String name = "$" + child;
            if (img.size() == 0) {
                if (appearance != null) {
                    Vector<String> app = SMmap.getImageTypes(appearance);
                    Hashtable<String, String> images = new Hashtable<String, String>();
                    String type = "";
                    for (int i = 0; i < app.size(); ++i) {
                        type = SMmap.getImageLink(appearance, (String)app.get(i));
                        images.put((String)app.get(i), type);
                    }
                    images.put("default", type);
                    SMmap.aspectImageMap.put(name, images);
                }
            } else {
                DefaultSignalAppearanceMap.loadImageMaps(img, name, SMmap);
                Hashtable<String, String> hm = new Hashtable<String, String>();
                String key = ((Element)img.get(img.size() - 1)).getName();
                String value = ((Element)img.get(img.size() - 1)).getText();
                hm.put(key, value);
                SMmap.aspectAttributeMap.put(name, hm);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    static void loadAspectRelationMap(String signalSystemName, String aspectMapName, DefaultSignalAppearanceMap SMmap, Element root) {
        if (log.isDebugEnabled()) {
            log.debug("load aspect relation map signalSystem= \"{}\", aspectMap= \"{}\"", (Object)signalSystemName, (Object)aspectMapName);
        }
        try {
            List l = root.getChild("aspectMappings").getChildren("aspectMapping");
            for (int i = 0; i < l.size(); ++i) {
                String advanced = ((Element)l.get(i)).getChild("advancedAspect").getText();
                List o = ((Element)l.get(i)).getChildren("ourAspect");
                String[] appearances = new String[o.size()];
                for (int j = 0; j < o.size(); ++j) {
                    appearances[j] = ((Element)o.get(j)).getText();
                }
                SMmap.aspectRelationshipMap.put(advanced, appearances);
            }
        }
        catch (NullPointerException e) {
            log.debug("appearance not configured");
            return;
        }
    }

    @Override
    public String getProperty(String aspect, String key) {
        return this.aspectAttributeMap.get(aspect).get(key);
    }

    @Override
    public String getImageLink(String aspect, String type) {
        String value;
        if (type == null || type.equals("")) {
            type = "default";
        }
        try {
            value = this.aspectImageMap.get(aspect).get(type);
            if (value == null) {
                value = this.getProperty(aspect, "imagelink");
            }
        }
        catch (NullPointerException e) {
            value = "";
        }
        return value;
    }

    @Override
    public Vector<String> getImageTypes(String aspect) {
        if (!this.checkAspect(aspect)) {
            return new Vector<String>();
        }
        Enumeration<String> e = this.aspectImageMap.get(aspect).keys();
        Vector<String> v = new Vector<String>();
        while (e.hasMoreElements()) {
            v.add(e.nextElement());
        }
        return v;
    }

    public void loadDefaults() {
        log.debug("start loadDefaults");
        String ra = Bundle.getMessage("SignalAspectDefaultRed");
        if (ra != null) {
            this.addAspect(ra, new int[]{1});
        } else {
            log.error("no default red aspect");
        }
        ra = Bundle.getMessage("SignalAspectDefaultYellow");
        if (ra != null) {
            this.addAspect(ra, new int[]{4});
        } else {
            log.error("no default yellow aspect");
        }
        ra = Bundle.getMessage("SignalAspectDefaultGreen");
        if (ra != null) {
            this.addAspect(ra, new int[]{16});
        } else {
            log.error("no default green aspect");
        }
    }

    @Override
    public boolean checkAspect(String aspect) {
        if (aspect == null) {
            return false;
        }
        return this.table.containsKey(aspect);
    }

    public void addAspect(String aspect, int[] appearances) {
        if (log.isDebugEnabled()) {
            log.debug("add aspect \"{}\" for {} heads {}", new Object[]{aspect, appearances.length, appearances[0]});
        }
        this.table.put(aspect, appearances);
    }

    @Override
    public Enumeration<String> getAspects() {
        log.debug("list of aspects provided");
        return new Vector<String>(this.table.keySet()).elements();
    }

    @Override
    public String getSpecificAppearance(int appearance) {
        if (this.specificMaps.containsKey(appearance)) {
            return this.specificMaps.get(appearance);
        }
        return null;
    }

    @Override
    @SuppressFBWarnings(value={"PZLA_PREFER_ZERO_LENGTH_ARRAYS"}, justification="null returned is documented to mean no valid result")
    public String[] getValidAspectsForAdvancedAspect(String advancedAspect) {
        if (this.aspectRelationshipMap == null) {
            log.error("aspect relationships have not been defined or loaded");
            throw new IllegalArgumentException("aspect relationships have not been defined or loaded");
        }
        if (advancedAspect == null) {
            String[] danger = new String[]{this.getSpecificAppearance(2)};
            return danger;
        }
        if (this.aspectRelationshipMap.containsKey(advancedAspect)) {
            return this.aspectRelationshipMap.get(advancedAspect);
        }
        return null;
    }

    @Override
    public SignalSystem getSignalSystem() {
        return this.systemDefn;
    }

    public void setSignalSystem(SignalSystem t) {
        this.systemDefn = t;
    }

    @Override
    public int getState() {
        return 8;
    }

    @Override
    public void setState(int s) {
    }

    public int[] getAspectSettings(String aspect) {
        return this.table.get(aspect);
    }

    @Override
    public String summary() {
        StringBuilder retval = new StringBuilder();
        retval.append(this.toString());
        retval.append("\n  BeanType: " + this.getBeanType());
        retval.append("\n  aspects:");
        Enumeration<String> values = this.getAspects();
        while (values.hasMoreElements()) {
            String aspect = values.nextElement();
            retval.append("\n    aspect: " + aspect);
            retval.append("\n       len aspectSettings: " + this.getAspectSettings(aspect).length);
            retval.append("\n       attribute map:");
            Enumeration<String> keys = this.aspectAttributeMap.get(aspect).keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                retval.append("\n       key: " + key + " value: " + this.aspectAttributeMap.get(aspect).get(key));
            }
        }
        retval.append("\n  SignalSystem = " + this.getSignalSystem());
        return new String(retval);
    }
}

