/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import jmri.InstanceManager;
import jmri.NamedBean;
import jmri.NamedBeanHandle;
import jmri.NamedBeanHandleManager;
import jmri.NamedBeanUsageReport;
import jmri.Sensor;
import jmri.SignalGroup;
import jmri.SignalHead;
import jmri.SignalHeadManager;
import jmri.SignalMast;
import jmri.SignalMastManager;
import jmri.Turnout;
import jmri.implementation.AbstractNamedBean;
import jmri.implementation.Bundle;
import jmri.implementation.SingleTurnoutSignalHead;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultSignalGroup
extends AbstractNamedBean
implements SignalGroup {
    ArrayList<String> _signalMastAspects = new ArrayList();
    private NamedBeanHandle<SignalMast> _signalMast;
    private boolean headactive = false;
    private boolean enabled = true;
    protected PropertyChangeListener mSignalMastListener = null;
    ArrayList<SignalHeadItem> _signalHeadItem = new ArrayList();
    private static final Logger log = LoggerFactory.getLogger(DefaultSignalGroup.class);

    public DefaultSignalGroup(String systemName, String userName) {
        super(systemName, userName);
    }

    public DefaultSignalGroup(String systemName) {
        super(systemName, null);
        log.debug("default SignalGroup {} created", (Object)systemName);
    }

    @Override
    public String getBeanType() {
        return Bundle.getMessage("BeanNameSignalGroup");
    }

    @Override
    public void setEnabled(boolean boo) {
        this.enabled = boo;
    }

    @Override
    public boolean getEnabled() {
        return this.enabled;
    }

    @Override
    public void setSignalMast(String pName) {
        SignalMast mMast = InstanceManager.getDefault(SignalMastManager.class).getBySystemName(pName);
        if (mMast == null) {
            mMast = InstanceManager.getDefault(SignalMastManager.class).getByUserName(pName);
        }
        if (mMast == null) {
            log.warn("did not find a Signal Mast named {}", (Object)pName);
            return;
        }
        this.setSignalMast(mMast, pName);
    }

    @Override
    public void setSignalMast(SignalMast signalMast, String mastName) {
        if (this._signalMast != null) {
            this.getSignalMast().removePropertyChangeListener(this.mSignalMastListener);
        }
        this._signalMast = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(mastName, signalMast);
        this.mSignalMastListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent e) {
                if (e.getPropertyName().equals("Aspect")) {
                    String now = (String)e.getNewValue();
                    if (DefaultSignalGroup.this.isSignalMastAspectIncluded(now)) {
                        DefaultSignalGroup.this.setHead();
                    } else {
                        DefaultSignalGroup.this.resetHeads();
                    }
                }
            }
        };
        this.getSignalMast().addPropertyChangeListener(this.mSignalMastListener);
    }

    @Override
    public SignalMast getSignalMast() {
        return this._signalMast.getBean();
    }

    @Override
    public String getSignalMastName() {
        return this._signalMast.getName();
    }

    @Override
    public void addSignalMastAspect(String aspect) {
        if (this.isSignalMastAspectIncluded(aspect)) {
            return;
        }
        this._signalMastAspects.add(aspect);
    }

    @Override
    public boolean isSignalMastAspectIncluded(String aspect) {
        for (int i = 0; i < this._signalMastAspects.size(); ++i) {
            if (!this._signalMastAspects.get(i).equals(aspect)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void deleteSignalMastAspect(String aspect) {
        this._signalMastAspects.remove(aspect);
    }

    @Override
    public int getNumSignalMastAspects() {
        return this._signalMastAspects.size();
    }

    @Override
    public String getSignalMastAspectByIndex(int x) {
        try {
            return this._signalMastAspects.get(x);
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public void clearSignalMastAspect() {
        this._signalMastAspects = new ArrayList();
    }

    @Override
    public void addSignalHead(NamedBeanHandle<SignalHead> headBean) {
        SignalHeadItem shi = new SignalHeadItem(headBean);
        this._signalHeadItem.add(shi);
    }

    public void addSignalHead(String pName) {
        SignalHead mHead = InstanceManager.getDefault(SignalHeadManager.class).getBySystemName(pName);
        if (mHead == null) {
            mHead = InstanceManager.getDefault(SignalHeadManager.class).getByUserName(pName);
        }
        if (mHead == null) {
            log.warn("did not find a SignalHead named {}", (Object)pName);
        } else {
            this.addSignalHead(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(pName, mHead));
        }
    }

    @Override
    public void addSignalHead(SignalHead signalHead) {
        this.addSignalHead(InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(signalHead.getDisplayName(), signalHead));
    }

    @Override
    public void setHeadAlignTurnout(SignalHead signalHead, Turnout turnout, int state) {
        SignalHeadItem shi = this.getHeadItem(signalHead);
        shi.addTurnout(turnout, state);
    }

    @Override
    public void setHeadAlignSensor(SignalHead signalHead, Sensor sensor, int state) {
        SignalHeadItem shi = this.getHeadItem(signalHead);
        shi.addSensor(sensor, state);
    }

    private SignalHeadItem getHeadItemByIndex(int x) {
        try {
            return this._signalHeadItem.get(x);
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public String getHeadItemNameByIndex(int x) {
        try {
            return this.getHeadItemByIndex(x).getName();
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public SignalHead getHeadItemBeanByIndex(int x) {
        try {
            return this.getHeadItemByIndex(x).getSignalHead();
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public int getNumHeadItems() {
        return this._signalHeadItem.size();
    }

    @Override
    public int getHeadOffState(SignalHead headBean) {
        try {
            return this.getHeadItem(headBean).getOffAppearance();
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public int getHeadOnState(SignalHead headBean) {
        try {
            return this.getHeadItem(headBean).getOnAppearance();
        }
        catch (NullPointerException e) {
            return -1;
        }
    }

    @Override
    public int getHeadOnStateByIndex(int x) {
        try {
            return this.getHeadItemByIndex(x).getOnAppearance();
        }
        catch (IndexOutOfBoundsException ioob) {
            return -1;
        }
    }

    @Override
    public int getHeadOffStateByIndex(int x) {
        try {
            return this.getHeadItemByIndex(x).getOffAppearance();
        }
        catch (IndexOutOfBoundsException ioob) {
            return -1;
        }
    }

    @Override
    public void deleteSignalHead(SignalHead sh) {
        this._signalHeadItem.remove(this.getHeadItem(sh));
    }

    @Override
    public void deleteSignalHead(NamedBeanHandle<SignalHead> headBean) {
        this._signalHeadItem.remove(this.getHeadItem(headBean.getName()));
    }

    @Override
    public void setHeadOnState(SignalHead head, int state) {
        this.getHeadItem(head).setOnAppearance(state);
        this.firePropertyChange("UpdateCondition", null, null);
    }

    @Override
    public void setHeadOffState(SignalHead head, int state) {
        this.getHeadItem(head).setOffAppearance(state);
        this.firePropertyChange("UpdateCondition", null, null);
    }

    @Override
    public boolean isHeadIncluded(SignalHead signalHead) {
        for (int i = 0; i < this._signalHeadItem.size(); ++i) {
            if (this._signalHeadItem.get(i).getSignalHead() != signalHead) continue;
            return true;
        }
        return false;
    }

    private SignalHeadItem getHeadItem(String name) {
        for (int i = 0; i < this._signalHeadItem.size(); ++i) {
            if (!this._signalHeadItem.get(i).getName().equals(name)) continue;
            return this._signalHeadItem.get(i);
        }
        return null;
    }

    private SignalHeadItem getHeadItem(NamedBean headBean) {
        for (int i = 0; i < this._signalHeadItem.size(); ++i) {
            if (!this._signalHeadItem.get(i).getSignalHead().equals(headBean)) continue;
            return this._signalHeadItem.get(i);
        }
        return null;
    }

    @Override
    public boolean isTurnoutIncluded(SignalHead signalHead, Turnout turnout) {
        return this.getHeadItem(signalHead).isTurnoutIncluded(turnout);
    }

    @Override
    public int getTurnoutState(SignalHead signalHead, Turnout turnout) {
        SignalHeadItem shi = this.getHeadItem(signalHead);
        if (shi != null) {
            return shi.getTurnoutState(turnout);
        }
        return -1;
    }

    @Override
    public int getTurnoutStateByIndex(int x, Turnout turnout) {
        try {
            return this.getHeadItemByIndex(x).getTurnoutState(turnout);
        }
        catch (IndexOutOfBoundsException ioob) {
            return -1;
        }
    }

    @Override
    public int getTurnoutStateByIndex(int x, int pTurnout) {
        try {
            return this.getHeadItemByIndex(x).getTurnoutState(pTurnout);
        }
        catch (IndexOutOfBoundsException ioob) {
            return -1;
        }
    }

    @Override
    public String getTurnoutNameByIndex(int x, int pTurnout) {
        try {
            return this.getHeadItemByIndex(x).getTurnoutName(pTurnout);
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public Turnout getTurnoutByIndex(int x, int pTurnout) {
        try {
            return this.getHeadItemByIndex(x).getTurnout(pTurnout);
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public int getSensorStateByIndex(int x, int pSensor) {
        try {
            return this.getHeadItemByIndex(x).getSensorState(pSensor);
        }
        catch (IndexOutOfBoundsException ioob) {
            return -1;
        }
    }

    @Override
    public String getSensorNameByIndex(int x, int pSensor) {
        try {
            return this.getHeadItemByIndex(x).getSensorName(pSensor);
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public Sensor getSensorByIndex(int x, int pSensor) {
        try {
            return this.getHeadItemByIndex(x).getSensor(pSensor);
        }
        catch (IndexOutOfBoundsException ioob) {
            return null;
        }
    }

    @Override
    public boolean isSensorIncluded(SignalHead signalHead, Sensor sensor) {
        return this.getHeadItem(signalHead).isSensorIncluded(sensor);
    }

    @Override
    public int getSensorState(SignalHead signalHead, Sensor sensor) {
        SignalHeadItem shi = this.getHeadItem(signalHead);
        if (shi != null) {
            return shi.getSensorState(sensor);
        }
        return -1;
    }

    @Override
    public boolean getSensorTurnoutOper(SignalHead signalHead) {
        return this.getHeadItem(signalHead).getSensorTurnoutOper();
    }

    @Override
    public boolean getSensorTurnoutOperByIndex(int x) {
        return this.getHeadItemByIndex(x).getSensorTurnoutOper();
    }

    @Override
    public void setSensorTurnoutOper(SignalHead signalHead, boolean boo) {
        this.getHeadItem(signalHead).setSensorTurnoutOper(boo);
        this.firePropertyChange("UpdateCondition", null, null);
    }

    @Override
    public void clearHeadTurnout(SignalHead signalHead) {
        this.getHeadItem(signalHead).clearSignalTurnouts();
    }

    @Override
    public void clearHeadSensor(SignalHead signalHead) {
        this.getHeadItem(signalHead).clearSignalSensors();
    }

    private void resetHeads() {
        if (!this.headactive) {
            return;
        }
        for (int i = 0; i < this._signalHeadItem.size(); ++i) {
            this._signalHeadItem.get(i).getSignalHead().setAppearance(this._signalHeadItem.get(i).getOffAppearance());
        }
        this.headactive = false;
    }

    private void setHead() {
        boolean active = false;
        for (int i = 0; i < this._signalHeadItem.size(); ++i) {
            if (!this._signalHeadItem.get(i).checkActive()) continue;
            if (active) {
                log.warn("two signal heads in the group should not be active at once");
            }
            active = true;
            this.headactive = true;
        }
    }

    @Override
    public int getNumHeadSensorsByIndex(int x) {
        try {
            return this.getHeadItemByIndex(x).getNumSensors();
        }
        catch (IndexOutOfBoundsException ioob) {
            return -1;
        }
    }

    @Override
    public int getNumHeadTurnoutsByIndex(int x) {
        try {
            return this.getHeadItemByIndex(x).getNumTurnouts();
        }
        catch (IndexOutOfBoundsException ioob) {
            return -1;
        }
    }

    @Override
    public int getState() {
        return 0;
    }

    @Override
    public void setState(int state) {
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null) {
            if (bean.equals(this.getSignalMast())) {
                report.add(new NamedBeanUsageReport("SignalGroupMast"));
            }
            for (int i = 0; i < this.getNumHeadItems(); ++i) {
                if (bean.equals(this.getHeadItemBeanByIndex(i))) {
                    report.add(new NamedBeanUsageReport("SignalGroupHead"));
                }
                for (int j = 0; j < this.getNumHeadSensorsByIndex(i); ++j) {
                    if (!bean.equals(this.getSensorByIndex(i, j))) continue;
                    report.add(new NamedBeanUsageReport("SignalGroupHeadSensor"));
                }
                for (int k = 0; k < this.getNumHeadTurnoutsByIndex(i); ++k) {
                    if (!bean.equals(this.getTurnoutByIndex(i, k))) continue;
                    report.add(new NamedBeanUsageReport("SignalGroupHeadTurnout"));
                }
            }
        }
        return report;
    }

    private static class SignalHeadItem {
        private NamedBeanHandle<SignalHead> namedHead;
        private int onAppearance = 0;
        private int offAppearance = 0;
        private boolean turnoutSensorOper = true;
        ArrayList<SignalTurnout> _signalTurnoutList = new ArrayList();
        ArrayList<SignalSensor> _signalSensorList = new ArrayList();

        SignalHeadItem(NamedBeanHandle<SignalHead> sh) {
            this.namedHead = sh;
            if (this.namedHead.getBean().getClass().getName().contains("SingleTurnoutSignalHead")) {
                SingleTurnoutSignalHead stsh = (SingleTurnoutSignalHead)this.namedHead.getBean();
                if (this.onAppearance == 0 && this.offAppearance == 0) {
                    this.onAppearance = stsh.getOnAppearance();
                    this.offAppearance = stsh.getOffAppearance();
                }
            }
        }

        public String getName() {
            return this.namedHead.getName();
        }

        public SignalHead getSignalHead() {
            return this.namedHead.getBean();
        }

        public void setOnAppearance(int app) {
            this.onAppearance = app;
        }

        public int getOnAppearance() {
            return this.onAppearance;
        }

        public void setOffAppearance(int app) {
            this.offAppearance = app;
        }

        public int getOffAppearance() {
            return this.offAppearance;
        }

        public boolean getSensorTurnoutOper() {
            return this.turnoutSensorOper;
        }

        public void setSensorTurnoutOper(boolean boo) {
            this.turnoutSensorOper = boo;
        }

        public boolean checkActive() {
            int x;
            boolean state = false;
            for (x = 0; x < this._signalTurnoutList.size(); ++x) {
                log.debug("Real state {} {} state we testing for {}", new Object[]{this._signalTurnoutList.get(x).getName(), this._signalTurnoutList.get(x).getTurnout().getKnownState(), this._signalTurnoutList.get(x).getState()});
                if (this._signalTurnoutList.get(x).getTurnout().getKnownState() != this._signalTurnoutList.get(x).getState()) {
                    state = false;
                    break;
                }
                state = true;
            }
            for (x = 0; x < this._signalSensorList.size(); ++x) {
                if (this._signalSensorList.get(x).getSensor().getKnownState() != this._signalSensorList.get(x).getState()) {
                    state = false;
                    break;
                }
                state = true;
            }
            if (state) {
                this.getSignalHead().setAppearance(this.onAppearance);
            } else {
                this.getSignalHead().setAppearance(this.offAppearance);
            }
            return state;
        }

        void addTurnout(Turnout turn, int state) {
            SignalTurnout signalTurnout = new SignalTurnout(turn, state);
            this._signalTurnoutList.add(signalTurnout);
        }

        Turnout getTurnout(int x) {
            return this._signalTurnoutList.get(x).getTurnout();
        }

        int getTurnoutState(Turnout turn) {
            for (int i = 0; i < this._signalTurnoutList.size(); ++i) {
                if (this._signalTurnoutList.get(i).getTurnout() != turn) continue;
                return this._signalTurnoutList.get(i).getState();
            }
            return -1;
        }

        int getNumTurnouts() {
            return this._signalTurnoutList.size();
        }

        String getTurnoutName(int x) {
            return this._signalTurnoutList.get(x).getName();
        }

        int getTurnoutState(int x) {
            return this._signalTurnoutList.get(x).getState();
        }

        boolean isTurnoutIncluded(Turnout turnout) {
            for (int i = 0; i < this._signalTurnoutList.size(); ++i) {
                if (this._signalTurnoutList.get(i).getTurnout() != turnout) continue;
                return true;
            }
            return false;
        }

        void clearSignalTurnouts() {
            this._signalTurnoutList = new ArrayList();
        }

        void clearSignalSensors() {
            this._signalSensorList = new ArrayList();
        }

        void addSensor(Sensor sen, int state) {
            SignalSensor signalSensor = new SignalSensor(sen, state);
            this._signalSensorList.add(signalSensor);
        }

        int getSensorState(Sensor sen) {
            for (int i = 0; i < this._signalSensorList.size(); ++i) {
                if (this._signalSensorList.get(i).getSensor() != sen) continue;
                return this._signalSensorList.get(i).getState();
            }
            return -1;
        }

        int getNumSensors() {
            return this._signalSensorList.size();
        }

        String getSensorName(int x) {
            return this._signalSensorList.get(x).getName();
        }

        Sensor getSensor(int x) {
            return this._signalSensorList.get(x).getSensor();
        }

        int getSensorState(int x) {
            return this._signalSensorList.get(x).getState();
        }

        boolean isSensorIncluded(Sensor sensor) {
            for (int i = 0; i < this._signalSensorList.size(); ++i) {
                if (this._signalSensorList.get(i).getSensor() != sensor) continue;
                return true;
            }
            return false;
        }

        private static class SignalSensor {
            NamedBeanHandle<Sensor> _Sensor;
            int _state;

            SignalSensor(Sensor sen, int state) {
                this._Sensor = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(sen.getDisplayName(), sen);
                this.setState(state);
            }

            String getName() {
                if (this._Sensor != null) {
                    return this._Sensor.getName();
                }
                return null;
            }

            boolean setState(int state) {
                if (this._Sensor == null) {
                    return false;
                }
                if (state != 2 && state != 4) {
                    log.warn("Illegal Sensor state {} for : {}", (Object)state, (Object)this.getName());
                    return false;
                }
                this._state = state;
                return true;
            }

            int getState() {
                return this._state;
            }

            Sensor getSensor() {
                return this._Sensor.getBean();
            }
        }

        private static class SignalTurnout {
            NamedBeanHandle<Turnout> _turnout;
            int _state;

            SignalTurnout(Turnout turn, int state) {
                this._turnout = InstanceManager.getDefault(NamedBeanHandleManager.class).getNamedBeanHandle(turn.getDisplayName(), turn);
                this.setState(state);
            }

            String getName() {
                if (this._turnout != null) {
                    return this._turnout.getName();
                }
                return null;
            }

            boolean setState(int state) {
                if (this._turnout == null) {
                    return false;
                }
                if (state != 4 && state != 2) {
                    log.warn("Illegal Turnout state {} for : {}", (Object)state, (Object)this.getName());
                    return false;
                }
                this._state = state;
                return true;
            }

            int getState() {
                return this._state;
            }

            Turnout getTurnout() {
                return this._turnout.getBean();
            }
        }
    }
}

