/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.Timer;
import jmri.NamedBean;
import jmri.NamedBeanUsageReport;
import jmri.Turnout;
import jmri.implementation.AbstractSignalHead;
import jmri.implementation.Bundle;

public abstract class DefaultSignalHead
extends AbstractSignalHead {
    protected boolean mFlashOn = true;
    Timer timer = null;
    public int delay = masterDelay;
    public static int masterDelay = 750;
    private static final int[] VALID_STATES = new int[]{0, 1, 4, 16, 2, 8, 32};
    private static final String[] VALID_STATE_KEYS = new String[]{"SignalHeadStateDark", "SignalHeadStateRed", "SignalHeadStateYellow", "SignalHeadStateGreen", "SignalHeadStateFlashingRed", "SignalHeadStateFlashingYellow", "SignalHeadStateFlashingGreen"};

    public DefaultSignalHead(String systemName, String userName) {
        super(systemName, userName);
    }

    public DefaultSignalHead(String systemName) {
        super(systemName);
    }

    @Override
    public void setAppearance(int newAppearance) {
        int oldAppearance = this.mAppearance;
        this.mAppearance = newAppearance;
        this.appearanceSetsFlashTimer(newAppearance);
        this.updateOutput();
        this.firePropertyChange("Appearance", oldAppearance, newAppearance);
    }

    protected void appearanceSetsFlashTimer(int newAppearance) {
        if (this.mLit && (newAppearance == 32 || newAppearance == 8 || newAppearance == 2 || newAppearance == 128)) {
            this.startFlash();
        }
        if (!this.mLit || newAppearance != 32 && newAppearance != 8 && newAppearance != 2 && newAppearance != 128) {
            this.stopFlash();
        }
    }

    @Override
    public void setLit(boolean newLit) {
        boolean oldLit = this.mLit;
        this.mLit = newLit;
        if (oldLit != newLit) {
            if (this.mLit && (this.mAppearance == 32 || this.mAppearance == 8 || this.mAppearance == 2 || this.mAppearance == 128)) {
                this.startFlash();
            }
            if (!this.mLit) {
                this.stopFlash();
            }
            this.updateOutput();
            this.firePropertyChange("Lit", oldLit, newLit);
        }
    }

    @Override
    public void setHeld(boolean newHeld) {
        boolean oldHeld = this.mHeld;
        this.mHeld = newHeld;
        if (oldHeld != newHeld) {
            this.firePropertyChange("Held", oldHeld, newHeld);
        }
    }

    protected abstract void updateOutput();

    protected void startFlash() {
        if (this.timer == null) {
            this.timer = new Timer(this.delay, e -> this.timeout());
            this.timer.setInitialDelay(this.delay);
            this.timer.setRepeats(true);
        }
        this.timer.start();
    }

    private void timeout() {
        this.mFlashOn = !this.mFlashOn;
        this.updateOutput();
    }

    protected void stopFlash() {
        if (this.timer != null) {
            this.timer.stop();
        }
        this.mFlashOn = true;
    }

    @Override
    public int[] getValidStates() {
        return Arrays.copyOf(VALID_STATES, VALID_STATES.length);
    }

    @Override
    public String[] getValidStateKeys() {
        return Arrays.copyOf(VALID_STATE_KEYS, VALID_STATE_KEYS.length);
    }

    @Override
    public String[] getValidStateNames() {
        String[] stateNames = new String[VALID_STATE_KEYS.length];
        int i = 0;
        for (String stateKey : VALID_STATE_KEYS) {
            stateNames[i++] = Bundle.getMessage(stateKey);
        }
        return stateNames;
    }

    @Override
    public boolean isTurnoutUsed(Turnout t) {
        return false;
    }

    @Override
    public List<NamedBeanUsageReport> getUsageReport(NamedBean bean) {
        Turnout t;
        ArrayList<NamedBeanUsageReport> report = new ArrayList<NamedBeanUsageReport>();
        if (bean != null && bean instanceof Turnout && this.isTurnoutUsed(t = (Turnout)bean)) {
            report.add(new NamedBeanUsageReport("SignalHeadTurnout"));
        }
        return report;
    }
}

