/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.awt.GraphicsEnvironment;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.TransferHandler;
import jmri.Application;
import jmri.ConfigureManager;
import jmri.InstanceManager;
import jmri.JmriException;
import jmri.ShutDownManager;
import jmri.configurexml.ConfigXmlManager;
import jmri.configurexml.StoreXmlUserAction;
import jmri.configurexml.swing.DialogErrorHandler;
import jmri.implementation.Bundle;
import jmri.jmrit.XmlFile;
import jmri.profile.Profile;
import jmri.profile.ProfileManager;
import jmri.spi.PreferencesManager;
import jmri.util.FileUtil;
import jmri.util.SystemType;
import jmri.util.com.sun.TransferActionListener;
import jmri.util.prefs.HasConnectionButUnableToConnectException;
import jmri.util.prefs.InitializationException;
import jmri.util.prefs.JmriPreferencesActionFactory;
import jmri.util.swing.JmriJOptionPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmriConfigurationManager
implements ConfigureManager {
    private final ConfigXmlManager legacy = new ConfigXmlManager();
    private final HashMap<PreferencesManager, InitializationException> initializationExceptions = new HashMap();
    private final List<PreferencesManager> initialized = new ArrayList<PreferencesManager>();
    private final Set<PreferencesManager> initializing = new HashSet<PreferencesManager>();
    private static final Logger log = LoggerFactory.getLogger(JmriConfigurationManager.class);

    public JmriConfigurationManager() {
        ServiceLoader<PreferencesManager> sl = ServiceLoader.load(PreferencesManager.class);
        for (PreferencesManager pp : sl) {
            InstanceManager.store(pp, PreferencesManager.class);
            for (Class<?> provided : pp.getProvides()) {
                InstanceManager.storeUnchecked(pp, provided);
            }
        }
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        if (profile != null) {
            this.legacy.setPrefsLocation(new File(profile.getPath(), "ProfileConfig.xml"));
        }
        if (!GraphicsEnvironment.isHeadless()) {
            ConfigXmlManager.setErrorHandler(new DialogErrorHandler());
        }
    }

    @Override
    public void registerPref(Object o) {
        if (o instanceof PreferencesManager) {
            InstanceManager.store((PreferencesManager)o, PreferencesManager.class);
        }
        this.legacy.registerPref(o);
    }

    @Override
    public void removePrefItems() {
        this.legacy.removePrefItems();
    }

    @Override
    public void registerConfig(Object o) {
        this.legacy.registerConfig(o);
    }

    @Override
    public void registerConfig(Object o, int x) {
        this.legacy.registerConfig(o, x);
    }

    @Override
    public void registerTool(Object o) {
        this.legacy.registerTool(o);
    }

    @Override
    public void registerUser(Object o) {
        this.legacy.registerUser(o);
    }

    @Override
    public void registerUserPrefs(Object o) {
        this.legacy.registerUserPrefs(o);
    }

    @Override
    public void deregister(Object o) {
        this.legacy.deregister(o);
    }

    @Override
    public Object findInstance(Class<?> c, int index) {
        return this.legacy.findInstance(c, index);
    }

    @Override
    public List<Object> getInstanceList(Class<?> c) {
        return this.legacy.getInstanceList(c);
    }

    @Override
    public void storePrefs() {
        log.debug("Saving preferences...");
        Profile profile = ProfileManager.getDefault().getActiveProfile();
        InstanceManager.getList(PreferencesManager.class).stream().forEach(o -> {
            log.debug("Saving preferences for {}", (Object)o.getClass().getName());
            o.savePreferences(profile);
        });
    }

    @Override
    public void storePrefs(File file) {
        this.storePrefs();
    }

    @Override
    public void storeUserPrefs(File file) {
        this.legacy.storeUserPrefs(file);
    }

    @Override
    public boolean storeConfig(File file) {
        return this.legacy.storeConfig(file);
    }

    @Override
    public boolean storeUser(File file) {
        return this.legacy.storeUser(file);
    }

    @Override
    public boolean load(File file) throws JmriException {
        return this.load(file, false);
    }

    @Override
    public boolean load(URL url) throws JmriException {
        return this.load(url, false);
    }

    @Override
    public boolean load(File file, boolean registerDeferred) throws JmriException {
        return this.load(FileUtil.fileToURL(file), registerDeferred);
    }

    @Override
    public boolean load(URL url, boolean registerDeferred) throws JmriException {
        log.debug("loading {} ...", (Object)url);
        try {
            if (url == null || new File(url.toURI()).getName().equals("ProfileConfig.xml") || new File(url.toURI()).getName().equals("profile.xml")) {
                Profile profile = ProfileManager.getDefault().getActiveProfile();
                ArrayList<PreferencesManager> providers = new ArrayList<PreferencesManager>(InstanceManager.getList(PreferencesManager.class));
                providers.stream().sorted(Comparator.comparingInt(p -> p.getRequires().size())).forEachOrdered(provider -> this.initializeProvider((PreferencesManager)provider, profile));
                if (!this.initializationExceptions.isEmpty()) {
                    this.handleInitializationExceptions(profile);
                }
                if (url != null && new File(url.toURI()).getName().equals("ProfileConfig.xml")) {
                    log.debug("Loading legacy configuration...");
                    return this.legacy.load(url, registerDeferred);
                }
                return this.initializationExceptions.isEmpty();
            }
        }
        catch (URISyntaxException ex) {
            log.error("Unable to get File for {}", (Object)url);
            throw new JmriException(ex.getMessage(), ex);
        }
        try {
            JFileChooser ufc = StoreXmlUserAction.getUserFileChooser();
            ufc.setSelectedFile(new File(FileUtil.urlToURI(url)));
        }
        catch (Exception e) {
            log.error("Exception caught while setting default load file in file chooser: {}", (Object)e.toString());
        }
        return this.legacy.load(url, registerDeferred);
    }

    private void handleInitializationExceptions(Profile profile) {
        if (!GraphicsEnvironment.isHeadless()) {
            AtomicBoolean isUnableToConnect = new AtomicBoolean(false);
            ArrayList<String> errors = new ArrayList<String>();
            this.initialized.forEach(provider -> {
                List<Exception> exceptions = provider.getInitializationExceptions(profile);
                if (!exceptions.isEmpty()) {
                    exceptions.forEach(exception -> {
                        if (exception instanceof HasConnectionButUnableToConnectException) {
                            isUnableToConnect.set(true);
                        }
                        errors.add(exception.getLocalizedMessage());
                    });
                } else if (this.initializationExceptions.get(provider) != null) {
                    errors.add(this.initializationExceptions.get(provider).getLocalizedMessage());
                }
            });
            Object list = this.getErrorListObject(errors);
            if (isUnableToConnect.get()) {
                this.handleConnectionError(errors, list);
            } else {
                this.displayErrorListDialog(list);
            }
        }
    }

    private Object getErrorListObject(List<String> errors) {
        Object list = errors.size() == 1 ? errors.get(0) : new JList<String>(errors.toArray(new String[0]));
        return list;
    }

    protected void displayErrorListDialog(Object list) {
        JmriJOptionPane.showMessageDialog(null, new Object[]{list instanceof JList ? Bundle.getMessage("InitExMessageListHeader") : null, list, "<html><br></html>", Bundle.getMessage("InitExMessageLogs"), Bundle.getMessage("InitExMessagePrefs")}, Bundle.getMessage("InitExMessageTitle", Application.getApplicationName()), 0);
        InstanceManager.getDefault(JmriPreferencesActionFactory.class).getDefaultAction().actionPerformed(new ActionEvent(this, 1001, ""));
    }

    private void handleConnectionError(List<String> errors, Object list) {
        List<String> errorList = errors;
        errorList.add(" ");
        errorList.add(Bundle.getMessage("InitExMessageLogs"));
        Object[] options = this.generateErrorDialogButtonOptions();
        if (list instanceof JList) {
            JPopupMenu popupMenu = new JPopupMenu();
            JMenuItem copyMenuItem = this.buildCopyMenuItem((JList)list);
            popupMenu.add(copyMenuItem);
            JMenuItem copyAllMenuItem = this.buildCopyAllMenuItem((JList)list);
            popupMenu.add(copyAllMenuItem);
            ((JList)list).setComponentPopupMenu(popupMenu);
            ((JList)list).addListSelectionListener(e -> copyMenuItem.setEnabled(((JList)e.getSource()).getSelectedIndex() != -1));
        }
        this.handleRestartSelection(this.getjOptionPane(list, options));
    }

    private void handleRestartSelection(int selectedValue) {
        if (selectedValue == 0) {
            this.handleQuit();
        } else if (selectedValue != 1 && selectedValue != -1) {
            if (selectedValue == 2) {
                if (this.isEditDialogRestart()) {
                    this.handleRestart();
                } else {
                    this.handleQuit();
                }
            } else {
                this.handleQuit();
            }
        }
    }

    protected boolean isEditDialogRestart() {
        return false;
    }

    protected void handleRestart() {
        try {
            InstanceManager.getDefault(ShutDownManager.class).restart();
        }
        catch (Exception er) {
            log.error("Continuing after error in handleRestart", (Throwable)er);
        }
    }

    private int getjOptionPane(Object list, Object[] options) {
        return JmriJOptionPane.showOptionDialog(null, new Object[]{list instanceof JList ? Bundle.getMessage("InitExMessageListHeader") : null, list, "<html><br></html>", Bundle.getMessage("InitExMessageLogs"), Bundle.getMessage("ErrorDialogConnectLayout")}, Bundle.getMessage("InitExMessageTitle", Application.getApplicationName()), -1, 0, null, options, null);
    }

    private JMenuItem buildCopyAllMenuItem(JList<?> list) {
        JMenuItem copyAllMenuItem = new JMenuItem(Bundle.getMessage("MenuItemCopyAll"));
        ActionListener copyAllActionListener = e -> {
            StringBuilder text = new StringBuilder();
            for (int i = 0; i < list.getModel().getSize(); ++i) {
                text.append(list.getModel().getElementAt(i).toString());
                text.append(System.getProperty("line.separator"));
            }
            Clipboard systemClipboard = Toolkit.getDefaultToolkit().getSystemClipboard();
            systemClipboard.setContents(new StringSelection(text.toString()), null);
        };
        copyAllMenuItem.setActionCommand("copyAll");
        copyAllMenuItem.addActionListener(copyAllActionListener);
        return copyAllMenuItem;
    }

    private JMenuItem buildCopyMenuItem(JList<?> list) {
        JMenuItem copyMenuItem = new JMenuItem(Bundle.getMessage("MenuItemCopy"));
        TransferActionListener copyActionListener = new TransferActionListener();
        copyMenuItem.setActionCommand((String)TransferHandler.getCopyAction().getValue("Name"));
        copyMenuItem.addActionListener(copyActionListener);
        if (SystemType.isMacOSX()) {
            copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 4));
        } else {
            copyMenuItem.setAccelerator(KeyStroke.getKeyStroke(67, 2));
        }
        copyMenuItem.setMnemonic(67);
        copyMenuItem.setEnabled(list.getSelectedIndex() != -1);
        return copyMenuItem;
    }

    private Object[] generateErrorDialogButtonOptions() {
        return new Object[]{Bundle.getMessage("ErrorDialogButtonQuitProgram", Application.getApplicationName()), Bundle.getMessage("ErrorDialogButtonContinue"), Bundle.getMessage("ErrorDialogButtonEditConnections")};
    }

    protected void handleQuit() {
        try {
            InstanceManager.getDefault(ShutDownManager.class).shutdown();
        }
        catch (Exception e) {
            log.error("Continuing after error in handleQuit", (Throwable)e);
        }
    }

    @Override
    public boolean loadDeferred(File file) {
        return this.legacy.loadDeferred(file);
    }

    @Override
    public boolean loadDeferred(URL file) {
        return this.legacy.loadDeferred(file);
    }

    @Override
    public URL find(String filename) {
        return this.legacy.find(filename);
    }

    @Override
    public boolean makeBackup(File file) {
        return this.legacy.makeBackup(file);
    }

    private void initializeProvider(PreferencesManager provider, Profile profile) {
        if (!(this.initializing.contains(provider) || provider.isInitialized(profile) || provider.isInitializedWithExceptions(profile))) {
            this.initializing.add(provider);
            log.debug("Initializing provider {}", provider.getClass());
            provider.getRequires().forEach(c -> InstanceManager.getList(c).forEach(p -> this.initializeProvider((PreferencesManager)p, profile)));
            try {
                provider.initialize(profile);
            }
            catch (InitializationException ex) {
                if (this.initializationExceptions.putIfAbsent(provider, ex) == null) {
                    log.error("Exception initializing {}: {}", (Object)provider.getClass().getName(), (Object)ex.getMessage());
                }
                log.error("Additional exception initializing {}: {}", (Object)provider.getClass().getName(), (Object)ex.getMessage());
            }
            this.initialized.add(provider);
            log.debug("Initialized provider {}", provider.getClass());
            this.initializing.remove(provider);
        }
    }

    public HashMap<PreferencesManager, InitializationException> getInitializationExceptions() {
        return new HashMap<PreferencesManager, InitializationException>(this.initializationExceptions);
    }

    @Override
    public void setValidate(XmlFile.Validate v) {
        this.legacy.setValidate(v);
    }

    @Override
    public XmlFile.Validate getValidate() {
        return this.legacy.getValidate();
    }
}

