/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import jmri.Conditional;
import jmri.NamedBean;
import jmri.NamedBeanHandle;

public class JmriSimplePropertyListener
implements PropertyChangeListener {
    int _type;
    String _varName;
    Conditional.Type _varType;
    String _propertyName;
    ArrayList<Conditional> _clients;
    boolean _enabled;
    NamedBeanHandle<?> _namedBean;

    JmriSimplePropertyListener(String propName, int type, String varName, Conditional.Type varType, Conditional client) {
        this._propertyName = propName;
        this._type = type;
        this._varName = varName;
        this._varType = varType;
        this._clients = new ArrayList();
        this._clients.add(client);
        this._enabled = true;
    }

    JmriSimplePropertyListener(String propName, int type, NamedBeanHandle<?> namedBean, Conditional.Type varType, Conditional client) {
        this._propertyName = propName;
        this._type = type;
        this._namedBean = namedBean;
        this._varType = varType;
        this._clients = new ArrayList();
        this._clients.add(client);
        this._enabled = true;
    }

    NamedBeanHandle<?> getNamedBean() {
        return this._namedBean;
    }

    public NamedBean getBean() {
        if (this._namedBean != null) {
            return this._namedBean.getBean();
        }
        return null;
    }

    public int getType() {
        return this._type;
    }

    public String getPropertyName() {
        return this._propertyName;
    }

    public Conditional.Type getVarType() {
        return this._varType;
    }

    public String getDevName() {
        if (this._namedBean != null) {
            return this._namedBean.getName();
        }
        return this._varName;
    }

    public void addConditional(Conditional client) {
        this._clients.add(client);
    }

    public void setEnabled(boolean state) {
        this._enabled = state;
    }

    public void calculateClient(int idx, PropertyChangeEvent evt) {
        this._clients.get(idx).calculate(this._enabled, evt);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        Object newValue = evt.getNewValue();
        if (newValue != null && newValue.equals(evt.getOldValue())) {
            return;
        }
        for (int i = 0; i < this._clients.size(); ++i) {
            this._clients.get(i).calculate(this._enabled, evt);
        }
    }
}

