/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.HashMap;
import java.util.Map;
import java.util.TimerTask;
import jmri.Meter;
import jmri.util.TimerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class MeterUpdateTask {
    Map<Meter, Boolean> meters = new HashMap<Meter, Boolean>();
    boolean _enabled = false;
    private UpdateTask _intervalTask = null;
    private int _initialInterval;
    private int _sleepInterval;
    private static final Logger log = LoggerFactory.getLogger(MeterUpdateTask.class);

    public MeterUpdateTask() {
        this._sleepInterval = 10000;
        this._initialInterval = 10000;
    }

    public MeterUpdateTask(int interval) {
        this._initialInterval = interval;
        this._sleepInterval = interval;
    }

    public MeterUpdateTask(int initialInterval, int sleepInterval) {
        this._initialInterval = initialInterval;
        this._sleepInterval = sleepInterval;
    }

    public void addMeter(Meter m) {
        this.meters.put(m, false);
    }

    public void removeMeter(Meter m) {
        this.meters.remove(m);
    }

    public void enable() {
        if (this._intervalTask != null) {
            this._intervalTask.enable();
        } else {
            log.debug("_intervalTask is null, enable() ignored");
        }
    }

    public void enable(Meter m) {
        if (!this.meters.containsKey(m)) {
            throw new IllegalArgumentException("Meter is not registered");
        }
        if (!this.meters.get(m).booleanValue()) {
            this.meters.put(m, true);
            if (!this._enabled) {
                this._enabled = true;
                this.enable();
            }
        }
    }

    protected void disable() {
        if (this._intervalTask != null) {
            this._intervalTask.disable();
        }
    }

    public void disable(Meter m) {
        if (!this.meters.containsKey(m)) {
            return;
        }
        if (this.meters.get(m).booleanValue()) {
            this.meters.put(m, false);
            if (this._enabled) {
                boolean found = false;
                for (Boolean b : this.meters.values()) {
                    found |= b.booleanValue();
                }
                if (!found) {
                    this._enabled = false;
                    this.disable();
                }
            }
        }
    }

    public void initTimer() {
        if (this._intervalTask != null) {
            this._intervalTask.cancel();
            this._intervalTask = null;
        }
        if (this._sleepInterval < 0) {
            log.debug("_sleepInterval {} less than zero, initTimer() ignored", (Object)this._sleepInterval);
            return;
        }
        this._intervalTask = new UpdateTask();
        log.debug("Starting Meter Timer for {}ms, {}ms", (Object)this._initialInterval, (Object)this._sleepInterval);
        TimerUtil.scheduleAtFixedRate((TimerTask)this._intervalTask, this._initialInterval, (long)this._sleepInterval);
    }

    public abstract void requestUpdateFromLayout();

    public void dispose(Meter m) {
        this.removeMeter(m);
        if (this.meters.isEmpty() && this._intervalTask != null) {
            this._intervalTask.cancel();
            this._intervalTask = null;
        }
    }

    private class UpdateTask
    extends TimerTask {
        private boolean _isEnabled = false;

        public void enable() {
            this._isEnabled = true;
        }

        public void disable() {
            this._isEnabled = false;
        }

        @Override
        public void run() {
            if (this._isEnabled) {
                log.debug("UpdateTask requesting update from layout");
                MeterUpdateTask.this.requestUpdateFromLayout();
            } else {
                log.debug("UpdateTask not enabled, run() ignored");
            }
        }
    }
}

