/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.ProgListener;
import jmri.Programmer;
import jmri.ProgrammerException;
import jmri.jmrix.AbstractProgrammerFacade;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MultiIndexProgrammerFacade
extends AbstractProgrammerFacade
implements ProgListener {
    String defaultIndexPI;
    String defaultIndexSI;
    String indexPI;
    String indexSI;
    boolean cvFirst;
    boolean skipDupIndexWrite;
    long maxDelay = 1000L;
    int _val;
    String _cv;
    int valuePI;
    int valueSI;
    int _startVal;
    int lastValuePI = -1;
    int lastValueSI = -1;
    long lastOpTime = -1L;
    private ProgListener _usingProgrammer = null;
    ProgState state = ProgState.NOTPROGRAMMING;
    private static final Logger log = LoggerFactory.getLogger(MultiIndexProgrammerFacade.class);

    public MultiIndexProgrammerFacade(Programmer prog, String indexPI, String indexSI, boolean cvFirst, boolean skipDupIndexWrite) {
        super(prog);
        this.defaultIndexPI = indexPI;
        this.defaultIndexSI = indexSI;
        this.cvFirst = cvFirst;
        this.skipDupIndexWrite = skipDupIndexWrite;
    }

    void parseCV(String cv) {
        this.valuePI = -1;
        this.valueSI = -1;
        if (cv.contains(".")) {
            if (this.cvFirst) {
                String[] splits = cv.split("\\.");
                switch (splits.length) {
                    case 2: {
                        if (this.hasAlternateAddress(splits[1])) {
                            this.valuePI = this.getAlternateValue(splits[1]);
                            this.indexPI = this.getAlternateAddress(splits[1]);
                        } else {
                            this.valuePI = Integer.parseInt(splits[1]);
                            this.indexPI = this.defaultIndexPI;
                        }
                        this._cv = splits[0];
                        break;
                    }
                    case 3: {
                        if (this.hasAlternateAddress(splits[1])) {
                            this.valuePI = this.getAlternateValue(splits[1]);
                            this.indexPI = this.getAlternateAddress(splits[1]);
                        } else {
                            this.valuePI = Integer.parseInt(splits[1]);
                            this.indexPI = this.defaultIndexPI;
                        }
                        if (this.hasAlternateAddress(splits[2])) {
                            this.valueSI = this.getAlternateValue(splits[2]);
                            this.indexSI = this.getAlternateAddress(splits[2]);
                        } else {
                            this.valueSI = Integer.parseInt(splits[2]);
                            this.indexSI = this.defaultIndexSI;
                        }
                        this._cv = splits[0];
                        break;
                    }
                    default: {
                        log.error("Too many parts in CV name; taking 1st two {}", (Object)cv);
                        this.valuePI = Integer.parseInt(splits[1]);
                        this.valueSI = Integer.parseInt(splits[2]);
                        this._cv = splits[0];
                        break;
                    }
                }
            } else {
                String[] splits = cv.split("\\.");
                switch (splits.length) {
                    case 2: {
                        if (this.hasAlternateAddress(splits[0])) {
                            this.valuePI = this.getAlternateValue(splits[0]);
                            this.indexPI = this.getAlternateAddress(splits[0]);
                        } else {
                            this.valuePI = Integer.parseInt(splits[0]);
                            this.indexPI = this.defaultIndexPI;
                        }
                        this._cv = splits[1];
                        break;
                    }
                    case 3: {
                        if (this.hasAlternateAddress(splits[0])) {
                            this.valuePI = this.getAlternateValue(splits[0]);
                            this.indexPI = this.getAlternateAddress(splits[0]);
                        } else {
                            this.valuePI = Integer.parseInt(splits[0]);
                            this.indexPI = this.defaultIndexPI;
                        }
                        if (this.hasAlternateAddress(splits[1])) {
                            this.valueSI = this.getAlternateValue(splits[1]);
                            this.indexSI = this.getAlternateAddress(splits[1]);
                        } else {
                            this.valueSI = Integer.parseInt(splits[1]);
                            this.indexSI = this.defaultIndexSI;
                        }
                        this._cv = splits[2];
                        break;
                    }
                    default: {
                        log.error("Too many parts in CV name; taking 1st two {}", (Object)cv);
                        this.valuePI = Integer.parseInt(splits[0]);
                        this.valueSI = Integer.parseInt(splits[1]);
                        this._cv = splits[2];
                        break;
                    }
                }
            }
        } else {
            this._cv = cv;
        }
    }

    boolean hasAlternateAddress(String cv) {
        return cv.contains("=");
    }

    String getAlternateAddress(String cv) {
        return cv.split("=")[0];
    }

    int getAlternateValue(String cv) {
        return Integer.parseInt(cv.split("=")[1]);
    }

    boolean useCachePiSi() {
        return this.skipDupIndexWrite && this.lastValuePI == this.valuePI && this.lastValueSI == this.valueSI && System.currentTimeMillis() - this.lastOpTime < this.maxDelay;
    }

    @Override
    public synchronized void writeCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this._val = val;
        this.useProgrammer(p);
        this.parseCV(CV);
        if (this.valuePI == -1) {
            this.lastValuePI = -1;
            this.lastValueSI = -1;
            this.state = ProgState.PROGRAMMING;
            this.prog.writeCV(this._cv, val, this);
        } else if (this.useCachePiSi()) {
            this.state = ProgState.PROGRAMMING;
            this.prog.writeCV(this._cv, val, this);
        } else {
            this.lastValuePI = this.valuePI;
            this.lastValueSI = this.valueSI;
            this.state = ProgState.FINISHWRITE;
            this.prog.writeCV(this.indexPI, this.valuePI, this);
        }
    }

    @Override
    public synchronized void readCV(String CV, ProgListener p) throws ProgrammerException {
        this.readCV(CV, p, 0);
    }

    @Override
    public synchronized void readCV(String CV, ProgListener p, int startVal) throws ProgrammerException {
        this.useProgrammer(p);
        this.parseCV(CV);
        this._startVal = startVal;
        if (this.valuePI == -1) {
            this.lastValuePI = -1;
            this.lastValueSI = -1;
            this.state = ProgState.PROGRAMMING;
            this.prog.readCV(this._cv, this, this._startVal);
        } else if (this.useCachePiSi()) {
            this.state = ProgState.PROGRAMMING;
            this.prog.readCV(this._cv, this, this._startVal);
        } else {
            this.lastValuePI = this.valuePI;
            this.lastValueSI = this.valueSI;
            this.state = ProgState.FINISHREAD;
            this.prog.writeCV(this.indexPI, this.valuePI, this);
        }
    }

    @Override
    public synchronized void confirmCV(String CV, int val, ProgListener p) throws ProgrammerException {
        this._val = val;
        this.useProgrammer(p);
        this.parseCV(CV);
        if (this.valuePI == -1) {
            this.lastValuePI = -1;
            this.lastValueSI = -1;
            this.state = ProgState.PROGRAMMING;
            this.prog.confirmCV(this._cv, val, this);
        } else if (this.useCachePiSi()) {
            this.state = ProgState.PROGRAMMING;
            this.prog.confirmCV(this._cv, val, this);
        } else {
            this.lastValuePI = this.valuePI;
            this.lastValueSI = this.valueSI;
            this.state = ProgState.FINISHCONFIRM;
            this.prog.writeCV(this.indexPI, this.valuePI, this);
        }
    }

    protected void useProgrammer(ProgListener p) throws ProgrammerException {
        if (this._usingProgrammer != null && this._usingProgrammer != p) {
            log.info("programmer already in use by {}", (Object)this._usingProgrammer);
            throw new ProgrammerException("programmer in use");
        }
        this._usingProgrammer = p;
    }

    @Override
    public void programmingOpReply(int value, int status) {
        log.debug("notifyProgListenerEnd value {} status {} ", (Object)value, (Object)status);
        if (status != 0) {
            this.lastValuePI = -1;
            this.lastValueSI = -1;
            this.lastOpTime = -1L;
            log.debug("Reset and pass abort up");
            ProgListener temp = this._usingProgrammer;
            this._usingProgrammer = null;
            this.state = ProgState.NOTPROGRAMMING;
            temp.programmingOpReply(value, status);
            return;
        }
        if (this._usingProgrammer == null) {
            log.error("No listener to notify, reset and ignore");
            this.state = ProgState.NOTPROGRAMMING;
            return;
        }
        switch (this.state) {
            case PROGRAMMING: {
                ProgListener temp = this._usingProgrammer;
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                this.lastOpTime = System.currentTimeMillis();
                temp.programmingOpReply(value, status);
                break;
            }
            case FINISHREAD: {
                if (this.valueSI == -1) {
                    try {
                        this.state = ProgState.PROGRAMMING;
                        this.prog.readCV(this._cv, this, this._startVal);
                    }
                    catch (ProgrammerException e) {
                        log.error("Exception doing final read", (Throwable)e);
                    }
                    break;
                }
                try {
                    int tempSI = this.valueSI;
                    this.valueSI = -1;
                    this.state = ProgState.FINISHREAD;
                    this.prog.writeCV(this.indexSI, tempSI, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write SI for read", (Throwable)e);
                }
                break;
            }
            case FINISHWRITE: {
                if (this.valueSI == -1) {
                    try {
                        this.state = ProgState.PROGRAMMING;
                        this.prog.writeCV(this._cv, this._val, this);
                    }
                    catch (ProgrammerException e) {
                        log.error("Exception doing final write", (Throwable)e);
                    }
                    break;
                }
                try {
                    int tempSI = this.valueSI;
                    this.valueSI = -1;
                    this.state = ProgState.FINISHWRITE;
                    this.prog.writeCV(this.indexSI, tempSI, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write SI for write", (Throwable)e);
                }
                break;
            }
            case FINISHCONFIRM: {
                if (this.valueSI == -1) {
                    try {
                        this.state = ProgState.PROGRAMMING;
                        this.prog.confirmCV(this._cv, this._val, this);
                    }
                    catch (ProgrammerException e) {
                        log.error("Exception doing final confirm", (Throwable)e);
                    }
                    break;
                }
                try {
                    int tempSI = this.valueSI;
                    this.valueSI = -1;
                    this.state = ProgState.FINISHCONFIRM;
                    this.prog.writeCV(this.indexSI, tempSI, this);
                }
                catch (ProgrammerException e) {
                    log.error("Exception doing write SI for write", (Throwable)e);
                }
                break;
            }
            default: {
                log.error("Unexpected state on reply: {}", (Object)this.state);
                this._usingProgrammer = null;
                this.state = ProgState.NOTPROGRAMMING;
                this.lastValuePI = -1;
                this.lastValueSI = -1;
                this.lastOpTime = -1L;
            }
        }
    }

    static enum ProgState {
        PROGRAMMING,
        FINISHREAD,
        FINISHWRITE,
        FINISHCONFIRM,
        NOTPROGRAMMING;

    }
}

