/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.CommandStation;
import jmri.DccLocoAddress;
import jmri.InstanceManager;
import jmri.NmraPacket;
import jmri.implementation.DccConsist;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NmraConsist
extends DccConsist {
    private CommandStation commandStation = null;
    private static final Logger log = LoggerFactory.getLogger(NmraConsist.class);

    public NmraConsist(int address) {
        super(address);
        log.debug("Nmra Consist created for address: {}", (Object)address);
    }

    public NmraConsist(DccLocoAddress address) {
        this(address, InstanceManager.getDefault(CommandStation.class));
    }

    public NmraConsist(DccLocoAddress address, CommandStation cs) {
        super(address);
        this.commandStation = cs;
        log.debug("Nmra Consist created for address: {}", (Object)address);
    }

    @Override
    protected void addToAdvancedConsist(DccLocoAddress locoAddress, boolean directionNormal) {
        log.debug("Add Locomotive {} to advanced consist {} With Direction Normal {}.", new Object[]{locoAddress, this.consistAddress, directionNormal});
        byte[] contents = NmraPacket.consistControl(locoAddress.getNumber(), locoAddress.isLongAddress(), this.consistAddress.getNumber(), directionNormal);
        this.commandStation.sendPacket(contents, 4);
        this.notifyConsistListeners(locoAddress, 2);
    }

    @Override
    protected void removeFromAdvancedConsist(DccLocoAddress locoAddress) {
        log.debug("Remove Locomotive {} from advanced consist {}.", (Object)locoAddress, (Object)this.consistAddress);
        byte[] contents = NmraPacket.consistControl(locoAddress.getNumber(), locoAddress.isLongAddress(), 0, true);
        this.commandStation.sendPacket(contents, 4);
        this.notifyConsistListeners(locoAddress, 2);
    }
}

