/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import jmri.CommandStation;
import jmri.Consist;
import jmri.DccLocoAddress;
import jmri.LocoAddress;
import jmri.implementation.AbstractConsistManager;
import jmri.implementation.NmraConsist;

public class NmraConsistManager
extends AbstractConsistManager {
    private CommandStation commandStation = null;

    public NmraConsistManager(CommandStation cs) {
        this.commandStation = cs;
    }

    @Override
    public Consist addConsist(LocoAddress address) {
        if (!(address instanceof DccLocoAddress)) {
            throw new IllegalArgumentException("address is not a DccLocoAddress object");
        }
        if (this.consistTable.containsKey(address)) {
            return (Consist)this.consistTable.get(address);
        }
        NmraConsist consist = new NmraConsist((DccLocoAddress)address, this.commandStation);
        this.consistTable.put(address, consist);
        this.notifyConsistListChanged();
        return consist;
    }

    @Override
    public boolean isCommandStationConsistPossible() {
        return false;
    }

    @Override
    public boolean csConsistNeedsSeperateAddress() {
        return false;
    }
}

