/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import jmri.AddressedProgrammer;
import jmri.Programmer;
import jmri.implementation.AccessoryOpsModeProgrammerFacade;
import jmri.implementation.AddressedHighCvProgrammerFacade;
import jmri.implementation.MultiIndexProgrammerFacade;
import jmri.implementation.OffsetHighCvProgrammerFacade;
import jmri.implementation.OpsModeDelayedProgrammerFacade;
import jmri.implementation.ResettingOffsetHighCvProgrammerFacade;
import jmri.implementation.TwoIndexTcsProgrammerFacade;
import jmri.jmrix.AbstractProgrammerFacade;
import org.jdom2.Element;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProgrammerFacadeSelector {
    private static final Logger log = LoggerFactory.getLogger(ProgrammerFacadeSelector.class);

    @SuppressFBWarnings(value={"BC_UNCONFIRMED_CAST"}, justification="cast is checked by conditional surrounding the code block")
    public static Programmer loadFacadeElements(Element element, Programmer programmer, boolean allowCache, Programmer baseProg) {
        List facades = element.getChildren("capability");
        if (log.isDebugEnabled()) {
            log.debug("Found {} capability elements", (Object)facades.size());
        }
        block32: for (Element facade : facades) {
            String fname = facade.getChild("name").getText();
            if (log.isDebugEnabled()) {
                log.debug("Process capability facade: {}", (Object)fname);
            }
            List parameters = facade.getChildren("parameter");
            if (log.isDebugEnabled()) {
                log.debug("Found {} capability parameters", (Object)facades.size());
            }
            for (Element parameter : parameters) {
                String pname = parameter.getAttributeValue("name");
                String pval = parameter.getText();
                log.debug("Found parameter name=\"{}\", value=\"{}\" ", (Object)pname, (Object)pval);
            }
            switch (fname) {
                case "High Access via Double Index": {
                    String top = ((Element)parameters.get(0)).getText();
                    String addrCVhigh = ((Element)parameters.get(1)).getText();
                    String addrCVlow = ((Element)parameters.get(2)).getText();
                    String valueCV = ((Element)parameters.get(3)).getText();
                    String modulo = ((Element)parameters.get(4)).getText();
                    AbstractProgrammerFacade pf = new AddressedHighCvProgrammerFacade(programmer, top, addrCVhigh, addrCVlow, valueCV, modulo);
                    log.debug("new programmer '{}' {}", (Object)fname, (Object)pf);
                    programmer = pf;
                    continue block32;
                }
                case "High Access via Partial Index": {
                    String top = ((Element)parameters.get(0)).getText();
                    String addrCV = ((Element)parameters.get(1)).getText();
                    String factor = ((Element)parameters.get(2)).getText();
                    String modulo = ((Element)parameters.get(3)).getText();
                    AbstractProgrammerFacade pf = new OffsetHighCvProgrammerFacade(programmer, top, addrCV, factor, modulo);
                    log.debug("new programmer '{}' {}", (Object)fname, (Object)pf);
                    programmer = pf;
                    continue block32;
                }
                case "High Access via Partial Index with Reset": {
                    String top = ((Element)parameters.get(0)).getText();
                    String addrCV = ((Element)parameters.get(1)).getText();
                    String factor = ((Element)parameters.get(2)).getText();
                    String modulo = ((Element)parameters.get(3)).getText();
                    String indicator = ((Element)parameters.get(4)).getText();
                    AbstractProgrammerFacade pf = new ResettingOffsetHighCvProgrammerFacade(programmer, top, addrCV, factor, modulo, indicator);
                    log.debug("new programmer '{}' {}", (Object)fname, (Object)pf);
                    programmer = pf;
                    continue block32;
                }
                case "Indexed CV access": {
                    boolean cvFirst;
                    String SI;
                    String PI = ((Element)parameters.get(0)).getText();
                    String string = SI = parameters.size() > 1 ? ((Element)parameters.get(1)).getText() : null;
                    boolean bl = parameters.size() > 2 ? !((Element)parameters.get(2)).getText().equals("false") : (cvFirst = true);
                    boolean skipDupIndexWrite = parameters.size() > 3 ? (((Element)parameters.get(3)).getText().equals("false") ? false : allowCache) : allowCache;
                    AbstractProgrammerFacade pf = new MultiIndexProgrammerFacade(programmer, PI, SI, cvFirst, skipDupIndexWrite);
                    log.debug("new programmer '{}' {}", (Object)fname, (Object)pf);
                    programmer = pf;
                    continue block32;
                }
                case "TCS 4 CV access": {
                    TwoIndexTcsProgrammerFacade pf = new TwoIndexTcsProgrammerFacade(programmer);
                    log.debug("new programmer '{}' {}", (Object)fname, (Object)pf);
                    programmer = pf;
                    continue block32;
                }
                case "Ops Mode Accessory Programming": {
                    if (!AddressedProgrammer.class.isAssignableFrom(baseProg.getClass())) continue block32;
                    String addrType = "decoder";
                    int delay = 500;
                    block34: for (Element x : parameters) {
                        switch (x.getAttributeValue("name")) {
                            case "Address Type": {
                                addrType = x.getText();
                                continue block34;
                            }
                            case "Delay": {
                                delay = Integer.parseInt(x.getText());
                                continue block34;
                            }
                        }
                        log.error("Unknown parameter \"{}\" for \"{}\"", (Object)fname, (Object)x.getText());
                    }
                    log.debug("\"{}\": addrType=\"{}\", delay=\"{}\", baseProg=\"{}\"", new Object[]{fname, addrType, delay, baseProg});
                    AccessoryOpsModeProgrammerFacade pf = new AccessoryOpsModeProgrammerFacade(programmer, addrType, delay, (AddressedProgrammer)baseProg);
                    log.debug("new programmer '{}' {}", (Object)fname, (Object)pf);
                    programmer = pf;
                    continue block32;
                }
                case "Ops Mode Delayed Programming": {
                    if (!AddressedProgrammer.class.isAssignableFrom(baseProg.getClass())) continue block32;
                    int delay = 500;
                    block35: for (Element x : parameters) {
                        switch (x.getAttributeValue("name")) {
                            case "Delay": {
                                delay = Integer.parseInt(x.getText());
                                continue block35;
                            }
                        }
                        log.error("Unknown parameter \"{}\" for \"{}\"", (Object)fname, (Object)x.getText());
                    }
                    log.debug("\"{}\": delay=\"{}\"", (Object)fname, (Object)delay);
                    OpsModeDelayedProgrammerFacade pf = new OpsModeDelayedProgrammerFacade(programmer, delay);
                    log.debug("new programmer '{}' {}", (Object)fname, (Object)pf);
                    programmer = pf;
                    continue block32;
                }
            }
            log.error("Cannot create programmer capability named: \"{}\"", (Object)fname);
        }
        return programmer;
    }
}

