/*
 * Decompiled with CFR 0.152.
 */
package jmri.implementation;

import java.util.Arrays;
import jmri.NamedBeanHandle;
import jmri.Turnout;
import jmri.implementation.Bundle;
import jmri.implementation.TripleTurnoutSignalHead;

public class QuadOutputSignalHead
extends TripleTurnoutSignalHead {
    NamedBeanHandle<Turnout> mLunar;
    private static final int[] validStates = new int[]{0, 1, 64, 4, 16, 2, 128, 8, 32};
    private static final String[] validStateKeys = new String[]{"SignalHeadStateDark", "SignalHeadStateRed", "SignalHeadStateLunar", "SignalHeadStateYellow", "SignalHeadStateGreen", "SignalHeadStateFlashingRed", "SignalHeadStateFlashingLunar", "SignalHeadStateFlashingYellow", "SignalHeadStateFlashingGreen"};

    public QuadOutputSignalHead(String sys, String user, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> yellow, NamedBeanHandle<Turnout> red, NamedBeanHandle<Turnout> lunar) {
        super(sys, user, green, yellow, red);
        this.mLunar = lunar;
    }

    public QuadOutputSignalHead(String sys, NamedBeanHandle<Turnout> green, NamedBeanHandle<Turnout> yellow, NamedBeanHandle<Turnout> red, NamedBeanHandle<Turnout> lunar) {
        super(sys, green, yellow, red);
        this.mLunar = lunar;
    }

    @Override
    protected void updateOutput() {
        if (!this.mLit) {
            super.updateOutput();
        } else if (!(this.mFlashOn || this.mAppearance != 32 && this.mAppearance != 8 && this.mAppearance != 2 && this.mAppearance != 128)) {
            ((Turnout)this.mRed.getBean()).setCommandedState(2);
            ((Turnout)this.mYellow.getBean()).setCommandedState(2);
            ((Turnout)this.mGreen.getBean()).setCommandedState(2);
            this.mLunar.getBean().setCommandedState(2);
        } else {
            switch (this.mAppearance) {
                case 64: 
                case 128: {
                    this.mLunar.getBean().setCommandedState(4);
                    ((Turnout)this.mRed.getBean()).setCommandedState(2);
                    ((Turnout)this.mYellow.getBean()).setCommandedState(2);
                    ((Turnout)this.mGreen.getBean()).setCommandedState(2);
                    break;
                }
                default: {
                    this.mLunar.getBean().setCommandedState(2);
                    super.updateOutput();
                }
            }
        }
    }

    @Override
    public void dispose() {
        this.mLunar = null;
        super.dispose();
    }

    public NamedBeanHandle<Turnout> getLunar() {
        return this.mLunar;
    }

    public void setLunar(NamedBeanHandle<Turnout> t) {
        this.mLunar = t;
    }

    @Override
    public int[] getValidStates() {
        return Arrays.copyOf(validStates, validStates.length);
    }

    @Override
    public String[] getValidStateKeys() {
        return Arrays.copyOf(validStateKeys, validStateKeys.length);
    }

    @Override
    public String[] getValidStateNames() {
        String[] stateNames = new String[validStateKeys.length];
        int i = 0;
        for (String stateKey : validStateKeys) {
            stateNames[i++] = Bundle.getMessage(stateKey);
        }
        return stateNames;
    }

    @Override
    public boolean isTurnoutUsed(Turnout t) {
        if (super.isTurnoutUsed(t)) {
            return true;
        }
        return this.getLunar() != null && t.equals(this.getLunar().getBean());
    }
}

